/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.ocharvester.MetricFetcher;
import oracle.sysman.ccr.ocharvester.OSInventory;
import oracle.sysman.ccr.ocharvester.OSPackage;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;

public class Metric_ECM_OS_REGISTERED_SW
implements MetricFetcher {
    private static final Category slog = Category.getInstance((String)Metric_ECM_OS_REGISTERED_SW.class.getName());
    private static final String SLASH = "/";
    private static final String COMMA = ",";
    private static final String METRIC_NAME = "ECM_OS_REGISTERED_SW";
    private static final int OC_METRIC_PKG_NAME = 2;
    private static final int OC_METRIC_PKG_LOCATION = 3;
    private static final int OC_METRIC_PKG_VERSION = 4;
    private static final int OC_METRIC_PKG_ARCH = 5;
    private static final Map<String, Integer> OCM_to_oc_map = new HashMap<String, Integer>(){
        {
            this.put("NAME", 2);
            this.put("VERSION", 4);
            this.put("INSTALLED_LOCATION", 3);
            this.put("SOFTWARE_ARCHITECTURE", 5);
        }
    };

    static void populate(int n, ValueRow valueRow, int n2, OSPackage oSPackage, String string) {
        switch (n) {
            case 2: {
                valueRow.setValue(n2, oSPackage.getName());
                break;
            }
            case 3: {
                valueRow.setValue(n2, SLASH);
                break;
            }
            case 5: {
                if (string == null) break;
                valueRow.setValue(n2, string);
                break;
            }
            case 4: {
                String string2 = oSPackage.getType() == OSPackage.PackageType.SVR4 ? oSPackage.getVersion() + COMMA + oSPackage.getSVR4_Revision() : oSPackage.getVersion();
                valueRow.setValue(n2, string2);
            }
        }
    }

    private static String host_arch(OperatingSystem operatingSystem) {
        String string = null;
        try {
            string = operatingSystem.getCpuArchitecture();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public CollectionResult fetch(Server server, OperatingSystem operatingSystem, String string, Metric metric, SoftwareInventory softwareInventory) {
        OSInventory oSInventory;
        CollectionResult collectionResult = null;
        String string2 = null;
        int n = 0;
        if (softwareInventory == null) {
            return null;
        }
        String string3 = OpsCenterHarvesterUtil.os_hostname(operatingSystem);
        if (string3 != null && (oSInventory = softwareInventory.findhost(string3)) != null && oSInventory.getPackageCount() > 0) {
            TableDescriptor tableDescriptor = metric.getTblDesc();
            Vector vector = tableDescriptor.getColDescs();
            string2 = Metric_ECM_OS_REGISTERED_SW.host_arch(operatingSystem);
            MetricResult metricResult = new MetricResult();
            Set<OSPackage> set = oSInventory.getPackages();
            for (OSPackage oSPackage : set) {
                String string4 = oSPackage.getName();
                if (OpsCenterHarvesterUtil.is_empty(string4)) continue;
                ++n;
                ValueRow valueRow = metricResult.addValueRow();
                for (int i = 0; i < vector.size(); ++i) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.elementAt(i);
                    String string5 = columnDescriptor.getColumnName();
                    Integer n2 = OCM_to_oc_map.get(string5.toUpperCase());
                    if (n2 == null) continue;
                    int n3 = n2;
                    Metric_ECM_OS_REGISTERED_SW.populate(n3, valueRow, i, oSPackage, string2);
                }
            }
            if (n > 0) {
                collectionResult = new CollectionResult(METRIC_NAME, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
            }
        }
        return collectionResult;
    }
}

