/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.ocharvester.MetricFetcher;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;

public class Metric_ECM_TARGET_VERSIONS
implements MetricFetcher {
    private static final Category slog = Category.getInstance((String)Metric_ECM_TARGET_VERSIONS.class.getName());
    private static final String METRIC_NAME = "ECM_TARGET_VERSIONS";
    private static final int OC_METRIC_TARGET_VERSION = 1;
    private static final String OC_RETRIEVAL_ERROR = "Error retrieving OS data from Ops Center";
    private static final Map<String, Integer> OCM_to_oc_map = new HashMap<String, Integer>(){
        {
            this.put("TARGET_VERSION", 1);
        }
    };

    static void populate(int n, ValueRow valueRow, int n2, OperatingSystem operatingSystem) {
        try {
            switch (n) {
                case 1: {
                    String[] stringArray = OpsCenterHarvesterUtil.os_base_and_update(operatingSystem);
                    if (OpsCenterHarvesterUtil.is_empty(stringArray[0])) break;
                    String string = operatingSystem.getType();
                    if (!OpsCenterHarvesterUtil.is_empty(string) && "solaris".equalsIgnoreCase(string)) {
                        valueRow.setValue(n2, "5." + stringArray[0]);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            slog.error((Object)(OC_RETRIEVAL_ERROR + exception));
        }
    }

    @Override
    public CollectionResult fetch(Server server, OperatingSystem operatingSystem, String string, Metric metric, SoftwareInventory softwareInventory) {
        MetricResult metricResult;
        Vector vector;
        CollectionResult collectionResult = null;
        int n = 0;
        if (metric == null) {
            return null;
        }
        TableDescriptor tableDescriptor = metric.getTblDesc();
        if (tableDescriptor != null && (vector = tableDescriptor.getColDescs()) != null && (metricResult = new MetricResult()) != null) {
            try {
                ValueRow valueRow = metricResult.addValueRow();
                if (valueRow != null) {
                    for (int i = 0; i < vector.size(); ++i) {
                        ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.elementAt(i);
                        String string2 = columnDescriptor.getColumnName();
                        Integer n2 = OCM_to_oc_map.get(string2.toUpperCase());
                        if (n2 == null) continue;
                        int n3 = n2;
                        Metric_ECM_TARGET_VERSIONS.populate(n3, valueRow, i, operatingSystem);
                        if (OpsCenterHarvesterUtil.is_empty(valueRow.getValue(0))) continue;
                        ++n;
                    }
                }
                if (n > 0) {
                    collectionResult = new CollectionResult(METRIC_NAME, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
                }
            }
            catch (Exception exception) {
                slog.error((Object)(OC_RETRIEVAL_ERROR + exception));
            }
        }
        return collectionResult;
    }
}

