/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.scn.vo.MOSUser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.install.AnonymousMailRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.MetaLinkEmailPrincipal;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.gcharvester.util.OCMConfigureUtil;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.ocharvester.OpsCenterEntitlement;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.scheduler.Scheduler;
import org.apache.log4j.Category;

public class OCConfigureCCR {
    private static final Category mSlog = Category.getInstance((String)OCConfigureCCR.class.getName());
    private static OCMRegistrationPrincipal mPrincipal;
    private static boolean mValidOcmProxy;
    private static boolean mValidOpsProxy;
    private static boolean mValidClearProxy;
    private static NetworkConfiguration mNetconfig;
    private static EndPoint mEndPoint;
    private static final String mANON_EMAIL = "opscenter-harvester@oracle.com";
    private static final String OCPROPERTIES = "/var/opt/sun/xvm/persistence/scn-satellite/connection.properties";
    private static Properties mOpsCenterProperties;
    private static final String mPORT_80 = "80";
    private static Set<String> Oc_props_observed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadOpsCenterProperties() {
        Properties properties = new Properties();
        BufferedInputStream bufferedInputStream = null;
        mSlog.debug((Object)"Loading Ops Center HTTP properties");
        try {
            File file = new File(OCPROPERTIES);
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            properties.load(bufferedInputStream);
        }
        catch (IOException iOException) {
            mSlog.error((Object)"Unable to load Ops Center connection properties");
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    public static String getClientRegistrationId() {
        return mOpsCenterProperties.getProperty("client-reg-id");
    }

    public static EndPoint probeNetworkUsingOCMProperties() {
        EndPoint endPoint = OCMConfigureUtil.proxyFromCCR((NetworkConfiguration)mNetconfig);
        return endPoint;
    }

    public static EndPoint probeNetworkUsingOpsCenterProperties() {
        EndPoint endPoint = null;
        if (mOpsCenterProperties != null) {
            String string = mOpsCenterProperties.getProperty("proxy-host");
            String string2 = mOpsCenterProperties.getProperty("proxy-port");
            String string3 = mOpsCenterProperties.getProperty("proxy-username");
            String string4 = mOpsCenterProperties.getProperty("proxy-password");
            if (string != null && string2 != null) {
                endPoint = OCMConfigureUtil.testProxyConnection((NetworkConfiguration)mNetconfig, (String)string, (String)string2, (String)string3, (String)string4);
            }
        }
        return endPoint;
    }

    private static EndPoint probeClearNetwork() {
        try {
            EndPoint endPoint = OCMConfigureUtil.testDirectConnection((NetworkConfiguration)mNetconfig);
            return endPoint;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static EndPoint probeNetwork() {
        EndPoint endPoint = null;
        mSlog.debug((Object)"Testing Ops Center HTTP properties");
        endPoint = OCConfigureCCR.probeNetworkUsingOpsCenterProperties();
        if (endPoint != null) {
            mSlog.debug((Object)"validated Ops Center HTTP properties");
            mValidOpsProxy = true;
            if (mEndPoint == null) {
                mSlog.debug((Object)"Set endPoint to Ops Center HTTP properties");
                mEndPoint = endPoint;
            }
        } else {
            mSlog.debug((Object)"Problem validating Ops Center HTTP properties");
        }
        endPoint = null;
        mNetconfig = new NetworkConfiguration();
        mSlog.debug((Object)"Testing clear network HTTP properties");
        endPoint = OCConfigureCCR.probeClearNetwork();
        if (endPoint != null) {
            mSlog.debug((Object)"validated clear HTTP properties");
            mValidClearProxy = true;
            if (mEndPoint == null) {
                mSlog.debug((Object)"Set endPoint to clear HTTP properties");
                mEndPoint = endPoint;
            }
        } else {
            mSlog.debug((Object)"Problem validating clear HTTP properties");
        }
        endPoint = null;
        mNetconfig = new NetworkConfiguration();
        UplinkSystemConfig.reload();
        mSlog.debug((Object)"Testing OCM HTTP Properties");
        endPoint = OCConfigureCCR.probeNetworkUsingOCMProperties();
        if (endPoint != null) {
            mSlog.debug((Object)"validated OCM HTTP properties");
            mValidOcmProxy = true;
            if (mEndPoint == null) {
                mSlog.debug((Object)"Set endPoint to OCM HTTP properties");
                mEndPoint = endPoint;
            }
        } else {
            mSlog.debug((Object)"Problem validating OCM HTTP properties");
        }
        if (mEndPoint != null) {
            if (mValidOpsProxy) {
                mNetconfig = new NetworkConfiguration();
                OCConfigureCCR.probeNetworkUsingOpsCenterProperties();
            } else if (mValidClearProxy) {
                mNetconfig = new NetworkConfiguration();
                OCConfigureCCR.probeClearNetwork();
            } else if (mValidOcmProxy) {
                mNetconfig = new NetworkConfiguration();
                OCConfigureCCR.probeNetworkUsingOCMProperties();
            }
        }
        return mEndPoint;
    }

    private static OCMRegistrationPrincipal authenticate(String string, String string2, EndPoint endPoint, boolean bl) {
        try {
            OCMRegistrationPrincipal oCMRegistrationPrincipal = OCMConfigureUtil.createOCMPrincipal((EndPoint)endPoint, (String)string, (String)string2, (boolean)bl);
            return oCMRegistrationPrincipal;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean needOCMConfiguration(MBeanServerConnection mBeanServerConnection) {
        boolean bl = false;
        boolean bl2 = false;
        if (UplinkHomeConfig.isDisconnected()) {
            mSlog.info((Object)"In disconnected mode will attempt a reconfig.");
            bl2 = OCConfigureCCR.checkForMosUser(mBeanServerConnection);
            bl = true;
            return true;
        }
        Config config = UplinkSystemConfig.getInstance();
        String string = config.getProperty("ccr.registration_mode");
        mSlog.info((Object)("OCM regmethod is " + string));
        mSlog.debug((Object)("OCM REGISTRATION_METHOD_ANON is " + config.getProperty("anon")));
        mSlog.debug((Object)("OCM REGISTRATION_METHOD_CSI is " + config.getProperty("csi")));
        mSlog.debug((Object)("OCM REGISTRATION_METHOD_EMAIL is " + config.getProperty("email")));
        if (OCMConfigureUtil.ocmInUnauthMode()) {
            mSlog.info((Object)"OCM is in anonymous mode, checking for validated MOS users.");
            if (bl && bl2) {
                return true;
            }
            if (!bl) {
                bl2 = OCConfigureCCR.checkForMosUser(mBeanServerConnection);
                bl = true;
                if (bl2) {
                    mSlog.info((Object)"Found a valid MOS user will reconfig.");
                    return true;
                }
            }
        }
        if (!mValidOcmProxy) {
            mSlog.info((Object)"OCM proxy settings are not valid.");
            if (!bl) {
                OCConfigureCCR.checkForMosUser(mBeanServerConnection);
            }
            return true;
        }
        mSlog.debug((Object)"Returning from needOCMConfiguration()");
        return false;
    }

    public static void configureOCM(MBeanServerConnection mBeanServerConnection) {
        String string = null;
        String string2 = OCMConfigureUtil.getConfigCCRFile();
        if (string2 == null) {
            mSlog.error((Object)"No CCR executable, exiting");
            return;
        }
        if (mSlog.isDebugEnabled()) {
            mSlog.debug((Object)OCConfigureCCR.ocm_oc_environment(mBeanServerConnection));
        }
        OCConfigureCCR.probeNetwork();
        if (mEndPoint == null) {
            mSlog.error((Object)"Can't reach CCR endpoint, exiting.");
            return;
        }
        if (!OCConfigureCCR.needOCMConfiguration(mBeanServerConnection)) {
            mSlog.info((Object)"No OCM configuration is needed");
            return;
        }
        mSlog.info((Object)"Attempting to reconfigure OCM");
        if (mPrincipal == null) {
            MOSUser mOSUser = new MOSUser();
            mOSUser.setUsername(mANON_EMAIL);
            try {
                mSlog.debug((Object)("Attempting to authenticate:  " + mOSUser.getUsername()));
                String string3 = null;
                mOSUser.setPassword(null);
                mPrincipal = OCConfigureCCR.authenticate(mOSUser.getUsername(), string3, mEndPoint, true);
                if (mPrincipal != null) {
                    mSlog.debug((Object)"Authentication successful");
                    mSlog.info((Object)"Performed an anonymous config");
                    OCConfigureCCR.configCCR(string, string2);
                    return;
                }
                mSlog.debug((Object)("Authentication failed for: " + mOSUser.getUsername()));
            }
            catch (Exception exception) {
                mSlog.error((Object)"OCM reconfiguration failure");
                if (string != null) {
                    OCMConfigureUtil.deleteResponseFile(string);
                }
            }
        } else if (mPrincipal != null) {
            OCConfigureCCR.configCCR(string, string2);
        }
    }

    private static void configCCR(String string, String string2) {
        block2: {
            try {
                mSlog.debug((Object)"Reconfiguring OCM");
                string = OCMConfigureUtil.getResponseFile();
                OCMConfigureUtil.createResponseFile((NetworkConfiguration)mNetconfig, (OCMRegistrationPrincipal)mPrincipal, (String)string);
                OCMConfigureUtil.execConfigCCR((String)string2, (String)string);
                OCMConfigureUtil.deleteResponseFile((String)string);
            }
            catch (Exception exception) {
                mSlog.error((Object)"OCM reconfiguration failure");
                if (string == null) break block2;
                OCMConfigureUtil.deleteResponseFile((String)string);
                mSlog.error((Object)("Unable to configure CCR: " + exception.getMessage()));
            }
        }
        mSlog.info((Object)"Configured CCR.");
    }

    public static boolean checkForMosUser(MBeanServerConnection mBeanServerConnection) {
        MOSUser[] mOSUserArray = OpsCenterEntitlement.configuredMOSUsers(mBeanServerConnection);
        if (mOSUserArray == null || mOSUserArray.length <= 0) {
            return false;
        }
        for (int i = 0; i < mOSUserArray.length; ++i) {
            boolean bl = false;
            try {
                mSlog.debug((Object)("Attempting to authenticate:  " + mOSUserArray[i].getUsername()));
                String string = null;
                string = OpsCenterEntitlement.display_sum(mOSUserArray[i].getPassword());
                if (string == null && i >= mOSUserArray.length - 1) {
                    mOSUserArray[i].setPassword(null);
                    bl = true;
                } else if (string == null) continue;
                if (!bl && i >= mOSUserArray.length - 1) {
                    bl = true;
                }
                mPrincipal = OCConfigureCCR.authenticate(mOSUserArray[i].getUsername(), string, mEndPoint, bl);
                string = null;
                if (mPrincipal != null) {
                    mSlog.debug((Object)"Authentication successful");
                    mSlog.debug((Object)("mPrincipal" + mPrincipal.getClass().getCanonicalName()));
                    if (mPrincipal instanceof MetaLinkEmailPrincipal) {
                        return true;
                    }
                    if (!(mPrincipal instanceof AnonymousMailRegistrationPrincipal) || i < mOSUserArray.length - 1) continue;
                    mSlog.info((Object)"Last user available to check and resulted in an anonymous authentication.");
                    return false;
                }
                mSlog.debug((Object)("Authentication failed for: " + mOSUserArray[i].getUsername()));
                if (i >= mOSUserArray.length - 1) continue;
            }
            catch (Exception exception) {
                mSlog.error((Object)"OCM reconfiguration failure");
            }
        }
        mSlog.info((Object)"No configured MOS Users authenticated with CCR");
        return false;
    }

    private static void outstr(int n, String string, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder2.append(string);
        stringBuilder2.append('\n');
        stringBuilder.append((CharSequence)stringBuilder2);
    }

    public static String ocm_oc_environment(MBeanServerConnection mBeanServerConnection) {
        StringBuilder stringBuilder = new StringBuilder();
        Config config = UplinkSystemConfig.getInstance();
        OCConfigureCCR.outstr(0, "Ops Center-bundled OCM status:", stringBuilder);
        OCConfigureCCR.outstr(4, String.format("Connected:  %s", Collector.isDisconnected() ? "no" : "yes"), stringBuilder);
        OCConfigureCCR.outstr(4, String.format("Scheduler running:  %s", Scheduler.isStopped() ? "no" : "yes"), stringBuilder);
        OCConfigureCCR.outstr(4, "Configured Endpoint = " + config.getProperty("ccr.endpoint"), stringBuilder);
        OCConfigureCCR.outstr(4, "Registration method = " + config.getProperty("ccr.registration_mode"), stringBuilder);
        OCConfigureCCR.outstr(4, "Email Id = " + config.getProperty("ccr.metalink_email.address"), stringBuilder);
        String string = config.getProperty("ccr.support_id");
        OCConfigureCCR.outstr(4, String.format("CSI = %s", OpsCenterHarvesterUtil.is_empty(string) ? "<not configured>" : string), stringBuilder);
        String string2 = config.getProperty("http.proxyHost");
        OCConfigureCCR.outstr(4, String.format("HTTP proxy host = %s", OpsCenterHarvesterUtil.is_empty(string2) ? "<not configured>" : string2), stringBuilder);
        String string3 = config.getProperty("http.proxyPort");
        OCConfigureCCR.outstr(4, String.format("HTTP proxy port = %s", OpsCenterHarvesterUtil.is_empty(string3) ? "<not configured>" : string3), stringBuilder);
        String string4 = config.getProperty("http.proxyUser");
        OCConfigureCCR.outstr(4, String.format("HTTP proxy user = %s", OpsCenterHarvesterUtil.is_empty(string4) ? "<not configured>" : string4), stringBuilder);
        String string5 = config.getProperty("http.proxyPassword");
        OCConfigureCCR.outstr(4, String.format("HTTP proxy password = %s", OpsCenterHarvesterUtil.is_empty(string5) ? "<not configured>" : "<configured>"), stringBuilder);
        OCConfigureCCR.outstr(0, "Ops Center status:", stringBuilder);
        MOSUser[] mOSUserArray = OpsCenterEntitlement.configuredMOSUsers(mBeanServerConnection);
        for (String string6 : Oc_props_observed) {
            String string7 = mOpsCenterProperties.getProperty(string6);
            if ("proxy-password".equals(string6)) {
                OCConfigureCCR.outstr(4, String.format("Property '%s' = %s", string6, OpsCenterHarvesterUtil.is_empty(string7) ? "<not configured>" : "<configured>"), stringBuilder);
                continue;
            }
            OCConfigureCCR.outstr(4, String.format("Property '%s' = %s", string6, OpsCenterHarvesterUtil.is_empty(string7) ? "<not configured>" : string7), stringBuilder);
        }
        if (mOSUserArray != null) {
            OCConfigureCCR.outstr(4, "Number of configured MOS users = " + mOSUserArray.length, stringBuilder);
            for (int i = 0; i < mOSUserArray.length; ++i) {
                OCConfigureCCR.outstr(8, String.format("User %d = %s", i + 1, mOSUserArray[i].getUsername()), stringBuilder);
            }
        } else {
            OCConfigureCCR.outstr(4, "Unable to retrieve list of MOS users", stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static void show_environment(MBeanServerConnection mBeanServerConnection) {
        System.out.print(OCConfigureCCR.ocm_oc_environment(mBeanServerConnection));
    }

    static {
        mValidOcmProxy = false;
        mValidOpsProxy = false;
        mValidClearProxy = false;
        mNetconfig = new NetworkConfiguration();
        mOpsCenterProperties = OCConfigureCCR.loadOpsCenterProperties();
        Oc_props_observed = new HashSet<String>(){
            {
                this.add("proxy-port");
                this.add("proxy-host");
                this.add("proxy-username");
                this.add("proxy-password");
                this.add("disconnected");
            }
        };
    }
}

