/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.sysman.ccr.collector.cmd.CollectCommandException;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgr;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResultList;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadataManager;
import oracle.sysman.ccr.gcharvester.GCInit;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.gcontext.GCContextFactory;
import oracle.sysman.ccr.ocharvester.MetricFetcher;
import oracle.sysman.ccr.ocharvester.Metric_ECM_HW;
import oracle.sysman.ccr.ocharvester.Metric_ECM_HW_COMPONENT;
import oracle.sysman.ccr.ocharvester.Metric_ECM_HW_CPU;
import oracle.sysman.ccr.ocharvester.Metric_ECM_HW_NIC;
import oracle.sysman.ccr.ocharvester.Metric_ECM_INSTALLED_FIRMWARE;
import oracle.sysman.ccr.ocharvester.Metric_ECM_INSTALLED_OS_PATCHES;
import oracle.sysman.ccr.ocharvester.Metric_ECM_OS;
import oracle.sysman.ccr.ocharvester.Metric_ECM_OS_FILESYSTEM;
import oracle.sysman.ccr.ocharvester.Metric_ECM_OS_REGISTERED_SW;
import oracle.sysman.ccr.ocharvester.Metric_ECM_TARGET_VERSIONS;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;
import org.xml.sax.SAXException;

public class OCM {
    private static final Category slog = Category.getInstance((String)OCM.class.getName());
    public static final String OCM_HOME = "/var/opt/sun/xvm/ocm";
    private static final String DEFAULT_PRODUCT_HOME = "N/A";
    private static final Map<String, MetricFetcher> Metric_to_gatherer = new HashMap<String, MetricFetcher>(){
        {
            this.put("ECM_HW", new Metric_ECM_HW());
            this.put("ECM_HW_NIC", new Metric_ECM_HW_NIC());
            this.put("ECM_OS", new Metric_ECM_OS());
            this.put("ECM_OS_FILESYSTEM", new Metric_ECM_OS_FILESYSTEM());
            this.put("ECM_HW_CPU", new Metric_ECM_HW_CPU());
            this.put("ECM_INSTALLED_FIRMWARE", new Metric_ECM_INSTALLED_FIRMWARE());
            this.put("ECM_HW_COMPONENT", new Metric_ECM_HW_COMPONENT());
            this.put("ECM_INSTALLED_OS_PATCHES", new Metric_ECM_INSTALLED_OS_PATCHES());
            this.put("ECM_OS_REGISTERED_SW", new Metric_ECM_OS_REGISTERED_SW());
            this.put("ECM_TARGET_VERSIONS", new Metric_ECM_TARGET_VERSIONS());
        }
    };
    public static final String GMT_TIMEZONE = "GMT";
    private static final String HOSTNAME_REGEX = "^([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])(\\.([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]))*$";

    public static CollectionMgr OCMinit() {
        CollectionMgr collectionMgr;
        try {
            GCInit.init();
            GCContextFactory.setOPCenterContext();
            collectionMgr = CollectionMgr.getInstance();
        }
        catch (HarvesterException harvesterException) {
            slog.error((Object)("Can't connect with OCM:  " + harvesterException.getMessage()));
            collectionMgr = null;
        }
        return collectionMgr;
    }

    private static String hostname(Server server, OperatingSystem operatingSystem) {
        String string = null;
        try {
            string = operatingSystem.getUserFriendlyName();
            return string;
        }
        catch (Exception exception) {
            try {
                string = server.getUserFriendlyName();
                return string;
            }
            catch (Exception exception2) {
                return string;
            }
        }
    }

    public static String ec_hostname() {
        String string = "localhost";
        try {
            Pattern pattern = Pattern.compile(HOSTNAME_REGEX);
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    Matcher matcher;
                    InetAddress inetAddress = enumeration2.nextElement();
                    String string2 = inetAddress.getCanonicalHostName();
                    if (OpsCenterHarvesterUtil.is_empty(string2) || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !(matcher = pattern.matcher(string2)).matches()) continue;
                    return string2;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return string;
    }

    private static Target hostTarget(String string) {
        Target target = null;
        String string2 = OpsCenterHarvesterUtil.get_timezone();
        try {
            target = new Target(string, "host", false, string, false, OCM.ec_hostname(), DEFAULT_PRODUCT_HOME, null, true, string, string2, null);
            if (target.getTimeZone() == null) {
                slog.info((Object)("Unknown time zone, defaulting to GMT:  " + string2));
                target = new Target(string, "host", false, string, false, OCM.ec_hostname(), DEFAULT_PRODUCT_HOME, null, true, string, GMT_TIMEZONE, null);
            }
        }
        catch (SAXException sAXException) {
            slog.error((Object)"Unable to create new Target");
        }
        return target;
    }

    public static void harvestSystems(CollectionMgr collectionMgr, Map map, SoftwareInventory softwareInventory) {
        CollectionResultList collectionResultList = null;
        Iterator iterator = map.entrySet().iterator();
        Object[] objectArray = Metric_to_gatherer.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Server server = (Server)entry.getKey();
            OperatingSystem operatingSystem = (OperatingSystem)entry.getValue();
            if (operatingSystem == null) continue;
            try {
                if ("GlobalZone".equalsIgnoreCase(server.getGearType())) continue;
                slog.info((Object)("==> Harvesting system:  " + OCM.hostname(server, operatingSystem)));
            }
            catch (Exception exception) {
                slog.error((Object)("Error fetching Server/OS info from Ops Center:  " + exception));
            }
            TargetMetadata targetMetadata = TargetMetadataManager.getTargetMetadata((String)"host");
            String string = OCM.hostname(server, operatingSystem);
            Target target = OCM.hostTarget(string);
            if (target == null || targetMetadata == null) continue;
            collectionResultList = new CollectionResultList(target, "ll_host_config", targetMetadata.getMetadataVersion());
            if (!CollectionMgr.isGCUploaded((Target)target, (String)"ll_host_config")) {
                slog.debug((Object)("Skipping host target (" + string + ") because it has already exists in upload area"));
                continue;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                Metric metric = targetMetadata.getMetric(string2, target);
                CollectionResult collectionResult = null;
                MetricFetcher metricFetcher = Metric_to_gatherer.get(string2);
                if (metricFetcher != null) {
                    collectionResult = metricFetcher.fetch(server, operatingSystem, string2, metric, softwareInventory);
                }
                if (collectionResult == null) continue;
                collectionResultList.put((Object)string2, collectionResult);
            }
            try {
                collectionMgr.diffAndPersistCollectionForGCUpload(collectionResultList);
            }
            catch (CollectCommandException collectCommandException) {
                slog.error((Object)("Error with OCM persistence:  " + (Object)((Object)collectCommandException)));
            }
        }
    }
}

