/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.sysman.ccr.ocharvester.OSPackage;
import oracle.sysman.ccr.ocharvester.OSPatch;

public class OSInventory {
    private String name;
    private int updateHostId;
    private Set<OSPackage> pkgList = new HashSet<OSPackage>();
    private Map<String, OSPatch> patchList = new HashMap<String, OSPatch>();
    private Set<Integer> obsoletePatchList = new HashSet<Integer>();

    public OSInventory(String string, int n) {
        this.name = string;
        this.updateHostId = n;
    }

    public String getName() {
        return this.name;
    }

    public boolean addPackage(OSPackage oSPackage) {
        return this.pkgList.add(oSPackage);
    }

    public void addObsoletePatch(Integer n) {
        this.obsoletePatchList.add(n);
    }

    public Set<Integer> getObsoletedPatchList() {
        return this.obsoletePatchList;
    }

    public void addPatch(OSPatch oSPatch) {
        String string = oSPatch.getName();
        OSPatch oSPatch2 = this.patchList.get(string);
        if (oSPatch2 == null) {
            this.patchList.put(string, oSPatch);
        } else {
            String string2 = oSPatch2.getRevision();
            if (Integer.parseInt(oSPatch.getRevision()) > Integer.parseInt(string2)) {
                this.patchList.put(string, oSPatch);
            }
        }
    }

    public void removePatch(String string, String string2) {
        OSPatch oSPatch = this.patchList.get(string);
        if (oSPatch != null && string2.equals(oSPatch.getRevision())) {
            this.patchList.remove(string);
        }
    }

    public int getPackageCount() {
        return this.pkgList.size();
    }

    public int getPatchCount() {
        return this.patchList.size();
    }

    public Map<String, OSPatch> getPatches() {
        return this.patchList;
    }

    public Set<OSPackage> getPackages() {
        return this.pkgList;
    }

    public int getObsoletedPatchCount() {
        return this.obsoletePatchList.size();
    }
}

