/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import java.io.File;
import java.net.URL;
import java.util.Map;
import javax.management.MBeanServerConnection;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgr;
import oracle.sysman.ccr.ocharvester.OCConfigureCCR;
import oracle.sysman.ccr.ocharvester.OCM;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.ocharvester.OpsCenterManagedInventory;
import oracle.sysman.ccr.ocharvester.OpsCenterManagedSWInventory;
import oracle.sysman.ccr.ocharvester.OpsCenterServer;
import oracle.sysman.ccr.ocharvester.OpsCenterTarget;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import oracle.sysman.ccr.scheduler.Scheduler;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class OpsCenterHarvester {
    private static final Category slog = Category.getInstance((String)OpsCenterHarvester.class.getName());
    private static final String logProps = "ocharvester-logging.properties";
    private static final Category rootLog = Category.getRoot();
    private static MBeanServerConnection mbsc;
    private static boolean dryrun;
    private static boolean ocm_reconfigure;
    private static boolean no_update;
    private static String ocm_home;
    private static boolean force;
    private static boolean showenv;
    private static Priority logprio;

    private static void handle_args(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        block7: for (n = 0; n < n2 && (string = stringArray[n]).length() >= 2 && string.startsWith("-"); ++n) {
            char c = string.charAt(1);
            switch (c) {
                case 'n': {
                    dryrun = true;
                    continue block7;
                }
                case 'f': {
                    force = true;
                    continue block7;
                }
                case 'r': {
                    ocm_reconfigure = false;
                    continue block7;
                }
                case 'u': {
                    no_update = true;
                    continue block7;
                }
                case 'e': {
                    showenv = true;
                    continue block7;
                }
                default: {
                    System.err.println("Unrecognized argument: " + string);
                    OpsCenterHarvester.usage();
                    System.exit(1);
                }
            }
        }
        if (n < n2) {
            string = stringArray[n];
            if (!OpsCenterHarvesterUtil.is_empty(string)) {
                logprio = Priority.toPriority((String)string);
            }
            ++n;
        }
        if (n < n2 && !OpsCenterHarvesterUtil.is_empty(string = stringArray[n])) {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) {
                slog.fatal((Object)("Can't find OCM directory at:  " + string));
                System.exit(1);
            }
            ocm_home = string;
            slog.info((Object)("Using OCM home = " + ocm_home));
        }
    }

    public static MBeanServerConnection getMBeanServerConnection() {
        return mbsc;
    }

    private static boolean OpsCenterConnected() {
        return !OpsCenterHarvesterUtil.is_empty(OCConfigureCCR.getClientRegistrationId());
    }

    public static void usage() {
        System.out.println("Usage: java -jar OpsCenterHarvester.jar [options] Debug-level OCM-Home");
        System.out.println("Options");
        System.out.println("  [-n] Dry Run only.  Show Ops Center inventory");
        System.out.println("       but don't attempt to generate OCM XML");
        System.out.println("  [-r] Do not attempt to reconfigure");
        System.out.println("       OCM HTTP and authentication information");
        System.out.println("  [-f] Force OCM XML generation even if Ops");
        System.out.println("       Center is in disconnected mode");
        System.out.println("  [-u] Do not emit software inventory metrics");
        System.out.println("  [-e] Show Ops Center / OCM environment only");
        System.out.println("\nPositional Arguments:");
        System.out.println("  OCM-Home.   Use specified location for OCM.  Default is: /var/opt/sun/xvm/ocm");
        System.out.println("  Debug-level.  Use specified debug level");
        System.out.println("     <level> = ERROR | INFO | DEBUG");
        System.out.println("     A Debug level must be specified if you are also specifying OCM-Home");
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        CollectionMgr collectionMgr = null;
        try {
            object2 = Class.forName(OpsCenterHarvester.class.getName());
            object = ((Class)object2).getClassLoader().getResource(logProps);
            if (object != null) {
                PropertyConfigurator.configure((URL)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        slog.setPriority(Priority.INFO);
        slog.info((Object)"Starting Ops Center Harvester");
        OpsCenterHarvester.handle_args(stringArray);
        System.setProperty("ORACLE_HOME", ocm_home);
        rootLog.setPriority(logprio);
        object2 = OpsCenterServer.getInstance();
        mbsc = ((OpsCenterServer)object2).connect();
        if (mbsc == null) {
            slog.fatal((Object)"Unable to connect to Ops Center enterprise controller");
            System.exit(1);
        }
        if (!(force || dryrun || OpsCenterHarvester.OpsCenterConnected())) {
            slog.info((Object)"Ops Center is disconnected; no harvesting will be done");
            System.exit(1);
        }
        object = ((OpsCenterServer)object2).OCVersion();
        slog.info((Object)("Ops Center version = " + ((OpsCenterServer.Version_level)((Object)object)).toString()));
        if (((OpsCenterServer)object2).compareOpsCenterVersion(OpsCenterServer.Version_level.ECHELON) < 0) {
            slog.fatal((Object)"Unrecognized or unsupported version of Ops Center");
            System.exit(1);
        }
        if (!dryrun) {
            collectionMgr = OCM.OCMinit();
            if (collectionMgr == null) {
                slog.fatal((Object)"Unable to connect to Oracle Configuration Manager");
                System.exit(1);
            }
            if (showenv) {
                OCConfigureCCR.show_environment(mbsc);
                System.exit(0);
            }
            if (!force) {
                if (Collector.isDisconnected()) {
                    slog.info((Object)"OCM disconnected; no harvesting will be done");
                    System.exit(1);
                } else if (Scheduler.isStopped()) {
                    slog.info((Object)"OCM scheduler stopped; no harvesting will be done");
                    System.exit(1);
                }
            }
        }
        if (ocm_reconfigure && !((OpsCenterServer)object2).is_version(OpsCenterServer.Version_level.ECHELON)) {
            OCConfigureCCR.configureOCM(mbsc);
        }
        Map map = OpsCenterManagedInventory.retrieveAssets(mbsc);
        if (slog.isDebugEnabled()) {
            slog.debug((Object)("Number of Ops Center managed systems: " + map.size()));
            OpsCenterManagedInventory.topodump(map);
        }
        SoftwareInventory softwareInventory = null;
        if (!no_update) {
            softwareInventory = OpsCenterManagedSWInventory.process_software_inventory(mbsc, map);
        }
        if (!dryrun && map != null) {
            OCM.harvestSystems(collectionMgr, map, softwareInventory);
            OpsCenterTarget.createOpsCenterTarget(mbsc, collectionMgr, map);
        }
        System.exit(0);
    }

    static {
        dryrun = false;
        ocm_reconfigure = true;
        no_update = false;
        ocm_home = "/var/opt/sun/xvm/ocm";
        force = false;
        showenv = false;
        logprio = Priority.INFO;
    }
}

