/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.hss.type.os.OperatingSystem;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpsCenterHarvesterUtil {
    public static final long ONE_MEG = 0x100000L;
    public static final long ONE_GIG = 0x40000000L;
    private static String timezone;
    public static final String SOLARIS_OS_MATCHER = "^[\\s]*(?:[Oo]racle[\\s]?)?([Ss][Oo][Ll][Aa][Rr][Ii][Ss])[\\s]+([0-9]+)[\\s]+([0-9]+/[0-9]+)(.*)";
    public static final String SOLARIS11_OS_MATCHER = "^[\\s]*(?:[Oo]racle[\\s]?)?([Ss][Oo][Ll][Aa][Rr][Ii][Ss])[\\s]+([0-9]+)[\\s]+(Update [0-9]+)(.*)";
    public static final String LINUX_RHEL_OS_MATCHER = "^[\\s]*(Red Hat Enterprise Linux Server release)[\\s]+([0-9]+)[\\.]+([0-9]+)(.*)";
    public static final String LINUX_SUSE_OS_MATCHER = "^[\\s]*(SUSE Linux Enterprise Server)[\\s]+([0-9]+)[\\s]+(.*)";

    public static String get_timezone() {
        return timezone;
    }

    public static boolean is_empty(String string) {
        return string == null || string.length() == 0 || string.trim().equals("");
    }

    public static String os_hostname(OperatingSystem operatingSystem) {
        try {
            return operatingSystem.getHostname();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] os_base_and_update(OperatingSystem operatingSystem) {
        String[] stringArray = new String[]{null, null};
        try {
            int n;
            Matcher matcher;
            Pattern pattern = Pattern.compile(SOLARIS_OS_MATCHER);
            if (pattern != null && (matcher = pattern.matcher(operatingSystem.getDescription())) != null && matcher.matches() && 4 == (n = matcher.groupCount())) {
                stringArray[0] = matcher.group(2);
                stringArray[1] = matcher.group(3);
                return stringArray;
            }
            pattern = Pattern.compile(SOLARIS11_OS_MATCHER);
            if (pattern != null && (matcher = pattern.matcher(operatingSystem.getDescription())) != null && matcher.matches() && 4 == (n = matcher.groupCount())) {
                stringArray[0] = matcher.group(2);
                stringArray[1] = matcher.group(3);
                return stringArray;
            }
            pattern = Pattern.compile(LINUX_RHEL_OS_MATCHER);
            if (pattern != null && (matcher = pattern.matcher(operatingSystem.getDescription())) != null && matcher.matches() && 4 == (n = matcher.groupCount())) {
                stringArray[0] = matcher.group(2);
                stringArray[1] = matcher.group(3);
                return stringArray;
            }
            pattern = Pattern.compile(LINUX_SUSE_OS_MATCHER);
            if (pattern != null && (matcher = pattern.matcher(operatingSystem.getDescription())) != null && matcher.matches() && 3 == (n = matcher.groupCount())) {
                stringArray[0] = matcher.group(2);
                stringArray[1] = "";
                return stringArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    static {
        Calendar calendar = Calendar.getInstance();
        TimeZone timeZone = calendar.getTimeZone();
        timezone = timeZone.getID();
    }
}

