/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.cacao.ObjectNameFactory;
import com.sun.hss.domain.MXBeanProxyFactory;
import com.sun.hss.domain.types.BoardInfo;
import com.sun.hss.domain.types.BoardInfoSet;
import com.sun.hss.domain.types.CpuInfo;
import com.sun.hss.domain.types.CpuInfoSet;
import com.sun.hss.domain.types.DiskInfo;
import com.sun.hss.domain.types.DiskInfoSet;
import com.sun.hss.domain.types.FirmwareInfo;
import com.sun.hss.domain.types.FirmwareInfoSet;
import com.sun.hss.domain.types.HardDiskInfo;
import com.sun.hss.domain.types.HardDiskInfoSet;
import com.sun.hss.domain.types.IOUnitInfo;
import com.sun.hss.domain.types.IOUnitInfoSet;
import com.sun.hss.domain.types.InterfaceInfo;
import com.sun.hss.domain.types.InterfaceInfoSet;
import com.sun.hss.domain.types.LocalDiskInfo;
import com.sun.hss.domain.types.LocalDiskInfoSet;
import com.sun.hss.domain.types.MemoryInfo;
import com.sun.hss.domain.types.MemoryInfoSet;
import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import com.sun.hss.type.servercontainer.ServerContainer;
import com.sun.hss.type.switchmgmt.Switch;
import com.sun.xvm.services.gear.GearServiceMXBean;
import com.sun.xvm.services.svrmgmt.SvrMgmtServiceMXBean;
import com.sun.xvm.services.switchmgmt.SwitchServiceMXBean;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.log4j.Category;

public class OpsCenterManagedInventory {
    private static final Category slog = Category.getInstance((String)OpsCenterManagedInventory.class.getName());

    public static SvrMgmtServiceMXBean getSvrMgmtService(MBeanServerConnection mBeanServerConnection) throws Exception {
        ObjectName objectName = new ObjectNameFactory(SvrMgmtServiceMXBean.class).getObjectName(SvrMgmtServiceMXBean.class, null);
        return (SvrMgmtServiceMXBean)MXBeanProxyFactory.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)objectName, SvrMgmtServiceMXBean.class, (boolean)false);
    }

    public static GearServiceMXBean getGearService(MBeanServerConnection mBeanServerConnection) throws Exception {
        ObjectName objectName = new ObjectNameFactory(GearServiceMXBean.class).getObjectName(GearServiceMXBean.class, null);
        return (GearServiceMXBean)MXBeanProxyFactory.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)objectName, GearServiceMXBean.class, (boolean)false);
    }

    public static SwitchServiceMXBean getSwitchService(MBeanServerConnection mBeanServerConnection) throws Exception {
        ObjectName objectName = new ObjectNameFactory(SwitchServiceMXBean.class).getObjectName(SwitchServiceMXBean.class, null);
        return (SwitchServiceMXBean)MXBeanProxyFactory.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)objectName, SwitchServiceMXBean.class, (boolean)false);
    }

    public static boolean ObjectNameType(ObjectName objectName, String string) {
        return string.equalsIgnoreCase(objectName.getKeyProperty("type"));
    }

    public static Map retrieveAssets(MBeanServerConnection mBeanServerConnection) {
        HashMap<Server, OperatingSystem> hashMap = new HashMap<Server, OperatingSystem>();
        try {
            GearServiceMXBean gearServiceMXBean = OpsCenterManagedInventory.getGearService(mBeanServerConnection);
            SvrMgmtServiceMXBean svrMgmtServiceMXBean = OpsCenterManagedInventory.getSvrMgmtService(mBeanServerConnection);
            if (gearServiceMXBean == null || svrMgmtServiceMXBean == null) {
                return null;
            }
            ObjectName[] objectNameArray = gearServiceMXBean.getGearObjectNames(null, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName[] objectNameArray2;
                OperatingSystem[] operatingSystemArray;
                if (objectNameArray[i] == null || !OpsCenterManagedInventory.ObjectNameType(objectNameArray[i], "Server")) continue;
                ObjectName[] objectNameArray3 = new ObjectName[]{objectNameArray[i]};
                Server[] serverArray = svrMgmtServiceMXBean.getServers(objectNameArray3, null);
                OperatingSystem operatingSystem = null;
                if (serverArray == null || serverArray.length <= 0 || serverArray[0] == null) continue;
                ObjectName objectName = gearServiceMXBean.getAssociated(objectNameArray[i]);
                if (objectName != null && OpsCenterManagedInventory.ObjectNameType(objectName, "OperatingSystem") && (operatingSystemArray = svrMgmtServiceMXBean.getOperatingSystems(objectNameArray2 = new ObjectName[]{objectName}, null)) != null & operatingSystemArray.length > 0 && operatingSystemArray[0] != null) {
                    operatingSystem = operatingSystemArray[0];
                }
                hashMap.put(serverArray[0], operatingSystem);
            }
        }
        catch (Exception exception) {
            slog.error((Object)("Gear client retrieval error :" + exception.toString()));
            exception.printStackTrace();
        }
        return hashMap;
    }

    public static Switch[] getSwitches(MBeanServerConnection mBeanServerConnection) {
        Switch[] switchArray = null;
        try {
            SwitchServiceMXBean switchServiceMXBean = OpsCenterManagedInventory.getSwitchService(mBeanServerConnection);
            ObjectName[] objectNameArray = switchServiceMXBean.getObjectNames(null, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                slog.debug((Object)("Switch " + i + " = " + objectNameArray[i]));
            }
            switchArray = switchServiceMXBean.getSwitches(objectNameArray, null);
            slog.debug((Object)("Number of switch objects = " + objectNameArray.length));
        }
        catch (Exception exception) {
            slog.error((Object)("Error fetching Switch objects:  " + exception));
        }
        return switchArray;
    }

    public static ServerContainer[] getChassis(MBeanServerConnection mBeanServerConnection) {
        ServerContainer[] serverContainerArray = null;
        try {
            SvrMgmtServiceMXBean svrMgmtServiceMXBean = OpsCenterManagedInventory.getSvrMgmtService(mBeanServerConnection);
            ObjectName[] objectNameArray = svrMgmtServiceMXBean.getChassisObjectNames(null, null);
            serverContainerArray = svrMgmtServiceMXBean.getChassis(objectNameArray, null);
            slog.debug((Object)("Number of Chassis = " + serverContainerArray.length));
        }
        catch (Exception exception) {
            slog.error((Object)("Error fetching Chassis objects:  " + exception));
        }
        return serverContainerArray;
    }

    private static String prval(String string) {
        if (string != null && string.length() == 0) {
            return "<empty>";
        }
        return string != null ? string : "<not available>";
    }

    private static void pr_firmware(Server server) {
        try {
            FirmwareInfo[] firmwareInfoArray;
            FirmwareInfoSet firmwareInfoSet = server.getFirmwareInfos();
            if (firmwareInfoSet != null && (firmwareInfoArray = firmwareInfoSet.getValues()) != null) {
                for (int i = 0; i < firmwareInfoArray.length; ++i) {
                    if (firmwareInfoArray[i] == null) continue;
                    slog.debug((Object)("   Firmware[" + (i + 1) + "]  Description: " + OpsCenterManagedInventory.prval(firmwareInfoArray[i].getDescription())));
                    slog.debug((Object)("   Firmware[" + (i + 1) + "]  Type: " + OpsCenterManagedInventory.prval(firmwareInfoArray[i].getType())));
                    slog.debug((Object)("   Firmware[" + (i + 1) + "]  Version: " + OpsCenterManagedInventory.prval(firmwareInfoArray[i].getVersion())));
                    slog.debug((Object)("   Firmware[" + (i + 1) + "]  is Compliant?: " + firmwareInfoArray[i].isCompliant()));
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void pr_io(Server server) {
        try {
            IOUnitInfo[] iOUnitInfoArray;
            IOUnitInfoSet iOUnitInfoSet = server.getIOUnitSet();
            if (iOUnitInfoSet != null && (iOUnitInfoArray = iOUnitInfoSet.getValues()) != null) {
                for (int i = 0; i < iOUnitInfoArray.length; ++i) {
                    if (iOUnitInfoArray[i] == null) continue;
                    slog.debug((Object)("   IO[" + (i + 1) + "]  Name: " + OpsCenterManagedInventory.prval(iOUnitInfoArray[i].getName())));
                    slog.debug((Object)("   IO[" + (i + 1) + "]  Manufacturer: " + OpsCenterManagedInventory.prval(iOUnitInfoArray[i].getManufacturer())));
                    slog.debug((Object)("   IO[" + (i + 1) + "]  Version: " + OpsCenterManagedInventory.prval(iOUnitInfoArray[i].getVersion())));
                    slog.debug((Object)("   IO[" + (i + 1) + "]  Part Number: " + iOUnitInfoArray[i].getPartNumber()));
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void pr_cpu(Server server) {
        try {
            CpuInfo[] cpuInfoArray;
            CpuInfoSet cpuInfoSet = server.getCpuInfos();
            if (cpuInfoSet != null && (cpuInfoArray = cpuInfoSet.getValues()) != null) {
                for (int i = 0; i < cpuInfoArray.length; ++i) {
                    if (cpuInfoArray[i] == null) continue;
                    slog.debug((Object)("   CPU[" + (i + 1) + "]  Architecture: " + OpsCenterManagedInventory.prval(cpuInfoArray[i].getArchitecture())));
                    slog.debug((Object)("   CPU[" + (i + 1) + "]  Model: " + OpsCenterManagedInventory.prval(cpuInfoArray[i].getModel())));
                    slog.debug((Object)("   CPU[" + (i + 1) + "]  Speed: " + cpuInfoArray[i].getSpeed()));
                    slog.debug((Object)("   CPU[" + (i + 1) + "]  Core Count: " + cpuInfoArray[i].getCoreCount()));
                    slog.debug((Object)("   CPU[" + (i + 1) + "]  Thread Count: " + cpuInfoArray[i].getThreadCount()));
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void pr_memory(Server server) {
        try {
            MemoryInfo[] memoryInfoArray;
            MemoryInfoSet memoryInfoSet = server.getMemoryInfos();
            if (memoryInfoSet != null && (memoryInfoArray = memoryInfoSet.getValues()) != null) {
                for (int i = 0; i < memoryInfoArray.length; ++i) {
                    slog.debug((Object)("   Memory[" + (i + 1) + "]  Architecture: " + OpsCenterManagedInventory.prval(memoryInfoArray[i].getType())));
                    slog.debug((Object)("   Memory[" + (i + 1) + "]  Name: " + OpsCenterManagedInventory.prval(memoryInfoArray[i].getName())));
                    slog.debug((Object)("   Memory[" + (i + 1) + "]  Size: " + memoryInfoArray[i].getSize()));
                    slog.debug((Object)("   Memory[" + (i + 1) + "] Manufacturer: " + memoryInfoArray[i].getManufacturer()));
                    slog.debug((Object)("   Memory[" + (i + 1) + "] Part Number: " + memoryInfoArray[i].getPartNumber()));
                    slog.debug((Object)("   Memory[" + (i + 1) + "] Serial Number: " + memoryInfoArray[i].getSerialNumber()));
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void pr_diskset(Server server) {
        try {
            HardDiskInfo[] hardDiskInfoArray;
            HardDiskInfoSet hardDiskInfoSet = server.getHardDiskSet();
            if (hardDiskInfoSet != null && (hardDiskInfoArray = hardDiskInfoSet.getValues()) != null) {
                for (int i = 0; i < hardDiskInfoArray.length; ++i) {
                    slog.debug((Object)("    Disk[" + (i + 1) + "]      Architecture: " + OpsCenterManagedInventory.prval(hardDiskInfoArray[i].getName())));
                    slog.debug((Object)("    Disk[" + (i + 1) + "]      Size: " + hardDiskInfoArray[i].getSizeInBytes()));
                    slog.debug((Object)("    Disk[" + (i + 1) + "]      Part Number: " + hardDiskInfoArray[i].getPartNumber()));
                    slog.debug((Object)("    Disk[" + (i + 1) + "]      Manufacturer: " + hardDiskInfoArray[i].getManufacturer()));
                    slog.debug((Object)("    Disk[" + (i + 1) + "]      Serial Number: " + hardDiskInfoArray[i].getSerialNumber()));
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void pr_boards(Server server) {
        try {
            BoardInfo[] boardInfoArray;
            BoardInfoSet boardInfoSet = server.getBoardInfoSet();
            if (boardInfoSet != null && (boardInfoArray = boardInfoSet.getValues()) != null) {
                for (int i = 0; i < boardInfoArray.length; ++i) {
                    slog.debug((Object)("    Board[" + (i + 1) + "]      Name: " + OpsCenterManagedInventory.prval(boardInfoArray[i].getName())));
                    slog.debug((Object)("    Board[" + (i + 1) + "]      Manufacturer: " + boardInfoArray[i].getManufacturer()));
                    slog.debug((Object)("    Board[" + (i + 1) + "]      Part Number: " + boardInfoArray[i].getPartNumber()));
                    slog.debug((Object)("    Board[" + (i + 1) + "]      Serial Number: " + boardInfoArray[i].getSerialNumber()));
                    slog.debug((Object)("    Disk[" + (i + 1) + "]      Version: " + boardInfoArray[i].getVersion()));
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void pr_interfaces(OperatingSystem operatingSystem) {
        try {
            InterfaceInfo[] interfaceInfoArray;
            InterfaceInfoSet interfaceInfoSet = operatingSystem.getInterfaceInfos();
            if (interfaceInfoSet != null && (interfaceInfoArray = interfaceInfoSet.getValues()) != null && interfaceInfoArray.length > 0) {
                for (int i = 0; i < interfaceInfoArray.length; ++i) {
                    slog.debug((Object)("   OS Network interface Name [" + (i + 1) + "] " + interfaceInfoArray[i].getName()));
                    slog.debug((Object)("   OS Network interface IP address [" + (i + 1) + "] " + OpsCenterManagedInventory.prval(interfaceInfoArray[i].getIpAddress())));
                    slog.debug((Object)("   OS Network interface IP address [" + (i + 1) + "] " + OpsCenterManagedInventory.prval(interfaceInfoArray[i].getMacAddress())));
                    slog.debug((Object)("   OS Network interface subnet mask [" + (i + 1) + "] " + OpsCenterManagedInventory.prval(interfaceInfoArray[i].getSubnetMask())));
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void pr_disks(OperatingSystem operatingSystem) {
        try {
            DiskInfo[] diskInfoArray;
            DiskInfoSet diskInfoSet = operatingSystem.getDiskInfoSet();
            if (diskInfoSet != null && (diskInfoArray = diskInfoSet.getValues()) != null && diskInfoArray.length > 0) {
                for (int i = 0; i < diskInfoArray.length; ++i) {
                    slog.debug((Object)("   OS Disk Name: [" + (i + 1) + "] " + diskInfoArray[i].getName()));
                    slog.debug((Object)("   OS Disk Descriptive Name:  [" + (i + 1) + "] " + diskInfoArray[i].getDescriptiveName()));
                    slog.debug((Object)("   OS Disk Type:  [" + (i + 1) + "] " + diskInfoArray[i].getType()));
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void pr_localdisks(OperatingSystem operatingSystem) {
        try {
            LocalDiskInfo[] localDiskInfoArray;
            LocalDiskInfoSet localDiskInfoSet = operatingSystem.getLocalDiskInfos();
            if (localDiskInfoSet != null && (localDiskInfoArray = localDiskInfoSet.getValues()) != null && localDiskInfoArray.length > 0) {
                for (int i = 0; i < localDiskInfoArray.length; ++i) {
                    slog.debug((Object)("   OS Local Disk Name: [" + (i + 1) + "] " + localDiskInfoArray[i].getName()));
                    slog.debug((Object)("   OS Local Disk Capacity:  [" + (i + 1) + "] " + localDiskInfoArray[i].getCapacity()));
                    slog.debug((Object)("   OS Local Disk Firmware Version:  [" + (i + 1) + "] " + localDiskInfoArray[i].getFirmwareVersion()));
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void topodump(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            Server server = (Server)entry.getKey();
            OperatingSystem operatingSystem = (OperatingSystem)entry.getValue();
            try {
                slog.debug((Object)("Server:  " + OpsCenterManagedInventory.prval(server.getUserFriendlyName())));
                slog.debug((Object)("   Manufacturer:  " + OpsCenterManagedInventory.prval(server.getManufacturer())));
                slog.debug((Object)("   Model:  " + OpsCenterManagedInventory.prval(server.getModel())));
                slog.debug((Object)("   Internal Name:   " + OpsCenterManagedInventory.prval(server.getName())));
                slog.debug((Object)("   Machine Hardware Class:   " + OpsCenterManagedInventory.prval(server.getMachineHardwareClass())));
                slog.debug((Object)("   Serial Number:   " + OpsCenterManagedInventory.prval(server.getSerialNumber())));
                slog.debug((Object)("   User Friendly Description:   " + OpsCenterManagedInventory.prval(server.getUserFriendlyDescription())));
                slog.debug((Object)("   UUID (from BIOS):   " + OpsCenterManagedInventory.prval(server.getUuid())));
                slog.debug((Object)("   Service Tag Instance URN:    " + OpsCenterManagedInventory.prval(server.getServiceTagInstanceURN())));
                slog.debug((Object)("   Managed State    " + OpsCenterManagedInventory.prval(server.getManagedState())));
                OpsCenterManagedInventory.pr_firmware(server);
                OpsCenterManagedInventory.pr_cpu(server);
                OpsCenterManagedInventory.pr_memory(server);
                OpsCenterManagedInventory.pr_diskset(server);
                OpsCenterManagedInventory.pr_io(server);
                OpsCenterManagedInventory.pr_boards(server);
                if (operatingSystem == null) continue;
                slog.debug((Object)("   OS Description:    " + OpsCenterManagedInventory.prval(operatingSystem.getDescription())));
                slog.debug((Object)("   OS Host Name :   " + OpsCenterManagedInventory.prval(operatingSystem.getHostname())));
                slog.debug((Object)("   OS Host ID :   " + OpsCenterManagedInventory.prval(operatingSystem.getHostId())));
                slog.debug((Object)("   OS CPU Architecture :   " + OpsCenterManagedInventory.prval(operatingSystem.getCpuArchitecture())));
                slog.debug((Object)("   OS Type :   " + OpsCenterManagedInventory.prval(operatingSystem.getType())));
                slog.debug((Object)("   OS Service Tag Instance URN :   " + OpsCenterManagedInventory.prval(operatingSystem.getServiceTagInstanceURN())));
                slog.debug((Object)("   OS User Friendly Description :   " + OpsCenterManagedInventory.prval(operatingSystem.getUserFriendlyDescription())));
                slog.debug((Object)("   OS User Friendly Name :   " + OpsCenterManagedInventory.prval(operatingSystem.getUserFriendlyName())));
                slog.debug((Object)("   OS Type :   " + OpsCenterManagedInventory.prval(operatingSystem.getGearType())));
                OpsCenterManagedInventory.pr_interfaces(operatingSystem);
                OpsCenterManagedInventory.pr_disks(operatingSystem);
                OpsCenterManagedInventory.pr_localdisks(operatingSystem);
            }
            catch (Exception exception) {}
        }
    }
}

