/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.cacao.ObjectNameFactory;
import com.sun.hss.domain.MXBeanProxyFactory;
import com.sun.xvm.opscenter.updatechannel.XVMUpdateServicePrivateMXBean;
import com.sun.xvm.opscenter.updatechannel.datastructures.XVMUpdateHostIdentifier;
import com.sun.xvm.opscenter.updatechannel.datastructures.XVMUpdateHostInfo;
import com.sun.xvm.opscenter.updatechannel.datastructures.XVMUpdateInventory;
import com.sun.xvm.opscenter.updatechannel.datastructures.XVMUpdateInventoryItem;
import com.sun.xvm.opscenter.updatechannel.datastructures.XVMUpdateVtreeNode;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import oracle.sysman.ccr.ocharvester.OSInventory;
import oracle.sysman.ccr.ocharvester.OSPackage;
import oracle.sysman.ccr.ocharvester.OSPatch;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.ocharvester.OpsCenterManagedInventory;
import oracle.sysman.ccr.ocharvester.SoftwareInventory;
import org.apache.log4j.Category;

public class OpsCenterManagedSWInventory {
    private static final Category slog = Category.getInstance((String)OpsCenterManagedInventory.class.getName());
    private static final String Pkg_re = "^(.*)-([\\d]+[\\.[\\d]+]*)-([\\d]+[\\.[\\d]+]*)[\\s]+(.*)";
    private static final String Rpm_re = "^(.*)-([alpha]*[\\d]+(?:.*))-(.*)";
    private static final Pattern Patt_pkg_re = Pattern.compile("^(.*)-([\\d]+[\\.[\\d]+]*)-([\\d]+[\\.[\\d]+]*)[\\s]+(.*)");
    private static final Pattern Patt_rpm_re = Pattern.compile("^(.*)-([alpha]*[\\d]+(?:.*))-(.*)");
    private static final String PKG_SVR4 = "pkg__";
    private static final String PKG_RPM = "rpm__";
    private static final String PATCH = "patch__";

    public static XVMUpdateServicePrivateMXBean getUpdateService(MBeanServerConnection mBeanServerConnection) throws Exception {
        ObjectName objectName = new ObjectNameFactory(XVMUpdateServicePrivateMXBean.class).getObjectName(XVMUpdateServicePrivateMXBean.class, null);
        return (XVMUpdateServicePrivateMXBean)MXBeanProxyFactory.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)objectName, XVMUpdateServicePrivateMXBean.class, (boolean)false);
    }

    private static String getName(String string, String string2) {
        int n = string2.length();
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(n, n2);
        }
        return null;
    }

    private static void process_svr4_entry(XVMUpdateVtreeNode xVMUpdateVtreeNode, String string, OSInventory oSInventory) {
        String string2 = OpsCenterManagedSWInventory.getName(string, PKG_SVR4);
        if (!OpsCenterHarvesterUtil.is_empty(string2)) {
            Matcher matcher;
            String string3 = xVMUpdateVtreeNode.getComponentDescription();
            String string4 = xVMUpdateVtreeNode.getNameToShow();
            if (!OpsCenterHarvesterUtil.is_empty(string4) && Patt_pkg_re != null && (matcher = Patt_pkg_re.matcher(string4)) != null && matcher.matches() && matcher.groupCount() == 4) {
                OSPackage oSPackage = new OSPackage(string2, OSPackage.PackageType.SVR4, matcher.group(2), string3, matcher.group(3));
                oSInventory.addPackage(oSPackage);
            }
        }
    }

    private static void process_rpm_entry(XVMUpdateVtreeNode xVMUpdateVtreeNode, String string, OSInventory oSInventory) {
        String string2 = OpsCenterManagedSWInventory.getName(string, PKG_RPM);
        if (!OpsCenterHarvesterUtil.is_empty(string2)) {
            Matcher matcher;
            String string3 = xVMUpdateVtreeNode.getComponentDescription();
            String string4 = xVMUpdateVtreeNode.getNameToShow();
            if (!OpsCenterHarvesterUtil.is_empty(string4) && Patt_rpm_re != null && (matcher = Patt_rpm_re.matcher(string4)) != null && matcher.matches() && matcher.groupCount() == 3) {
                OSPackage oSPackage = new OSPackage(string2, OSPackage.PackageType.RPM, matcher.group(2), string3, matcher.group(3));
                oSInventory.addPackage(oSPackage);
            }
        }
    }

    private static void process_patch_entry(XVMUpdateVtreeNode xVMUpdateVtreeNode, String string, OSInventory oSInventory) {
        String string2 = OpsCenterManagedSWInventory.getName(string, PATCH);
        if (!OpsCenterHarvesterUtil.is_empty(string2)) {
            int n;
            String string3 = xVMUpdateVtreeNode.getComponentDescription();
            String string4 = xVMUpdateVtreeNode.getNameToShow();
            if (!(OpsCenterHarvesterUtil.is_empty(string4) || string4.startsWith("8") || xVMUpdateVtreeNode.isWithdrawn() || string4.toLowerCase().indexOf("withdrawn") != -1 || (n = string4.indexOf("-")) == -1)) {
                String string5 = string4.substring(n + 1, string4.length());
                OSPatch oSPatch = new OSPatch(string2, string5, string3);
                oSInventory.addPatch(oSPatch);
                List list = xVMUpdateVtreeNode.getObsoletes();
                if (list != null) {
                    for (Integer n2 : list) {
                        oSInventory.addObsoletePatch(n2);
                    }
                }
            }
        }
    }

    private static void process_component(XVMUpdateVtreeNode xVMUpdateVtreeNode, String string, OSInventory oSInventory) {
        if (string.startsWith(PKG_SVR4)) {
            OpsCenterManagedSWInventory.process_svr4_entry(xVMUpdateVtreeNode, string, oSInventory);
        } else if (string.startsWith(PKG_RPM)) {
            OpsCenterManagedSWInventory.process_rpm_entry(xVMUpdateVtreeNode, string, oSInventory);
        } else if (string.startsWith(PATCH)) {
            OpsCenterManagedSWInventory.process_patch_entry(xVMUpdateVtreeNode, string, oSInventory);
        }
    }

    private static void process_next_inventory_elem(XVMUpdateInventoryItem xVMUpdateInventoryItem, XVMUpdateServicePrivateMXBean xVMUpdateServicePrivateMXBean, OSInventory oSInventory) {
        String string;
        int n;
        int n2;
        XVMUpdateVtreeNode xVMUpdateVtreeNode;
        if (xVMUpdateInventoryItem != null && (xVMUpdateVtreeNode = xVMUpdateServicePrivateMXBean.getVtreeNode(n2 = xVMUpdateInventoryItem.getComponentId())) != null && (n = xVMUpdateVtreeNode.getNextBrotherId()) == 0 && (string = xVMUpdateVtreeNode.getComponentName()) != null) {
            OpsCenterManagedSWInventory.process_component(xVMUpdateVtreeNode, string, oSInventory);
        }
    }

    private static void prunePatchList(XVMUpdateServicePrivateMXBean xVMUpdateServicePrivateMXBean, OSInventory oSInventory) {
        Set<Integer> set = oSInventory.getObsoletedPatchList();
        if (set != null) {
            for (Integer n : set) {
                int n2;
                int n3 = n;
                XVMUpdateVtreeNode xVMUpdateVtreeNode = xVMUpdateServicePrivateMXBean.getVtreeNode(n3);
                if (xVMUpdateVtreeNode == null) continue;
                String string = xVMUpdateVtreeNode.getComponentName();
                String string2 = OpsCenterManagedSWInventory.getName(string, PATCH);
                String string3 = xVMUpdateVtreeNode.getNameToShow();
                if (OpsCenterHarvesterUtil.is_empty(string2) || OpsCenterHarvesterUtil.is_empty(string3) || (n2 = string3.indexOf("-")) == -1) continue;
                String string4 = string3.substring(n2 + 1, string3.length());
                oSInventory.removePatch(string2, string4);
            }
        }
    }

    public static List<String> getChannels(MBeanServerConnection mBeanServerConnection) {
        try {
            XVMUpdateServicePrivateMXBean xVMUpdateServicePrivateMXBean = OpsCenterManagedSWInventory.getUpdateService(mBeanServerConnection);
            return xVMUpdateServicePrivateMXBean.getAvailableDistributions(false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static SoftwareInventory process_software_inventory(MBeanServerConnection mBeanServerConnection, Map map) {
        SoftwareInventory softwareInventory = new SoftwareInventory();
        try {
            XVMUpdateServicePrivateMXBean xVMUpdateServicePrivateMXBean = OpsCenterManagedSWInventory.getUpdateService(mBeanServerConnection);
            List list = xVMUpdateServicePrivateMXBean.getAvailableDistributions(false);
            slog.info((Object)("Update channels = " + list));
            try {
                Set set = xVMUpdateServicePrivateMXBean.loadHosts();
                for (XVMUpdateHostInfo xVMUpdateHostInfo : set) {
                    int n = xVMUpdateHostInfo.getHostId();
                    XVMUpdateHostIdentifier xVMUpdateHostIdentifier = xVMUpdateHostInfo.getHostIdentifier();
                    slog.debug((Object)("ident is " + xVMUpdateHostIdentifier.getIdentifier()));
                    if (!xVMUpdateServicePrivateMXBean.isInventoryAvailable(xVMUpdateHostIdentifier).booleanValue()) continue;
                    XVMUpdateInventory xVMUpdateInventory = xVMUpdateServicePrivateMXBean.loadInventory(xVMUpdateHostIdentifier, null);
                    OSInventory oSInventory = new OSInventory(xVMUpdateHostInfo.getHostName(), n);
                    Enumeration enumeration = Collections.enumeration(xVMUpdateInventory.getInventory());
                    while (enumeration.hasMoreElements()) {
                        OpsCenterManagedSWInventory.process_next_inventory_elem((XVMUpdateInventoryItem)enumeration.nextElement(), xVMUpdateServicePrivateMXBean, oSInventory);
                    }
                    if (slog.isDebugEnabled()) {
                        slog.debug((Object)("-- package count = " + oSInventory.getPackageCount()));
                        slog.debug((Object)("-- patch count = " + oSInventory.getPatchCount()));
                        slog.debug((Object)("-- obsoleted patch count = " + oSInventory.getObsoletedPatchCount()));
                    }
                    softwareInventory.addInventory(oSInventory);
                }
            }
            catch (Exception exception) {
                slog.info((Object)"Failed to load hosts from Update Service");
            }
        }
        catch (Exception exception) {
            slog.error((Object)"Failed to get Update Service Bean");
        }
        return softwareInventory;
    }
}

