/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import org.apache.log4j.Category;

public class OpsCenterServer {
    private static final Category slog = Category.getInstance((String)OpsCenterServer.class.getName());
    private static OpsCenterServer instance = null;
    private MBeanServerConnection mbsc = null;
    private String full_opscenter_version = null;
    private Version_level opscenter_level = null;

    private OpsCenterServer() {
    }

    public static OpsCenterServer getInstance() {
        if (instance == null) {
            instance = new OpsCenterServer();
        }
        return instance;
    }

    public MBeanServerConnection connect() {
        MBeanServerConnection mBeanServerConnection = this.jmxconnect();
        if (mBeanServerConnection != null) {
            this.mbsc = mBeanServerConnection;
            return mBeanServerConnection;
        }
        return null;
    }

    private MBeanServerConnection jmxconnect() {
        HashMap hashMap = new HashMap();
        MBeanServerConnection mBeanServerConnection = null;
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL("service:jmx:cacao-rmi://localhost");
            slog.info((Object)("Opening local connection:  " + jMXServiceURL));
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            String string = "com.sun.cacao.";
            hashMap2.put(string + "wellknown", "true");
            String string2 = System.getProperty("os.name");
            if (!OpsCenterHarvesterUtil.is_empty(string2) && "linux".equalsIgnoreCase(string2)) {
                hashMap2.put("com.sun.cacao.config.dir", "/etc/opt/sun/cacao2/instances/oem-ec");
            } else {
                hashMap2.put("com.sun.cacao.config.dir", "/etc/cacao/instances/oem-ec");
            }
            JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap2);
            mBeanServerConnection = jMXConnector.getMBeanServerConnection();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            mBeanServerConnection = null;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return mBeanServerConnection;
    }

    public String getOpsCenterFullVersion() {
        if (this.full_opscenter_version != null) {
            return this.full_opscenter_version;
        }
        String string = null;
        if (this.mbsc != null) {
            try {
                Set<ObjectName> set = this.mbsc.queryNames(ObjectName.getInstance("__local/com.sun.hss.domain:type=ZoneController,*"), null);
                if (set != null && !set.isEmpty()) {
                    this.full_opscenter_version = string = (String)this.mbsc.getAttribute(set.iterator().next(), "XVMVersion");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private Version_level OCVersion(String string) {
        Version_level version_level = Version_level.UNKNOWN;
        if (!OpsCenterHarvesterUtil.is_empty(string)) {
            if (string.startsWith("11.")) {
                version_level = Version_level.ECHELON;
            } else if (string.startsWith("12.")) {
                version_level = Version_level.DELTA;
            }
        }
        return version_level;
    }

    public Version_level OCVersion() {
        if (this.opscenter_level == null) {
            this.opscenter_level = this.OCVersion(this.getOpsCenterFullVersion());
        }
        return this.opscenter_level;
    }

    public boolean is_version(Version_level version_level) {
        boolean bl = false;
        if (!OpsCenterHarvesterUtil.is_empty(this.full_opscenter_version)) {
            bl = this.OCVersion(this.full_opscenter_version) == version_level;
        }
        return bl;
    }

    public int compareOpsCenterVersion(Version_level version_level) {
        return this.OCVersion().getOrdinal() - version_level.getOrdinal();
    }

    public static enum Version_level {
        UNKNOWN(0),
        ECHELON(1),
        DELTA(2);

        private final int ord;

        private Version_level(int n2) {
            this.ord = n2;
        }

        public int getOrdinal() {
            return this.ord;
        }

        public String toString() {
            return super.toString();
        }
    }
}

