/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.ocharvester;

import com.sun.cacao.ObjectNameFactory;
import com.sun.hss.domain.MXBeanProxyFactory;
import com.sun.hss.domain.types.CpuInfo;
import com.sun.hss.domain.types.CpuInfoSet;
import com.sun.hss.domain.types.FileSystemUsage;
import com.sun.hss.domain.types.FileSystemUsageSet;
import com.sun.hss.type.ManagedResource;
import com.sun.hss.type.os.OperatingSystem;
import com.sun.hss.type.server.Server;
import com.sun.xvm.services.fwdeployment.FirmwareMgmtMXBean;
import com.sun.xvm.services.fwdeployment.FirmwarePackage;
import com.sun.xvm.services.gear.GearServiceMXBean;
import com.sun.xvm.services.osdeployment.Distribution;
import com.sun.xvm.services.osdeployment.OSDeploymentMXBean;
import com.sun.xvm.services.svrmgmt.SvrMgmtServiceMXBean;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.StringValueExp;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgr;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResultList;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadataManager;
import oracle.sysman.ccr.ocharvester.Metric_ECM_HW;
import oracle.sysman.ccr.ocharvester.OCM;
import oracle.sysman.ccr.ocharvester.OpsCenterEntitlement;
import oracle.sysman.ccr.ocharvester.OpsCenterHarvesterUtil;
import oracle.sysman.ccr.ocharvester.OpsCenterManagedInventory;
import oracle.sysman.ccr.ocharvester.OpsCenterManagedSWInventory;
import org.apache.log4j.Category;
import org.xml.sax.SAXException;

public class OpsCenterTarget {
    private static final Category slog = Category.getInstance((String)OpsCenterTarget.class.getName());
    static final String ControllerType = "com.sun.hss.domain.ZoneControllerMXBean";
    static final String ControllerTypeAttributeName = "ZoneControllerType";
    static final String VersionAttributeName = "XVMVersion";
    static final String BuildDateAttribute = "XVMBuildDate";
    static final String OPSCENTER_PRODUCT_HOME = "/var/opt/sun/xvm/ocm";
    static final String OCM_OC_TARGET_NAME = "oracle_ops_center";
    static final String OCM_OC_TARGET_CONFIG_METRIC = "ECM_OPS_CTR_CFG_PARAMS";
    static final String OCM_OC_TARGET_CONFIG_METRIC_TABLE = "MGMT_ECM_OPS_CTR_CFG_PARAMS";
    static final String OCM_OC_TARGET_CHANNELS_TABLE = "MGMT_ECM_OPS_CTR_CHANNELS";
    private static final String EC_VERSION = "version";
    private static final String EC_BUILD_DATE = "build_date";
    private static final String EC_HOSTNAME = "hostname";
    private static final String EC_OS = "os";
    private static final String EC_MODEL = "model";
    private static final String EC_RAM = "ram";
    private static final String EC_DISKSPACE = "diskspace";
    private static final String EC_CPU_CORES = "cpu_cores";
    private static final String EC_CPU_SPEED = "cpu_speed";
    static final String TARGET_VERSIONS_METRIC = "ECM_TARGET_VERSIONS";
    static final String TARGET_CHANNELS_METRIC = "ECM_OPS_CTR_CHANNELS";
    private static final String[] Server_gear_filter = new String[]{"GlobalZone", "MSeriesChassis"};
    private static final String PRODUCT_NAME = "Oracle Enterprise Manager Ops Center";
    private static String opscenter_version = null;

    private static Set<ObjectName> getManagedControllerObjects(MBeanServerConnection mBeanServerConnection) {
        try {
            ObjectName objectName = new ObjectName("com.sun.xvm.domain:*");
            StringValueExp stringValueExp = new StringValueExp(ControllerType);
            Set<ObjectName> set = mBeanServerConnection.queryNames(objectName, Query.isInstanceOf(stringValueExp));
            return set;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static int get_domain_object_count(MBeanServerConnection mBeanServerConnection) {
        try {
            ObjectName objectName = new ObjectName("*com.sun.xvm.domain:*");
            Set<ObjectName> set = mBeanServerConnection.queryNames(objectName, null);
            return set.size();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static FirmwareMgmtMXBean getFirmwareMgmtService(MBeanServerConnection mBeanServerConnection) throws Exception {
        ObjectName objectName = new ObjectNameFactory(FirmwareMgmtMXBean.class).getObjectName(FirmwareMgmtMXBean.class, null);
        return (FirmwareMgmtMXBean)MXBeanProxyFactory.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)objectName, FirmwareMgmtMXBean.class, (boolean)false);
    }

    private static OSDeploymentMXBean getOSDeploymentService(MBeanServerConnection mBeanServerConnection) throws Exception {
        ObjectName objectName = new ObjectNameFactory(OSDeploymentMXBean.class).getObjectName(OSDeploymentMXBean.class, null);
        return (OSDeploymentMXBean)MXBeanProxyFactory.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)objectName, OSDeploymentMXBean.class, (boolean)false);
    }

    private static int firmware_image_count(MBeanServerConnection mBeanServerConnection) {
        try {
            FirmwareMgmtMXBean firmwareMgmtMXBean = OpsCenterTarget.getFirmwareMgmtService(mBeanServerConnection);
            FirmwarePackage[] firmwarePackageArray = firmwareMgmtMXBean.getAllFirmwarePackages();
            return firmwarePackageArray.length;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static int os_image_count(MBeanServerConnection mBeanServerConnection) {
        try {
            OSDeploymentMXBean oSDeploymentMXBean = OpsCenterTarget.getOSDeploymentService(mBeanServerConnection);
            Distribution[] distributionArray = oSDeploymentMXBean.getDistributions((String[])null);
            return distributionArray.length;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static int get_gear_object_count(MBeanServerConnection mBeanServerConnection) {
        try {
            GearServiceMXBean gearServiceMXBean = OpsCenterManagedInventory.getGearService(mBeanServerConnection);
            ObjectName[] objectNameArray = gearServiceMXBean.getGearObjectNames(null, null);
            return objectNameArray.length;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static long ec_cpu_speed(Server server) {
        try {
            CpuInfo[] cpuInfoArray;
            CpuInfoSet cpuInfoSet = server.getCpuInfos();
            if (cpuInfoSet != null && (cpuInfoArray = cpuInfoSet.getValues()) != null) {
                for (int i = 0; i < cpuInfoArray.length; ++i) {
                    int n;
                    if (cpuInfoArray[i] == null || (n = cpuInfoArray[i].getSpeed()) <= 0) continue;
                    return n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    private static int ec_cpu_cores(Server server) {
        int n = 0;
        try {
            CpuInfo[] cpuInfoArray;
            CpuInfoSet cpuInfoSet = server.getCpuInfos();
            if (cpuInfoSet != null && (cpuInfoArray = cpuInfoSet.getValues()) != null) {
                for (int i = 0; i < cpuInfoArray.length; ++i) {
                    int n2;
                    Integer n3;
                    if (cpuInfoArray[i] == null || (n3 = cpuInfoArray[i].getCoreCount()) == null || (n2 = n3.intValue()) <= 0) continue;
                    n += n2;
                }
            }
            return n > 0 ? n : 1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static long os_disk_capacity(OperatingSystem operatingSystem) {
        BigInteger bigInteger = BigInteger.ZERO;
        try {
            Object object;
            FileSystemUsageSet fileSystemUsageSet = operatingSystem.getFileSystemUsages();
            if (fileSystemUsageSet != null && (object = fileSystemUsageSet.getValues()) != null) {
                for (int i = 0; i < ((FileSystemUsage[])object).length; ++i) {
                    if (object[i] == null) continue;
                    bigInteger = bigInteger.add(BigInteger.valueOf(object[i].getFreeSpace()));
                }
            }
            object = BigInteger.valueOf(0x40000000L);
            return bigInteger.divide((BigInteger)object).longValue();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static ObjectName make_server_on(ObjectName objectName) {
        final String string = objectName.getKeyProperty("name");
        Hashtable<String, String> hashtable = new Hashtable<String, String>(){
            {
                this.put("name", string);
                this.put("type", "Server");
            }
        };
        try {
            ObjectName objectName2 = new ObjectName(objectName.getDomain(), hashtable);
            return objectName2;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
    }

    private static void get_ec_server_os(ObjectName objectName, SvrMgmtServiceMXBean svrMgmtServiceMXBean, GearServiceMXBean gearServiceMXBean, Map<String, String> map) {
        try {
            ObjectName[] objectNameArray = new ObjectName[]{objectName};
            if (objectNameArray.length > 0 && objectNameArray[0] != null) {
                ObjectName[] objectNameArray2;
                OperatingSystem[] operatingSystemArray;
                long l;
                Server[] serverArray = svrMgmtServiceMXBean.getServers(objectNameArray, null);
                map.put(EC_MODEL, serverArray[0].getModel());
                long l2 = Metric_ECM_HW.memory_size(serverArray[0]);
                if (l2 > 0L) {
                    map.put(EC_RAM, Long.toString(l2));
                }
                if ((l = OpsCenterTarget.ec_cpu_speed(serverArray[0])) > 0L) {
                    map.put(EC_CPU_SPEED, Long.toString(l));
                }
                int n = OpsCenterTarget.ec_cpu_cores(serverArray[0]);
                map.put(EC_CPU_CORES, Integer.toString(n));
                ObjectName objectName2 = gearServiceMXBean.getAssociated(objectName);
                if (objectName2 != null && OpsCenterManagedInventory.ObjectNameType(objectName2, "OperatingSystem") && (operatingSystemArray = svrMgmtServiceMXBean.getOperatingSystems(objectNameArray2 = new ObjectName[]{objectName2}, null)) != null & operatingSystemArray.length > 0 && operatingSystemArray[0] != null) {
                    OperatingSystem operatingSystem = operatingSystemArray[0];
                    map.put(EC_HOSTNAME, operatingSystem.getHostname());
                    map.put(EC_OS, operatingSystem.getType());
                    long l3 = OpsCenterTarget.os_disk_capacity(operatingSystem);
                    if (l3 > 0L) {
                        map.put(EC_DISKSPACE, Long.toString(l3));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Map<String, String> getSatelliteInfo(MBeanServerConnection mBeanServerConnection, Set<ObjectName> set) {
        GearServiceMXBean gearServiceMXBean;
        SvrMgmtServiceMXBean svrMgmtServiceMXBean;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            svrMgmtServiceMXBean = OpsCenterManagedInventory.getSvrMgmtService(mBeanServerConnection);
            gearServiceMXBean = OpsCenterManagedInventory.getGearService(mBeanServerConnection);
        }
        catch (Exception exception) {
            return null;
        }
        if (set != null && set.size() > 0) {
            for (ObjectName objectName : set) {
                try {
                    ObjectName objectName2;
                    String string = (String)mBeanServerConnection.getAttribute(objectName, ControllerTypeAttributeName);
                    if (!"XVM_SATELLITE".equalsIgnoreCase(string)) continue;
                    String string2 = (String)mBeanServerConnection.getAttribute(objectName, VersionAttributeName);
                    hashMap.put(EC_VERSION, string2);
                    opscenter_version = string2;
                    hashMap.put(EC_BUILD_DATE, (String)mBeanServerConnection.getAttribute(objectName, BuildDateAttribute));
                    ObjectName[] objectNameArray = new ObjectName[]{objectName};
                    Server[] serverArray = svrMgmtServiceMXBean.getServers(objectNameArray, null);
                    if (serverArray.length <= 0 || serverArray[0] == null || (objectName2 = OpsCenterTarget.make_server_on(serverArray[0].getObjectName())) == null) continue;
                    OpsCenterTarget.get_ec_server_os(objectName2, svrMgmtServiceMXBean, gearServiceMXBean, hashMap);
                }
                catch (Exception exception) {}
            }
        }
        return hashMap;
    }

    private static String getSatelliteName(MBeanServerConnection mBeanServerConnection, Set<ObjectName> set) {
        if (set != null && set.size() > 0) {
            for (ObjectName objectName : set) {
                try {
                    String string = (String)mBeanServerConnection.getAttribute(objectName, ControllerTypeAttributeName);
                    if (!"XVM_SATELLITE".equalsIgnoreCase(string)) continue;
                    String string2 = (String)mBeanServerConnection.getAttribute(objectName, "UserFriendlyName");
                    return string2;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private static int proxyCount(MBeanServerConnection mBeanServerConnection, Set<ObjectName> set) {
        int n = 0;
        if (set != null && set.size() > 0) {
            for (ObjectName objectName : set) {
                try {
                    String string = (String)mBeanServerConnection.getAttribute(objectName, ControllerTypeAttributeName);
                    if (!"XVM_PROXY".equalsIgnoreCase(string)) continue;
                    ++n;
                }
                catch (Exception exception) {}
            }
        }
        return n;
    }

    private static Target OCTarget(String string) {
        Target target = null;
        try {
            target = new Target(string, OCM_OC_TARGET_NAME, false, string, false, string, OPSCENTER_PRODUCT_HOME, null, false, string, OpsCenterHarvesterUtil.get_timezone(), null);
            if (target.getTimeZone() == null) {
                target = new Target(string, OCM_OC_TARGET_NAME, false, string, false, string, OPSCENTER_PRODUCT_HOME, null, false, string, "GMT", null);
            }
        }
        catch (SAXException sAXException) {
            slog.error((Object)"Unable to create new Target");
        }
        return target;
    }

    private static boolean isManaged(ManagedResource managedResource) {
        try {
            String string = managedResource.getManagedState();
            if (string != null && ("MANAGED".equalsIgnoreCase(string) || "MANAGED_OR_PROVISIONED".equalsIgnoreCase(string))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String user_friendly_name(ManagedResource managedResource) {
        try {
            String string = managedResource.getUserFriendlyName();
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String get_server_type(ManagedResource managedResource) {
        try {
            return managedResource.getGearType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean countable_server(Server server) {
        String string = OpsCenterTarget.get_server_type((ManagedResource)server);
        if (OpsCenterHarvesterUtil.is_empty(string)) {
            return false;
        }
        for (int i = 0; i < Server_gear_filter.length; ++i) {
            if (!string.equalsIgnoreCase(Server_gear_filter[i])) continue;
            return false;
        }
        return true;
    }

    private static void setValue(ValueRow valueRow, int n, String string) {
        if (!OpsCenterHarvesterUtil.is_empty(string)) {
            valueRow.setValue(n, string);
        }
    }

    private static void setIntValue(ValueRow valueRow, int n, int n2) {
        if (n2 >= 0) {
            valueRow.setValue(n, (float)n2);
        }
    }

    private static CollectionResult make_target_version_metric(Target target, TargetMetadata targetMetadata, String string) {
        ValueRow valueRow;
        MetricResult metricResult;
        Metric metric = targetMetadata.getMetric(TARGET_VERSIONS_METRIC, target);
        CollectionResult collectionResult = null;
        if (metric != null && (metricResult = new MetricResult()) != null && (valueRow = metricResult.addValueRow()) != null) {
            valueRow.setValue(0, string);
            collectionResult = new CollectionResult(TARGET_VERSIONS_METRIC, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
        }
        return collectionResult;
    }

    private static CollectionResult make_channel_metric(Target target, TargetMetadata targetMetadata, MBeanServerConnection mBeanServerConnection) {
        Metric metric;
        MetricResult metricResult = null;
        CollectionResult collectionResult = null;
        List<String> list = OpsCenterManagedSWInventory.getChannels(mBeanServerConnection);
        if (list != null && list.size() >= 1 && (metric = targetMetadata.getMetric(TARGET_CHANNELS_METRIC, target)) != null && (metricResult = new MetricResult()) != null) {
            for (String string : list) {
                ValueRow valueRow = metricResult.addValueRow();
                if (valueRow == null) continue;
                valueRow.setValue(0, string);
            }
            collectionResult = new CollectionResult(TARGET_CHANNELS_METRIC, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
        }
        return collectionResult;
    }

    private static CollectionResult make_opscenter_config_metric(Target target, TargetMetadata targetMetadata, MBeanServerConnection mBeanServerConnection, Map map, Set<ObjectName> set) {
        ValueRow valueRow;
        MetricResult metricResult;
        Metric metric;
        String string = null;
        int n = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        int n2 = 0;
        int n3 = 0;
        CollectionResult collectionResult = null;
        Map<String, String> map2 = OpsCenterTarget.getSatelliteInfo(mBeanServerConnection, set);
        n = OpsCenterTarget.proxyCount(mBeanServerConnection, set);
        for (Map.Entry entry : map.entrySet()) {
            Server server = (Server)entry.getKey();
            OperatingSystem operatingSystem = (OperatingSystem)entry.getValue();
            boolean bl = false;
            if (server != null && OpsCenterTarget.countable_server(server)) {
                bl = OpsCenterTarget.isManaged((ManagedResource)server);
                if (bl) {
                    ++n2;
                }
                slog.debug((Object)("Server:  " + OpsCenterTarget.user_friendly_name((ManagedResource)server) + "| Managed status = " + bl));
            }
            boolean bl2 = false;
            if (operatingSystem == null) continue;
            bl2 = OpsCenterTarget.isManaged((ManagedResource)operatingSystem);
            if (bl2) {
                ++n3;
            }
            slog.debug((Object)("OS:  " + OpsCenterTarget.user_friendly_name((ManagedResource)server) + "| Managed status = " + bl2));
        }
        int n4 = OpsCenterEntitlement.getUserCount(mBeanServerConnection);
        int n5 = OpsCenterTarget.firmware_image_count(mBeanServerConnection);
        int n6 = OpsCenterTarget.os_image_count(mBeanServerConnection);
        if (map2 != null) {
            string2 = map2.get(EC_VERSION);
            string3 = map2.get(EC_BUILD_DATE);
            string4 = map2.get(EC_HOSTNAME);
            string6 = map2.get(EC_OS);
            string7 = map2.get(EC_MODEL);
            string5 = map2.get(EC_RAM);
            string8 = map2.get(EC_DISKSPACE);
        }
        if (slog.isDebugEnabled()) {
            slog.debug((Object)("OC Target:  Version = " + string2));
            slog.debug((Object)("OC Target:  Build date = " + string3));
            slog.debug((Object)("OC Target:  EC Hostname = " + string4));
            slog.debug((Object)("OC Target:  Proxy count = " + n));
            slog.debug((Object)("OC Target:  Server count = " + n2));
            slog.debug((Object)("OC Target:  OS count = " + n3));
            slog.debug((Object)("OC Target:  EC name = " + string));
            slog.debug((Object)("OC Target:  EC OS = " + string6));
            slog.debug((Object)("OC Target:  Model = " + string7));
            slog.debug((Object)("OC Target:  RAM = " + string5));
            slog.debug((Object)("OC Target:  Disk = " + string8));
            slog.debug((Object)("Number of OC Users = " + n4));
            slog.debug((Object)("Managed Server count = " + n2));
            slog.debug((Object)("Managed OS count = " + n3));
            slog.debug((Object)("Firmware image count = " + n5));
            slog.debug((Object)("OS image count = " + n6));
        }
        if ((metric = targetMetadata.getMetric(OCM_OC_TARGET_CONFIG_METRIC, target)) != null && (metricResult = new MetricResult()) != null && (valueRow = metricResult.addValueRow()) != null) {
            valueRow.setValue(0, PRODUCT_NAME);
            OpsCenterTarget.setValue(valueRow, 1, string2);
            valueRow.setValue(2, "Oracle");
            OpsCenterTarget.setValue(valueRow, 3, string6);
            OpsCenterTarget.setValue(valueRow, 4, string7);
            OpsCenterTarget.setValue(valueRow, 5, string5);
            OpsCenterTarget.setValue(valueRow, 6, string8);
            OpsCenterTarget.setValue(valueRow, 7, map2.get(EC_CPU_CORES));
            OpsCenterTarget.setValue(valueRow, 8, map2.get(EC_CPU_SPEED));
            OpsCenterTarget.setIntValue(valueRow, 9, n3);
            OpsCenterTarget.setIntValue(valueRow, 10, n2);
            OpsCenterTarget.setIntValue(valueRow, 11, n6);
            OpsCenterTarget.setIntValue(valueRow, 12, n5);
            OpsCenterTarget.setIntValue(valueRow, 13, n);
            OpsCenterTarget.setIntValue(valueRow, 14, n4);
            OpsCenterTarget.setValue(valueRow, 15, string4);
            OpsCenterTarget.setValue(valueRow, 16, string3);
            OpsCenterTarget.setIntValue(valueRow, 17, OpsCenterTarget.get_domain_object_count(mBeanServerConnection));
            OpsCenterTarget.setIntValue(valueRow, 18, OpsCenterTarget.get_gear_object_count(mBeanServerConnection));
            collectionResult = new CollectionResult(OCM_OC_TARGET_CONFIG_METRIC, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
        }
        return collectionResult;
    }

    public static void createOpsCenterTarget(MBeanServerConnection mBeanServerConnection, CollectionMgr collectionMgr, Map map) {
        String string;
        Set<ObjectName> set = OpsCenterTarget.getManagedControllerObjects(mBeanServerConnection);
        CollectionResult collectionResult = null;
        if (set != null && !OpsCenterHarvesterUtil.is_empty(string = OpsCenterTarget.getSatelliteName(mBeanServerConnection, set))) {
            CollectionResultList collectionResultList;
            Target target = OpsCenterTarget.OCTarget(OCM.ec_hostname());
            TargetMetadata targetMetadata = TargetMetadataManager.getTargetMetadata((String)OCM_OC_TARGET_NAME);
            if (target != null && targetMetadata != null && (collectionResultList = new CollectionResultList(target, "ops_center_config", targetMetadata.getMetadataVersion())) != null) {
                CollectionResult collectionResult2 = OpsCenterTarget.make_opscenter_config_metric(target, targetMetadata, mBeanServerConnection, map, set);
                if (!OpsCenterHarvesterUtil.is_empty(opscenter_version)) {
                    collectionResult = OpsCenterTarget.make_target_version_metric(target, targetMetadata, opscenter_version);
                }
                CollectionResult collectionResult3 = OpsCenterTarget.make_channel_metric(target, targetMetadata, mBeanServerConnection);
                if (collectionResult2 != null) {
                    collectionResultList.put((Object)OCM_OC_TARGET_CONFIG_METRIC, (Object)collectionResult2);
                    if (collectionResult3 != null) {
                        collectionResultList.put((Object)TARGET_CHANNELS_METRIC, (Object)collectionResult3);
                    }
                    if (collectionResult != null) {
                        collectionResultList.put((Object)TARGET_VERSIONS_METRIC, (Object)collectionResult);
                    }
                    try {
                        collectionMgr.diffAndPersistCollectionForGCUpload(collectionResultList);
                    }
                    catch (Exception exception) {
                        slog.warn((Object)("Unable to persist Ops Center Target: " + exception.getMessage()));
                    }
                }
            }
        }
    }
}

