/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.security.ucrypto;

import com.oracle.security.ucrypto.CipherContextRef;
import com.oracle.security.ucrypto.NativeCipher;
import com.oracle.security.ucrypto.UcryptoException;
import com.oracle.security.ucrypto.UcryptoMech;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import sun.security.jca.JCAUtil;

class NativeGCMCipher
extends NativeCipher {
    private static final int DEFAULT_TAG_LEN = 128;
    private static final int MAX_BUF_SIZE = Integer.MAX_VALUE;
    private ByteArrayOutputStream aadBuffer;
    private ByteArrayOutputStream ibuffer;
    private int processed;
    private int tagLen = 128;
    private boolean requireReinit;
    private byte[] lastEncKey = null;
    private byte[] lastEncIv = null;

    private void checkAndUpdateProcessed(int n) {
        int n2 = Integer.MAX_VALUE - this.tagLen;
        if (this.processed > n2 - n) {
            throw new ProviderException("OracleUcrypto provider only supports input size up to " + n2 + " bytes");
        }
        this.processed += n;
    }

    NativeGCMCipher(int n) throws NoSuchAlgorithmException {
        super(UcryptoMech.CRYPTO_AES_GCM, n);
    }

    @Override
    protected void ensureInitialized() {
        if (!this.initialized) {
            byte[] byArray = null;
            if (this.aadBuffer != null && this.aadBuffer.size() > 0) {
                byArray = this.aadBuffer.toByteArray();
            }
            this.init(this.encrypt, this.keyValue, this.iv, this.tagLen, byArray);
            this.aadBuffer = null;
            if (!this.initialized) {
                throw new UcryptoException("Cannot initialize Cipher");
            }
        }
    }

    @Override
    protected int getOutputSizeByOperation(int n, boolean bl) {
        if (n < 0) {
            return 0;
        }
        if (!bl && n == 0) {
            return 0;
        }
        int n2 = n + this.bytesBuffered;
        if (this.encrypt) {
            if (bl) {
                n2 += this.tagLen / 8;
            }
        } else {
            if (this.ibuffer != null) {
                n2 += this.ibuffer.size();
            }
            if (bl) {
                n2 -= this.tagLen / 8;
            }
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    @Override
    protected void reset(boolean bl) {
        super.reset(bl);
        if (this.aadBuffer == null) {
            this.aadBuffer = new ByteArrayOutputStream();
        } else {
            this.aadBuffer.reset();
        }
        if (this.ibuffer != null) {
            this.ibuffer.reset();
        }
        if (!this.encrypt) {
            this.requireReinit = false;
        }
        this.processed = 0;
    }

    protected void init(boolean bl, byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
        this.reset(true);
        this.encrypt = bl;
        this.keyValue = byArray;
        this.iv = byArray2;
        long l = NativeCipher.nativeInit(this.mech.value(), bl, this.keyValue, this.iv, n, byArray3);
        boolean bl2 = this.initialized = l != 0L;
        if (!this.initialized) {
            throw new UcryptoException("Cannot initialize Cipher");
        }
        this.pCtxt = new CipherContextRef(this, l, bl);
    }

    @Override
    protected synchronized AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        try {
            if (this.iv != null) {
                GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(this.tagLen, (byte[])this.iv.clone());
                algorithmParameters = AlgorithmParameters.getInstance("GCM");
                algorithmParameters.init(gCMParameterSpec);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new UcryptoException("Could not encode parameters", generalSecurityException);
        }
        return algorithmParameters;
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.checkKey(key);
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new InvalidAlgorithmParameterException("Unsupported mode: " + n);
        }
        this.aadBuffer = new ByteArrayOutputStream();
        boolean bl = n == 1 || n == 3;
        byte[] byArray = (byte[])key.getEncoded().clone();
        byte[] byArray2 = null;
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof GCMParameterSpec)) {
                throw new InvalidAlgorithmParameterException("GCMParameterSpec required. Received: " + algorithmParameterSpec.getClass().getName());
            }
            this.tagLen = ((GCMParameterSpec)algorithmParameterSpec).getTLen();
            byArray2 = ((GCMParameterSpec)algorithmParameterSpec).getIV();
        } else if (bl) {
            this.tagLen = 128;
            byArray2 = new byte[this.blockSize];
            if (secureRandom == null) {
                secureRandom = JCAUtil.getSecureRandom();
            }
            secureRandom.nextBytes(byArray2);
        } else {
            throw new InvalidAlgorithmParameterException("Parameters required for decryption");
        }
        if (bl) {
            boolean bl2 = this.requireReinit = Arrays.equals(byArray2, this.lastEncIv) && MessageDigest.isEqual(byArray, this.lastEncKey);
            if (this.requireReinit) {
                throw new InvalidAlgorithmParameterException("Cannot reuse iv for GCM encryption");
            }
            this.lastEncIv = byArray2;
            this.lastEncKey = byArray;
            this.ibuffer = null;
        } else {
            this.requireReinit = false;
            this.ibuffer = new ByteArrayOutputStream();
        }
        this.init(bl, byArray, byArray2, this.tagLen, null);
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        GCMParameterSpec gCMParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                gCMParameterSpec = algorithmParameters.getParameterSpec(GCMParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException(invalidParameterSpecException);
            }
        }
        this.engineInit(n, key, gCMParameterSpec, secureRandom);
    }

    @Override
    protected synchronized byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (this.aadBuffer != null) {
            if (this.aadBuffer.size() > 0) {
                this.init(this.encrypt, this.keyValue, this.iv, this.tagLen, this.aadBuffer.toByteArray());
            }
            this.aadBuffer = null;
        }
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        this.checkAndUpdateProcessed(n2);
        if (n2 > 0) {
            if (!this.encrypt) {
                this.ibuffer.write(byArray, n, n2);
                return null;
            }
            return super.engineUpdate(byArray, n, n2);
        }
        return null;
    }

    @Override
    protected synchronized int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        int n4 = this.getOutputSizeByOperation(n2, false);
        if (byArray2.length - n3 < n4) {
            throw new ShortBufferException("Output buffer must be (at least) " + n4 + " bytes long. Got: " + (byArray2.length - n3));
        }
        if (this.aadBuffer != null) {
            if (this.aadBuffer.size() > 0) {
                this.init(this.encrypt, this.keyValue, this.iv, this.tagLen, this.aadBuffer.toByteArray());
            }
            this.aadBuffer = null;
        }
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        this.checkAndUpdateProcessed(n2);
        if (n2 > 0) {
            if (!this.encrypt) {
                this.ibuffer.write(byArray, n, n2);
                return 0;
            }
            return super.engineUpdate(byArray, n, n2, byArray2, n3);
        }
        return 0;
    }

    @Override
    protected synchronized void engineUpdateAAD(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (byArray == null || n < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Invalid AAD");
        }
        if (this.keyValue == null) {
            throw new IllegalStateException("Need to initialize Cipher first");
        }
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        if (this.aadBuffer == null) {
            throw new IllegalStateException("Update has been called; no more AAD data");
        }
        this.aadBuffer.write(byArray, n, n2);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) throws IllegalStateException {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("Invalid AAD");
        }
        if (this.keyValue == null) {
            throw new IllegalStateException("Need to initialize Cipher first");
        }
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        if (this.aadBuffer != null) {
            if (byteBuffer.hasRemaining()) {
                byte[] byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
                this.aadBuffer.write(byArray, 0, byArray.length);
            }
        } else {
            throw new IllegalStateException("Update has been called; no more AAD data");
        }
    }

    @Override
    protected synchronized byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = new byte[this.getOutputSizeByOperation(n2, true)];
        try {
            int n3 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
            if (byArray2.length != n3) {
                byArray2 = Arrays.copyOf(byArray2, n3);
            }
            return byArray2;
        }
        catch (ShortBufferException shortBufferException) {
            throw new UcryptoException("Internal Error", shortBufferException);
        }
    }

    @Override
    protected synchronized int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n4 = this.getOutputSizeByOperation(n2, true);
        if (byArray2.length - n3 < n4) {
            throw new ShortBufferException("Output buffer must be (at least) " + n4 + " bytes long. Got: " + (byArray2.length - n3));
        }
        if (this.aadBuffer != null) {
            if (this.aadBuffer.size() > 0) {
                this.init(this.encrypt, this.keyValue, this.iv, this.tagLen, this.aadBuffer.toByteArray());
            }
            this.aadBuffer = null;
        }
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        this.checkAndUpdateProcessed(n2);
        if (!this.encrypt) {
            if (n2 > 0) {
                this.ibuffer.write(byArray, n, n2);
            }
            if ((n2 = this.ibuffer.size()) < this.tagLen / 8) {
                throw new AEADBadTagException("Input too short - need tag. inLen: " + n2 + ". tagLen: " + this.tagLen);
            }
            byArray = this.ibuffer.toByteArray();
            n = 0;
            this.ibuffer.reset();
        }
        try {
            int n5 = super.engineDoFinal(byArray, n, n2, byArray2, n3);
            return n5;
        }
        catch (UcryptoException ucryptoException) {
            if (ucryptoException.getMessage().equals("CRYPTO_INVALID_MAC")) {
                throw new AEADBadTagException("Tag does not match");
            }
            throw ucryptoException;
        }
        finally {
            this.requireReinit = this.encrypt;
        }
    }

    public static final class Aes256GcmNoPadding
    extends NativeGCMCipher {
        public Aes256GcmNoPadding() throws NoSuchAlgorithmException {
            super(32);
        }
    }

    public static final class Aes192GcmNoPadding
    extends NativeGCMCipher {
        public Aes192GcmNoPadding() throws NoSuchAlgorithmException {
            super(24);
        }
    }

    public static final class Aes128GcmNoPadding
    extends NativeGCMCipher {
        public Aes128GcmNoPadding() throws NoSuchAlgorithmException {
            super(16);
        }
    }

    public static final class AesGcmNoPadding
    extends NativeGCMCipher {
        public AesGcmNoPadding() throws NoSuchAlgorithmException {
            super(-1);
        }
    }
}

