/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.sysman.ccr.collector.install.AnonymousRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.ConfigResponse;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.gcharvester.GCConfigureCCRException;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.ccr.gcharvester.util.IProxyAdaptor;
import oracle.sysman.ccr.gcharvester.util.OCMConfigureUtil;
import oracle.sysman.ccr.gcharvester.util.ProxyData;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.eml.ecm.patch.repaccess.TargetsSql;
import org.apache.log4j.Category;

public class GCConfigureCCR {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$GCConfigureCCR == null ? (class$oracle$sysman$ccr$gcharvester$GCConfigureCCR = GCConfigureCCR.class$("oracle.sysman.ccr.gcharvester.GCConfigureCCR")) : class$oracle$sysman$ccr$gcharvester$GCConfigureCCR).getName());
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$GCConfigureCCR;

    public static void configCCR(Connection connection) throws GCConfigureCCRException {
        GCConfigureCCR.configCCR(connection, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void configCCR(Connection connection, boolean bl, String[] stringArray) throws GCConfigureCCRException {
        String string;
        boolean bl2 = true;
        if (bl) {
            if (stringArray == null || stringArray.length < 2 || stringArray[0] == null || stringArray[0].trim().length() <= 0 || stringArray[1] == null || stringArray[1].trim().length() <= 0) {
                throw new GCConfigureCCRException("Invalid Metalink Credentials provided");
            }
            bl2 = false;
        }
        if (!new File(string = OCMConfigureUtil.getConfigCCRFile()).exists()) throw new GCConfigureCCRException("File " + string + " is not present. Either CCR is not installed " + "or it has not been configured.");
        EndPoint endPoint = null;
        String string2 = null;
        try {
            UplinkSystemConfig.reload();
            ConfigResponse.init();
            NetworkConfiguration networkConfiguration = new NetworkConfiguration();
            endPoint = GCConfigureCCR.checkNetworkConnection(connection, networkConfiguration, bl2);
            OCMRegistrationPrincipal oCMRegistrationPrincipal = null;
            oCMRegistrationPrincipal = bl ? OCMConfigureUtil.createOCMPrincipal(endPoint, stringArray[0], stringArray[1], false) : GCConfigureCCR.createOCMPrincipal(connection, endPoint);
            if (oCMRegistrationPrincipal == null) {
                throw new GCConfigureCCRException("Registration to CCR Server failed");
            }
            string2 = OCMConfigureUtil.getResponseFile();
            OCMConfigureUtil.createResponseFile(networkConfiguration, oCMRegistrationPrincipal, string2);
            OCMConfigureUtil.execConfigCCR(string, string2);
            Object var10_9 = null;
            if (endPoint != null) {
                endPoint.disconnect();
            }
            if (string2 == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (endPoint != null) {
                endPoint.disconnect();
            }
            if (string2 == null) throw throwable;
            OCMConfigureUtil.deleteResponseFile(string2);
            throw throwable;
        }
        OCMConfigureUtil.deleteResponseFile(string2);
    }

    public static String[] getEMMetalinkCredentials(Connection connection) {
        String[] stringArray = null;
        try {
            stringArray = TargetsSql.getMetalinkCredentials((Connection)connection);
        }
        catch (SQLException sQLException) {
            sLog.error((Object)("Error while getting the Metalink credential from EM Repository: " + sQLException));
        }
        return stringArray;
    }

    private static EndPoint checkNetworkConnection(Connection connection, NetworkConfiguration networkConfiguration, boolean bl) throws GCConfigureCCRException {
        EndPoint endPoint = null;
        endPoint = OCMConfigureUtil.testDirectConnection(networkConfiguration);
        if (endPoint == null && (endPoint = OCMConfigureUtil.proxyFromCCR(networkConfiguration)) == null) {
            if (bl) {
                endPoint = GCConfigureCCR.proxyFromEM(networkConfiguration, connection);
            }
            if (endPoint == null) {
                throw new GCConfigureCCRException("Unable to make a direct connection and Connection failed with Metalink Proxy information.");
            }
        }
        return endPoint;
    }

    private static OCMRegistrationPrincipal createOCMPrincipal(Connection connection, EndPoint endPoint) throws GCConfigureCCRException {
        OCMRegistrationPrincipal oCMRegistrationPrincipal = null;
        String[] stringArray = GCConfigureCCR.getEMMetalinkCredentials(connection);
        String string = null;
        String string2 = null;
        if (stringArray != null && stringArray.length >= 2) {
            string = stringArray[0];
            string2 = stringArray[1];
            oCMRegistrationPrincipal = OCMConfigureUtil.createOCMPrincipal(endPoint, string, string2, false);
        }
        if (oCMRegistrationPrincipal == null && (oCMRegistrationPrincipal = OCMConfigureUtil.createOCMPrincipalFromCCR(endPoint)) == null && (oCMRegistrationPrincipal = OCMConfigureUtil.createOCMPrincipal(endPoint, string, string2, true)) == null) {
            oCMRegistrationPrincipal = new AnonymousRegistrationPrincipal();
        }
        return oCMRegistrationPrincipal;
    }

    private static EndPoint proxyFromEM(NetworkConfiguration networkConfiguration, Connection connection) {
        EndPoint endPoint = GCConfigureCCR.proxyFromEM(networkConfiguration, connection, HTTPS);
        if (endPoint == null) {
            endPoint = GCConfigureCCR.proxyFromEM(networkConfiguration, connection, HTTP);
        }
        return endPoint;
    }

    private static EndPoint proxyFromEM(NetworkConfiguration networkConfiguration, Connection connection, String string) {
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("Inside proxyFromEM with protocol: " + string));
        }
        ProxyData proxyData = null;
        try {
            IProxyAdaptor iProxyAdaptor = HarvesterUtil.getProxyAdaptor();
            if (iProxyAdaptor == null) {
                return null;
            }
            proxyData = iProxyAdaptor.getEMProxyData(connection, string);
            if (proxyData == null) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)("Proxy info not available in the EM Repository for protocol " + string));
                }
                return null;
            }
        }
        catch (SQLException sQLException) {
            sLog.error((Object)("SQL error while querying the proxy info from EM Repository: " + sQLException));
            return null;
        }
        return OCMConfigureUtil.testProxyConnection(networkConfiguration, proxyData.getHost(), "" + proxyData.getPort(), proxyData.getProxyUser(), proxyData.getProxyPasswd());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

