/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import oracle.jdbc.OracleConnection;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterJobUtils;
import oracle.sysman.ccr.gcharvester.perf.GCHarvesterPerf;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.emSDK.job.CommandManager;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class GCHarvesterImpl {
    private static final Category s_log = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$HarvesterJobUtils == null ? (class$oracle$sysman$ccr$gcharvester$HarvesterJobUtils = GCHarvesterImpl.class$("oracle.sysman.ccr.gcharvester.HarvesterJobUtils")) : class$oracle$sysman$ccr$gcharvester$HarvesterJobUtils).getName());
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$HarvesterJobUtils;

    public void harvesterMain(HashMap hashMap, CommandManager commandManager) throws Exception {
        OracleConnection oracleConnection = null;
        GCHarvesterPerf.init();
        GCHarvesterPerf.startPerf("perf_all");
        try {
            try {
                oracleConnection = (OracleConnection)commandManager.getConnection();
                try {
                    oracleConnection.setAutoCommit(false);
                }
                catch (Throwable throwable) {}
            }
            catch (SQLException sQLException) {
                String string = "Failed to get connection from repository: " + sQLException.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string));
                throw new HarvesterException(string, sQLException);
            }
            if (oracleConnection == null) {
                String string = "Failed to get connection from repository";
                s_log.error((Object)("GC OCM Harvester: " + string));
                throw new HarvesterException(string);
            }
            GCHarvesterImpl.updateReportedHarvesterErrorInfo(oracleConnection, "NO_HARVESTER_ERROR", 0);
            int n = HarvesterJobUtils.performOCMCollections(oracleConnection, commandManager.getServletContext());
            GCHarvesterImpl.updateReportedHarvesterErrorInfo(oracleConnection, "NO_HARVESTER_ERROR", 1);
        }
        catch (Throwable throwable) {
            HarvesterUtil.logToRepository(oracleConnection, throwable.getMessage());
            if (!(throwable instanceof HarvesterException)) {
                s_log.error((Object)("GC OCM Harvester: Caught non-harvester exception: " + throwable.getMessage()), throwable);
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"GC OCM Harvester: Error stacktrace for the harvester error", throwable);
            }
            String string = null;
            string = throwable.getMessage().length() > 4000 ? throwable.getMessage().substring(0, 3999) : throwable.getMessage();
            GCHarvesterImpl.updateReportedHarvesterErrorInfo(oracleConnection, string, 1);
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable.getMessage(), throwable);
        }
        finally {
            GCHarvesterPerf.endPerf("perf_all");
            GCHarvesterPerf.commit((Connection)oracleConnection);
            JDBCUtil.close((Connection)oracleConnection);
        }
    }

    private static void updateReportedHarvesterErrorInfo(OracleConnection oracleConnection, String string, int n) throws HarvesterException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = oracleConnection.prepareStatement("      MERGE INTO mgmt_ocm_upl_props p\n      USING dual\n      ON ( name = 'harv_error' )\n      WHEN MATCHED THEN UPDATE SET p.str_value = ?, p.num_value = ?, p.ts_value = systimestamp\n      WHEN NOT MATCHED THEN INSERT (name, str_value, num_value, ts_value)\n      VALUES ('harv_error', ?, ?, systimestamp)\n");
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            preparedStatement.setString(3, string);
            preparedStatement.setInt(4, n);
            preparedStatement.executeUpdate();
            oracleConnection.commit();
        }
        catch (SQLException sQLException) {
            String string2 = "Failed to insert or update harvester error flag from mgmt_ocm_upl_props: " + sQLException.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string2));
            throw new HarvesterException(string2, sQLException);
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

