/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResultList;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.AuthenticationKey;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.util.AgentConfig;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.scheduler.Scheduler;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;
import org.apache.log4j.Category;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class GCInit {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$GCInit == null ? (class$oracle$sysman$ccr$gcharvester$GCInit = GCInit.class$("oracle.sysman.ccr.gcharvester.GCInit")) : class$oracle$sysman$ccr$gcharvester$GCInit).getName());
    private static final String CCR_HOSTS_SUBDIR = "hosts";
    private static final String CCR_HOME = "ccr";
    private static final String BAT_FILETYPE = ".bat";
    private static final String SH_FILETYPE = "";
    private static final String LIB_DIR = "lib";
    private static final String EMOCMUTL = "emocmutl";
    private static final String EMCCR_JAR = "emCCR.jar";
    private static final String CONFIG_DIR = "config";
    private static final String CONFIG_DEFAULT_DIR = "default";
    private static final String STATE_DIR = "state";
    private static final String STATE_DIAGNOSTIC_DIR = "diagnostic";
    private static final String LOG_DIR = "log";
    private static final String GC_MARKER_FILE = "gc_upload_timestamp";
    private static final String OCM_NOT_INSTALLED = "Oracle Configuration Manager is not installed within the OMS home ({0}).";
    private static final String OCM_NOT_CONFIGURED = "Oracle Configuration Manager is not configured within the ORACLE_HOME ({0}).";
    private static final String OCM_OLD_VERSION = "The installed version of Oracle Configuration Manager in the ORACLE_HOME ({0}) is prior to 10.3.1. The Grid Control Configuration harvesting requires at a minimum, 10.3.1.";
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$GCInit;

    public static void init() throws HarvesterException {
        try {
            Object object;
            UplinkPath.setGCMode();
            String string = System.getProperty("ORACLE_HOME");
            if (string == null || string.equals(SH_FILETYPE)) {
                String string2 = "ORACLE_HOME system property is null.";
                throw new HarvesterException(string2);
            }
            String string3 = System.getProperty("CCR_CONFIG_HOME");
            if (string3 == null || string3.equals(SH_FILETYPE) || GCInit.isOCMConfigured(string, string3) != null) {
                object = null;
                string3 = GCInit.getCCRHome(string);
                object = GCInit.isOCMConfigured(string, string3);
                if (null != object) {
                    throw new HarvesterException((String)object);
                }
                System.setProperty("CCR_CONFIG_HOME", string3);
            }
            GCInit.createDirs();
            UplinkHomeConfig.reload();
            UplinkSystemConfig.reload();
            Scheduler.reload();
            Collector.setDisconnected();
            try {
                object = SecurityMgr.getInstance();
                AuthenticationKey authenticationKey = AuthenticationKey.instantiate();
                ((SecurityMgr)object).setAuthenticationKey(authenticationKey);
            }
            catch (AuthenticationFailure authenticationFailure) {
                throw new HarvesterException("Unable to load the AuthenticationKey", authenticationFailure);
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("ORACLE_HOME: " + System.getProperty("ORACLE_HOME")));
                sLog.debug((Object)("CCR_CONFIG_HOME = " + System.getProperty("CCR_CONFIG_HOME")));
                sLog.debug((Object)("Collector.isDisconnected(): " + Collector.isDisconnected()));
                sLog.debug((Object)("Scheduler.isStopped(): " + Scheduler.isStopped()));
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof HarvesterException) {
                throw (HarvesterException)throwable;
            }
            throw new HarvesterException("Unexpected error in GCInit.init", throwable);
        }
    }

    private static String getCCRHome(String string) throws HarvesterException {
        String string2 = System.getProperty("ORACLE_CONFIG_HOME");
        if (string2 != null && string2.trim().length() > 0) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Got ORACLE_CONFIG_HOME as " + string2));
            }
            return FileSpec.catfile(new String[]{string2, CCR_HOME});
        }
        String string3 = GCInit.getInstanceHomeAsConfigHome(string);
        if (string3 != null) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Got CCR_CONFIG_HOME from OMS INSTANCE_HOME as " + string3));
            }
            return string3;
        }
        string3 = GCInit.getHostInstanceConfigRoot(string);
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("Got CCR_CONFIG_HOME from Hostname as " + string3));
        }
        if (string3 == null) {
            string3 = FileSpec.catfile(new String[]{string, CCR_HOME});
        }
        return string3;
    }

    private static String getInstanceHomeAsConfigHome(String string) {
        String string2 = System.getProperty("INSTANCE_HOME");
        if (string2 != null && string2.trim().length() > 0) {
            String string3;
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Got OMS INSTANCE_HOME as " + string2));
            }
            if (GCInit.isOCMConfigured(string, string3 = FileSpec.catfile(new String[]{string2, CCR_HOME})) == null) {
                System.setProperty("ORACLE_CONFIG_HOME", string2);
                return string3;
            }
        }
        return null;
    }

    private static String buildDirFromInternal(String string) {
        return FileSpec.catfile(new String[]{AgentConfig.getRootStateDir(), string, "external"});
    }

    private static void createSubDirs(String string) throws HarvesterException {
        for (int i = 0; i < 11; ++i) {
            String string2 = SH_FILETYPE + i;
            String string3 = FileSpec.catfile(new String[]{string, string2});
            GCInit.createDir(string3);
        }
    }

    private static void createDirs() throws HarvesterException {
        String string = GCInit.buildDirFromInternal(UplinkPath.STATE_UPLOAD_PATH);
        GCInit.createSubDirs(string);
        String string2 = GCInit.buildDirFromInternal(UplinkPath.STATE_PREVIOUS_PATH);
        GCInit.createDir(string2);
        GCInit.createSubDirs(string2);
    }

    private static void createDir(String string) throws HarvesterException {
        File file = new File(string);
        boolean bl = false;
        bl = file.exists() ? true : file.mkdir();
        if (!bl) {
            String string2 = "Could not create the directory " + string;
            throw new HarvesterException(string2);
        }
    }

    private static String getHostInstanceConfigRoot(String string) throws HarvesterException {
        String string2 = FileSpec.catfile(new String[]{string, CCR_HOME, CCR_HOSTS_SUBDIR});
        File file = new File(string2);
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        String string3 = GCInit.getHostname(string);
        String string4 = FileSpec.catfile(new String[]{string2, string3});
        File file2 = new File(string4);
        if (file2.exists() && file2.isDirectory()) {
            return string4;
        }
        return null;
    }

    private static String getHostname(String string) throws HarvesterException {
        String string2;
        BufferedReader bufferedReader;
        int n;
        block13: {
            StringBuffer stringBuffer = new StringBuffer();
            n = -1;
            bufferedReader = null;
            string2 = GCInit.getUtilityCmd(string);
            Process process = Runtime.getRuntime().exec(new String[]{string2, "get_hostname"});
            n = process.waitFor();
            if (n != 0) break block13;
            String string3 = SH_FILETYPE;
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3);
            }
            String string4 = GCInit.stripTrimHostname(stringBuffer.toString());
            Object var9_12 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string4;
        }
        try {
            try {
                String string5 = "Unexpected error in command " + string2 + " get_hostname, return value " + n;
                throw new HarvesterException(string5);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new HarvesterException("Unexpected error in getting hostname", fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new HarvesterException("Unexpected error in getting hostname", iOException);
            }
            catch (InterruptedException interruptedException) {
                throw new HarvesterException("Unexpected error in getting hostname", interruptedException);
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
    }

    private static String getUtilityCmd(String string) throws FileNotFoundException {
        String string2 = System.getProperty("os.name").startsWith("Windows") ? BAT_FILETYPE : SH_FILETYPE;
        String string3 = FileSpec.catfile(new String[]{string, CCR_HOME, LIB_DIR, EMOCMUTL}) + string2;
        File file = new File(string3);
        if (!file.exists()) {
            throw new FileNotFoundException(string3);
        }
        return string3;
    }

    private static String stripTrimHostname(String string) throws HarvesterException {
        String string2 = null;
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("stripTrimHostname Input:" + string));
        }
        try {
            RE rE = new RE("([0-9a-zA-Z\\-\\.]+)");
            if (rE.match(string)) {
                string2 = rE.getParen(0);
            }
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
        }
        catch (RESyntaxException rESyntaxException) {
            throw new HarvesterException("Exception in stripping whitespaces from " + string, rESyntaxException);
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("stripTrimHostname Output:" + string2));
        }
        return string2;
    }

    private static String isOCMConfigured(String string, String string2) {
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("Trying CCR_CONFIG_HOME as " + string2));
        }
        String string3 = FileSpec.catfile(new String[]{string, CCR_HOME, LIB_DIR, EMCCR_JAR});
        File file = new File(string3);
        File file2 = new File(FileSpec.catfile(new String[]{string2, CONFIG_DIR}));
        File file3 = new File(FileSpec.catfile(new String[]{string2, CONFIG_DIR, CONFIG_DEFAULT_DIR}));
        File file4 = new File(FileSpec.catfile(new String[]{string2, STATE_DIR}));
        File file5 = new File(FileSpec.catfile(new String[]{string2, LOG_DIR}));
        File file6 = new File(FileSpec.catfile(new String[]{string2, UplinkPath.STATE_UPLOAD_PATH, "external"}));
        if (!file.exists()) {
            return MessageFormat.format(OCM_NOT_INSTALLED, string);
        }
        if (!(file2.isDirectory() && file3.isDirectory() && file4.isDirectory() && file5.isDirectory())) {
            return MessageFormat.format(OCM_NOT_CONFIGURED, string);
        }
        if (!file6.isDirectory()) {
            return MessageFormat.format(OCM_OLD_VERSION, string);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fullCollectionDate() throws HarvesterException {
        String string3;
        String string2 = FileSpec.catfile(new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_PREVIOUS_PATH, GC_MARKER_FILE});
        File file = new File(string2);
        if (!file.exists()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            try {
                String string;
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                string3 = string = bufferedReader.readLine();
                Object var6_6 = null;
            }
            catch (IOException iOException) {
                throw new HarvesterException("Error while reading gc_upload_timestamp file", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return string3;
        }
        if (bufferedReader == null) return string3;
        bufferedReader.close();
        return string3;
    }

    public static void deleteFullCollFile() {
        String string = FileSpec.catfile(new String[]{Collector.getCCRConfigHome(), UplinkPath.STATE_PREVIOUS_PATH, GC_MARKER_FILE});
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        if (string.equals("subdir")) {
            System.out.println("subdir: " + CollectionResultList.getObjectBaseSubDir(stringArray[1]));
        } else if (string.equals("gc_time")) {
            GCInit.init();
            System.out.println("Date: '" + GCInit.fullCollectionDate() + "'");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

