/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.OracleConnection;
import oracle.sysman.ccr.collector.gcontext.GCContext;
import oracle.sysman.ccr.collector.gcontext.GCContextList;
import oracle.sysman.ccr.collector.gcontext.GCContextManager;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.gcharvester.HarvesterEMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterMetadata;
import oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterSnapshotMD;
import oracle.sysman.ccr.gcharvester.IgnoreTargetException;
import oracle.sysman.ccr.gcharvester.gcontext.GCContextFactory;
import oracle.sysman.ccr.gcharvester.targettype.HarvesterTargetPropUtil;
import oracle.sysman.ccr.gcharvester.targettype.TargetMetadataUtil;
import oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergedTargetTypeInfo;
import oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergenceUtil;
import oracle.sysman.ccr.gcharvester.ti.bi.BIUtil;
import oracle.sysman.ccr.gcharvester.ti.common.ConvergedTargetTypeManager;
import oracle.sysman.ccr.gcharvester.ti.common.HarvesterTargetProperies;
import oracle.sysman.ccr.gcharvester.ti.database.RacDatabaseUtil;
import oracle.sysman.ccr.gcharvester.ti.exadata.DbmachineUtil;
import oracle.sysman.ccr.gcharvester.ti.exadata.ExadataGridUtil;
import oracle.sysman.ccr.gcharvester.ti.exadata.ExadataUtil;
import oracle.sysman.ccr.gcharvester.ti.idm.IDMUtil;
import oracle.sysman.ccr.gcharvester.ti.self_monitor.EMSystemUtil;
import oracle.sysman.ccr.gcharvester.ti.siebel.SiebelUtil;
import oracle.sysman.ccr.gcharvester.ti.weblogic.WLUtil;
import oracle.sysman.ccr.gcharvester.util.GCHarvesterEnv;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import oracle.sysman.eml.ecm.track.TrackUtilities;
import oracle.sysman.util.jdk.StringUtil;
import org.apache.log4j.Category;
import org.xml.sax.SAXException;

public class GcCollectionInfo {
    static final String OCM_TARGET_NAME_IS_NULL = "Could not determine OCM target name";
    private Connection m_connection = null;
    private String m_emTargetName = null;
    private String m_emDisplayTargetName = null;
    private String m_harvesterTargetType = null;
    private String m_harvesterSnapshotType = null;
    private String m_emTargetTimezone = null;
    private String m_emHostName = null;
    private String m_emHomePath = null;
    private String m_ocmTargetName = null;
    private String m_ocmTargetType = null;
    private String m_ocmSnapshotType = null;
    private ArrayList m_ocmMetricInfos = null;
    private boolean m_lastOhMetricIsEmpty = false;
    private List m_ocmTargets = null;
    private static final Category s_log = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$GcCollectionInfo == null ? (class$oracle$sysman$ccr$gcharvester$GcCollectionInfo = GcCollectionInfo.class$("oracle.sysman.ccr.gcharvester.GcCollectionInfo")) : class$oracle$sysman$ccr$gcharvester$GcCollectionInfo).getName());
    private static final Map emOcmTargetTypeMap = new HashMap();
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$GcCollectionInfo;

    GcCollectionInfo(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, ArrayList arrayList) throws HarvesterException {
        this(connection, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, arrayList, null);
    }

    GcCollectionInfo(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, ArrayList arrayList, String string12) throws HarvesterException {
        Object object;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap<String, String> hashMap = null;
        this.m_connection = connection;
        this.m_emTargetName = string;
        this.m_emDisplayTargetName = string2;
        this.m_harvesterTargetType = string4;
        this.m_harvesterSnapshotType = string5;
        boolean bl4 = GCHarvesterEnv.isGlobalGCForced();
        if ("host".equals(this.m_harvesterTargetType) || "oracle_home".equals(this.m_harvesterTargetType)) {
            this.m_emTargetTimezone = "GMT";
            this.m_emHomePath = "host".equals(this.m_harvesterTargetType) ? "N/A" : string8;
        } else {
            this.m_emTargetTimezone = string6;
            this.m_emHomePath = string8;
        }
        if (string7 != null) {
            this.m_emHostName = string7.toLowerCase();
        }
        String string13 = string8;
        String string14 = this.m_emHomePath;
        String string15 = null;
        this.m_ocmTargetName = string12;
        this.m_ocmTargetType = string10;
        this.m_ocmSnapshotType = string11;
        this.m_ocmMetricInfos = arrayList;
        try {
            Object object2;
            if (!GCVersion.pre11_2GC() && ConvergenceUtil.isConverged(this.m_harvesterTargetType, this.m_ocmTargetType, connection)) {
                object2 = ConvergedTargetTypeManager.getConvergedTargetTypeInfo(this.m_harvesterTargetType);
                this.m_ocmTargetName = ((ConvergedTargetTypeInfo)object2).getTargetName(this.m_emTargetName, string3, connection);
                if ("host".equals(this.m_harvesterTargetType)) {
                    this.m_ocmTargetName = this.m_emHostName;
                }
                string15 = ((ConvergedTargetTypeInfo)object2).getUniqueId(this.m_emTargetName, connection);
                bl = ((ConvergedTargetTypeInfo)object2).hasFakeOracleHome(connection);
                bl2 = ((ConvergedTargetTypeInfo)object2).hasFakeHost(connection);
                bl3 = ((ConvergedTargetTypeInfo)object2).isProxyForced();
                if (bl) {
                    string14 = this.m_emHomePath = ((ConvergedTargetTypeInfo)object2).getOracleHome(this.m_emTargetName, this.m_emHomePath, connection);
                }
                if (bl2) {
                    this.m_emHostName = ((ConvergedTargetTypeInfo)object2).getHostName(this.m_emTargetName, this.m_emHostName, connection);
                }
                hashMap = ((ConvergedTargetTypeInfo)object2).getTargetProperties(this.m_emTargetName, this.m_ocmTargetName, this.m_ocmTargetType, string14, this.m_emHostName, string15, connection);
                bl4 = true;
            } else {
                if ("oracle_vm_server_pool".equals(this.m_harvesterTargetType)) {
                    this.m_emHostName = this.getOVSPHostName("initial_master_vs_name");
                    this.m_emHomePath = "N/A";
                    string14 = "N/A";
                    bl = true;
                    bl2 = true;
                    string15 = this.getOVSPHostName("vsp_uuid");
                } else if ("oracle_vm_server".equals(this.m_harvesterTargetType)) {
                    this.m_emHostName = this.getVSHostName("hostname");
                    this.m_emHomePath = "N/A";
                    string14 = "N/A";
                    bl = true;
                    bl2 = true;
                    string15 = this.generateMD5Hash(this.getOVSUniqueIDString());
                } else if ("oracle_vm_server_host".equals(this.m_harvesterTargetType)) {
                    this.m_emHostName = this.getVSHostName("hostname");
                    this.m_emHomePath = "N/A";
                    string14 = "N/A";
                    this.m_emTargetTimezone = "GMT";
                } else if ("oracle_vm_guest".equals(this.m_harvesterTargetType)) {
                    this.m_emHostName = this.getGuestVMHostName("initial_master_vs_name");
                    bl2 = true;
                    object2 = this.m_emHomePath.split("_");
                    string15 = object2[0];
                    string14 = "N/A";
                    bl = true;
                    string13 = null;
                } else if ("oracle_cell".equals(this.m_harvesterTargetType) || "oracle_exadata".equals(this.m_harvesterTargetType)) {
                    this.m_emHomePath = "/opt/oracle/cell";
                    string14 = "/opt/oracle/cell";
                    object2 = ExadataUtil.getCellConfig(this.m_emTargetName, this.m_harvesterTargetType, this.m_harvesterSnapshotType, this.m_connection);
                    string15 = object2[0];
                    n = string7.indexOf(".");
                    object = n == -1 ? "" : string7.substring(n, string7.length());
                    this.m_emHostName = (String)object2[1] + (String)object;
                    this.m_ocmTargetName = object2[1];
                    bl3 = true;
                } else if ("oracle_exadata_grid".equals(this.m_harvesterTargetType)) {
                    object2 = ExadataGridUtil.getDBMachineId(this.m_connection, this.m_emTargetName);
                    this.m_emHomePath = "N/A";
                    string14 = "N/A";
                    String string16 = this.m_emHostName = string7 == null ? ExadataGridUtil.getDBMachineHostName(this.m_connection, this.m_emTargetName) : string7;
                    if (object2 != null) {
                        this.m_ocmTargetName = "Exadata Grid " + (String)object2;
                        string15 = "exadata_grid_" + (String)object2;
                    }
                } else if ("rac_database".equals(this.m_harvesterTargetType)) {
                    if ("oracle_exadata_dbsys".equals(this.m_ocmTargetType)) {
                        this.m_ocmTargetName = RacDatabaseUtil.getRacTargetName(this.m_emTargetName, this.m_connection);
                        this.m_emHomePath = "N/A";
                        string14 = "N/A";
                        this.m_emHostName = string7;
                        string15 = this.m_ocmTargetName = this.m_ocmTargetName + "_grid";
                    }
                } else if ("oracle_dbmachine".equals(this.m_harvesterTargetType)) {
                    object2 = DbmachineUtil.getDbmachineTargetName(this.m_connection, this.m_emTargetName);
                    if ("oracle_exadata_clustergrp".equals(this.m_ocmTargetType)) {
                        this.m_emHomePath = "N/A";
                        string14 = "N/A";
                        this.m_emHostName = string7;
                        if (object2 != null) {
                            this.m_ocmTargetName = "Exadata DatabaseSystem " + (String)object2;
                            string15 = "exadata_databasesystem_" + (String)object2;
                        }
                    } else {
                        this.m_emHomePath = "N/A";
                        string14 = "N/A";
                        this.m_emHostName = string7;
                        this.m_ocmTargetName = object2;
                        string15 = this.m_ocmTargetName;
                    }
                } else if ("weblogic_j2eeserver".equals(this.m_harvesterTargetType) || "weblogic_domain".equals(this.m_harvesterTargetType) || "weblogic_cluster".equals(this.m_harvesterTargetType) || "j2ee_application".equals(this.m_harvesterTargetType) || "oracle_ias_farm".equals(this.m_harvesterTargetType)) {
                    this.m_emHostName = WLUtil.getAdminserverHost(this.m_emTargetName, this.m_harvesterTargetType, this.m_connection, this.m_emHostName);
                    bl2 = true;
                } else if ("siebel_server".equals(this.m_harvesterTargetType) || "siebel_component".equals(this.m_harvesterTargetType) || "siebel_component_group".equals(this.m_harvesterTargetType) || "siebel_gateway".equals(this.m_harvesterTargetType)) {
                    object2 = SiebelUtil.getHostAndOracleHome(this.m_harvesterTargetType, this.m_ocmTargetType, this.m_emTargetName, this.m_emHostName, string14, this.m_connection);
                    this.m_emHostName = (String)((ArrayList)object2).get(0);
                    string14 = (String)((ArrayList)object2).get(1);
                }
                if ("weblogic_j2eeserver".equals(this.m_harvesterTargetType)) {
                    string14 = this.m_emHomePath = WLUtil.getAdminserverOH(this.m_emTargetName, this.m_harvesterTargetType, this.m_connection, this.m_emHomePath);
                    bl = true;
                }
                if ("oracle_bi_instance".equals(this.m_harvesterTargetType)) {
                    string14 = this.m_emHomePath = BIUtil.getBIOH(this.m_emTargetName, this.m_harvesterTargetType, this.m_connection, this.m_emHomePath);
                    bl = true;
                    this.m_emHostName = BIUtil.getAdminserverHost(this.m_emTargetName, this.m_harvesterTargetType, this.m_connection, this.m_emHostName);
                    bl2 = true;
                }
                if (this.m_harvesterTargetType.equals("oracle_emrep") && this.m_ocmTargetType.equals("oracle_emsystem")) {
                    this.m_emHomePath = EMSystemUtil.oracleHome(this.m_connection);
                    string14 = this.m_emHomePath = EMSystemUtil.oracleHome(this.m_connection);
                    bl2 = true;
                    bl = true;
                }
                if (null == this.m_ocmTargetName) {
                    if ("oracle_home".equals(this.m_harvesterTargetType)) {
                        this.m_ocmTargetName = this.getHomeName();
                    } else if ("oracle_database".equals(this.m_harvesterTargetType)) {
                        this.m_ocmTargetName = RacDatabaseUtil.getDBTargetName(this.m_emTargetName, this.m_connection);
                    } else if ("rac_database".equals(this.m_harvesterTargetType)) {
                        if (!"oracle_exadata_dbsys".equals(this.m_ocmTargetType)) {
                            this.m_ocmTargetName = RacDatabaseUtil.getRacTargetName(this.m_emTargetName, this.m_connection);
                        }
                    } else if ("oracle_ias".equals(this.m_harvesterTargetType)) {
                        this.m_ocmTargetName = this.getIasName();
                    } else if ("host".equals(this.m_harvesterTargetType)) {
                        this.m_ocmTargetName = this.m_emHostName;
                    } else if ("siebel_server".equals(this.m_harvesterTargetType) || "siebel_component_group".equals(this.m_harvesterTargetType) || "siebel_component".equals(this.m_harvesterTargetType) || "siebel_gateway".equals(this.m_harvesterTargetType)) {
                        this.m_ocmTargetName = SiebelUtil.getNewTargetName(this.m_harvesterTargetType, this.m_ocmTargetType, this.m_emTargetName, this.m_connection);
                    } else if ("weblogic_j2eeserver".equals(this.m_harvesterTargetType) || "weblogic_domain".equals(this.m_harvesterTargetType) || "weblogic_cluster".equals(this.m_harvesterTargetType) || "j2ee_application".equals(this.m_harvesterTargetType)) {
                        this.m_ocmTargetName = WLUtil.getWLServerTargetName(this.m_emTargetName, this.m_harvesterTargetType, this.m_connection);
                    } else if ("oracle_ias_farm".equals(this.m_harvesterTargetType)) {
                        this.m_ocmTargetName = WLUtil.getFarmTargetName(this.m_emTargetName, this.m_connection);
                    } else if ("oracle_eps_server".equals(this.m_harvesterTargetType) || "oracle_federation".equals(this.m_harvesterTargetType) || "oracle_ldap".equals(this.m_harvesterTargetType) && "oracle_ldap_11g_config".equals(this.m_harvesterSnapshotType) || "oracle_ovd".equals(this.m_harvesterTargetType)) {
                        this.m_ocmTargetName = IDMUtil.getIDMTargetName(this.m_emTargetName, this.m_harvesterTargetType, this.m_connection);
                        if (s_log.isDebugEnabled()) {
                            s_log.debug((Object)("IDM Target Name: " + this.m_ocmTargetName));
                        }
                    } else if ("oracle_bi_instance".equals(this.m_harvesterTargetType)) {
                        this.m_ocmTargetName = BIUtil.getAnalyticsAppTargetName(this.m_emTargetName, this.m_harvesterTargetType, connection);
                        if (s_log.isDebugEnabled()) {
                            s_log.debug((Object)("oracle_bi_instance Target Name: " + this.m_ocmTargetName));
                        }
                    } else {
                        this.m_ocmTargetName = this.m_harvesterTargetType.equals("oracle_emrep") && this.m_ocmTargetType.equals("oracle_emsystem") ? EMSystemUtil.targetName(this.m_connection) : this.m_emTargetName;
                    }
                }
                if (this.m_ocmTargetName != null) {
                    hashMap = HarvesterTargetProperies.getTargetProperties(this.m_emTargetName, this.m_harvesterTargetType, this.m_ocmTargetName, this.m_ocmTargetType, string14, this.m_emHostName, string15, this.m_connection);
                }
            }
            if (null == this.m_ocmTargetName || "".equals(this.m_ocmTargetName)) {
                object2 = "Could not determine OCM target name for EM target / harvester target type / harvester snapshot type = " + this.m_emTargetName + " / " + this.m_harvesterTargetType + " / " + this.m_harvesterSnapshotType;
                throw new HarvesterException((String)object2);
            }
            if (!GCVersion.pre11_2GC()) {
                if (null == hashMap) {
                    hashMap = new HashMap<String, String>();
                }
                hashMap.put("METAL_LEVEL", this.getTargetMetalLevel());
                object2 = this.getTargetLifeCycle();
                if (object2 != null && !((String)object2).equals("")) {
                    hashMap.put("orcl_ccr_lifecycle_status", (String)object2);
                }
            }
            this.m_ocmTargets = this.getOCMTargetInstance(connection, this.m_emTargetName, this.m_harvesterTargetType, string7, string13, this.m_ocmTargetName, this.m_ocmTargetType, this.m_emDisplayTargetName, this.m_emHostName, null != string9 ? string9 : string14, bl2, bl, this.m_emTargetTimezone, TargetMetadataUtil.getTargetMetadata(this.m_ocmTargetType).getMetadataVersion(), string15, hashMap, bl4, bl3);
        }
        catch (HarvesterException harvesterException) {
            throw harvesterException;
        }
        catch (Throwable throwable) {
            String string17 = "Failed creating Target object for " + this.m_emTargetName + " :" + throwable.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string17), throwable);
            throw new HarvesterException(string17, throwable);
        }
        boolean bl5 = false;
        for (n = 0; n < this.m_ocmTargets.size(); ++n) {
            object = (Target)this.m_ocmTargets.get(n);
            if (null != ((Target)object).getTimeZone()) continue;
            bl5 = true;
            break;
        }
        if (bl5) {
            String string18 = this.getTargetTimezone();
            boolean bl6 = "GMT".equals(this.getTargetTimezone());
            String string19 = "Timezone " + string18 + " not supported when creating Target object for " + this.getTargetName() + (bl6 ? "" : "; trying to use GMT...");
            if (!bl6) {
                Object object3;
                s_log.warn((Object)("GC OCM Harvester: " + string19));
                if (s_log.isDebugEnabled()) {
                    object3 = "Retrying Target object creation using GMT timezone for " + this.m_emTargetName;
                    s_log.debug((Object)("GC OCM Harvester: " + (String)object3));
                }
                object3 = new GcCollectionInfo(connection, string, string2, string3, string4, string5, "GMT", string7, string8, string9, string10, string11, arrayList, this.m_ocmTargetName);
                this.m_ocmTargets = ((GcCollectionInfo)object3).getOcmTargets();
            } else {
                s_log.error((Object)("GC OCM Harvester: " + string19));
                throw new HarvesterException(string19);
            }
        }
    }

    Connection getConnection() {
        return this.m_connection;
    }

    public String getTargetName() {
        return this.m_emTargetName;
    }

    public String getDisplayTargetName() {
        return this.m_emDisplayTargetName;
    }

    public String getTargetType() {
        return this.m_harvesterTargetType;
    }

    public String getSnapshotType() {
        return this.m_harvesterSnapshotType;
    }

    public String getTargetTimezone() {
        return this.m_emTargetTimezone;
    }

    public String getHostName() {
        return this.m_emHostName;
    }

    public String getHomePath() {
        return this.m_emHomePath;
    }

    public String getOcmTargetName() {
        return this.m_ocmTargetName;
    }

    public String getOcmTargetType() {
        return this.m_ocmTargetType;
    }

    public String getOcmSnapshotType() {
        return this.m_ocmSnapshotType;
    }

    public ArrayList getOcmMetricInfos() {
        return this.m_ocmMetricInfos;
    }

    public List getOcmTargets() {
        return this.m_ocmTargets;
    }

    void setLastOhMetricIsEmpty(boolean bl) {
        this.m_lastOhMetricIsEmpty = bl;
    }

    boolean getLastOhMetricIsEmpty() {
        return this.m_lastOhMetricIsEmpty;
    }

    private List getOCMTargetInstance(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, boolean bl2, String string10, String string11, String string12, Map map, boolean bl3, boolean bl4) throws HarvesterException, SAXException {
        Object object;
        if (string8 == null || string9 == null || string8.equals("") || string9.equals("")) {
            String string13 = "Skiping target [targetName: " + string + ", targetType: " + string2 + "]" + " as oracle home or hostname is null [oh: " + string9 + ", host: " + string8 + "]";
            s_log.warn((Object)("GC OCM Harvester: " + string13));
            throw new IgnoreTargetException(string13);
        }
        ArrayList<Target> arrayList = new ArrayList<Target>();
        GCContextList gCContextList = GCContextFactory.getGCContext(string, string2, string3, string4, string6, string8, string9, bl2, bl, bl3, connection);
        List list = gCContextList.gcContextList();
        if (list == null || list.isEmpty()) {
            String string14 = "GC Context is empty";
            s_log.error((Object)("GC OCM Harvester: " + string14));
            throw new HarvesterException(string14);
        }
        GCContextManager.setGCContext(gCContextList);
        gCContextList.setCurrentGCContext((GCContext)list.get(0));
        if (GCVersion.pre11_1GC()) {
            if (string12 != null) {
                String string15 = "UNIQUE_ID not supported for GC version less then 11.1.0.1.0Failed collection for " + string5 + " (" + string6 + ")";
                s_log.error((Object)("GC OCM Harvester: " + string15));
                throw new HarvesterException(string15);
            }
            Target target = new Target(string5, string6, false, string7, false, string8, string9, null, true, string8, string10, string11);
            arrayList.add(target);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                object = (GCContext)list.get(i);
                gCContextList.setCurrentGCContext((GCContext)object);
                boolean bl5 = object.isProxy();
                if (bl4) {
                    bl5 = true;
                }
                if (object.isOutOfPlaceUpgrade()) {
                    map = this.mergeOutOfPlaceMap(map, (GCContext)object);
                    this.changeMetricListForFullCollection(connection);
                }
                Target target = new Target(string5, string6, false, string7, false, string8, string9, null, bl5, string8, string10, string11, string12, map);
                arrayList.add(target);
            }
            gCContextList.setCurrentGCContext((GCContext)list.get(0));
        }
        if (string6.equals(this.m_harvesterTargetType) || string6.equals((String)emOcmTargetTypeMap.get(this.m_harvesterTargetType))) {
            Target target = (Target)arrayList.get(0);
            object = new HashMap();
            object.put("OCM_TARGET_GUID", target.getGUID());
            HarvesterTargetPropUtil.persistHarvesterTargetProperties(connection, (Map)object, this.m_emTargetName, this.m_harvesterTargetType);
        }
        return arrayList;
    }

    private Map mergeOutOfPlaceMap(Map map, GCContext gCContext) {
        Map map2 = map;
        Map map3 = gCContext.outOfPlaceUpgradeProps();
        if (map3 != null) {
            if (map == null) {
                map2 = map3;
            } else {
                map2.remove("OLD_NAME");
                map2.remove(HarvesterTargetProperies.OLD_HOST_PROP);
                map2.remove(HarvesterTargetProperies.OLD_OH_PROP);
                map2.remove("OLD_ORACLE_CONFIG_HOME");
                map2.remove("OLD_UNIQUE_ID");
                Set set = map3.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    map2.put(string, map3.get(string));
                }
            }
        }
        return map2;
    }

    private void changeMetricListForFullCollection(Connection connection) throws HarvesterException {
        HarvesterMetadata harvesterMetadata = HarvesterMetadata.getInstance((OracleConnection)connection);
        HarvesterSnapshotMD harvesterSnapshotMD = harvesterMetadata.getSnapshotMD(this.getTargetType(), this.getSnapshotType());
        if (harvesterSnapshotMD != null) {
            this.m_ocmMetricInfos = new ArrayList();
            Set set = harvesterSnapshotMD.getMetricNames();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                HarvesterEMMetricMD harvesterEMMetricMD = harvesterSnapshotMD.getEMMetricMD(string);
                HarvesterOCMMetricMD[] harvesterOCMMetricMDArray = harvesterEMMetricMD.getOCMMetrics();
                for (int i = 0; i < harvesterOCMMetricMDArray.length; ++i) {
                    this.m_ocmMetricInfos.add(harvesterOCMMetricMDArray[i]);
                }
            }
        }
    }

    private String getTargetMetalLevel() throws HarvesterException {
        String string = "";
        String string2 = "select p.property_value from mgmt_target_prop_defs d, mgmt$target_properties p where p.target_name = :tn and p.target_type = :tt and p.property_name = d.property_name and p.target_type = d.target_type and d.property_display_name = 'Metal Level' and d.property_name like 'udtp%'";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{this.m_emTargetName, this.m_harvesterTargetType});
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1024};
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)string2, (int[])new int[]{1, 1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Throwable throwable) {
            String string3 = "Getting metal level failed: " + throwable.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string3));
            throw new HarvesterException(string3, throwable);
        }
        if (null != arrayList2) {
            Object[] objectArray = (Object[])arrayList2.get(0);
            string = (String)objectArray[0];
        }
        return string;
    }

    private String getTargetLifeCycle() throws HarvesterException {
        String string = "";
        String string2 = "select lifecycle_status from gc$global_target_properties where target_name = :tn and target_type = :tt";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{this.m_emTargetName, this.m_harvesterTargetType});
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1024};
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)string2, (int[])new int[]{1, 1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Throwable throwable) {
            String string3 = "Getting lifecycle for the target failed: " + throwable.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string3));
            throw new HarvesterException(string3, throwable);
        }
        if (null != arrayList2) {
            Object[] objectArray = (Object[])arrayList2.get(0);
            string = (String)objectArray[0];
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Lifecycle for this target in gc collection info is : " + string));
        }
        return string;
    }

    private String getHomeName() throws HarvesterException {
        String string = null;
        String string2 = "SELECT c.container_name FROM mgmt_ecm_snapshot s, mgmt_inv_container c WHERE s.target_name = :tn AND s.target_type = 'host' AND s.snapshot_type = 'host_configuration' AND s.is_current = 'Y' AND c.snapshot_guid = s.snapshot_guid AND c.container_location = :hp";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{this.m_emTargetName, this.m_emHomePath});
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{64};
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)string2, (int[])new int[]{1, 1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Throwable throwable) {
            String string3 = "Getting home name failed: " + throwable.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string3));
            throw new HarvesterException(string3, throwable);
        }
        if (null != arrayList2) {
            Object[] objectArray = (Object[])arrayList2.get(0);
            string = (String)objectArray[0];
        }
        return string;
    }

    private String getIasName() throws HarvesterException {
        String string = null;
        String string2 = null;
        String string3 = "SELECT p.property_value FROM mgmt_target_properties p, mgmt_targets t WHERE t.target_name = :tn AND t.target_type = 'oracle_ias' AND t.target_guid = p.target_guid AND p.property_name = 'Version' AND p.property_type = 'INSTANCE'";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{this.m_emTargetName});
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1024};
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)string3, (int[])new int[]{1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Throwable throwable) {
            String string4 = "Getting ias name failed: " + throwable.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string4));
            throw new HarvesterException(string4, throwable);
        }
        if (null != arrayList2) {
            Object[] objectArray = (Object[])arrayList2.get(0);
            string2 = (String)objectArray[0];
        }
        string = null != string2 && !"".equals(string2) && string2.startsWith("1.0.2.") ? "iASR1_" + this.m_emHomePath : this.m_emTargetName;
        return string;
    }

    private String getOVSPHostName(String string) throws HarvesterException {
        String string2 = null;
        String string3 = "SELECT p.property_value FROM mgmt_target_properties p, mgmt_targets t WHERE t.target_name = :tn AND t.target_type = 'oracle_vm_server_pool' AND t.target_guid = p.target_guid AND p.property_name = :pn AND p.property_type = 'INSTANCE'";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{this.m_emTargetName, string});
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1024};
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)string3, (int[])new int[]{1, 1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Throwable throwable) {
            String string4 = "Getting host name failed for Oracle Virtual Server Pool: " + throwable.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string4));
            throw new HarvesterException(string4, throwable);
        }
        if (null != arrayList2) {
            Object[] objectArray = (Object[])arrayList2.get(0);
            string2 = (String)objectArray[0];
        }
        return string2;
    }

    private String getGuestVMHostName(String string) throws HarvesterException {
        String string2 = null;
        String string3 = "SELECT p.property_value FROM mgmt_target_properties p, mgmt_targets t WHERE t.target_guid = (select SERVER_POOL_GUID from  mgmt_virt_vm_master where VM_DOMAIN_NAME = :tn and VM_OVM_ID = regexp_substr(:vcid , '[^_APPEND_]+') ) AND t.target_type = 'oracle_vm_server_pool' AND t.target_guid = p.target_guid AND p.property_name = :pn AND p.property_type = 'INSTANCE'";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{this.m_emTargetName, this.m_emHomePath, string});
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1024};
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)string3, (int[])new int[]{1, 1, 1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Throwable throwable) {
            String string4 = "Getting host name failed for Oracle VM Guest Virtual Machine: " + throwable.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string4));
            throw new HarvesterException(string4, throwable);
        }
        if (null != arrayList2) {
            Object[] objectArray = (Object[])arrayList2.get(0);
            string2 = (String)objectArray[0];
        }
        return string2;
    }

    private String getVSHostName(String string) throws HarvesterException {
        String string2 = null;
        String string3 = "SELECT p.property_value FROM mgmt_target_properties p, mgmt_targets t WHERE t.target_name = :tn AND t.target_type = 'oracle_vm_server' AND t.target_guid = p.target_guid AND p.property_name = :pn AND p.property_type = 'INSTANCE'";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{this.m_emTargetName, string});
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1024};
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)string3, (int[])new int[]{1, 1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Throwable throwable) {
            String string4 = "Getting host name failed for Oracle Virtual Server : " + throwable.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string4));
            throw new HarvesterException(string4, throwable);
        }
        if (null != arrayList2) {
            Object[] objectArray = (Object[])arrayList2.get(0);
            string2 = (String)objectArray[0];
        }
        return string2;
    }

    private String generateMD5Hash(String string) throws HarvesterException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(string.getBytes());
            String string2 = StringUtil.byteArrayToAsciiString((byte[])byArray).toUpperCase();
            return string2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new HarvesterException("Unable to get MD5 GUID for the string: \n" + string + " " + noSuchAlgorithmException.getMessage());
        }
    }

    private String getOVSUniqueIDString() throws HarvesterException {
        String string = null;
        String string2 = "SELECT to_timestamp(to_char(load_timestamp,'DD/MM/YYYY HH24:MI:SS'), 'DD/MM/YYYY HH24:MI:SS') as load_timestamp FROM mgmt_targets WHERE target_name = :tn AND target_type = 'oracle_vm_server' ";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{this.m_emTargetName});
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1024};
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)string2, (int[])new int[]{1, 1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Throwable throwable) {
            String string3 = "Getting uniqueString failed for Oracle Virtual Server : " + throwable.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string3));
            throw new HarvesterException(string3, throwable);
        }
        if (null != arrayList2) {
            Object[] objectArray = (Object[])arrayList2.get(0);
            string = (String)objectArray[0];
        }
        string = this.m_emTargetName + ":" + this.m_harvesterTargetType + ":" + string;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getOcmTargetsForEMTarget(OracleConnection oracleConnection, String string) throws HarvesterException {
        List list;
        if (GCVersion.pre11_2GC()) {
            String string2 = "pre 11_2GC version not supported";
            throw new HarvesterException(string2);
        }
        GCContextList gCContextList = GCContextManager.getGCContextList();
        GCContext gCContext = GCContextManager.getGCContext();
        ArrayList arrayList = GcCollectionInfo.getTargets(oracleConnection, string);
        Object[] objectArray = (Object[])arrayList.get(0);
        int n = 0;
        String string3 = (String)objectArray[n++];
        String string4 = (String)objectArray[n++];
        String string5 = (String)objectArray[n++];
        String string6 = (String)objectArray[n++];
        String string7 = (String)objectArray[n++];
        String string8 = (String)objectArray[n++];
        String string9 = (String)objectArray[n++];
        try {
            GcCollectionInfo gcCollectionInfo = new GcCollectionInfo((Connection)oracleConnection, string3, string5, string9, string4, null, string7, string6, string8, string8, string4, string4, null);
            list = gcCollectionInfo.getOcmTargets();
        }
        finally {
            gCContextList.setCurrentGCContext(gCContext);
            GCContextManager.setGCContext(gCContextList);
        }
        return list;
    }

    private static ArrayList getTargets(OracleConnection oracleConnection, String string) throws HarvesterException {
        ArrayList arrayList;
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>(1);
        arrayList2.add(new Object[]{new String(string)});
        try {
            arrayList = TrackUtilities.executePreparedStatement((OracleConnection)oracleConnection, (String)" SELECT  t.target_name, \n         t.target_type, \n         t.display_name, \n         t.host_name, \n         t.timezone_region,\n         /* lowercase home path if find host and it runs any kind of Windows */\n         COALESCE (\n           (SELECT (\n              CASE \n                WHEN INSTR(NLS_UPPER(t2.category_prop_1), 'WINDOWS') != 0 THEN\n                  NLS_LOWER(p.property_value)\n                ELSE p.property_value\n              END)\n            FROM mgmt_targets t2\n            WHERE t2.target_name = t.host_name\n            AND t2.target_type = 'host'),\n           p.property_value) home,\n         t.discovered_name discovered_name\n    FROM mgmt_targets t, \n         mgmt_target_properties p\n   WHERE t.target_guid = hextoraw(?)\n     AND t.target_guid = p.target_guid (+)\n     AND 'OracleHome' = p.property_name(+)\n", (int[])new int[]{1}, arrayList2, (int[])new int[]{1, 1, 1, 1, 1, 1, 1}, (int[])new int[]{256, 64, 256, 256, 64, 1024, 256}, (boolean)false);
        }
        catch (Exception exception) {
            String string2 = "Failed to get targets to process: " + exception.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string2));
            throw new HarvesterException(string2, exception);
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        emOcmTargetTypeMap.put("oracle_exadata", "oracle_cell");
    }
}

