/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sysman.ccr.collector.collectionMgr.CollectionMgr;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResultList;
import oracle.sysman.ccr.collector.collectionMgr.MetricCollectionLimiterMgr;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.gcontext.GCContext;
import oracle.sysman.ccr.collector.gcontext.GCContextList;
import oracle.sysman.ccr.collector.gcontext.GCContextManager;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.OCheckMetric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.gcharvester.GCInit;
import oracle.sysman.ccr.gcharvester.GcCollectionInfo;
import oracle.sysman.ccr.gcharvester.GcMetric;
import oracle.sysman.ccr.gcharvester.GcSnapshot;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD;
import oracle.sysman.ccr.gcharvester.targettype.HarvesterAddTargetCallback;
import oracle.sysman.ccr.gcharvester.targettype.TargetMetadataUtil;
import oracle.sysman.ccr.gcharvester.ti.common.HarvesterAddTargetCallbacks;
import oracle.sysman.ccr.gcharvester.ti.common.HarvesterMetricResultCallbacks;
import oracle.sysman.ccr.gcharvester.upload.GCUploader;
import oracle.sysman.ccr.gcharvester.upload.UploadCallBack;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

class GcCollectionMgr {
    private static final Category s_log = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$GcCollectionMgr == null ? (class$oracle$sysman$ccr$gcharvester$GcCollectionMgr = GcCollectionMgr.class$("oracle.sysman.ccr.gcharvester.GcCollectionMgr")) : class$oracle$sysman$ccr$gcharvester$GcCollectionMgr).getName());
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$GcCollectionMgr;

    GcCollectionMgr() throws HarvesterException {
        GcCollectionMgr.initOcm();
    }

    int collectAndPersistGcMetrics(GcCollectionInfo gcCollectionInfo, GCUploader gCUploader, UploadCallBack uploadCallBack, Connection connection) throws HarvesterException {
        Object object;
        int n = 0;
        int n2 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            Serializable serializable;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Inside collectAndPersistGcMetrics for loop: " + n2));
            }
            if (!gCUploader.shouldCollectConfigMetricData(gcCollectionInfo)) {
                n = 1;
                if (!s_log.isInfoEnabled()) break;
                object = "Previously created file was not uploaded yet; so will wait until next time to upload information for target / collection = " + gcCollectionInfo.getTargetName() + " / " + gcCollectionInfo.getOcmSnapshotType();
                s_log.info((Object)("GC OCM Harvester: " + (String)object));
                break;
            }
            object = new GcSnapshot(gcCollectionInfo);
            List list = this.collectConfigMetricData(gcCollectionInfo);
            if (!gcCollectionInfo.getSnapshotType().equals("oracle_db_adrinfo") && null != gcCollectionInfo.getOcmMetricInfos() && gcCollectionInfo.getOcmMetricInfos().size() > 0 && ((GcSnapshot)object).snapshotChanged()) {
                if (((GcSnapshot)object).targetExists(gcCollectionInfo.getLastOhMetricIsEmpty())) continue;
                n = 3;
                break;
            }
            if (!(gcCollectionInfo.getSnapshotType().equals("OCheck") || gcCollectionInfo.getSnapshotType().equals("oracle_db_adrinfo") || ((GcSnapshot)object).targetExists(gcCollectionInfo.getLastOhMetricIsEmpty()))) {
                n = 3;
                break;
            }
            Timestamp timestamp = ((GcSnapshot)object).getStartTimestamp();
            List list2 = gcCollectionInfo.getOcmTargets();
            for (int i = 0; i < list2.size(); ++i) {
                serializable = (Target)list2.get(i);
                ((Target)serializable).setCollectionTimestampOverride(timestamp);
            }
            gCUploader.uploadCollectionResults(list, true, uploadCallBack, connection);
            HarvesterAddTargetCallback harvesterAddTargetCallback = HarvesterAddTargetCallbacks.getCallback(gcCollectionInfo.getOcmTargetType());
            if (harvesterAddTargetCallback == null) break;
            serializable = new ArrayList();
            GCContextList gCContextList = GCContextManager.getGCContextList();
            List list3 = gCContextList.gcContextList();
            for (int i = 0; i < list3.size(); ++i) {
                GCContext gCContext = (GCContext)list3.get(i);
                gCContextList.setCurrentGCContext(gCContext);
                CollectionResultList collectionResultList = harvesterAddTargetCallback.getCollectionResultList(gcCollectionInfo, connection);
                serializable.add(collectionResultList);
            }
            gCUploader.uploadCollectionResults((List)((Object)serializable), true, uploadCallBack, connection);
            break;
        }
        if (3 == n2) {
            if (s_log.isInfoEnabled()) {
                object = "Source snapshot changed during 3 collection attempts for target / collection = " + gcCollectionInfo.getTargetName() + " / " + gcCollectionInfo.getOcmSnapshotType();
                s_log.info((Object)("GC OCM Harvester: " + (String)object));
            }
            n = 2;
        }
        return n;
    }

    private static void initOcm() throws HarvesterException {
        try {
            GCInit.init();
        }
        catch (HarvesterException harvesterException) {
            String string = "Caught GC Harvester exception from GCInit.init(): " + harvesterException.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string));
            throw harvesterException;
        }
    }

    private List collectOCheckMetricData(GcCollectionInfo gcCollectionInfo) throws HarvesterException {
        int n;
        ArrayList<CollectionResultList> arrayList = new ArrayList<CollectionResultList>();
        MetricResult metricResult = new MetricResult();
        Connection connection = gcCollectionInfo.getConnection();
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        String string = gcCollectionInfo.getTargetName();
        String string2 = gcCollectionInfo.getTargetType();
        String string3 = "OCheck";
        Metric metric = OCheckMetric.getOCheckMetric();
        TableDescriptor tableDescriptor = metric.getTblDesc();
        try {
            oraclePreparedStatement = (OraclePreparedStatement)((OracleConnection)connection).prepareStatement("  SELECT d.diag_name, d.data_type, d.key, d.value, d.context_value1, \n         d.context_value2, d.context_value3, d.context_value4, \n         d.context_value5\n   FROM MGMT_DIAGNOSTIC_CHECK_ROWS d,\n        MGMT_TARGETS tg, \n        MGMT_OCM_UPL_METRICS om\n        WHERE tg.target_name = om.target_name\n          AND tg.target_type = om.target_type \n          AND om.snapshot_type = 'OCheck' \n          AND (om.last_harvest_ts is null\n               OR d.collection_timestamp >= om.last_harvest_ts)\n          AND d.collection_timestamp < ( select ts_value \n                                         from mgmt_ocm_upl_props\n                                         WHERE name = 'changes_ts') \n          AND d.target_guid = tg.target_guid\n          AND tg.target_type = :tt\n          AND tg.target_name = :tn\n");
            oraclePreparedStatement.setStringAtName("tn", string);
            oraclePreparedStatement.setStringAtName("tt", string2);
            oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            ValueRow valueRow = null;
            int n2 = tableDescriptor.getColDescs().size();
            if (null != oracleResultSet) {
                while (oracleResultSet.next()) {
                    valueRow = metricResult.addValueRow();
                    for (n = 0; n < n2; ++n) {
                        valueRow.setValue(n, oracleResultSet.getString(n + 1));
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                String string4 = "collect failed for  target / EM snapshot type / targetType / sql = " + string + " / " + "OCheck" + " / " + string2 + " :" + sQLException.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string4));
                throw new HarvesterException(string4, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(oraclePreparedStatement, oracleResultSet);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)oraclePreparedStatement, (ResultSet)oracleResultSet);
        int n3 = gcCollectionInfo.getOcmTargets().size();
        CollectionResult collectionResult = new CollectionResult("OCheck", true, false, tableDescriptor, metricResult);
        for (n = 0; n < n3; ++n) {
            Target target = (Target)gcCollectionInfo.getOcmTargets().get(n);
            CollectionResultList collectionResultList = new CollectionResultList(target, gcCollectionInfo.getOcmSnapshotType(), "1.0");
            collectionResultList.put(string3, collectionResult);
            arrayList.add(collectionResultList);
        }
        return arrayList;
    }

    private List collectADRInfoMetricData(GcCollectionInfo gcCollectionInfo) throws HarvesterException {
        int n;
        ArrayList<CollectionResultList> arrayList = new ArrayList<CollectionResultList>();
        MetricResult metricResult = new MetricResult();
        Connection connection = gcCollectionInfo.getConnection();
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        String string = gcCollectionInfo.getTargetName();
        String string2 = gcCollectionInfo.getTargetType();
        String string3 = "adr_info";
        TargetMetadata targetMetadata = TargetMetadataUtil.getTargetMetadata(string2);
        Metric metric = targetMetadata.getMetric(string3);
        TableDescriptor tableDescriptor = metric.getTblDesc();
        boolean bl = false;
        try {
            oraclePreparedStatement = (OraclePreparedStatement)((OracleConnection)connection).prepareStatement("    SELECT \n        PROBLEM_KEY, \n        TO_CHAR(STARTTIME,'YYYY-MM-DD HH24:MI:SS TZH:TZM' ) STARTTIME, \n        TO_CHAR(ENDTIME ,'YYYY-MM-DD HH24:MI:SS TZH:TZM' ) ENDTIME, \n        COUNT (*) COUNT \n    FROM \n    ( \n        SELECT \n            PROBLEM_KEY, \n            -- Convert date to timestamp and add timezone\n            FROM_TZ( CAST ( STARTTIME  AS TIMESTAMP) , TIMEZONE_REGION) STARTTIME, \n            FROM_TZ( CAST ( (STARTTIME + 1/24)  AS TIMESTAMP) , TIMEZONE_REGION) ENDTIME \n        FROM \n        (  \n            SELECT \n                P.PROBLEM_KEY,  \n                -- Convert CREATION_DATE which is in UTC time to Target timezone and truncate till hour\n                TRUNC( MGMT_GLOBAL.FROM_UTC_DST(I.CREATION_DATE, TG.TIMEZONE_REGION ) ,'HH') AS STARTTIME ,\n                TG.TIMEZONE_REGION \n            FROM EM_PROBLEM_ISSUE PARTITION(OPEN) P     \n            JOIN EM_ISSUES_INTERNAL PARTITION(OPEN) I ON P.PROBLEM_ID = I.RELATED_PROBLEM_ID \n                 AND P.OPEN_STATUS = I.OPEN_STATUS AND P.CLOSED_DATE = I.CLOSED_DATE\n            JOIN EM_EVENTS_INCIDENT PARTITION(OPEN) EI ON EI.INCIDENT_ID = I.ISSUE_ID \n            JOIN MGMT_TARGETS TG ON TG.TARGET_GUID = EI.TARGET_GUID \n            JOIN MGMT_OCM_UPL_METRICS OM ON TG.TARGET_NAME = OM.TARGET_NAME \n            WHERE  \n                    OM.TARGET_NAME= :tn   \n                AND OM.TARGET_TYPE = :tt \n                AND OM.SNAPSHOT_TYPE= 'oracle_db_adrinfo' \n                AND OM.TABLE_NAME = 'MGMT_ECM_ADR_INFO' \n                AND I.ISSUE_TYPE = 1 \n                AND I.IS_ADR_AWARE = 1 \n                AND I.CREATION_DATE >=  MGMT_GLOBAL.TO_UTC_DST(OM.LAST_HARVEST_TS, sessiontimezone) \n                AND i.creation_date < ( select MGMT_GLOBAL.TO_UTC_DST(ts_value, sessiontimezone)  \n                                        FROM MGMT_OCM_UPL_PROPS WHERE name = 'changes_ts') \n        ) \n    ) \n    GROUP BY PROBLEM_KEY, STARTTIME, ENDTIME\n");
            oraclePreparedStatement.setStringAtName("tn", string);
            oraclePreparedStatement.setStringAtName("tt", string2);
            oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            ValueRow valueRow = null;
            int n2 = tableDescriptor.getColDescs().size();
            if (null != oracleResultSet) {
                while (oracleResultSet.next()) {
                    valueRow = metricResult.addValueRow();
                    for (n = 0; n < n2; ++n) {
                        valueRow.setValue(n, oracleResultSet.getString(n + 1));
                    }
                    bl = true;
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                String string4 = "collect failed for  target / EM snapshot type / targetType / sql = " + string + " / " + "oracle_db_adrinfo" + " / " + string2 + " :" + sQLException.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string4));
                throw new HarvesterException(string4, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(oraclePreparedStatement, oracleResultSet);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)oraclePreparedStatement, (ResultSet)oracleResultSet);
        if (!bl) {
            return arrayList;
        }
        int n3 = gcCollectionInfo.getOcmTargets().size();
        CollectionResult collectionResult = new CollectionResult(string3, true, false, tableDescriptor, metricResult);
        for (n = 0; n < n3; ++n) {
            Target target = (Target)gcCollectionInfo.getOcmTargets().get(n);
            CollectionResultList collectionResultList = new CollectionResultList(target, gcCollectionInfo.getOcmSnapshotType(), "1.0");
            collectionResultList.put(string3, collectionResult);
            arrayList.add(collectionResultList);
            s_log.debug((Object)"## inside ADR Info metric added ");
        }
        return arrayList;
    }

    private List collectConfigMetricData(GcCollectionInfo gcCollectionInfo) throws HarvesterException {
        TargetMetadata targetMetadata = null;
        ArrayList arrayList = new ArrayList();
        if ("OCheck".equals(gcCollectionInfo.getSnapshotType())) {
            return this.collectOCheckMetricData(gcCollectionInfo);
        }
        if ("oracle_db_adrinfo".equals(gcCollectionInfo.getSnapshotType())) {
            arrayList.addAll(this.collectADRInfoMetricData(gcCollectionInfo));
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        try {
            Object object;
            Object object2;
            int n;
            targetMetadata = gcCollectionInfo.getTargetType().equals("oracle_vm_server_host") ? TargetMetadataUtil.getTargetMetadata(gcCollectionInfo.getTargetType()) : TargetMetadataUtil.getTargetMetadata(gcCollectionInfo.getOcmTargetType());
            Target target = (Target)gcCollectionInfo.getOcmTargets().get(0);
            if (arrayList.size() > 0) {
                arrayList2.addAll(arrayList);
            } else {
                for (n = 0; n < gcCollectionInfo.getOcmTargets().size(); ++n) {
                    object2 = (Target)gcCollectionInfo.getOcmTargets().get(n);
                    object = new CollectionResultList((Target)object2, gcCollectionInfo.getOcmSnapshotType(), targetMetadata.getMetadataVersion());
                    arrayList2.add(object);
                }
            }
            for (n = 0; n < gcCollectionInfo.getOcmMetricInfos().size(); ++n) {
                Object object3;
                Object object4;
                object2 = (HarvesterOCMMetricMD)gcCollectionInfo.getOcmMetricInfos().get(n);
                object = ((HarvesterOCMMetricMD)object2).getName();
                if ("oracle_db_adrinfo".equals(gcCollectionInfo.getSnapshotType()) && "adr_info".equals(object) || "PatchedComponent".equals(object) && null != ((CollectionResultList)arrayList2.get(0)).get(object)) continue;
                Metric metric = targetMetadata.getMetric((String)object, target);
                GcMetric gcMetric = new GcMetric((HarvesterOCMMetricMD)object2, gcCollectionInfo.getTargetName(), gcCollectionInfo.getTargetType(), gcCollectionInfo.getSnapshotType(), gcCollectionInfo.getOcmSnapshotType(), gcCollectionInfo.getHomePath());
                MetricResult metricResult = null;
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Metric name for harvester collection is: " + gcCollectionInfo.getTargetType() + " And the target type for the metric is this: " + (String)object));
                }
                boolean bl = true;
                if (!GCVersion.pre11_1GC()) {
                    object4 = MetricCollectionLimiterMgr.getInstance();
                    bl = ((MetricCollectionLimiterMgr)object4).isMetricCollectionAllowed(gcCollectionInfo.getTargetType(), (String)object);
                }
                if (!bl) continue;
                try {
                    metricResult = gcMetric.collect(gcCollectionInfo.getConnection());
                    if ("oracle_home".equals(gcCollectionInfo.getTargetType()) && GCVersion.pre11_2GC() && gcCollectionInfo.getOcmMetricInfos().size() - 1 == n) {
                        gcCollectionInfo.setLastOhMetricIsEmpty(null == metricResult.getValueRows());
                    }
                    if ((object4 = HarvesterMetricResultCallbacks.getCallback(gcCollectionInfo.getOcmTargetType())) != null) {
                        s_log.debug((Object)(metric + ":" + metricResult + ":" + gcCollectionInfo.getOcmTargetName()));
                        metricResult = object4.callback(metric, metricResult, gcCollectionInfo.getOcmTargetName(), gcCollectionInfo.getOcmTargetType(), gcCollectionInfo.getOcmSnapshotType(), gcCollectionInfo.getTargetName(), gcCollectionInfo.getTargetType(), gcCollectionInfo.getSnapshotType(), gcCollectionInfo.getConnection());
                    }
                    object3 = new CollectionResult((String)object, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        CollectionResultList collectionResultList = (CollectionResultList)arrayList2.get(i);
                        collectionResultList.put(object, object3);
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    object3 = "Failed collecting metric for  target / collection / metric = " + gcCollectionInfo.getTargetName() + " / " + gcCollectionInfo.getOcmSnapshotType() + " / " + (String)object + " :" + throwable.getMessage();
                    if (throwable instanceof HarvesterException) {
                        s_log.error((Object)("GC OCM Harvester: " + (String)object3));
                    } else {
                        s_log.error((Object)("GC OCM Harvester: " + (String)object3), throwable);
                    }
                    throw new HarvesterException((String)object3, throwable);
                }
            }
            return arrayList2;
        }
        catch (Throwable throwable) {
            if (throwable instanceof HarvesterException) {
                throw (HarvesterException)throwable;
            }
            String string = "Failed collecting metrics for  target / collection = " + gcCollectionInfo.getTargetName() + " / " + gcCollectionInfo.getOcmSnapshotType() + " :\n" + throwable.getStackTrace();
            s_log.error((Object)("GC OCM Harvester: " + string), throwable);
            throw new HarvesterException(string, throwable);
        }
    }

    private void persistConfigMetricDataForUpload(CollectionResultList collectionResultList) throws HarvesterException {
        try {
            CollectionMgr collectionMgr = CollectionMgr.getInstance();
            collectionMgr.persistCollectionForGCUpload(collectionResultList, true);
        }
        catch (Throwable throwable) {
            String string = "Failed persisting metrics for  target / collection = " + collectionResultList.getTargetInstance().getTargetName() + " / " + collectionResultList.getCollectionName() + " :" + throwable.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string), throwable);
            throw new HarvesterException(string, throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static interface CollectionStatuses {
        public static final int SUCCESS = 0;
        public static final int PREVIOUS_PENDING = 1;
        public static final int SNAPSHOT_CHANGING = 2;
        public static final int NO_SUCH_TARGET_OR_SNAPSHOT = 3;
    }
}

