/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import oracle.sysman.eml.ecm.track.RepositoryOperationException;
import oracle.sysman.eml.ecm.track.TrackUtilities;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

class GcMetric {
    private HarvesterOCMMetricMD m_ocmMMd = null;
    private String m_targetName = null;
    private String m_harvesterTargetType = null;
    private String m_harvesterSnapshotType = null;
    private String m_collectionName = null;
    private String m_homePath = null;
    private static boolean s_upi_column_fixed = false;
    private static final Category s_log = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$GcMetric == null ? (class$oracle$sysman$ccr$gcharvester$GcMetric = GcMetric.class$("oracle.sysman.ccr.gcharvester.GcMetric")) : class$oracle$sysman$ccr$gcharvester$GcMetric).getName());
    private static final int ROW_PREFETCH_SIZE = 100;
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$GcMetric;

    GcMetric(HarvesterOCMMetricMD harvesterOCMMetricMD, String string, String string2, String string3, String string4, String string5) {
        this.m_ocmMMd = harvesterOCMMetricMD;
        this.m_targetName = string;
        this.m_harvesterTargetType = string2;
        this.m_harvesterSnapshotType = string3;
        this.m_collectionName = string4;
        this.m_homePath = string5;
    }

    MetricResult collect(Connection connection) throws HarvesterException {
        if (!s_upi_column_fixed && this.m_ocmMMd.getName().equals("Patch")) {
            this.fixUpiColumnName(connection);
            s_upi_column_fixed = true;
        }
        MetricResult metricResult = new MetricResult();
        String string = this.m_harvesterSnapshotType;
        String string2 = this.m_harvesterTargetType;
        if ("oracle_home".equals(this.m_harvesterTargetType) && GCVersion.pre11_2GC()) {
            string = "host_configuration";
            string2 = this.m_homePath;
        } else if ("oracle_vm_guest".equals(this.m_harvesterTargetType) && GCVersion.pre11_2GC()) {
            string2 = this.m_homePath;
        }
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        try {
            int n;
            oraclePreparedStatement = (OraclePreparedStatement)((OracleConnection)connection).prepareStatement(this.m_ocmMMd.getEmToOcmQuery());
            oraclePreparedStatement.setRowPrefetch(100);
            if ("oracle_vm_guest".equals(this.m_harvesterTargetType) && this.m_ocmMMd.getName().equals("OVMVirtualComputer")) {
                if (this.checkAndgetHaltedVMQuery(connection)) {
                    oraclePreparedStatement = (OraclePreparedStatement)((OracleConnection)connection).prepareStatement("SELECT vm_pri_mac_addr, vm_memory, vm_num_cpus, vm_num_nics, vm_power_state \n        ,null, null, null,  null,  null,  null,  null,  null,  null,  null, null \n FROM mgmt_virt_vm_config c, mgmt_virt_vm_perf p  \n WHERE c.vm_uuid = substr(:vcid,  instr(:vcid, '_',1,2)+1) \n and c.vm_uuid=p.vm_uuid \n");
                    oraclePreparedStatement.setStringAtName("vcid", string2);
                } else {
                    oraclePreparedStatement.setStringAtName("vcid", string2);
                    oraclePreparedStatement.setStringAtName("tn", this.m_targetName);
                }
            } else {
                n = 1;
                oraclePreparedStatement.setString(n++, this.m_targetName);
                int n2 = this.m_ocmMMd.getEmToOcmQueryParamLayout();
                if (n2 == 1) {
                    oraclePreparedStatement.setString(n++, string);
                    oraclePreparedStatement.setString(n++, string2);
                } else if (n2 == 3) {
                    oraclePreparedStatement.setString(n++, string2);
                    oraclePreparedStatement.setString(n++, this.m_targetName);
                    oraclePreparedStatement.setString(n++, string2);
                    oraclePreparedStatement.setString(n++, this.m_targetName);
                    oraclePreparedStatement.setString(n++, string2);
                } else if (n2 != 5) {
                    if (n2 == 6) {
                        oraclePreparedStatement.setString(n++, string2);
                        oraclePreparedStatement.setString(n++, this.m_targetName);
                        oraclePreparedStatement.setString(n++, string2);
                    } else if (n2 == 8) {
                        oraclePreparedStatement.setString(n++, string2);
                        oraclePreparedStatement.setString(n++, string2);
                        oraclePreparedStatement.setString(n++, string2);
                    } else if (n2 == 7) {
                        oraclePreparedStatement.setString(n++, string2);
                        oraclePreparedStatement.setString(n++, this.m_targetName);
                        oraclePreparedStatement.setString(n++, string2);
                        oraclePreparedStatement.setString(n++, this.m_targetName);
                        oraclePreparedStatement.setString(n++, string2);
                        oraclePreparedStatement.setString(n++, this.m_targetName);
                        oraclePreparedStatement.setString(n++, string2);
                    } else {
                        oraclePreparedStatement.setString(n++, string2);
                    }
                }
            }
            n = this.m_ocmMMd.getOcmColumnCount();
            oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            ValueRow valueRow = null;
            if (null != oracleResultSet) {
                while (oracleResultSet.next()) {
                    valueRow = metricResult.addValueRow();
                    for (int i = 0; i < n; ++i) {
                        valueRow.setValue(i, oracleResultSet.getString(i + 1));
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                String string3 = "collect failed for  target / EM snapshot type / targetTypeOrHomePath / sql = " + this.m_targetName + " / " + string + " / " + string2 + " / " + this.m_ocmMMd.getEmToOcmQuery() + " :" + sQLException.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string3));
                throw new HarvesterException(string3, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(oraclePreparedStatement, oracleResultSet);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)oraclePreparedStatement, (ResultSet)oracleResultSet);
        return metricResult;
    }

    private void fixUpiColumnName(Connection connection) {
        String string = "NULL";
        String string2 = "SELECT 1 FROM user_tab_columns WHERE table_name = :tn AND column_name = :cn";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{"ECM$HIST_INV_PATCHES", "UPI"});
        ArrayList arrayList2 = null;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        nArray[0] = 2;
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)connection), (String)string2, (int[])new int[]{1, 1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
            if (null != arrayList2) {
                string = "UPI";
            }
        }
        catch (SQLException sQLException) {
            String string3 = "UPI column existence check failed; using NULL: " + sQLException.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string3));
        }
        catch (RepositoryOperationException repositoryOperationException) {
            String string4 = "UPI column existence check failed; using NULL: " + repositoryOperationException.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string4));
        }
        this.m_ocmMMd.setEmToOcmQuery(this.m_ocmMMd.getEmToOcmQuery().replaceAll("t1.upi-column-name-or-NULL", string));
    }

    boolean checkAndgetHaltedVMQuery(Connection connection) {
        ArrayList arrayList;
        block2: {
            ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>(1);
            String string = this.m_homePath;
            arrayList2.add(new Object[]{string, string});
            int[] nArray = new int[]{1, 1};
            arrayList = null;
            int[] nArray2 = new int[]{5};
            int[] nArray3 = new int[2];
            try {
                arrayList = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)connection), (String)"SELECT\tvm.server_pool_guid\n FROM mgmt_virt_vm_master vm, mgmt_virt_vm_perf perf, mgmt_virt_vm_op_status opstat\n WHERE vm.vm_uuid = perf.vm_uuid (+) \n AND vm.vm_uuid = opstat.vm_uuid (+) \n AND perf.virtual_server_guid is null \n AND vm.vm_uuid = substr(:vcid,  instr(:vcid, '_',1,2)+1) \n AND nvl(opstat.op_status_name,perf.vm_power_state) != 'OPERATION_ERROR'\n", (int[])nArray, arrayList2, (int[])nArray2, (int[])nArray3, (boolean)false);
            }
            catch (Exception exception) {
                if (!s_log.isDebugEnabled()) break block2;
                String string2 = "Getting Server Pool target guid failed for halted Guest VM target / type = " + this.m_targetName + " / " + this.m_harvesterTargetType + " : " + exception.getMessage();
                s_log.debug((Object)("GC OCM Harvester: " + string2));
            }
        }
        return null != arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

