/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import oracle.jdbc.OracleConnection;
import oracle.sql.RAW;
import oracle.sysman.ccr.gcharvester.GcCollectionInfo;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import oracle.sysman.eml.ecm.track.TrackUtilities;
import org.apache.log4j.Category;

class GcSnapshot {
    private Connection m_connection = null;
    private String m_targetName = null;
    private String m_targetType = null;
    private String m_snapshotType = null;
    private String m_homePath = null;
    private RAW m_snapshotGuid = null;
    private Timestamp m_startTimestamp = null;
    private boolean m_targetExists = true;
    private String m_emTargetTimezone = null;
    private boolean haltedGVM = false;
    private static ThreadLocal s_formatter = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static final Category s_log = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$GcSnapshot == null ? (class$oracle$sysman$ccr$gcharvester$GcSnapshot = GcSnapshot.class$("oracle.sysman.ccr.gcharvester.GcSnapshot")) : class$oracle$sysman$ccr$gcharvester$GcSnapshot).getName());
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$GcSnapshot;

    GcSnapshot(GcCollectionInfo gcCollectionInfo) throws HarvesterException {
        this.m_connection = gcCollectionInfo.getConnection();
        this.m_targetName = gcCollectionInfo.getTargetName();
        this.m_targetType = gcCollectionInfo.getTargetType();
        this.m_snapshotType = gcCollectionInfo.getSnapshotType();
        this.m_homePath = gcCollectionInfo.getHomePath();
        this.m_emTargetTimezone = gcCollectionInfo.getTargetTimezone();
        this.m_snapshotGuid = this.getCurrentSnapshotGuid();
        if (null == this.m_snapshotGuid) {
            this.m_targetExists = false;
            if (this.haltedGVM) {
                this.m_targetExists = true;
            }
        }
        if ("oracle_vm_server_pool".equals(this.m_targetType) && GCVersion.pre11_2GC() || "weblogic_domain".equals(this.m_targetType) || "weblogic_cluster".equals(this.m_targetType) || "oracle_ias_farm".equals(this.m_targetType) || "j2ee_application".equals(this.m_targetType)) {
            this.m_targetExists = true;
        }
    }

    boolean snapshotChanged() throws HarvesterException {
        boolean bl = false;
        RAW rAW = this.getCurrentSnapshotGuid();
        if (null == rAW) {
            this.m_targetExists = false;
            bl = true;
            if ("weblogic_domain".equals(this.m_targetType) || "weblogic_cluster".equals(this.m_targetType) || "oracle_ias_farm".equals(this.m_targetType) || "j2ee_application".equals(this.m_targetType)) {
                bl = false;
                this.m_targetExists = true;
            }
            if ("oracle_vm_server_pool".equals(this.m_targetType) && GCVersion.pre11_2GC()) {
                bl = false;
                this.m_targetExists = true;
            }
            if (this.haltedGVM) {
                bl = false;
                this.m_targetExists = true;
            }
        } else {
            boolean bl2 = bl = !this.m_snapshotGuid.equals((Object)rAW);
            if (bl) {
                this.m_snapshotGuid = rAW;
            }
        }
        return bl;
    }

    boolean targetExists(boolean bl) throws HarvesterException {
        boolean bl2 = this.m_targetExists;
        if (bl2 && bl) {
            String string = "SELECT 1 FROM mgmt_ecm_snapshot s, mgmt_inv_container c WHERE s.snapshot_guid = :sg AND s.is_current = 'Y' AND c.snapshot_guid = s.snapshot_guid AND c.container_location = :hp";
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
            arrayList.add(new Object[]{this.m_snapshotGuid, this.m_homePath});
            ArrayList arrayList2 = null;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            nArray[0] = 2;
            try {
                arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)string, (int[])new int[]{5, 1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
                if (null == arrayList2) {
                    bl2 = false;
                }
            }
            catch (Exception exception) {
                String string2 = "Home existence check failed for target / type / path = " + this.m_targetName + " / " + this.m_targetType + " / " + this.m_homePath + " : " + exception.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string2));
                throw new HarvesterException(string2, exception);
            }
        }
        if ("oracle_vm_server_pool".equals(this.m_targetType) && GCVersion.pre11_2GC()) {
            bl2 = true;
        }
        if (this.haltedGVM) {
            bl2 = true;
        }
        return bl2;
    }

    Timestamp getStartTimestamp() {
        return this.m_startTimestamp;
    }

    private RAW getCurrentSnapshotGuid() throws HarvesterException {
        String string;
        Object[] objectArray;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        RAW rAW = null;
        string5 = ("host".equals(this.m_targetType) || "oracle_home".equals(this.m_targetType)) && GCVersion.pre11_2GC() ? "mgmt_ecm_snapshot" : "mgmt_ecm_gen_snapshot";
        string2 = "SELECT snapshot_guid, (TO_CHAR(   NVL(FROM_TZ(CAST(s.start_timestamp AS TIMESTAMP), dbtimezone)        AT TIME ZONE '";
        string3 = "',         s.start_timestamp),    'YYYY-MM-DD HH24:MI:SS'))    FROM " + string5 + " s" + "  WHERE s.is_current = 'Y'" + "  AND s.target_type    = :tt " + "  AND s.snapshot_type  = :st";
        string4 = "oracle_vm_guest".equals(this.m_targetType) && GCVersion.pre11_2GC() ? "  AND s.target_name    = ( select P_VS_TARGET_NAME from mgmt_ovm_gvm_summary where VM_UUID = :tn )" : "  AND s.target_name    = :tn";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        String string6 = this.m_targetType;
        String string7 = this.m_snapshotType;
        String string8 = this.m_targetName;
        if ("oracle_home".equals(this.m_targetType) && GCVersion.pre11_2GC()) {
            string6 = "host";
            string7 = "host_configuration";
        }
        if ("oracle_vm_guest".equals(this.m_targetType) && GCVersion.pre11_2GC()) {
            string6 = "oracle_vm_server";
            objectArray = this.m_homePath.split("_");
            string8 = objectArray[2];
        }
        if ("oracle_vm_server_host".equals(this.m_targetType)) {
            string6 = "oracle_vm_server";
        }
        arrayList.add(new Object[]{string6, string7, string8});
        objectArray = new int[]{1, 1, 1};
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{5, 1};
        nArray[0] = 5;
        int[] nArray2 = new int[2];
        nArray2[0] = 16;
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)(string2 + this.m_emTargetTimezone + string3 + string4), (int[])objectArray, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Exception exception) {
            if (s_log.isDebugEnabled()) {
                string = "First get of current snapshot guid failed for target / type = " + this.m_targetName + " / " + this.m_targetType + " : " + exception.getMessage();
                s_log.debug((Object)("GC OCM Harvester: " + string));
            }
            try {
                arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)(string2 + "GMT" + string3), (int[])objectArray, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
            }
            catch (Exception exception2) {
                String string9 = "Getting  current snapshot failed for target / type = " + this.m_targetName + " / " + this.m_targetType + " : " + exception2.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string9));
                throw new HarvesterException(string9, exception2);
            }
        }
        if (null != arrayList2) {
            try {
                Object[] objectArray2 = (Object[])arrayList2.get(0);
                rAW = (RAW)objectArray2[0];
                this.m_startTimestamp = new Timestamp(((SimpleDateFormat)s_formatter.get()).parse((String)objectArray2[1]).getTime());
            }
            catch (Exception exception) {
                string = "Getting snapshot start_timestamp failed for target / type = " + this.m_targetName + " / " + this.m_targetType + " : " + exception.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string));
                throw new HarvesterException(string, exception);
            }
        }
        if ("oracle_vm_guest".equals(this.m_targetType) && GCVersion.pre11_2GC()) {
            ArrayList arrayList3;
            block15: {
                ArrayList<Object[]> arrayList4 = new ArrayList<Object[]>(1);
                string = this.m_homePath;
                arrayList4.add(new Object[]{string, string});
                int[] nArray3 = new int[]{1, 1};
                arrayList3 = null;
                int[] nArray4 = new int[]{5};
                int[] nArray5 = new int[2];
                try {
                    arrayList3 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)this.m_connection), (String)"SELECT\tvm.server_pool_guid\n FROM mgmt_virt_vm_master vm, mgmt_virt_vm_perf perf, mgmt_virt_vm_op_status opstat\n WHERE vm.vm_uuid = perf.vm_uuid (+) \n AND vm.vm_uuid = opstat.vm_uuid (+) \n AND perf.virtual_server_guid is null \n AND vm.vm_uuid = substr(:vcid,  instr(:vcid, '_',1,2)+1) \n AND nvl(opstat.op_status_name,perf.vm_power_state) != 'OPERATION_ERROR'\n", (int[])nArray3, arrayList4, (int[])nArray4, (int[])nArray5, (boolean)false);
                }
                catch (Exception exception) {
                    if (!s_log.isDebugEnabled()) break block15;
                    String string10 = "Getting Server Pool target guid failed for halted Guest VM target / type = " + this.m_targetName + " / " + this.m_targetType + " : " + exception.getMessage();
                    s_log.debug((Object)("GC OCM Harvester: " + string10));
                }
            }
            if (null != arrayList3) {
                this.haltedGVM = true;
            }
        }
        return rAW;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

