/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.network.httplog.HTTPThreadLogger;
import oracle.sysman.ccr.gcharvester.GCConfigureCCR;
import oracle.sysman.ccr.gcharvester.GCConfigureCCRException;
import oracle.sysman.ccr.gcharvester.GCInit;
import oracle.sysman.ccr.gcharvester.GcCollectionInfo;
import oracle.sysman.ccr.gcharvester.GcCollectionMgr;
import oracle.sysman.ccr.gcharvester.HarvesterEMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterMetadata;
import oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterSnapshotMD;
import oracle.sysman.ccr.gcharvester.IgnoreTargetException;
import oracle.sysman.ccr.gcharvester.perf.GCHarvesterPerf;
import oracle.sysman.ccr.gcharvester.registration.RegistrationUtil;
import oracle.sysman.ccr.gcharvester.targettype.TargetMetadataUtil;
import oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergenceUtil;
import oracle.sysman.ccr.gcharvester.ti.common.TargetCacheManager;
import oracle.sysman.ccr.gcharvester.upload.GCUploadManager;
import oracle.sysman.ccr.gcharvester.upload.GCUploader;
import oracle.sysman.ccr.gcharvester.upload.UploadCallBack;
import oracle.sysman.ccr.gcharvester.util.GCHarvesterEnv;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.ccr.gcharvester.util.OCMConfigureUtil;
import oracle.sysman.ccr.scheduler.Scheduler;
import oracle.sysman.eml.ecm.track.TrackUtilities;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class HarvesterJobUtils {
    private static final Category s_log = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$HarvesterJobUtils == null ? (class$oracle$sysman$ccr$gcharvester$HarvesterJobUtils = HarvesterJobUtils.class$("oracle.sysman.ccr.gcharvester.HarvesterJobUtils")) : class$oracle$sysman$ccr$gcharvester$HarvesterJobUtils).getName());
    private static final String RESYNC_SEQ_NUM_PROP_NAME = "resync_seq_num";
    static final String CHANGES_TS_PROP_NAME = "changes_ts";
    static final String LAST_FULL_RESYNC_TS = "last_full_resync_ts_gmt";
    static final String TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss z";
    private static ThreadLocal s_formatter = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new SimpleDateFormat(HarvesterJobUtils.TIMESTAMP_PATTERN);
        }
    };
    private static final int NUM_OF_TARGET_IN_BATCH = 256;
    private static final int NUM_OF_TGT_EXCEPTIONS_TO_IGNORE = 10;
    private static final int MSG_PREFIX_LENGTH = 15;
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$HarvesterJobUtils;

    private static Timestamp convertStringToTS(String string, String string2) throws HarvesterException {
        if (string == null || string.length() == 0) {
            return null;
        }
        Timestamp timestamp = null;
        try {
            timestamp = new Timestamp(((SimpleDateFormat)s_formatter.get()).parse(string).getTime());
        }
        catch (ParseException parseException) {
            String string3 = "Internal Error: failed to parse timestamp \"" + string + "\" " + (string2 == null ? "" : string2) + ": " + parseException.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string3));
            throw new HarvesterException(string3);
        }
        return timestamp;
    }

    private static Object getProperty(OracleConnection oracleConnection, String string, int n, boolean bl) throws HarvesterException {
        ArrayList arrayList;
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>(1);
        arrayList2.add(new Object[]{string});
        String string2 = null;
        switch (n) {
            case 2: {
                string2 = "SELECT num_value FROM mgmt_ocm_upl_props WHERE NAME = ?";
                break;
            }
            case 4: {
                string2 = "SELECT ts_value FROM mgmt_ocm_upl_props WHERE NAME = ?";
                break;
            }
            case 1: {
                string2 = "SELECT str_value FROM mgmt_ocm_upl_props WHERE NAME = ?";
                break;
            }
            default: {
                String string3 = "Internal Error: Unsupported type of OCM upload property: " + n;
                s_log.error((Object)("GC OCM Harvester: " + string3));
                throw new HarvesterException(string3);
            }
        }
        try {
            arrayList = TrackUtilities.executePreparedStatement((OracleConnection)oracleConnection, (String)string2, (int[])new int[]{1}, arrayList2, (int[])new int[]{n}, (int[])new int[]{0}, (boolean)false);
        }
        catch (Exception exception) {
            String string4 = "Failed to get OCM upload property " + string + " from EM repository: " + exception.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string4));
            throw new HarvesterException(string4, exception);
        }
        if (bl && (arrayList == null || arrayList.isEmpty())) {
            String string5 = "Failed to get OCM upload property from EM repository: property " + string + " is not found.";
            s_log.error((Object)("GC OCM Harvester: " + string5));
            throw new HarvesterException(string5);
        }
        return arrayList == null || arrayList.isEmpty() ? null : ((Object[])arrayList.get(0))[0];
    }

    private static int getResyncNumberFromRepository(OracleConnection oracleConnection) throws HarvesterException {
        return (Integer)HarvesterJobUtils.getProperty(oracleConnection, RESYNC_SEQ_NUM_PROP_NAME, 2, true);
    }

    private static String[] getChangesTSFromRepository(OracleConnection oracleConnection) throws HarvesterException {
        ArrayList arrayList;
        try {
            arrayList = TrackUtilities.executePreparedStatement((OracleConnection)oracleConnection, (String)"  SELECT \n    (SELECT CASE WHEN ts_value IS NULL THEN NULL ELSE 'a' END\n       FROM mgmt_ocm_upl_props\n      WHERE NAME = 'changes_ts') s1,\n    (SELECT CASE WHEN ts_value IS NULL THEN NULL ELSE\n              to_char(ts_value, 'YYYY-MM-DD HH24:MI:SS') || ' GMT' \n            END\n       FROM mgmt_ocm_upl_props\n      WHERE NAME = 'last_full_resync_ts_gmt') s2 \n    FROM DUAL\n", null, null, (int[])new int[]{1, 1}, (int[])new int[]{1, 100}, (boolean)false);
        }
        catch (Exception exception) {
            String string = "Failed to get last OCM collection timestamps from repository: " + exception.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string));
            throw new HarvesterException(string, exception);
        }
        if (arrayList == null || arrayList.isEmpty()) {
            String string = "Failed to get last OCM collection timestamps from repository: empty set of results returned.";
            s_log.error((Object)("GC OCM Harvester: " + string));
            throw new HarvesterException(string);
        }
        String[] stringArray = new String[]{((Object[])arrayList.get(0))[0] == null ? null : "a", (String)((Object[])arrayList.get(0))[1]};
        return stringArray;
    }

    private static void initHTTPLog() {
        Config config = UplinkHomeConfig.getInstance();
        String string = config.getProperty("httpclient.log.enable");
        HTTPThreadLogger.stopLogger();
        if ("true".equals(string)) {
            String string2 = System.getProperty("INSTANCE_HOME") + File.separator + "sysman" + File.separator + "log";
            HTTPThreadLogger.init(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int performOCMCollections(OracleConnection oracleConnection, ServletContext servletContext) throws HarvesterException {
        block23: {
            int n;
            block22: {
                String[] stringArray;
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"*************************************************************************************************");
                    s_log.debug((Object)"Harvester Metadata Version: Major 8 Minor 0");
                    s_log.debug((Object)"**************************************************************************************************");
                }
                GcCollectionMgr gcCollectionMgr = new GcCollectionMgr();
                GCHarvesterEnv.init((Connection)oracleConnection);
                GCUploadManager.getGCUploaderInstance().cleanCollectionData();
                TargetCacheManager.init();
                HarvesterJobUtils.initHTTPLog();
                if (OCMConfigureUtil.ocmInUnauthMode() && !Scheduler.isStopped()) {
                    try {
                        stringArray = GCConfigureCCR.getEMMetalinkCredentials((Connection)oracleConnection);
                        if (stringArray != null) {
                            GCConfigureCCR.configCCR((Connection)oracleConnection, true, stringArray);
                        }
                    }
                    catch (GCConfigureCCRException gCConfigureCCRException) {
                        s_log.error((Object)("GC OCM Harvester: Error while configuring CCR to authenticated mode using credentials from EM Repository:  " + gCConfigureCCRException.getMessage()));
                    }
                }
                if (Collector.isDisconnected()) {
                    try {
                        s_log.info((Object)"GC OCM Harvester: OCM is in disconnected mode. Trying to Configure it...");
                        GCConfigureCCR.configCCR((Connection)oracleConnection);
                        s_log.info((Object)"GC OCM Harvester: CCR configured to connected mode.");
                    }
                    catch (GCConfigureCCRException gCConfigureCCRException) {
                        s_log.error((Object)("GC OCM Harvester: Error while configuring CCR: " + gCConfigureCCRException.getMessage()));
                        return 2;
                    }
                }
                if (Scheduler.isStopped()) {
                    stringArray = "OCM was stopped and is not running";
                    s_log.warn((Object)("GC OCM Harvester: " + (String)stringArray));
                    return 3;
                }
                GCHarvesterPerf.startPerf("perf_metadata");
                try {
                    int n2 = HarvesterMetadata.compareVersionVsRepository(oracleConnection);
                    switch (n2) {
                        case 0: {
                            break;
                        }
                        case -1: {
                            break;
                        }
                        case -2: {
                            n = 1;
                            Object var6_9 = null;
                            GCUploadManager.getGCUploaderInstance().ensureUploadIsComplete();
                            break block22;
                        }
                        case 100: {
                            HarvesterMetadata.getInstance(oracleConnection).populateRepository(oracleConnection);
                            break;
                        }
                        case 1: 
                        case 2: {
                            HarvesterMetadata.getInstance(oracleConnection).populateRepository(oracleConnection);
                            HarvesterMetadata.getInstance(oracleConnection).populateNewTargetsInRepository(oracleConnection);
                            break;
                        }
                        default: {
                            throw new HarvesterException("Unknown metadata version comparison result.");
                        }
                    }
                    GCHarvesterPerf.endPerf("perf_metadata");
                    GCHarvesterPerf.startPerf("perf_regn");
                    if (!GCVersion.pre11_2GC()) {
                        if (!GCHarvesterEnv.disableCSIAssign()) {
                            RegistrationUtil.processGCDefaultRegistration((Connection)oracleConnection, servletContext);
                            RegistrationUtil.processPendingRegistrations((Connection)oracleConnection);
                        }
                        ConvergenceUtil.processPendingConvergedTargetTypes((Connection)oracleConnection);
                    }
                    GCHarvesterPerf.endPerf("perf_regn");
                    GCHarvesterPerf.startPerf("perf_stage");
                    boolean bl = HarvesterJobUtils.initOrResyncIfNeeded(oracleConnection);
                    if (bl) {
                        HarvesterJobUtils.performHistoryBasedUpdates(oracleConnection);
                        HarvesterJobUtils.performPeriodicCollectionUpdates(oracleConnection);
                    } else {
                        GCHarvesterPerf.setFullCollection();
                    }
                    GCHarvesterPerf.endPerf("perf_stage");
                    GCHarvesterPerf.startPerf("perf_coll_upl");
                    HarvesterJobUtils.generateDataFiles(oracleConnection, gcCollectionMgr);
                    GCHarvesterPerf.endPerf("perf_coll_upl");
                    break block23;
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    GCUploadManager.getGCUploaderInstance().ensureUploadIsComplete();
                    HarvesterUtil.releaseNetworkConnection();
                    TargetMetadataUtil.cleanup();
                    TargetCacheManager.destroy();
                    HarvesterJobUtils.connectionCleanup(oracleConnection);
                    throw throwable;
                }
            }
            HarvesterUtil.releaseNetworkConnection();
            TargetMetadataUtil.cleanup();
            TargetCacheManager.destroy();
            HarvesterJobUtils.connectionCleanup(oracleConnection);
            return n;
        }
        Object var6_10 = null;
        GCUploadManager.getGCUploaderInstance().ensureUploadIsComplete();
        HarvesterUtil.releaseNetworkConnection();
        TargetMetadataUtil.cleanup();
        TargetCacheManager.destroy();
        HarvesterJobUtils.connectionCleanup(oracleConnection);
        return 0;
    }

    private static boolean initOrResyncIfNeeded(OracleConnection oracleConnection) throws HarvesterException {
        boolean bl;
        Timestamp timestamp;
        String[] stringArray = HarvesterJobUtils.getChangesTSFromRepository(oracleConnection);
        boolean bl2 = stringArray[0] == null || stringArray[1] == null;
        String string = GCInit.fullCollectionDate();
        if (string != null && stringArray[1] != null) {
            timestamp = HarvesterJobUtils.convertStringToTS(string, "from OMS resync file");
            Timestamp timestamp2 = HarvesterJobUtils.convertStringToTS(stringArray[1], "from repository resync parameter");
            boolean bl3 = bl2 = bl2 || timestamp.after(timestamp2);
        }
        if (bl2) {
            timestamp = null;
            try {
                timestamp = (OracleCallableStatement)oracleConnection.prepareCall(HarvesterJobUtils.getQuery("RESYNC_CODE"));
                timestamp.execute();
            }
            catch (SQLException sQLException) {
                String string2 = "Failed to [re]initialize repository for OCM uploads: " + sQLException.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string2));
                try {
                    ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
                    arrayList.add(new Object[]{CHANGES_TS_PROP_NAME});
                    TrackUtilities.executePreparedStatement((OracleConnection)oracleConnection, (String)"DELETE FROM mgmt_ocm_upl_props WHERE NAME = ?", (int[])new int[]{1}, arrayList, null, null, (boolean)true);
                    oracleConnection.commit();
                }
                catch (Exception exception) {
                    s_log.error((Object)("GC OCM Harvester: Failed to delete changes_ts property when recovering from an error during resync: " + exception.getMessage()));
                }
                throw new HarvesterException(string2, sQLException);
            }
            finally {
                JDBCUtil.close((Statement)((Object)timestamp));
            }
            bl = false;
        } else {
            bl = true;
        }
        if (string != null) {
            GCInit.deleteFullCollFile();
        }
        return bl;
    }

    private static void performHistoryBasedUpdates(OracleConnection oracleConnection) throws HarvesterException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall(HarvesterJobUtils.getQuery("HISTORY_POPULATE_CODE"));
            oracleCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                String string = "Failed to populate OCM metrics based on ECM history: " + sQLException.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string));
                throw new HarvesterException(string, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(oracleCallableStatement);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)oracleCallableStatement);
    }

    private static void prepareTargetsForShipment(OracleConnection oracleConnection) throws HarvesterException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("BEGIN\n  EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_metrics_tmp';\n\n  BEGIN\n    EXECUTE IMMEDIATE 'DROP SEQUENCE mgmt_ocm_upl_seq';\n  EXCEPTION WHEN OTHERS THEN NULL; -- ignore if it did not exist\n  END;\n\n  EXECUTE IMMEDIATE 'CREATE SEQUENCE mgmt_ocm_upl_seq INCREMENT BY 1 START WITH 1 \n    MAXVALUE 1.0E28 MINVALUE 1 CYCLE NOORDER';\n\n  EXECUTE IMMEDIATE\n  'INSERT INTO mgmt_ocm_upl_metrics_tmp (target_name, target_type, idx)\n   SELECT target_name, target_type, mgmt_ocm_upl_seq.nextval\n     FROM (SELECT DISTINCT target_name, target_type \n             FROM mgmt_ocm_upl_metrics\n            ORDER BY target_name, target_type)';\n\n  COMMIT;\n\nEND;\n");
            oracleCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                String string = "Failed to stage targets for shipment to Oracle: " + sQLException.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string));
                throw new HarvesterException(string, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(oracleCallableStatement);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)oracleCallableStatement);
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall(HarvesterJobUtils.getQuery("FIXUP_METRICS_SQL"));
            oracleCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            String string = "Failed to fix up metrics tracking table: " + sQLException.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string));
            throw new HarvesterException(string, sQLException);
        }
        finally {
            JDBCUtil.close((Statement)oracleCallableStatement);
        }
    }

    private static void generateDataFiles(OracleConnection oracleConnection, GcCollectionMgr gcCollectionMgr) throws HarvesterException {
        HarvesterJobUtils.prepareTargetsForShipment(oracleConnection);
        int n = HarvesterJobUtils.getMaxStagingIndex(oracleConnection);
        String string = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = n4 + 256;
        while (n4 <= n) {
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
            arrayList.add(new Object[]{new Integer(n4), new Integer(n5)});
            ArrayList arrayList2 = HarvesterJobUtils.getTargetsBatch(oracleConnection, n4, n5);
            if (arrayList2 != null && !arrayList2.isEmpty()) {
                HarvesterMetadata harvesterMetadata = HarvesterMetadata.getInstance(oracleConnection);
                int n6 = arrayList2.size();
                for (int i = 0; i < n6; ++i) {
                    String string2;
                    int n7 = 0;
                    Object[] objectArray = (Object[])arrayList2.get(i);
                    String string3 = (String)objectArray[n7++];
                    String string4 = (String)objectArray[n7++];
                    String string5 = (String)objectArray[n7++];
                    String string6 = (String)objectArray[n7++];
                    String string7 = (String)objectArray[n7++];
                    String string8 = (String)objectArray[n7++];
                    String string9 = (String)objectArray[n7++];
                    try {
                        GCHarvesterPerf.incrementPerf("perf_tg_total", 1L);
                        HarvesterJobUtils.generateDataFilesForEMTarget(gcCollectionMgr, oracleConnection, string3, string4, string5, string6, string7, string8, harvesterMetadata, string9);
                        TargetCacheManager.cleanCache(string3, string4);
                        GCHarvesterPerf.incrementPerf("perf_tg_suc", 1L);
                        n2 = 0;
                        continue;
                    }
                    catch (IgnoreTargetException ignoreTargetException) {
                        GCHarvesterPerf.incrementPerf("perf_tg_ignore", 1L);
                        if (!s_log.isDebugEnabled()) continue;
                        string2 = ignoreTargetException.getMessage();
                        s_log.debug((Object)("GC OCM Harvester: " + string2));
                        continue;
                    }
                    catch (HarvesterException harvesterException) {
                        String string10;
                        string2 = harvesterException.getMessage();
                        s_log.error((Object)("GC OCM Harvester: Error while processing targetname,target_type: " + string3 + ", " + string4 + ": " + string2));
                        if (null != string2 && string2.startsWith("Could not determine OCM target name")) {
                            if (n3++ >= 10) continue;
                            s_log.error((Object)("GC OCM Harvester: " + string2));
                            continue;
                        }
                        String string11 = string10 = string2 == null ? null : string2.substring(0, 15);
                        if (string10 == null && string == null || string10 != null && string10.equals(string)) {
                            ++n2;
                        } else {
                            n2 = 1;
                            string = string10;
                        }
                        if (n2 < 10) continue;
                        if (GCHarvesterEnv.ignoreErrors()) {
                            s_log.warn((Object)"GC OCM Harvester: Harvester Job has more than 10 consecutive harvester errors. Harvester will still try to harvest as many as target as possible. Please look for Harvester errors in logs to get more details.");
                            continue;
                        }
                        s_log.error((Object)"GC OCM Harvester: Exiting Harvester Job as no. of harvester errors exceeded maximum limit.");
                        if (s_log.isDebugEnabled()) {
                            String string12 = harvesterException.getMessage();
                            s_log.debug((Object)("GC OCM Harvester: " + string12));
                        }
                        throw harvesterException;
                    }
                    catch (Throwable throwable) {
                        string2 = throwable.getMessage();
                        s_log.error((Object)("GC OCM Harvester: Error while processing targetname,target_type: " + string3 + ", " + string4 + ": " + string2));
                        if (!s_log.isDebugEnabled()) continue;
                        s_log.debug((Object)("GC OCM Harvester: " + string2), throwable);
                    }
                }
            }
            n4 += 256;
            n5 += 256;
        }
        if (n3 >= 10) {
            s_log.error((Object)("GC OCM Harvester: Could not determine OCM target name for a total of " + n3 + " targets"));
        }
    }

    private static void generateDataFilesForEMTarget(GcCollectionMgr gcCollectionMgr, OracleConnection oracleConnection, String string, String string2, String string3, String string4, String string5, String string6, HarvesterMetadata harvesterMetadata, String string7) throws HarvesterException {
        ArrayList arrayList = HarvesterJobUtils.getMetricsForTarget(oracleConnection, string, string2);
        if (arrayList == null) {
            String string8 = "Failed to get any metrics from OCM tracking table for target " + string + " of type " + string2 + " even though the target is in the staging table: " + "target was most likely removed";
            s_log.debug((Object)("GC OCM Harvester: " + string8));
            GCHarvesterPerf.incrementPerf("perf_tg_suc", -1L);
            GCHarvesterPerf.incrementPerf("perf_tg_ignore", 1L);
            return;
        }
        int n = arrayList.size();
        boolean bl = true;
        boolean bl2 = false;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        HarvesterSnapshotMD harvesterSnapshotMD = null;
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < n; ++i) {
            boolean bl3 = false;
            boolean bl4 = false;
            Object[] objectArray = (Object[])arrayList.get(i);
            string13 = (String)objectArray[0];
            string15 = (String)objectArray[3];
            if (!bl2) {
                string11 = (String)objectArray[1];
            }
            String string17 = (String)objectArray[2];
            bl3 = string11.equals("OCheck");
            boolean bl5 = bl4 = string11.equals("oracle_db_adrinfo") && "MGMT_ECM_ADR_INFO".equals(string17);
            if (string17 != null) {
                bl = true;
            }
            if (i == 0 || string14 == null && string13 != null || string14 != null && !string14.equals(string13) || !string12.equals(string11)) {
                if (bl3 && string17 == null) {
                    bl = false;
                }
                if (i > 0) {
                    if ("oracle_vm_guest".equals(string2) && GCVersion.pre11_2GC() || "weblogic_domain".equals(string2) || "weblogic_cluster".equals(string2) || "oracle_ias_farm".equals(string2) || "j2ee_application".equals(string2)) {
                        string6 = string14;
                    }
                    if (bl) {
                        HarvesterJobUtils.generateDataFile(gcCollectionMgr, oracleConnection, string, string2, string12, string9, string10, bl2 ? string14 : string6, bl2 ? string16 : null, string3, string4, string5, arrayList2, string7);
                    }
                }
                arrayList2 = new ArrayList();
                boolean bl6 = bl2 = string13 != null && !"oracle_vm_guest".equals(string2) && !"weblogic_domain".equals(string2) && !"weblogic_cluster".equals(string2) && !"oracle_ias_farm".equals(string2) && !"j2ee_application".equals(string2);
                if (bl2) {
                    string2 = "oracle_home";
                    string11 = "oracle_home_config";
                }
                if (bl3 || bl4) {
                    string9 = string2;
                    string10 = string11;
                } else {
                    harvesterSnapshotMD = harvesterMetadata.getSnapshotMD(string2, string11);
                    if (harvesterSnapshotMD == null) {
                        throw new HarvesterException("Unrecognized snapshot type " + string11 + " for target type " + string2);
                    }
                    string9 = harvesterSnapshotMD.getOCMTargetType();
                    string10 = harvesterSnapshotMD.getOCMSnapshotType();
                }
                string14 = string13;
                string16 = string15;
                string12 = string11;
            }
            if (bl3 || bl4) continue;
            HarvesterJobUtils.addOCMMetricsToList(harvesterSnapshotMD, string2, string11, string17, arrayList2);
        }
        if ("oracle_vm_guest".equals(string2) && GCVersion.pre11_2GC() || "weblogic_domain".equals(string2) || "weblogic_cluster".equals(string2) || "oracle_ias_farm".equals(string2) || "j2ee_application".equals(string2)) {
            string6 = string13;
        }
        if (bl) {
            HarvesterJobUtils.generateDataFile(gcCollectionMgr, oracleConnection, string, string2, string11, string9, string10, bl2 ? string13 : string6, bl2 ? string15 : null, string3, string4, string5, arrayList2, string7);
        }
    }

    private static void generateDataFile(GcCollectionMgr gcCollectionMgr, OracleConnection oracleConnection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, ArrayList arrayList, String string11) throws HarvesterException {
        GcCollectionInfo gcCollectionInfo = new GcCollectionInfo((Connection)oracleConnection, string, string8, string11, string2, string3, string10, string9, string6, string7, string4, string5, arrayList);
        GCUploader gCUploader = GCUploadManager.getGCUploaderInstance();
        UploadCallBack uploadCallBack = new UploadCallBack(string, string2, string6, string3, !arrayList.isEmpty(), oracleConnection);
        int n = gcCollectionMgr.collectAndPersistGcMetrics(gcCollectionInfo, gCUploader, uploadCallBack, (Connection)oracleConnection);
    }

    private static ArrayList getTargetsBatch(OracleConnection oracleConnection, int n, int n2) throws HarvesterException {
        ArrayList arrayList;
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>(1);
        arrayList2.add(new Object[]{new Integer(n), new Integer(n2)});
        try {
            arrayList = TrackUtilities.executePreparedStatement((OracleConnection)oracleConnection, (String)HarvesterJobUtils.getQuery("GET_TARGET_BATCH"), (int[])new int[]{2, 2}, arrayList2, (int[])new int[]{1, 1, 1, 1, 1, 1, 1}, (int[])new int[]{256, 64, 256, 256, 64, 1024, 256}, (boolean)false);
        }
        catch (Exception exception) {
            String string = "Failed to get a batch of targets to process: " + exception.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string));
            throw new HarvesterException(string, exception);
        }
        return arrayList;
    }

    private static int getMaxStagingIndex(OracleConnection oracleConnection) throws HarvesterException {
        ArrayList arrayList;
        try {
            arrayList = TrackUtilities.executePreparedStatement((OracleConnection)oracleConnection, (String)"SELECT max(idx) FROM mgmt_ocm_upl_metrics_tmp", null, null, (int[])new int[]{2}, (int[])new int[]{0}, (boolean)false);
        }
        catch (Exception exception) {
            String string = "Failed to get maximum staging index: " + exception.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string));
            throw new HarvesterException(string, exception);
        }
        if (arrayList == null || arrayList.isEmpty()) {
            String string = "Failed to get maximum staging index: is the staging table empty?";
            s_log.error((Object)("GC OCM Harvester: " + string));
            throw new HarvesterException(string);
        }
        Object object = ((Object[])arrayList.get(0))[0];
        return object == null ? -1 : (Integer)((Object[])arrayList.get(0))[0];
    }

    private static ArrayList getMetricsForTarget(OracleConnection oracleConnection, String string, String string2) throws HarvesterException {
        ArrayList arrayList;
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>(1);
        arrayList2.add(new Object[]{string2, string});
        try {
            arrayList = TrackUtilities.executePreparedStatement((OracleConnection)oracleConnection, (String)"  SELECT DISTINCT um.addl_target_info, um.snapshot_type, \n         CASE WHEN um.is_changed = 1 THEN um.table_name\n              ELSE NULL END AS table_name,\n         (SELECT (\n            CASE \n              WHEN INSTR(NLS_UPPER(t2.category_prop_1), 'WINDOWS') != 0 THEN\n                NLS_LOWER(um.addl_target_info)\n              ELSE NULL\n            END)\n          FROM mgmt_targets t2\n          WHERE t2.target_name = um.target_name\n          AND t2.target_type = 'host') addl_target_info_lower\n    FROM mgmt_ocm_upl_metrics um\n   WHERE um.target_type = ?\n     AND um.target_name = ?  \n     AND um.snapshot_type <> 'internal_props' \n   ORDER BY um.addl_target_info NULLS FIRST, um.snapshot_type,\n            table_name DESC NULLS FIRST \n", (int[])new int[]{1, 1}, arrayList2, (int[])new int[]{1, 1, 1, 1}, (int[])new int[]{128, 64, 30, 128}, (boolean)false);
        }
        catch (Exception exception) {
            String string3 = "Failed to get changed metrics and unchanged snapshots for target " + string + " of type " + string2 + ": " + exception.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string3));
            throw new HarvesterException(string3, exception);
        }
        return arrayList;
    }

    private static void addOCMMetricsToList(HarvesterSnapshotMD harvesterSnapshotMD, String string, String string2, String string3, ArrayList arrayList) throws HarvesterException {
        if (string3 == null) {
            return;
        }
        HarvesterEMMetricMD harvesterEMMetricMD = harvesterSnapshotMD.getEMMetricMD(string3);
        if (harvesterEMMetricMD == null) {
            throw new HarvesterException("Unrecognized metric " + string3 + " in snapshot type " + string2 + " for target type " + string);
        }
        HarvesterOCMMetricMD[] harvesterOCMMetricMDArray = harvesterEMMetricMD.getOCMMetrics();
        if (harvesterOCMMetricMDArray != null) {
            for (int i = 0; i < harvesterOCMMetricMDArray.length; ++i) {
                arrayList.add(harvesterOCMMetricMDArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performPeriodicCollectionUpdates(OracleConnection oracleConnection) {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("DECLARE \n  l_cur_date DATE := sysdate;\n\n  -- selects metrics to be updated \n  CURSOR full_update_metrics IS\n    SELECT target_type, snapshot_type, table_name\n      FROM mgmt_ocm_upl_periodic_full f\n     WHERE f.last_update IS NULL\n        OR f.last_update + f.period < l_cur_date;\nBEGIN\n\n  FOR f IN full_update_metrics LOOP\n    BEGIN \n      UPDATE mgmt_ocm_upl_metrics m\n         SET m.is_changed = 1\n       WHERE m.target_type = f.target_type\n         AND m.snapshot_type = f.snapshot_type\n         AND m.table_name = f.table_name;\n\n      UPDATE mgmt_ocm_upl_periodic_full pf \n         SET pf.last_update = l_cur_date\n       WHERE pf.target_type = f.target_type\n         AND pf.snapshot_type = f.snapshot_type\n         AND pf.table_name = f.table_name; \n\n      COMMIT;\n\n    EXCEPTION WHEN OTHERS THEN\n\n      -- perform update in chunks\n      DECLARE\n        l_num NUMBER;\n      BEGIN\n\n        LOOP\n          UPDATE mgmt_ocm_upl_metrics m\n           SET m.is_changed = 1\n         WHERE m.is_changed = 0\n           AND m.target_type = f.target_type\n           AND m.snapshot_type = f.snapshot_type\n           AND m.table_name = f.table_name\n           AND ROWNUM <= MGMT_GLOBAL.MAX_COMMIT; \n\n          l_num := SQL%ROWCOUNT;\n\n          COMMIT;\n\n          EXIT WHEN l_num < MGMT_GLOBAL.MAX_COMMIT;\n        END LOOP; \n\n        UPDATE mgmt_ocm_upl_periodic_full pf\n           SET pf.last_update = l_cur_date\n         WHERE pf.target_type = f.target_type\n           AND pf.snapshot_type = f.snapshot_type\n           AND pf.table_name = f.table_name;\n\n        COMMIT;\n\n      EXCEPTION WHEN OTHERS THEN\n\n        MGMT_LOG.LOG_ERROR('GCHARVESTER', -203, \n          'Encountered a problem during full periodic updates for target type ' ||\n          f.target_type || ', snapshot type ' || f.snapshot_type || ', metric ' || \n          f.table_name || ': ' || SQLCODE || ': ' || SQLERRM,\n          v_log_level_in =>  MGMT_GLOBAL.G_ERROR); \n\n        RAISE;\n\n      END;\n    END;\n  END LOOP; -- over full_update_metrics\nEND;\n");
            oracleCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                String string = "Failed to populate OCM metrics based on full periodic updates: " + sQLException.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string));
                HarvesterUtil.logToRepository(oracleConnection, string);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(oracleCallableStatement);
                throw throwable;
            }
            JDBCUtil.close((Statement)oracleCallableStatement);
        }
        JDBCUtil.close((Statement)oracleCallableStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connectionCleanup(OracleConnection oracleConnection) {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("BEGIN EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_metrics_tmp'; END;");
            oracleCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                String string = "Failed to release OCM temp tables: " + sQLException.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string));
                HarvesterUtil.logToRepository(oracleConnection, string);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(oracleCallableStatement);
                throw throwable;
            }
            JDBCUtil.close((Statement)oracleCallableStatement);
        }
        JDBCUtil.close((Statement)oracleCallableStatement);
    }

    static String getQuery(String string) {
        boolean bl = GCVersion.pre11_2GC();
        if (string.equals("GET_TARGET_BATCH")) {
            if (bl) {
                return "  SELECT temp.target_name, temp.target_type, temp.display_name, temp.host_name, temp.timezone_region,  \n    (  /* lowercase home path if find host and it runs any kind of Windows */\n                  COALESCE (  \n           (SELECT (      \n              CASE       \n            WHEN INSTR(NLS_UPPER(t2.category_prop_1), 'WINDOWS') != 0 THEN  \n              NLS_LOWER(p.property_value) \n            ELSE p.property_value \n              END) \n            FROM mgmt_targets t2 \n            WHERE t2.target_name = temp.host_name \n            AND t2.target_type = 'host'), \n           p.property_value) ) home,                        \n           null discovered_name --mgmt_targets.discovered_name is not present in pre112 so null\n  FROM mgmt_target_properties p,  \n     (SELECT t.target_guid, (CASE WHEN o.target_type = 'oracle_vm_guest' THEN o.target_name ELSE t.target_name END) target_name, \n             o.target_type ,(CASE WHEN o.target_type = 'oracle_vm_guest' THEN o.target_name ELSE t.display_name END) display_name, \n             t.host_name, t.timezone_region , o.idx\n      FROM   mgmt_ocm_upl_metrics_tmp o, mgmt_targets t \n      WHERE \n             /* look for GVM and its target_guid */\n             ( o.target_type = 'oracle_vm_guest' AND\n\n               t.target_guid in (\n\n               SELECT distinct server_pool_guid from mgmt_virt_vm_master, mgmt_ocm_upl_metrics tgt_info \n                    where vm_uuid = (substr ( tgt_info.addl_target_info, instr( tgt_info.addl_target_info,'_',1,2 )+1 ) )\n                    and tgt_info.target_name = o.target_name\n                    and tgt_info.target_type = 'oracle_vm_guest'\n\n\n               )\n             )\n      OR (\n               o.target_type = 'oracle_vm_server_host' AND\n               t.target_type = 'oracle_vm_server' AND\n               t.target_name = o.target_name\n      )\n             /* or look for other target types and there target_guid */\n      OR     ( o.target_type = t.target_type  AND \n               o.target_name = t.target_name \n             )\n\n      AND o.idx >= ? AND o.idx < ? )temp  \n\n  WHERE temp.target_guid = p.target_guid (+) \n  AND 'OracleHome' = p.property_name(+) \n  ORDER BY temp.idx\n";
            }
            return " SELECT  t.target_name, \n         t.target_type, \n         t.display_name, \n         t.host_name, \n         t.timezone_region,\n         /* lowercase home path if find host and it runs any kind of Windows */\n         COALESCE (\n           (SELECT (\n              CASE \n                WHEN INSTR(NLS_UPPER(t2.category_prop_1), 'WINDOWS') != 0 THEN\n                  NLS_LOWER(p.property_value)\n                ELSE p.property_value\n              END)\n            FROM mgmt_targets t2\n            WHERE t2.target_name = t.host_name\n            AND t2.target_type = 'host'),\n           p.property_value) home,\n         t.discovered_name discovered_name\n    FROM mgmt_ocm_upl_metrics_tmp o, \n           mgmt_targets t, \n         mgmt_target_properties p\n   WHERE o.idx >= ? AND o.idx < ?\n     AND t.target_name = o.target_name\n     AND t.target_type = o.target_type\n     AND t.target_guid = p.target_guid (+)\n     AND 'OracleHome' = p.property_name(+)\n   ORDER BY o.idx\n";
        }
        if (string.equals("ADD_TARGETS_FOR_NEW_TT")) {
            if (bl) {
                return "BEGIN  \n     -- This is the harvester upgarde scenario WHERE the major version gets upgraded , the procedure will take   \n     -- care of adding the new targets coming FROM new target type if were introduced with upgrade  \n\n     -- Find all the target types which are present in mgmt_ocm_upl_md_tbls but not in mgmt_ocm_upl_metrics  \n     -- Loop over each target type and update the mgmt_ocm_upl_metrics if new targets found  \n\n     FOR record IN ( SELECT DISTINCT(target_type) FROM mgmt_ocm_upl_md_tbls mt    \n                     WHERE NOT EXISTS (SELECT target_type FROM mgmt_ocm_upl_metrics um \n                                       WHERE um.target_type = mt.target_type))  \n     LOOP  \n\n        -- GVM target type requires special casing\n        -- GVM is not a target in EMGC and its snapshot comes from oracle_vm_server target\n        IF record.target_type = 'oracle_vm_guest' THEN  \n\n               -- populate oracle guest vm target type metrics  \n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)  \n                 -- defaults used for:  is_changed  \n               SELECT gvm.vm_domain_name, h.target_type, h.snapshot_type, \n                      h.table_name, (gvm.vm_ovm_id  || '_APPEND_' || gvm.vm_uuid)  \n                 FROM mgmt_virt_vm_master gvm, mgmt_ocm_upl_md_tbls h  \n                WHERE h.target_type = 'oracle_vm_guest'\n                  AND gvm.vm_ovm_id is not null\n                  AND h.snapshot_type = 'oracle_ovm_vm_config';  \n\n        -- OVSP target type requires special casing\n        -- OVSP is a repository side target in EMGC and does not have any snapshot\n        ELSIF  record.target_type = 'oracle_vm_server_pool' THEN  \n\n             -- populate oracle vm server pool target type metrics  \n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name)  \n                 -- defaults used for:  addl_target_info, is_changed  \n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name  \n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h  \n                WHERE t.target_type = 'oracle_vm_server_pool'  \n                  AND h.target_type = 'oracle_vm_server_pool';  \n\n        ELSIF  record.target_type = 'oracle_vm_server_host' THEN\n\n             -- populate oracle vm server host target type metrics\n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name)\n                 -- defaults used for:  addl_target_info, is_changed\n               SELECT t.target_name, 'oracle_vm_server_host', h.snapshot_type, h.table_name\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h\n                WHERE t.target_type = 'oracle_vm_server'\n                  AND h.target_type = 'oracle_vm_server_host';\n\n        -- weblogic domain target type requires special casing\n        ELSIF  record.target_type = 'weblogic_domain' THEN  \n             -- populate weblogic domain target type metrics  \n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)  \n                 -- defaults used for:  is_changed  \n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value \n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p  \n                WHERE t.target_type = 'weblogic_domain'\n                  AND h.target_type = t.target_type \n                  AND p.target_guid = t.target_guid \n\t\t  AND p.property_name = 'WebLogicHome';\n\n        -- weblogic_cluster/j2ee_application target types requires special casing\n        ELSIF  (record.target_type = 'weblogic_cluster' OR\n\t\trecord.target_type = 'j2ee_application') THEN\n             -- populate weblogic cluster target type metrics\n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)\n                 -- defaults used for:  is_changed\n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n                WHERE t.target_type = record.target_type\n                  AND h.target_type = t.target_type\n\t\t  AND assocs.source_target_guid = t.target_guid\n\t\t  AND domain.target_guid = assocs.assoc_target_guid\n\t\t  AND domain.target_type = 'weblogic_domain'\n                  AND p.target_guid = domain.target_guid\n                  AND p.property_name = 'WebLogicHome'; \n\n        -- oracle_ias_farm target type requires special casing\n        ELSIF  record.target_type = 'oracle_ias_farm' THEN\n              -- populate oracle ias farm target type metric\n                INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)\n                 -- defaults used for:  is_changed\n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n                WHERE t.target_type = record.target_type\n                  AND h.target_type = t.target_type\n                  AND assocs.source_target_guid = t.target_guid\n                  AND domain.target_guid = assocs.assoc_target_guid\n                  AND domain.target_type = 'weblogic_domain'\n                  AND p.target_guid = domain.target_guid\n                  AND p.property_name = 'WebLogicHome'\n                  AND assocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*');\n\n        --if a new target type requires special casing , add a new ELSIF  \n        -- This is for generic target types  \n        ELSE  \n               -- populate metrics other than host config and oracle home target type  \n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name)  \n                 -- defaults used for:  addl_target_info, is_changed  \n               SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name  \n                 FROM mgmt_ecm_gen_snapshot s, mgmt_ocm_upl_md_tbls h  \n                WHERE s.is_current = 'Y'  \n                  AND s.target_type = h.target_type  \n                  AND s.snapshot_type = h.snapshot_type  \n                  AND NOT (s.target_type = 'host' and s.snapshot_type = 'host_configuration')  \n                  AND s.target_type = record.target_type;  \n\n        END IF;  \n       COMMIT;\n     END LOOP;  \n\n     EXCEPTION WHEN OTHERS THEN   \n\n       MGMT_LOG.LOG_ERROR('GCHARVESTER', -201,   \n         'Encountered a problem during addtion of new targets for OCM upload: ' ||   \n           SQLCODE || ': ' || SQLERRM,   \n         v_log_level_in =>  MGMT_GLOBAL.G_ERROR);   \n\n       RAISE;   \n\nEND;  \n";
            }
            return "BEGIN  \n     -- This is the harvester upgarde scenario WHERE the major version gets upgraded , the procedure will take   \n     -- care of adding the new targets coming FROM new target type if were introduced with upgrade  \n\n     -- Find all the target types which are present in mgmt_ocm_upl_md_tbls but not in mgmt_ocm_upl_metrics  \n     -- Loop over each target type and update the mgmt_ocm_upl_metrics if new targets found  \n\n     FOR record IN ( SELECT DISTINCT(target_type) FROM mgmt_ocm_upl_md_tbls mt    \n                     WHERE NOT EXISTS (SELECT target_type FROM mgmt_ocm_upl_metrics um \n                                       WHERE um.target_type = mt.target_type))  \n     LOOP  \n         -- weblogic domain target type requires special casing\n        IF  record.target_type = 'weblogic_domain' THEN\n             -- populate weblogic domain target type metrics\n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)\n                 -- defaults used for:  is_changed\n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p\n                WHERE t.target_type = 'weblogic_domain'\n                  AND h.target_type = t.target_type\n                  AND p.target_guid = t.target_guid\n                  AND p.property_name = 'WebLogicHome';\n\n        -- weblogic_cluster/j2ee_application target types requires special casing\n        ELSIF  (record.target_type = 'weblogic_cluster' OR\n                record.target_type = 'j2ee_application') THEN\n             -- populate weblogic cluster target type metrics\n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)\n                 -- defaults used for:  is_changed\n               SELECT distinct t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n                WHERE t.target_type = record.target_type\n                  AND h.target_type = t.target_type\n                  AND assocs.source_target_guid = t.target_guid\n                  AND domain.target_guid = assocs.assoc_target_guid\n                  AND domain.target_type = 'weblogic_domain'\n                  AND p.target_guid = domain.target_guid\n                  AND p.property_name = 'WebLogicHome';\n\n        -- oracle_ias_farm target type requires special casing\n        ELSIF  record.target_type = 'oracle_ias_farm' THEN\n              -- populate oracle ias farm target type metric\n                INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)\n                 -- defaults used for:  is_changed\n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n                WHERE t.target_type = record.target_type\n                  AND h.target_type = t.target_type\n                  AND assocs.source_target_guid = t.target_guid\n                  AND domain.target_guid = assocs.assoc_target_guid\n                  AND domain.target_type = 'weblogic_domain'\n                  AND p.target_guid = domain.target_guid\n                  AND p.property_name = 'WebLogicHome'\n                  AND assocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*');\n\n           --if a new target type requires special casing , add a new ELSIF\n           -- This is for generic target types\n        ELSE\n          -- populate metrics other than host config and oracle home target type  \n             INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name)  \n                 -- defaults used for:  addl_target_info, is_changed  \n             SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name  \n             FROM mgmt_ecm_gen_snapshot s, mgmt_ocm_upl_md_tbls h  \n             WHERE s.is_current = 'Y'  \n               AND s.target_type = h.target_type  \n               AND s.snapshot_type = h.snapshot_type  \n             --AND NOT (s.target_type = 'host' and s.snapshot_type = 'host_configuration')  \n               AND s.target_type = record.target_type\n               AND exists (select 'x' from mgmt_targets where target_guid = s.target_guid);  \n         END IF;\n         COMMIT;\n\n         INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name)  \n                 -- defaults used for:  addl_target_info, is_changed  \n         SELECT distinct tg.target_name, tg.target_type, \n                    'OCheck' snapshot_type, \n                   'MGMT_DIAGNOSTIC_CHECK_ROWS' table_name\n           FROM MGMT_DIAGNOSTIC_CHECK_ROWS d, mgmt_targets tg\n          WHERE tg.target_guid = d.target_guid\n            AND tg.target_type = record.target_type;  \n         COMMIT;\n     END LOOP;  \n\n     EXCEPTION WHEN OTHERS THEN   \n\n       MGMT_LOG.LOG_ERROR('GCHARVESTER', -201,   \n         'Encountered a problem during addtion of new targets for OCM upload: ' ||   \n           SQLCODE || ': ' || SQLERRM,   \n         v_log_level_in =>  MGMT_GLOBAL.G_ERROR);   \n\n       RAISE;   \n\nEND;  \n";
        }
        if (string.equals("RESYNC_CODE")) {
            if (bl) {
                return "DECLARE\n  l_changes_ts DATE;\nBEGIN\n  -- Initialization / resynch code\n  EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_metrics';\n\n  -- would rather later send duplicate config than miss some changes\n  -- assumption: history code does not take more than 10 minutes\n  l_changes_ts := sysdate - 1 / (24 * 6); \n\n  -- populate metrics other than host config and oracle home target type\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics \n    (target_name, target_type, snapshot_type, table_name)\n    -- defaults used for:  addl_target_info, is_changed\n  SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name\n    FROM mgmt_ecm_gen_snapshot s, mgmt_ocm_upl_md_tbls h\n   WHERE s.is_current = 'Y'\n     AND s.target_type = h.target_type \n     AND s.snapshot_type = h.snapshot_type\n     AND NOT (s.target_type = 'host' and s.snapshot_type = 'host_configuration');\n\n  COMMIT;\n\n  -- populate oracle vm server pool target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name)\n    -- defaults used for:  addl_target_info, is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name\n      FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h\n    WHERE t.target_type = 'oracle_vm_server_pool' \n     AND h.target_type = 'oracle_vm_server_pool';\n\n  COMMIT;\n\n  -- populate oracle guest vm target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for:  is_changed\n  SELECT gvm.vm_domain_name, h.target_type, h.snapshot_type, h.table_name, (gvm.vm_ovm_id  || '_APPEND_' || gvm.vm_uuid) \n      FROM mgmt_virt_vm_master gvm, mgmt_ocm_upl_md_tbls h \n    WHERE h.target_type = 'oracle_vm_guest' \n     AND gvm.vm_ovm_id is not null\n     AND h.snapshot_type = 'oracle_ovm_vm_config'; \n\n  COMMIT;\n\n -- populate vm_server as host\n INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name)\n    -- defaults used for:  addl_target_info, is_changed\n  SELECT s.target_name, 'oracle_vm_server_host', s.snapshot_type, h.table_name\n    FROM mgmt_ecm_gen_snapshot s, mgmt_ocm_upl_md_tbls h\n   WHERE s.is_current = 'Y'\n     AND s.target_type = 'oracle_vm_server'\n     AND h.target_type = 'oracle_vm_server_host'\n     AND s.snapshot_type = h.snapshot_type;\n\n  COMMIT;\n\n  -- populate weblogic domain target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p\n    WHERE t.target_type = 'weblogic_domain' \n     AND h.target_type = t.target_type\n     AND p.target_guid = t.target_guid\n     AND p.property_name = 'WebLogicHome';\n\n  COMMIT;\n\n  -- populate weblogic_cluster/j2ee_application target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n    WHERE t.target_type in ('weblogic_cluster', 'j2ee_application')\n     AND h.target_type = t.target_type\n     AND assocs.source_target_guid = t.target_guid\n     AND domain.target_guid = assocs.assoc_target_guid\n     AND domain.target_type = 'weblogic_domain'\n     AND p.target_guid = domain.target_guid\n     AND p.property_name = 'WebLogicHome';\n\n  COMMIT;\n\n  -- populate oracle_ias_farm target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n    WHERE t.target_type = 'oracle_ias_farm'\n     AND h.target_type = t.target_type\n     AND assocs.source_target_guid = t.target_guid\n     AND domain.target_guid = assocs.assoc_target_guid\n     AND domain.target_type = 'weblogic_domain'\n     AND p.target_guid = domain.target_guid\n     AND p.property_name = 'WebLogicHome'\n     AND assocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*');\n\n  COMMIT;\n\n  -- populate metrics for host configs\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name) \n    -- defaults used for:  addl_target_info, is_changed\n  SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name\n    FROM mgmt_ecm_snapshot s, mgmt_ocm_upl_md_tbls h\n   WHERE s.is_current = 'Y'\n     AND s.target_type = h.target_type\n     AND s.snapshot_type = h.snapshot_type\n     AND s.target_type = 'host' \n     AND s.snapshot_type = 'host_configuration';\n\n  COMMIT;\n\n  -- populate oracle home target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for:  is_changed\n  SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name, c.container_location\n    FROM mgmt_ecm_snapshot s, mgmt_inv_container c, \n         (SELECT 'ECM$HIST_INV_COMPONENTS' as table_name FROM DUAL \n           UNION ALL SELECT 'ECM$HIST_INV_PATCHES' FROM DUAL\n           UNION ALL SELECT 'ECM$HIST_INV_PATCHSETS' FROM DUAL) h \n   WHERE s.is_current = 'Y'\n     AND s.target_type = 'host' \n     AND s.snapshot_type = 'host_configuration'\n     AND s.snapshot_guid = c.snapshot_guid\n     AND c.container_type != 'I';\n\n  COMMIT;\n\n  MERGE INTO mgmt_ocm_upl_props p\n  USING dual \n     ON ( name = 'changes_ts' )\n   WHEN MATCHED THEN UPDATE SET p.ts_value = l_changes_ts\n   WHEN NOT MATCHED THEN INSERT (name, ts_value)\n        VALUES ('changes_ts', l_changes_ts);\n\n  -- update periodic full table since all its metrics are marked\n  UPDATE mgmt_ocm_upl_periodic_full\n     SET last_update = sysdate;\n\n  -- increment resync_seq_num for older code\n  UPDATE mgmt_ocm_upl_props\n     SET num_value = num_value + 1\n   WHERE name = 'resync_seq_num';\n\n  -- update last full resynch timestamp\n  MERGE INTO mgmt_ocm_upl_props p\n  USING (SELECT SYSTIMESTAMP AT TIME ZONE 'GMT' AS ts FROM dual) t\n     ON ( name = 'last_full_resync_ts_gmt' )\n   WHEN MATCHED THEN UPDATE SET p.ts_value = t.ts\n   WHEN NOT MATCHED THEN INSERT (name, ts_value) values\n        ('last_full_resync_ts_gmt', t.ts);\n\n  COMMIT;\n\nEXCEPTION WHEN OTHERS THEN\n\n  MGMT_LOG.LOG_ERROR('GCHARVESTER', -201,\n    'Encountered a problem during [re]initialization of OCM upload: ' ||\n      SQLCODE || ': ' || SQLERRM,\n    v_log_level_in =>  MGMT_GLOBAL.G_ERROR);\n\n  RAISE;\n\nEND;\n";
            }
            return "DECLARE\n  l_changes_ts DATE;\nBEGIN\n  -- Initialization / resynch code\n  EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_metrics';\n\n  -- would rather later send duplicate config than miss some changes\n  -- assumption: history code does not take more than 10 minutes\n  l_changes_ts := sysdate - 1 / (24 * 6); \n\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics \n    (target_name, target_type, snapshot_type, table_name)\n    -- defaults used for:  addl_target_info, is_changed\n  SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name\n    FROM mgmt_ecm_gen_snapshot s, mgmt_ocm_upl_md_tbls h\n   WHERE s.is_current = 'Y'\n     AND s.target_type = h.target_type \n     AND s.snapshot_type = h.snapshot_type \n     --wls targets need to populate additional info with oracle home value\n     --so populating them is custom query\n     AND h.target_type not in ('weblogic_domain', 'weblogic_cluster',\n                               'oracle_ias_farm', 'j2ee_application')\n     AND exists (select 'x' from mgmt_targets where target_guid = s.target_guid);  \n\n  COMMIT;\n\n   -- populate weblogic domain target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p\n    WHERE t.target_type = 'weblogic_domain'\n     AND h.target_type = t.target_type\n     AND p.target_guid = t.target_guid\n     AND p.property_name = 'WebLogicHome';\n\n  COMMIT;\n\n  -- populate weblogic_cluster/j2ee_application target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT distinct  t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n    WHERE t.target_type in ('weblogic_cluster', 'j2ee_application')\n     AND h.target_type = t.target_type\n     AND assocs.source_target_guid = t.target_guid\n     AND domain.target_guid = assocs.assoc_target_guid\n     AND domain.target_type = 'weblogic_domain'\n     AND p.target_guid = domain.target_guid\n     AND p.property_name = 'WebLogicHome';\n\n  COMMIT;\n\n  -- populate oracle_ias_farm target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n    WHERE t.target_type = 'oracle_ias_farm'\n     AND h.target_type = t.target_type\n     AND assocs.source_target_guid = t.target_guid\n     AND domain.target_guid = assocs.assoc_target_guid\n     AND domain.target_type = 'weblogic_domain'\n     AND p.target_guid = domain.target_guid \n     AND p.property_name = 'WebLogicHome' \n     AND assocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*');\n\n  COMMIT;\n\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics \n    (target_name, target_type, snapshot_type, table_name)\n    -- defaults used for:  addl_target_info, is_changed\n  SELECT distinct tg.target_name, tg.target_type, \n         'OCheck' snapshot_type, \n         'MGMT_DIAGNOSTIC_CHECK_ROWS' table_name\n    FROM MGMT_DIAGNOSTIC_CHECK_ROWS d, mgmt_targets tg\n   WHERE tg.target_guid = d.target_guid;\n\n  COMMIT;\n\n  INSERT /*+ APPEND */ INTO MGMT_OCM_UPL_METRICS(target_name, target_type, snapshot_type, table_name, last_harvest_ts)\n  /* \n   * Association to get database from dbmachine\n   * rac_database -> deployed_on -> oracle_dbmachine\n   * rac_databas -> cluster_contains -> oracle_database\n   */\n  SELECT \n         --RAC2DBMC.ASSOC_TYPE, DBMC.TARGET_TYPE, RAC2DB.ASSOC_TYPE, DB.TARGET_TYPE,\n         DB.TARGET_NAME, \n         DB.TARGET_TYPE, \n         'oracle_db_adrinfo' SNAPSHOT_TYPE, \n         'MGMT_ECM_ADR_INFO' TABLE_NAME,\n         add_months(sysdate , -12) LAST_HARVEST_TS\n  FROM GC_ASSOC_INSTANCES RAC2DBMC \n  JOIN MGMT_TARGETS DBMC ON DBMC.TARGET_TYPE = 'oracle_dbmachine' AND DBMC.TARGET_GUID = RAC2DBMC.DEST_ME_GUID \n  JOIN GC_ASSOC_INSTANCES RAC2DB ON RAC2DB.SOURCE_ME_GUID = RAC2DBMC.SOURCE_ME_GUID \n  JOIN MGMT_TARGETS DB ON DB.TARGET_TYPE = 'oracle_database' AND DB.TARGET_GUID = RAC2DB.DEST_ME_GUID \n  WHERE RAC2DBMC.ASSOC_TYPE = 'deployed_on' AND RAC2DB.ASSOC_TYPE = 'cluster_contains';\n\n  COMMIT;\n\n   -- populate SCN metric target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info, last_harvest_ts)\n     SELECT DISTINCT  \n            T.TARGET_NAME, \n            T.TARGET_TYPE,   \n            H.SNAPSHOT_TYPE , \n            H.TABLE_NAME, \n            NULL AS ADDL_TARGET_INFO, \n            add_months(sysdate , -12) LAST_HARVEST_TS\n     FROM MGMT_TARGETS T, MGMT_OCM_UPL_MD_TBLS H\n     WHERE T.TARGET_TYPE = H.TARGET_TYPE\n        AND  H.SNAPSHOT_TYPE = 'oracle_db_adrinfo'\n        AND T.TARGET_TYPE = 'oracle_database' \n        AND H.TABLE_NAME='MGMT_ECM_SCN_INFO' ;\n\n  COMMIT;\n\n\n  MERGE INTO mgmt_ocm_upl_props p\n  USING dual \n     ON ( name = 'changes_ts' )\n   WHEN MATCHED THEN UPDATE SET p.ts_value = l_changes_ts\n   WHEN NOT MATCHED THEN INSERT (name, ts_value)\n        VALUES ('changes_ts', l_changes_ts);\n\n  -- update periodic full table since all its metrics are marked\n  UPDATE mgmt_ocm_upl_periodic_full\n     SET last_update = sysdate;\n\n  -- increment resync_seq_num for older code\n  UPDATE mgmt_ocm_upl_props\n     SET num_value = num_value + 1\n   WHERE name = 'resync_seq_num';\n\n  -- update last full resynch timestamp\n  MERGE INTO mgmt_ocm_upl_props p\n  USING (SELECT SYSTIMESTAMP AT TIME ZONE 'GMT' AS ts FROM dual) t\n     ON ( name = 'last_full_resync_ts_gmt' )\n   WHEN MATCHED THEN UPDATE SET p.ts_value = t.ts\n   WHEN NOT MATCHED THEN INSERT (name, ts_value) values\n        ('last_full_resync_ts_gmt', t.ts);\n\n  COMMIT;\n\nEXCEPTION WHEN OTHERS THEN\n\n  MGMT_LOG.LOG_ERROR('GCHARVESTER', -201,\n    'Encountered a problem during [re]initialization of OCM upload: ' ||\n      SQLCODE || ': ' || SQLERRM,\n    v_log_level_in =>  MGMT_GLOBAL.G_ERROR);\n\n  RAISE;\n\nEND;\n";
        }
        if (string.equals("HISTORY_POPULATE_CODE")) {
            if (bl) {
                return "DECLARE\n  l_min_ts DATE := NULL;\n  l_max_ts DATE := NULL;\n  l_prev_ts DATE := NULL;\n  l_next_ts DATE := NULL;\n  l_overall_interval NUMBER; -- overall number of days\n  l_interval_div_by_4 NUMBER; -- above number divided by 4\n  l_interval NUMBER := 1; -- number of days (used to split overall interval)\n  l_split BOOLEAN := false; -- are we splitting into intervals?\n  l_last_interval BOOLEAN := true; -- are we processing last interval?\nBEGIN\n  BEGIN\n    SELECT ts_value INTO l_min_ts\n      FROM mgmt_ocm_upl_props\n     WHERE name = 'changes_ts';\n  EXCEPTION WHEN NO_DATA_FOUND THEN\n    raise_application_error(-20000, \n      'Internal error: last update timestamp is unavailable to history-based code');\n  END;\n\n  -- select current timestamp minus 10 minutes (assumption: ECM history computation\n  -- should be done within 10 minutes of when it starts)\n  l_max_ts := sysdate - 1 / (24 * 6);\n\n  l_prev_ts := l_min_ts;\n  l_next_ts := l_max_ts;\n  LOOP -- over intervals\n    BEGIN\n\n      -- update mgmt_ocm_upl_metrics with changes in the l_prev_ts to l_next_ts interval\n\n      -- first, handle all new and old targets except for oracle homes \n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT DISTINCT s.new_left_target_name as target_name, s.target_type , \n               s.snapshot_type, null as addl_target_info, h.table_name\n          FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_ocm_upl_md_tbls h\n         WHERE\n           s.delta_type = 'HISTORY'\n           AND e.row_guid = i.row_guid (+)\n           AND s.delta_guid = e.delta_guid (+)\n           AND s.delta_timestamp > l_prev_ts \n           AND s.delta_timestamp <= l_next_ts \n           AND s.target_type =  h.target_type\n           AND s.snapshot_type = h.snapshot_type\n           AND ( (e.delta_guid IS NULL AND s.old_right_snapshot_guid IS NULL)\n               OR\n               ( e.operation != 'SAME' AND i.collection_type = h.table_name) )\n\n         ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null \n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- handle oracle homes on new hosts\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT DISTINCT s.target_name, 'host' as target_type, 'host_configuration' as snapshot_type, \n               i.container_location as addl_target_info, h.table_name\n          FROM (SELECT s.new_left_target_name as target_name -- cardinality hint? to drive overall query by timestamp index?\n                  FROM mgmt_delta_snap s\n                 WHERE s.delta_type = 'HISTORY'\n                   AND s.delta_timestamp > l_prev_ts \n                   AND s.delta_timestamp <= l_next_ts \n                   AND s.target_type =  'host'\n                   AND s.snapshot_type = 'host_configuration'\n                   AND s.old_right_snapshot_guid IS NULL\n               ) new_hosts,\n               mgmt_ecm_snapshot s, mgmt_inv_container i,\n               (SELECT 'ECM$HIST_INV_COMPONENTS' as table_name FROM DUAL \n                   UNION ALL SELECT 'ECM$HIST_INV_PATCHES' FROM DUAL\n                   UNION ALL SELECT 'ECM$HIST_INV_PATCHSETS' FROM DUAL) h\n         WHERE s.target_name = new_hosts.target_name\n           AND s.target_type = 'host'\n           AND s.snapshot_type = 'host_configuration'\n           AND s.is_current = 'Y'\n           AND s.snapshot_guid = i.snapshot_guid   \n           AND i.container_type != 'I'\n\n          ) t \n         ON (   p.target_type = t.target_type \n            AND p.target_name = t.target_name \n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- handle inserts/deletes/updates to oracle homes on existing hosts\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT DISTINCT s.new_left_target_name as target_name, \n               'host' as target_type, 'host_configuration' as snapshot_type, \n               iv.value as addl_target_info, i.collection_type as table_name\n          FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_delta_id_values iv\n         WHERE s.delta_type = 'HISTORY' \n           AND s.delta_timestamp > l_prev_ts \n           AND s.delta_timestamp <= l_next_ts \n           AND s.target_type = 'host'\n           AND s.snapshot_type = 'host_configuration'\n           AND s.delta_guid = e.delta_guid\n           AND e.operation != 'SAME' \n           AND e.row_guid = i.row_guid\n           and i.collection_type in \n               ('ECM$HIST_INV_COMPONENTS', \n                'ECM$HIST_INV_PATCHSETS',\n                'ECM$HIST_INV_PATCHES')\n           and iv.delta_ids_guid = i.row_guid\n           and iv.name = 'CONTAINER_LOCATION'\n           and iv.value not like 'N/A%'\n\n      ) t\n         ON (    p.target_type = t.target_type\n             AND p.target_name = t.target_name\n             AND p.snapshot_type = t.snapshot_type\n             AND p.table_name = t.table_name\n             AND p.addl_target_info = t.addl_target_info\n             )\n        WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n        WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n             VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- OVSP target depends on OVS target for snapshot and history changes as it does not have any snapshot in EMGC\n      -- First get the new OVS target or for which snapshot has chaned, now from assocs table get the corresponding\n      -- OVSP target and other data from upl_md_table\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n         SELECT DISTINCT vva.vsp_target_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type, \n                         null as addl_target_info, h.table_name as table_name\n           FROM (SELECT s.new_left_target_name as target_name , s.target_type as target_type\n                           FROM mgmt_delta_snap s\n                          WHERE s.delta_type = 'HISTORY'\n                            AND s.delta_timestamp > l_prev_ts \n                            AND s.delta_timestamp <= l_next_ts \n                            AND s.target_type =  'oracle_vm_server'\n                            AND s.snapshot_type = 'oracle_ovm_vs_config'\n                            AND s.old_right_snapshot_guid IS NULL\n                 ) new_vs, \n                   mgmt_ovm_vs_vsp_assoc vva, mgmt_ovm_vsp_summary vsp, mgmt_ocm_upl_md_tbls h\n          WHERE vva.vs_target_name = new_vs.target_name\n            AND vva.vs_target_type = new_vs.target_type\n            AND vva.vsp_target_guid = vsp.target_guid\n            AND vva.vs_target_guid = vsp.mas_target_guid\n            AND h.target_type = 'oracle_vm_server_pool'\n            AND h.snapshot_type = 'oracle_ovm_vsp_config'\n\n          ) t \n         ON (   p.target_type = t.target_type \n            AND p.target_name = t.target_name \n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null \n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- handle modifications to existing OVSPs\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n         SELECT DISTINCT vva.vsp_target_name as target_name , h.target_type as target_type, h.snapshot_type as snapshot_type, \n                         null as addl_target_info, h.table_name as table_name\n           FROM (SELECT s.new_left_target_name as target_name, s.target_type as target_type\n                  FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_delta_id_values iv\n                 WHERE s.delta_type = 'HISTORY' \n                   AND s.delta_timestamp > l_prev_ts \n                   AND s.delta_timestamp <= l_next_ts \n                   AND s.target_type = 'oracle_vm_server'\n                   AND s.snapshot_type = 'oracle_ovm_vs_config'\n                   AND s.delta_guid = e.delta_guid\n                   AND e.operation != 'SAME' \n                   AND e.row_guid = i.row_guid\n                   AND iv.delta_ids_guid = i.row_guid\n                ) changed_vs,\n                  mgmt_ovm_vs_vsp_assoc vva,  mgmt_ovm_vsp_summary vsp, mgmt_ocm_upl_md_tbls h\n          WHERE vva.vs_target_name = changed_vs.target_name\n            AND vva.vs_target_type = changed_vs.target_type\n            AND vva.vsp_target_guid = vsp.target_guid\n            AND vva.vs_target_guid = vsp.mas_target_guid\n            AND h.target_type = 'oracle_vm_server_pool'\n            AND h.snapshot_type = 'oracle_ovm_vsp_config'\n\n          ) t \n         ON (   p.target_type = t.target_type \n            AND p.target_name = t.target_name \n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null \n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- GVM target depends on OVS target for snapshot and history as it does not exists as a target in EMGC\n      -- First get the new OVS target or for which snapshot has chaned, now from assocs table get the corresponding\n      -- OVSP target guid , use the guid to find the GVMs from master table\n      -- and other data from upl_md_table\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT  DISTINCT gvm.vm_domain_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type, \n                (gvm.vm_ovm_id  || '_APPEND_' || gvm.vm_uuid) as addl_target_info, h.table_name as table_name\n          FROM  (SELECT s.new_left_target_name as target_name, s.target_type as target_type\n                          FROM mgmt_delta_snap s\n                         WHERE s.delta_type = 'HISTORY'\n                           AND s.delta_timestamp > l_prev_ts \n                           AND s.delta_timestamp <= l_next_ts \n                           AND s.target_type =  'oracle_vm_server'\n                           AND s.snapshot_type = 'oracle_ovm_vs_config'\n                           AND s.old_right_snapshot_guid IS NULL\n                ) new_vs,\n                  mgmt_virt_vm_master gvm, mgmt_ocm_upl_md_tbls h,mgmt_ovm_vs_vsp_assoc vva\n         WHERE  vva.vs_target_name = new_vs.target_name\n           AND  vva.vs_target_type = new_vs.target_type\n           AND  vva.vsp_target_guid =gvm.server_pool_guid\n           AND  h.target_type = 'oracle_vm_guest'\n           AND  h.snapshot_type = 'oracle_ovm_vm_config'\n           AND  gvm.vm_ovm_id is not null\n\n          ) t \n         ON (   p.target_type = t.target_type \n            AND p.target_name = t.target_name \n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- handle modifications to existing GVMs\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT  DISTINCT gvm.vm_domain_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type, \n                (gvm.vm_ovm_id  || '_APPEND_' || gvm.vm_uuid) as addl_target_info, h.table_name as table_name\n          FROM  (SELECT s.new_left_target_name as target_name, s.target_type as target_type\n                  FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_delta_id_values iv\n                 WHERE s.delta_type = 'HISTORY' \n                   AND s.delta_timestamp > l_prev_ts \n                   AND s.delta_timestamp <= l_next_ts \n                   AND s.target_type = 'oracle_vm_server'\n                   AND s.snapshot_type = 'oracle_ovm_vs_config'\n                   AND s.delta_guid = e.delta_guid\n                   AND e.operation != 'SAME' \n                   AND e.row_guid = i.row_guid\n                   AND iv.delta_ids_guid = i.row_guid\n                ) changed_vs,\n                  mgmt_virt_vm_master gvm, mgmt_ocm_upl_md_tbls h,mgmt_ovm_vs_vsp_assoc vva\n         WHERE  vva.vs_target_name = changed_vs.target_name\n           AND  vva.vs_target_type = changed_vs.target_type\n           AND  vva.vsp_target_guid =gvm.server_pool_guid\n           AND  h.target_type = 'oracle_vm_guest'\n           AND  h.snapshot_type = 'oracle_ovm_vm_config'\n           AND  gvm.vm_ovm_id is not null\n\n          ) t \n         ON (   p.target_type = t.target_type \n            AND p.target_name = t.target_name \n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- oracle_vm_server_host target type depend on oracle_vm_server target types , handle new and existing  oracle_vm_server_host targets\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (  \n\n       SELECT DISTINCT s.new_left_target_name as target_name, h.target_type,\n               s.snapshot_type, null as addl_target_info, h.table_name\n          FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_ocm_upl_md_tbls h\n         WHERE\n           s.delta_type = 'HISTORY'\n           AND e.row_guid = i.row_guid (+)\n           AND s.delta_guid = e.delta_guid (+)\n           AND s.delta_timestamp > l_prev_ts\n           AND s.delta_timestamp <= l_next_ts\n           AND s.target_type =  'oracle_vm_server'\n           AND h.target_type = 'oracle_vm_server_host'\n           AND s.snapshot_type = h.snapshot_type\n           AND ( (e.delta_guid IS NULL AND s.old_right_snapshot_guid IS NULL)\n               OR\n               ( e.operation != 'SAME' AND i.collection_type = h.table_name) )\n\n         ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- Fix for bug#9980503\n      -- MGMT_ECM_ASSOCIATIONS is a periodically collected metric for weblogic_j2eeserver target.\n      -- Adding the following query to minimize the time lag in collecting the MGMT_ECM_ASSOCIATIONS metric which would otherwise be collected periodically i.e 30 days\n      -- Following query would enable the MGMT_ECM_ASSOCIATIONS metric collection when there is any change in the existing server cofiguration\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT DISTINCT s.new_left_target_name as target_name, 'weblogic_j2eeserver' as target_type ,\n               'weblogic_j2eeserver_config' as snapshot_type, null as addl_target_info, 'MGMT_ECM_ASSOCIATIONS' as table_name\n          FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i\n         WHERE s.delta_type = 'HISTORY'\n           AND e.row_guid = i.row_guid\n           AND e.operation != 'SAME'\n           AND s.delta_guid = e.delta_guid\n           AND s.delta_timestamp > l_prev_ts\n           AND s.delta_timestamp <= l_next_ts\n           AND s.target_type = 'weblogic_j2eeserver'\n           AND s.snapshot_type = 'weblogic_j2eeserver_config'\n\n         ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- weblogic_domain/weblogic_cluster/j2ee_application targets depends on weblogic server target for snapshot and history as there is no snapshot for domain target in EMGC\n      -- First get the new weblogic server target or for which snapshot has chaned, now from targets table get the corresponding\n      -- weblogic server target guid , use the guid to find the domain/cluster/j2ee_application target from assocs table\n      -- and other data from upl_md_table\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT  DISTINCT assocTgt.target_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type,\n                prop.property_value as addl_target_info, h.table_name as table_name\n          FROM  (SELECT s.new_left_target_name as target_name, s.target_type as target_type\n                          FROM mgmt_delta_snap s\n                         WHERE s.delta_type = 'HISTORY'\n                           AND s.delta_timestamp > l_prev_ts\n                           AND s.delta_timestamp <= l_next_ts\n                           AND s.target_type =  'weblogic_j2eeserver'\n                           AND s.snapshot_type = 'weblogic_j2eeserver_config'\n                           AND s.old_right_snapshot_guid IS NULL\n                ) new_wlserver,\n                  mgmt_targets assocTgt, mgmt_targets server, mgmt_ocm_upl_md_tbls h, mgmt_target_assocs tgtAssocs, \n\t\t  mgmt_target_properties prop, mgmt_targets domain, mgmt_target_assocs domainAssocs\n        WHERE  server.target_name = new_wlserver.target_name\n           AND  server.target_type = new_wlserver.target_type\n           AND  tgtAssocs.assoc_target_guid = server.target_guid \n\t   AND  assocTgt.target_guid = tgtAssocs.source_target_guid\n\t   AND  assocTgt.target_type in ('weblogic_domain', 'weblogic_cluster', 'j2ee_application')\n\t   AND  h.target_type = assocTgt.target_type\n\t   AND  h.snapshot_type in ('weblogic_domain_config', 'weblogic_cluster_config', 'j2ee_application_config')\n\t   AND  domainAssocs.source_target_guid = server.target_guid\n           AND  domain.target_guid = domainAssocs.assoc_target_guid\n           AND  prop.target_guid = domain.target_guid\n           AND  prop.property_name = 'WebLogicHome'                \n           AND  prop.property_value is not null\n\n          ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- oracle_ias_farm target has an association with weblogic domain target\n      -- weblogic domain target depends on weblogic server target for snapshot and history as there is no snapshot for domain target in EMGC\n      -- First get the new weblogic server target or for which snapshot has chaned, then get the corresponding domain target from the assocs table.\n      -- finally use the domain target guid to find the oracle ias farm target from assocs table\n      -- and other data from upl_md_table\n      -- For oracle_ias_farm target we are only collecting association with the wl adminserver target.\n      -- The association with the wl adminserver target will not change if there are any config changes for the wlserver target.\n      -- So we are not collecting data for oracle_ias_farm target when there are changes to the wlserver.\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n\tWITH tbls AS\n\t(SELECT /*+ materialize */ table_name\n\t FROM mgmt_ocm_upl_md_tbls\n\t WHERE target_Type = 'oracle_ias_farm'\n\t   AND snapshot_type = 'oracle_ias_farm_config')\n\n        SELECT  DISTINCT farm.target_name as target_name, 'oracle_ias_farm' as target_type, 'oracle_ias_farm_config' as snapshot_type,\n                prop.property_value as addl_target_info, h.table_name as table_name\n          FROM  (SELECT s.new_left_target_name as target_name, 'weblogic_j2eeserver' as target_type\n                          FROM mgmt_delta_snap s\n                         WHERE s.delta_type = 'HISTORY'\n                           AND s.delta_timestamp > l_prev_ts \n                           AND s.delta_timestamp <= l_next_ts\n                           AND s.target_type =  'weblogic_j2eeserver'\n                           AND s.snapshot_type = 'weblogic_j2eeserver_config'\n                           AND s.old_right_snapshot_guid IS NULL\n                ) new_wlserver,\n                  mgmt_targets domain, mgmt_targets server, tbls h, mgmt_target_assocs tgtAssocs, mgmt_target_properties prop,\n\t\t  mgmt_targets farm, mgmt_target_assocs farmAssoc\n         WHERE  server.target_name = new_wlserver.target_name\n           AND  server.target_type = new_wlserver.target_type\n           AND  tgtAssocs.source_target_guid = server.target_guid\n           AND  domain.target_guid = tgtAssocs.assoc_target_guid\n\t   AND  domain.target_type = 'weblogic_domain'\n\t   AND  farmAssoc.assoc_target_guid = domain.target_guid\n\t   AND  farm.target_guid = farmAssoc.source_target_guid\n\t   AND  farm.target_type = 'oracle_ias_farm'\t\n           AND  prop.target_guid = domain.target_guid\n           AND  prop.property_name = 'WebLogicHome'\n           AND  prop.property_value is not null\n\n          ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- weblogic_cluster and j2ee_application targets for existing weblogic_server targets that have had config changes.     \n      -- An existing wlserver could be added as part of a cluster or a new j2ee_application can be deployed to a existing wlserver.\n      -- So we are collecting the data for cluster and j2ee_app targets where there are changes to wlserver. \n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n         SELECT  DISTINCT assocTgt.target_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type,\n                prop.property_value as addl_target_info, h.table_name as table_name\n           FROM (SELECT s.new_left_target_name as target_name, s.target_type as target_type\n                  FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_delta_id_values iv\n                 WHERE s.delta_type = 'HISTORY'\n                   AND s.delta_timestamp > l_prev_ts\n                   AND s.delta_timestamp <= l_next_ts\n                   AND s.target_type = 'weblogic_j2eeserver'\n                   AND s.snapshot_type = 'weblogic_j2eeserver_config'\n                   AND s.delta_guid = e.delta_guid\n                   AND e.operation != 'SAME'\n                   AND e.row_guid = i.row_guid\n                   AND iv.delta_ids_guid = i.row_guid\n                ) changed_wlserver,\n                  mgmt_targets assocTgt, mgmt_targets server, mgmt_ocm_upl_md_tbls h, mgmt_target_assocs tgtAssocs, \n                  mgmt_target_properties prop, mgmt_targets domain, mgmt_target_assocs domainAssocs, mgmt_target_assoc_defs assocDefs\n         WHERE  server.target_name = changed_wlserver.target_name\n           AND  server.target_type = changed_wlserver.target_type\n           AND  tgtAssocs.assoc_target_guid = server.target_guid \n           AND  assocTgt.target_guid = tgtAssocs.source_target_guid\n           AND  assocTgt.target_type in ('weblogic_cluster', 'j2ee_application')\n           AND  assocDefs.assoc_def_name = (CASE WHEN assocTgt.target_type = 'weblogic_cluster' THEN 'contains' ELSE 'managedServer' END)\n           AND  assocDefs.assoc_guid = tgtAssocs.assoc_guid\n           AND  h.target_type = assocTgt.target_type\n           AND  h.snapshot_type in ('weblogic_cluster_config', 'j2ee_application_config')\n           AND  domainAssocs.source_target_guid = server.target_guid\n           AND  domain.target_guid = domainAssocs.assoc_target_guid\n           AND  prop.target_guid = domain.target_guid\n           AND  prop.property_name = 'WebLogicHome'\n           AND  prop.property_value is not null\n\n          ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      IF (NOT l_split) OR l_last_interval THEN\n        EXIT;\n      ELSE -- split is on and this was not the last interval\n        l_prev_ts := l_next_ts;\n        l_next_ts := l_next_ts + l_interval;\n        IF l_next_ts >= l_max_ts THEN\n          l_next_ts := l_max_ts;\n          l_last_interval := true;\n        END IF;\n      END IF;\n\n    EXCEPTION WHEN OTHERS THEN\n      -- did we already try to split?\n      IF l_split THEN \n        IF l_interval > 0.04 THEN\n          -- last try: attempt minimal interval\n          l_interval := 0.04;\n        ELSE -- already tried minimal interval\n          RAISE;\n        END IF;\n      ELSE -- had not tried to split yet\n        -- split interval: try to split into at least 4 parts\n        -- but no more than one day and no less than about an hour each.\n        l_overall_interval := l_max_ts - l_min_ts;\n        l_interval_div_by_4 := l_overall_interval / 4;\n        IF l_interval_div_by_4 >= 1 THEN -- 1 day\n          l_interval := 1;\n        ELSIF l_interval_div_by_4 >= 0.5 THEN -- 12 hours\n          l_interval := 0.5;\n        ELSIF l_interval_div_by_4 >= 0.25 THEN -- 6 hours\n          l_interval := 0.25;\n        ELSIF l_interval_div_by_4 >= 0.125 THEN -- 3 hours\n          l_interval := 1/8;\n        ELSIF l_overall_interval > 0.04 THEN -- just less than an hour \n          l_interval := 0.04;\n        ELSE\n          RAISE; -- overall interval is already too short\n        END IF;\n      END IF;\n\n      l_split := true;\n      l_last_interval := false;\n      l_prev_ts := l_min_ts;\n      l_next_ts := l_prev_ts + l_interval;\n    END;\n  END LOOP;\n\n  UPDATE mgmt_ocm_upl_props\n     SET ts_value = l_max_ts\n   WHERE name = 'changes_ts';\n\n  COMMIT;\nEXCEPTION WHEN OTHERS THEN\n\n  MGMT_LOG.LOG_ERROR('GCHARVESTER', -202, \n    'Encountered a problem during history-based updates: ' ||\n      SQLCODE || ': ' || SQLERRM,\n    v_log_level_in =>  MGMT_GLOBAL.G_ERROR); \n  RAISE;\n\nEND;\n";
            }
            return "DECLARE\n  l_min_ts DATE := NULL;\n  l_max_ts DATE := NULL;\n  l_prev_ts DATE := NULL;\n  l_next_ts DATE := NULL;\n  l_overall_interval NUMBER; -- overall number of days\n  l_interval_div_by_4 NUMBER; -- above number divided by 4\n  l_interval NUMBER := 1; -- number of days (used to split overall interval)\n  l_split BOOLEAN := false; -- are we splitting into intervals?\n  l_last_interval BOOLEAN := true; -- are we processing last interval?\nBEGIN\n  BEGIN\n    SELECT ts_value INTO l_min_ts\n      FROM mgmt_ocm_upl_props\n     WHERE name = 'changes_ts';\n  EXCEPTION WHEN NO_DATA_FOUND THEN\n    raise_application_error(-20000, \n      'Internal error: last update timestamp is unavailable to history-based code');\n  END;\n\n  -- select current timestamp minus 10 minutes (assumption: ECM history computation\n  -- should be done within 10 minutes of when it starts)\n  l_max_ts := sysdate - 1 / (24 * 6);\n\n  l_prev_ts := l_min_ts;\n  l_next_ts := l_max_ts;\n  LOOP -- over intervals\n    BEGIN\n\n      -- update mgmt_ocm_upl_metrics with changes in the l_prev_ts to l_next_ts interval\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n        SELECT DISTINCT s.target_name as target_name, s.target_type ,\n                        s.snapshot_type, null as addl_target_info, h.table_name\n        from EM_ECM_ALL_CONFIG_METRICS a,\n             mgmt_ecm_gen_snapshot s,\n             mgmt_ocm_upl_md_tbls  h\n        where\n             --addl_target_info should never be null for these wls target types\n             --so not considering for this query\n             h.TARGET_TYPE not in ('weblogic_domain', 'weblogic_cluster',\n                               'oracle_ias_farm', 'j2ee_application') and\n             h.TARGET_TYPE = s.TARGET_TYPE and\n             h.snapshot_type = s.snapshot_type and\n             a.ecm_snapshot_id = s.SNAPSHOT_GUID and\n             s.is_current in ('Y', 'P') and\n             h.table_name = a.table_name and\n             a.collection_timestamp > l_prev_ts and\n             a.collection_timestamp <= l_next_ts\n        ) t\n          ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- Fix for bug#9980503\n      -- MGMT_ECM_ASSOCIATIONS is a periodically collected metric for weblogic_j2eeserver target.\n      -- Adding the following query to minimize the time lag in collecting the MGMT_ECM_ASSOCIATIONS metric which would otherwise be collected periodically i.e 30 days\n      -- Following query would enable the MGMT_ECM_ASSOCIATIONS metric collection when there is any change in the existing server cofiguration\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n         SELECT DISTINCT s.target_name  as target_name, 'weblogic_j2eeserver' as target_type,\n                'weblogic_j2eeserver_config' as snapshot_type,  null as addl_target_info,\n                'MGMT_ECM_ASSOCIATIONS' as table_name\n          from mgmt_ecm_gen_snapshot s\n           where s.target_type = 'weblogic_j2eeserver' and\n                 s.snapshot_type = 'weblogic_j2eeserver_config' and\n                  s.is_current in ('Y', 'P') and\n                   exists (select 'x' from EM_ECM_ALL_CONFIG_METRICS a\n                               where a.ecm_snapshot_id = s.SNAPSHOT_GUID and\n                                     a.collection_timestamp > l_prev_ts and\n                                     a.collection_timestamp <= l_next_ts\n                           )\n\n         ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null \n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- weblogic_domain/weblogic_cluster/j2ee_application targets depends on weblogic server target for snapshot and history as there is no snapshot for domain target in EMGC\n      -- First get the new weblogic server target or for which snapshot has chaned, now from targets table get the corresponding\n      -- weblogic server target guid , use the guid to find the domain/cluster/j2ee_application target from assocs table\n      -- and other data from upl_md_table\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT  DISTINCT assocTgt.target_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type,\n                prop.property_value as addl_target_info, h.table_name as table_name\n          FROM  (\n                    SELECT s.target_name  as target_name, s.target_type as target_type\n                      from mgmt_ecm_gen_snapshot s\n                     where s.target_type = 'weblogic_j2eeserver' and\n                           s.snapshot_type = 'weblogic_j2eeserver_config' and\n                           s.is_current in ('Y', 'P') and\n                           exists\n                              (select 'x' from EM_ECM_ALL_CONFIG_METRICS a\n                               where a.ecm_snapshot_id = s.SNAPSHOT_GUID and\n                                     a.collection_timestamp > l_prev_ts and\n                                     a.collection_timestamp <= l_next_ts\n                               )\n\n                ) new_wlserver,\n                  mgmt_targets assocTgt, mgmt_targets server, mgmt_ocm_upl_md_tbls h, mgmt_target_assocs tgtAssocs,\n                  mgmt_target_properties prop, mgmt_targets domain, mgmt_target_assocs domainAssocs\n        WHERE  server.target_name = new_wlserver.target_name\n           AND  server.target_type = new_wlserver.target_type\n           AND  tgtAssocs.assoc_target_guid = server.target_guid\n           AND  assocTgt.target_guid = tgtAssocs.source_target_guid\n           AND  assocTgt.target_type in ('weblogic_domain', 'weblogic_cluster', 'j2ee_application')\n           AND  h.target_type = assocTgt.target_type\n           AND  h.snapshot_type in ('weblogic_domain_config', 'weblogic_cluster_config', 'j2ee_application_config')\n           AND  domainAssocs.source_target_guid = server.target_guid\n           AND  domain.target_guid = domainAssocs.assoc_target_guid\n           AND  prop.target_guid = domain.target_guid\n           AND  prop.property_name = 'WebLogicHome'\n           AND  prop.property_value is not null\n\n          ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- oracle_ias_farm target has an association with weblogic domain target\n      -- weblogic domain target depends on weblogic server target for snapshot and history as there is no snapshot for domain target in EMGC\n      -- First get the new weblogic server target or for which snapshot has chaned, then get the corresponding domain target from the assocs table.\n      -- finally use the domain target guid to find the oracle ias farm target from assocs table\n      -- and other data from upl_md_table\n      -- For oracle_ias_farm target we are only collecting association with the wl adminserver target.\n      -- The association with the wl adminserver target will not change if there are any config changes for the wlserver target.\n      -- So we are not collecting data for oracle_ias_farm target when there are changes to the wlserver.\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        WITH tbls AS\n        (SELECT /*+ materialize */ table_name\n         FROM mgmt_ocm_upl_md_tbls\n         WHERE target_Type = 'oracle_ias_farm'\n           AND snapshot_type = 'oracle_ias_farm_config')\n\n        SELECT  DISTINCT farm.target_name as target_name, 'oracle_ias_farm' as target_type, 'oracle_ias_farm_config' as snapshot_type,\n                prop.property_value as addl_target_info, h.table_name as table_name\n          FROM  ( SELECT s.target_name  as target_name, s.target_type as target_type\n                      from mgmt_ecm_gen_snapshot s\n                     where s.target_type = 'weblogic_j2eeserver' and\n                           s.snapshot_type = 'weblogic_j2eeserver_config' and\n                           s.is_current in ('Y', 'P') and\n                           exists\n                              (select 'x' from EM_ECM_ALL_CONFIG_METRICS a\n                               where a.ecm_snapshot_id = s.SNAPSHOT_GUID and\n                                     a.collection_timestamp > l_prev_ts and\n                                     a.collection_timestamp <= l_next_ts\n                               )\n\n                ) new_wlserver,\n                  mgmt_targets domain, mgmt_targets server, tbls h, mgmt_target_assocs tgtAssocs, mgmt_target_properties prop,\n                  mgmt_targets farm, mgmt_target_assocs farmAssoc\n         WHERE  server.target_name = new_wlserver.target_name\n           AND  server.target_type = new_wlserver.target_type\n           AND  tgtAssocs.source_target_guid = server.target_guid\n           AND  domain.target_guid = tgtAssocs.assoc_target_guid\n           AND  domain.target_type = 'weblogic_domain'\n           AND  farmAssoc.assoc_target_guid = domain.target_guid\n           AND  farm.target_guid = farmAssoc.source_target_guid\n           AND  farm.target_type = 'oracle_ias_farm'\n           AND  prop.target_guid = domain.target_guid\n           AND  prop.property_name = 'WebLogicHome'\n           AND  prop.property_value is not null\n\n          ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      --insert for Periodic metric for the target, first time when target is added\n      insert into mgmt_ocm_upl_metrics \n       (target_name, target_type, snapshot_type, table_name, addl_target_info)\n      SELECT DISTINCT s.target_name as target_name, s.target_type ,s.snapshot_type, h.table_name,  null as addl_target_info\n         from mgmt_ecm_gen_snapshot s,\n               mgmt_ocm_upl_md_tbls  h\n         where h.kind = 2 and\n               --addl_target_info should never be null for thee wls target types\n               --so not considering for this query\n               h.target_type not in ('weblogic_domain', 'weblogic_cluster',\n                               'oracle_ias_farm', 'j2ee_application') and \n               s.target_type = h.target_type and\n               s.snapshot_type = h.snapshot_type and \n               s.is_current in('Y','P') and\n               s.START_TIMESTAMP > l_prev_ts and\n               s.START_TIMESTAMP <= l_next_ts and\n           not exists (\n             select 'x' from mgmt_ocm_upl_metrics m\n              where m.target_name = s.target_name and\n                    m.target_type = s.target_type and\n                    m.snapshot_type = s.snapshot_type and\n                    m.table_name = h.table_name\n           );\n       COMMIT;\n\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n        SELECT DISTINCT tg.target_name as target_name, tg.target_type ,\n                        'OCheck' as snapshot_type, null as addl_target_info, \n                        'MGMT_DIAGNOSTIC_CHECK_ROWS' as table_name\n        FROM MGMT_DIAGNOSTIC_CHECK_ROWS d,\n             mgmt_targets tg\n        WHERE tg.target_guid = d.target_guid \n          AND (l_prev_ts is null \n               OR d.collection_timestamp > l_prev_ts)\n          AND d.collection_timestamp <= l_next_ts\n        ) t\n          ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null\n            )\n       WHEN MATCHED THEN \n          UPDATE SET p.last_harvest_ts = l_prev_ts, p.is_changed = 1 \n                 WHERE p.is_changed=0\n       WHEN NOT MATCHED THEN \n            INSERT (target_name, target_type, snapshot_type, table_name, \n                    addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, \n                    t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n\n        MERGE INTO MGMT_OCM_UPL_METRICS P \n        USING \n        (   \n            SELECT DISTINCT \n               T.TARGET_NAME, \n               T.TARGET_TYPE, \n               'oracle_db_adrinfo' AS SNAPSHOT_TYPE, \n               'MGMT_ECM_ADR_INFO' AS TABLE_NAME, \n                NULL AS ADDL_TARGET_INFO \n                FROM EM_ISSUES_INTERNAL PARTITION(OPEN) I \n                JOIN EM_PROBLEM_ISSUE PARTITION(OPEN) P ON P.PROBLEM_ID = I.RELATED_PROBLEM_ID \n                            AND P.OPEN_STATUS = I.OPEN_STATUS \n                            AND P.CLOSED_DATE = I.CLOSED_DATE \n                JOIN EM_EVENTS_INCIDENT PARTITION(OPEN) EI ON EI.INCIDENT_ID = I.ISSUE_ID \n                JOIN MGMT_TARGETS T ON T.TARGET_GUID = EI.TARGET_GUID \n                WHERE I.ISSUE_TYPE = 1 \n                    AND I.IS_ADR_AWARE = 1 \n                    AND T.TARGET_TYPE = 'oracle_database' \n                    AND I.CREATION_DATE >  MGMT_GLOBAL.TO_UTC_DST(l_prev_ts, sessiontimezone) \n                    AND I.CREATION_DATE <= MGMT_GLOBAL.TO_UTC_DST(l_next_ts, sessiontimezone) \n        ) T \n        ON \n        ( \n            P.TARGET_TYPE = T.TARGET_TYPE \n            AND p.target_name = t.target_name \n            AND P.SNAPSHOT_TYPE = T.SNAPSHOT_TYPE \n            AND P.TABLE_NAME = T.TABLE_NAME \n            AND P.ADDL_TARGET_INFO IS NULL \n        )\n        WHEN MATCHED THEN        \n            UPDATE SET P.LAST_HARVEST_TS = L_PREV_TS, P.IS_CHANGED = 1 WHERE P.IS_CHANGED=0\n        WHEN NOT MATCHED THEN         \n            INSERT (TARGET_NAME, TARGET_TYPE, SNAPSHOT_TYPE, TABLE_NAME, ADDL_TARGET_INFO, LAST_HARVEST_TS, IS_CHANGED ) \n            VALUES (T.TARGET_NAME, T.TARGET_TYPE, T.SNAPSHOT_TYPE, t.table_name, t.addl_target_info, L_PREV_TS, 1); \n\n        COMMIT;\n\n        -- SCN Info: Add entry in MGMT_OCM_UPL_METRICS for new target  \n        MERGE INTO MGMT_OCM_UPL_METRICS P \n        USING \n        (   \n              SELECT DISTINCT \n                  T.TARGET_NAME, \n                  T.TARGET_TYPE, \n                  H.SNAPSHOT_TYPE , \n                  H.TABLE_NAME, \n                  NULL AS ADDL_TARGET_INFO \n              FROM MGMT_TARGETS T, MGMT_OCM_UPL_MD_TBLS H\n                  WHERE T.TARGET_TYPE = H.TARGET_TYPE\n                  AND  H.SNAPSHOT_TYPE = 'oracle_db_adrinfo'\n                  AND T.TARGET_TYPE = 'oracle_database' \n                  AND H.TABLE_NAME='MGMT_ECM_SCN_INFO'\n        ) T \n        ON \n        ( \n            P.TARGET_TYPE = T.TARGET_TYPE \n            AND P.TARGET_NAME = T.TARGET_NAME \n            AND P.SNAPSHOT_TYPE = T.SNAPSHOT_TYPE \n            AND P.TABLE_NAME = T.TABLE_NAME \n            AND P.ADDL_TARGET_INFO IS NULL \n        )\n        WHEN NOT MATCHED THEN         \n            INSERT (TARGET_NAME, TARGET_TYPE, SNAPSHOT_TYPE, TABLE_NAME, ADDL_TARGET_INFO, LAST_HARVEST_TS ) \n            VALUES (T.TARGET_NAME, T.TARGET_TYPE, T.SNAPSHOT_TYPE, t.table_name, t.addl_target_info, add_months(sysdate , -12) ); \n\n        COMMIT;        \n\n      IF (NOT l_split) OR l_last_interval THEN\n        EXIT;\n      ELSE -- split is on and this was not the last interval\n        l_prev_ts := l_next_ts;\n        l_next_ts := l_next_ts + l_interval;\n        IF l_next_ts >= l_max_ts THEN\n          l_next_ts := l_max_ts;\n          l_last_interval := true;\n        END IF;\n      END IF;\n\n    EXCEPTION WHEN OTHERS THEN\n      -- did we already try to split?\n      IF l_split THEN \n        IF l_interval > 0.04 THEN\n          -- last try: attempt minimal interval\n          l_interval := 0.04;\n        ELSE -- already tried minimal interval\n          RAISE;\n        END IF;\n      ELSE -- had not tried to split yet\n        -- split interval: try to split into at least 4 parts\n        -- but no more than one day and no less than about an hour each.\n        l_overall_interval := l_max_ts - l_min_ts;\n        l_interval_div_by_4 := l_overall_interval / 4;\n        IF l_interval_div_by_4 >= 1 THEN -- 1 day\n          l_interval := 1;\n        ELSIF l_interval_div_by_4 >= 0.5 THEN -- 12 hours\n          l_interval := 0.5;\n        ELSIF l_interval_div_by_4 >= 0.25 THEN -- 6 hours\n          l_interval := 0.25;\n        ELSIF l_interval_div_by_4 >= 0.125 THEN -- 3 hours\n          l_interval := 1/8;\n        ELSIF l_overall_interval > 0.04 THEN -- just less than an hour \n          l_interval := 0.04;\n        ELSE\n          RAISE; -- overall interval is already too short\n        END IF;\n      END IF;\n\n      l_split := true;\n      l_last_interval := false;\n      l_prev_ts := l_min_ts;\n      l_next_ts := l_prev_ts + l_interval;\n    END;\n  END LOOP;\n\n  UPDATE mgmt_ocm_upl_props\n     SET ts_value = l_max_ts\n   WHERE name = 'changes_ts';\n\n  COMMIT;\nEXCEPTION WHEN OTHERS THEN\n\n  MGMT_LOG.LOG_ERROR('GCHARVESTER', -202, \n    'Encountered a problem during history-based updates: ' ||\n      SQLCODE || ': ' || SQLERRM,\n    v_log_level_in =>  MGMT_GLOBAL.G_ERROR); \n  RAISE;\n\nEND;\n";
        }
        if (string.equals("FIXUP_METRICS_SQL")) {
            if (bl) {
                return "DECLARE \n  BATCH_SIZE CONSTANT NUMBER := 512;\n\n  l_prev_idx NUMBER := 1; -- previous index (inclusive)\n  l_next_idx NUMBER := l_prev_idx + BATCH_SIZE; -- next index (exclusive)\n  l_max_idx NUMBER := 1;\n  l_ignore_all_targets VARCHAR2(256):= 'FALSE';\nBEGIN\n\n  begin\n     select upper(str_value) \n        into l_ignore_all_targets \n       from mgmt_ocm_upl_props \n      where name = 'ignore_all_if_not_marked';\n   Exception \n     WHEN NO_DATA_FOUND THEN\n       l_ignore_all_targets := 'FALSE';\n  end;\n\n  SELECT max(idx) INTO l_max_idx FROM mgmt_ocm_upl_metrics_tmp;\n\n  WHILE l_prev_idx <= l_max_idx LOOP -- for each batch of EM targets\n\n    -- delete targets that no longer exist\n    DELETE FROM mgmt_ocm_upl_metrics m \n     WHERE EXISTS (\n             SELECT * \n               FROM mgmt_ocm_upl_metrics_tmp t\n              WHERE t.IDX >= l_prev_idx AND t.IDX < l_next_idx\n                AND t.target_name = m.target_name\n                -- skip GVM targets as they do not exists as targets in EM\n                AND t.target_type != 'oracle_vm_guest'\n                AND t.target_type != 'oracle_vm_server_host'\n                AND t.target_type = m.target_type)\n       AND NOT EXISTS (\n             SELECT *\n               FROM mgmt_targets tgt \n              WHERE m.target_name = tgt.target_name\n                AND m.target_type = tgt.target_type);\n\n    COMMIT;\n\n    -- delete no longer existing Oracle homes on hosts in the batch\n    DELETE FROM mgmt_ocm_upl_metrics m \n     WHERE m.target_type = 'host'\n       AND m.addl_target_info IS NOT NULL\n       AND EXISTS (\n             SELECT * \n               FROM mgmt_ocm_upl_metrics_tmp t\n              WHERE t.IDX >= l_prev_idx AND t.IDX < l_next_idx\n                AND t.target_name = m.target_name\n                AND t.target_type = m.target_type)\n       AND NOT EXISTS (\n             SELECT *\n               FROM mgmt_ecm_snapshot s, mgmt_inv_container c\n              WHERE s.target_name = m.target_name\n                AND s.target_type = m.target_type\n                AND s.snapshot_type = 'host_configuration'\n                AND s.is_current = 'Y'\n                AND s.snapshot_guid = c.snapshot_guid\n                AND c.container_location = m.addl_target_info);\n\n    COMMIT;\n\n    FOR home IN -- get homes with missing metrics\n      (SELECT target_name, addl_target_info\n        FROM (SELECT /*+ LEADING(T)  USE_NL(T,M) INDEX(M MGMT_OCM_UPL_METRICS_UK) */ \n                      m.target_name, m.addl_target_info, COUNT(*) metric_count\n                 FROM mgmt_ocm_upl_metrics_tmp t, mgmt_ocm_upl_metrics m\n                WHERE t.IDX >= l_prev_idx AND t.IDX < l_next_idx\n                  AND t.target_name = m.target_name\n                  AND t.target_type = m.target_type\n                  AND t.target_type = 'host'\n                  AND m.addl_target_info IS NOT NULL\n                  GROUP BY m.target_name, m.addl_target_info)\n       WHERE metric_count < 3)\n    LOOP\n      -- insert missing metric rows\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (SELECT 'ECM$HIST_INV_COMPONENTS' as table_name FROM DUAL \n               UNION ALL SELECT 'ECM$HIST_INV_PATCHES' FROM DUAL\n               UNION ALL SELECT 'ECM$HIST_INV_PATCHSETS' FROM DUAL) h\n         ON (p.target_type = 'host'\n        AND p.target_name = home.target_name\n        AND p.snapshot_type = 'host_configuration'\n        AND p.table_name = h.table_name)\n       WHEN MATCHED THEN UPDATE SET p.is_changed = p.is_changed \n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (home.target_name, 'host', 'host_configuration', h.table_name, home.addl_target_info);\n    END LOOP;\n\n    COMMIT;\n\n    --delete target marked to be ignored\n    if(l_ignore_all_targets = 'TRUE')\n    then\n      --delete all the target except for those not marked\n      -- to ignore\n      DELETE FROM mgmt_ocm_upl_metrics m\n        WHERE NOT EXISTS (\n              select 'X' from\n                     mgmt_ocm_upl_metrics_tmp t,\n                     mgmt_target_prop_defs d,\n                     mgmt$target_properties p\n              WHERE  t.IDX >= l_prev_idx AND\n                     t.IDX < l_next_idx AND\n                     t.target_name = m.target_name AND\n                     t.target_type = m.target_type and\n                     p.target_name = t.target_name and\n                     p.target_type = t.target_type and\n                     p.property_name = d.property_name and\n                     p.property_value = 'false' and\n                     p.target_type = d.target_type and\n                     d.property_display_name = 'Harvester Ignore' and\n                     d.property_name like 'udtp%'\n        );\n\n        commit;\n\n    else\n        --delete the targets marked to ignore\n        DELETE FROM mgmt_ocm_upl_metrics m\n        WHERE EXISTS (\n              select 'X' from \n                     mgmt_ocm_upl_metrics_tmp t,\n                     mgmt_target_prop_defs d, \n                     mgmt$target_properties p \n              WHERE  t.IDX >= l_prev_idx AND \n                     t.IDX < l_next_idx AND \n                     t.target_name = m.target_name AND\n                     t.target_type = m.target_type and\n                     p.target_name = t.target_name and \n                     p.target_type = t.target_type and \n                     p.property_name = d.property_name and \n                     p.property_value = 'true' and \n                     p.target_type = d.target_type and \n                     d.property_display_name = 'Harvester Ignore' and \n                     d.property_name like 'udtp%' \n        );\n\n        commit;\n    end if;\n\n    l_prev_idx := l_next_idx;  \n    l_next_idx := l_next_idx + BATCH_SIZE;\n\n  END LOOP; -- for each target batch\nEND;\n";
            }
            return "DECLARE \n  BATCH_SIZE CONSTANT NUMBER := 512;\n\n  l_prev_idx NUMBER := 1; -- previous index (inclusive)\n  l_next_idx NUMBER := l_prev_idx + BATCH_SIZE; -- next index (exclusive)\n  l_max_idx NUMBER := 1;\n  l_ignore_all_targets VARCHAR2(256):= 'FALSE';\nBEGIN\n\n  begin\n     select upper(str_value)\n        into l_ignore_all_targets\n       from mgmt_ocm_upl_props\n      where name = 'ignore_all_if_not_marked';\n   Exception\n     WHEN NO_DATA_FOUND THEN\n       l_ignore_all_targets := 'FALSE';\n  end;\n\n  SELECT max(idx) INTO l_max_idx FROM mgmt_ocm_upl_metrics_tmp;\n\n  WHILE l_prev_idx <= l_max_idx LOOP -- for each batch of EM targets\n\n    -- delete targets that no longer exist\n    DELETE FROM mgmt_ocm_upl_metrics \n    WHERE (target_name,target_type) IN\n       (SELECT t.target_name, t.target_type \n        FROM mgmt_ocm_upl_metrics_tmp t                      \n        WHERE t.IDX >= l_prev_idx AND t.IDX < l_next_idx\n        AND NOT EXISTS (SELECT * FROM mgmt_targets tgt             \n                        WHERE t.target_type=tgt.target_type\n                        AND  t.target_name=tgt.target_name) );\n    COMMIT;\n\n    delete  FROM MGMT_OCM_UPL_METRICS UM \n    WHERE 1=1\n    AND TARGET_TYPE = 'rac_database' \n    AND SNAPSHOT_TYPE = 'orcl_tp_config' \n    AND TABLE_NAME ='MGMT_ECM_ASSOCIATIONS' \n    AND not EXISTS \n    (\n    SELECT 1\n      FROM MGMT_OCM_UPL_METRICS_TMP UMT \n      JOIN MGMT_TARGETS src  ON src.TARGET_NAME = UMT.TARGET_NAME AND src.TARGET_TYPE = UMT.TARGET_TYPE\n      JOIN GC_ASSOC_INSTANCES RAC2DB ON RAC2DB.SOURCE_ME_GUID = SRC.TARGET_GUID \n      JOIN MGMT_TARGETS DEST  ON DEST.TARGET_GUID= RAC2DB.DEST_ME_GUID \n      WHERE  1=1\n      AND UMT.IDX >= L_PREV_IDX AND UMT.IDX < L_NEXT_IDX\n      AND UMT.TARGET_TYPE = UM.TARGET_TYPE\n      AND UMT.TARGET_NAME = UM.TARGET_NAME\n      --AND UMT.TARGET_TYPE='rac_database'\n      AND RAC2DB.ASSOC_TYPE = 'deployed_on' \n      AND DEST.TARGET_TYPE    ='oracle_dbmachine' \n    );\n\n    COMMIT;\n\n\n    --delete target marked to be ignored\n    if(l_ignore_all_targets = 'TRUE')\n    then\n      --delete all the target except for those not marked\n      -- to ignore\n      DELETE FROM mgmt_ocm_upl_metrics m\n        WHERE NOT EXISTS (\n              select 'X' from\n                     mgmt_ocm_upl_metrics_tmp t,\n                     mgmt_target_prop_defs d,\n                     mgmt$target_properties p\n              WHERE  t.IDX >= l_prev_idx AND\n                     t.IDX < l_next_idx AND\n                     t.target_name = m.target_name AND\n                     t.target_type = m.target_type and\n                     p.target_name = t.target_name and\n                     p.target_type = t.target_type and\n                     p.property_name = d.property_name and\n                     p.property_value = 'false' and\n                     p.target_type = d.target_type and\n                     d.property_display_name = 'Harvester Ignore' and\n                     d.property_name like 'udtp%'\n        );\n\n        commit;\n\n    else\n        --delete the targets marked to ignore\n        DELETE FROM mgmt_ocm_upl_metrics m\n        WHERE EXISTS (\n              select 'X' from\n                     mgmt_ocm_upl_metrics_tmp t,\n                     mgmt_target_prop_defs d,\n                     mgmt$target_properties p\n              WHERE  t.IDX >= l_prev_idx AND\n                     t.IDX < l_next_idx AND\n                     t.target_name = m.target_name AND\n                     t.target_type = m.target_type and\n                     p.target_name = t.target_name and\n                     p.target_type = t.target_type and\n                     p.property_name = d.property_name and\n                     p.property_value = 'true' and\n                     p.target_type = d.target_type and\n                     d.property_display_name = 'Harvester Ignore' and\n                     d.property_name like 'udtp%'\n        );\n\n        commit;\n    end if;\n\n    l_prev_idx := l_next_idx;  \n    l_next_idx := l_next_idx + BATCH_SIZE;\n\n  END LOOP; -- for each target batch\nEND;\n";
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface JobResultStatus {
        public static final int SUCCESS = 0;
        public static final int OLD_OMS_VERSION = 1;
        public static final int OCM_IN_DISCONNECTED_MODE = 2;
        public static final int OCM_IS_STOPPED = 3;
    }
}

