/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.sysman.ccr.collector.collectionMgr.CollectionList;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.gcharvester.HarvesterEMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterJobUtils;
import oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterSnapshotMD;
import oracle.sysman.ccr.gcharvester.OVMGuestVMHarvester;
import oracle.sysman.ccr.gcharvester.OVMServerHarvester;
import oracle.sysman.ccr.gcharvester.OVMServerHostHarvester;
import oracle.sysman.ccr.gcharvester.OVMServerPoolHarvester;
import oracle.sysman.ccr.gcharvester.QueryInfo;
import oracle.sysman.ccr.gcharvester.targettype.HarvesterTargetTypeDAO;
import oracle.sysman.ccr.gcharvester.targettype.HarvesterTargetTypeDO;
import oracle.sysman.ccr.gcharvester.targettype.TargetMetadataUtil;
import oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergedTargetTypeInfo;
import oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergenceUtil;
import oracle.sysman.ccr.gcharvester.ti.bi.BIClusterControllerUnconvergedHarvester;
import oracle.sysman.ccr.gcharvester.ti.bi.BIInstanceUnconvergedHarvester;
import oracle.sysman.ccr.gcharvester.ti.bi.BIJavaHostUnconvergedHarvester;
import oracle.sysman.ccr.gcharvester.ti.bi.BIPresentationServicesUnconvergedHarvester;
import oracle.sysman.ccr.gcharvester.ti.bi.BISchedulerUnconvergedHarvester;
import oracle.sysman.ccr.gcharvester.ti.bi.BIServerUnconvergedHarvester;
import oracle.sysman.ccr.gcharvester.ti.common.ConvergedTargetTypeManager;
import oracle.sysman.ccr.gcharvester.ti.database.RacDatabaseUtil;
import oracle.sysman.ccr.gcharvester.ti.exadata.ClusterGrpHarvester;
import oracle.sysman.ccr.gcharvester.ti.exadata.DbmachineHarvester;
import oracle.sysman.ccr.gcharvester.ti.exadata.ExadataGridHarvester;
import oracle.sysman.ccr.gcharvester.ti.exadata.ExadataHarvester;
import oracle.sysman.ccr.gcharvester.ti.idm.IdmDipHarvester;
import oracle.sysman.ccr.gcharvester.ti.idm.IdmOidHarvester;
import oracle.sysman.ccr.gcharvester.ti.idm.IdmOifHarvester;
import oracle.sysman.ccr.gcharvester.ti.idm.IdmOvdHarvester;
import oracle.sysman.ccr.gcharvester.ti.siebel.SiebelCompGroupHarvester;
import oracle.sysman.ccr.gcharvester.ti.siebel.SiebelCompHarvester;
import oracle.sysman.ccr.gcharvester.ti.siebel.SiebelEnterpriseHarvester;
import oracle.sysman.ccr.gcharvester.ti.siebel.SiebelGatewayHarvester;
import oracle.sysman.ccr.gcharvester.ti.siebel.SiebelServerHarvester;
import oracle.sysman.ccr.gcharvester.ti.test.HarvesterTestTargetType;
import oracle.sysman.ccr.gcharvester.ti.weblogic.FarmHarvester;
import oracle.sysman.ccr.gcharvester.ti.weblogic.J2eeApplicationHarvester;
import oracle.sysman.ccr.gcharvester.ti.weblogic.WLClusterHarvester;
import oracle.sysman.ccr.gcharvester.ti.weblogic.WLDomainHarvester;
import oracle.sysman.ccr.gcharvester.ti.weblogic.WLServerHarvester;
import oracle.sysman.ccr.gcharvester.util.GCHarvesterEnv;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import oracle.sysman.eml.ecm.track.TrackUtilities;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class HarvesterMetadata {
    private static final Category s_log = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$HarvesterMetadata == null ? (class$oracle$sysman$ccr$gcharvester$HarvesterMetadata = HarvesterMetadata.class$("oracle.sysman.ccr.gcharvester.HarvesterMetadata")) : class$oracle$sysman$ccr$gcharvester$HarvesterMetadata).getName());
    private static HarvesterMetadata s_metadata = null;
    public static final int MAJOR_VERSION = 8;
    public static final int MINOR_VERSION = 0;
    private HashMap m_snapshots = new HashMap();
    private HashMap m_targetTypes = new HashMap();
    private HashMap m_snapshotsPerTargetType = new HashMap();
    private static final String KEY_SEPARATOR = ":::";
    public static final String AGENT_DATE_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    private static final String TARGET_VERSION_METRIC = "ECM_TARGET_VERSIONS";
    private static final String MGMT_TARGET_VERSION_METRIC = "MGMT_ECM_TARGET_VERSIONS";
    static final String PATCH_COMP_OCM_NAME = "PatchedComponent";
    static final String HOME_INFO_OCM_NAME = "HomeInfo";
    static final String UPI_COLUMN_NAME_OR_NULL = "t1.upi-column-name-or-NULL";
    static final String ONEOFFS_METRIC_NAME = "Patch";
    static final String VIRTUAL_COMPUTER_METRIC_NAME = "OVMVirtualComputer";
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$HarvesterMetadata;

    private HarvesterMetadata() throws HarvesterException {
        HarvesterSnapshotMD harvesterSnapshotMD = new HarvesterSnapshotMD("host", "host_configuration", "host", "ll_host_config");
        String string = "ECM$HIST_HARDWARE";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ECM_HW", new String[]{"mgmt_ecm_snapshot", string}, new String[]{"hostname", "domain", "vendor_name", "system_config", "machine_architecture", "clock_freq_in_mhz", "memory_size_in_mb", "local_disk_space_in_gb", null, "cpu_count", null, "cpu_board_count", "iocard_count", null, null, null, null, null, null, null})}));
        string = "ECM$HIST_CPU_DETAILS";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ECM_HW_CPU", new String[]{"mgmt_ecm_snapshot", string}, new String[]{null, "vendor_name", "freq_in_mhz", "ecache_in_mb", "impl", "revision", "mask", null})}));
        string = "ECM$HIST_IOCARD_DETAILS";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ECM_HW_IOCARD", new String[]{"mgmt_ecm_snapshot", string}, new String[]{null, "vendor_name", "name", "freq_in_mhz", "bus", "revision"})}));
        string = "ECM$HIST_NIC_DETAILS";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ECM_HW_NIC", new String[]{"mgmt_ecm_snapshot", string}, new String[]{"name", "flags", "max_transfer_unit", "inet_address", null, "mask", "broadcast_address", "mac_address", "hostname_aliases", null, null, null})}));
        string = "ECM$HIST_OS_SUMMARY";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ECM_OS", new String[]{"mgmt_ecm_snapshot", string}, new String[]{"name", "vendor_name", "base_version", "update_level", "distributor_version", "max_swap_space_in_mb", "address_length_in_bits", null, null, null, null, "(COALESCE(   (     SELECT       (         CASE           /* sample Itanium/IA64 machine showed              this hw.system_config collected:              Intel Itanium processor family              GenuineIntel Itanium 2 */           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%WINDOWS%'           AND t1.address_length_in_bits = '64-bit'          AND NLS_UPPER(hw.system_config) LIKE           '%ITANIUM%'             THEN 208           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%WINDOWS%'           AND t1.address_length_in_bits = '64-bit'            THEN 233           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%WINDOWS%'             /* no evidence of 64 bit itanium or x86,                assume 32 bit */             THEN 912           ELSE NULL         END)     FROM       mgmt_targets t,       ecm$hist_hardware hw     WHERE       t.target_name   = s.target_name     AND t.target_type = 'host'     AND s.snapshot_guid = t1.ecm_snapshot_id     AND s.snapshot_guid = hw.ecm_snapshot_id   )   ,  /* non-windows - try first by aru platform id */  (SELECT  DECODE(cp.property_value,    2, DECODE(t1.address_length_in_bits,             '64-bit', 59, cp.property_value), 319, DECODE(t1.address_length_in_bits,             '64-bit', 212, cp.property_value), 46, DECODE(t1.address_length_in_bits,             '64-bit', 226, cp.property_value), 276, DECODE(t1.address_length_in_bits,             '64-bit', 277, cp.property_value), 168, DECODE(t1.address_length_in_bits,             '64-bit', 24, cp.property_value), 453, DECODE(t1.address_length_in_bits,             '64-bit', 23, cp.property_value), 173, DECODE(t1.address_length_in_bits,             '64-bit', 267, cp.property_value), 211, DECODE(t1.address_length_in_bits,              '64-bit', 209, cp.property_value),      cp.property_value)  FROM mgmt_inv_container c,      mgmt_inv_container_property cp  WHERE c.snapshot_guid = s.snapshot_guid  AND cp.container_guid = c.container_guid  AND cp.property_name = 'ARU_PLATFORM_ID'  AND cp.property_value IS NOT NULL  AND ROWNUM = 1   )   ,  /* non-windows - try next by oui platform id */  (SELECT  DECODE(c.oui_platform,  610, DECODE(t1.address_length_in_bits,             '64-bit', 212, c.oui_platform),  87,      87, 197,     197,   2, DECODE(t1.address_length_in_bits,             '64-bit', 59, c.oui_platform), 211,     209, 227,     227,  30,      30,  90,      93, 110,     214,  46, DECODE(t1.address_length_in_bits,             '64-bit', 226, c.oui_platform), 453, DECODE(t1.address_length_in_bits,             '64-bit', 23, c.oui_platform),  23,      23, 173, DECODE(t1.address_length_in_bits,             '64-bit', 267, c.oui_platform), 918,     501, 162,     612, 295,     724,          NULL)  FROM mgmt_inv_container c  WHERE c.snapshot_guid = s.snapshot_guid  AND c.oui_platform IS NOT NULL  AND ROWNUM = 1   )   ,   /* non-windows - try next by OS category prop */   (     SELECT       (         CASE           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%LINUX%'           AND t1.address_length_in_bits = '64-bit'            THEN 226           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%LINUX%'             /* no evidence of 64 bit, assume 32 */             THEN 46           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%SOLARIS%'           AND t1.address_length_in_bits = '64-bit'            THEN 23           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%SOLARIS%'             /* no evidence of 64 bit, assume 32 */             THEN 453           ELSE NULL         END)     FROM       mgmt_targets t     WHERE       t.target_name   = s.target_name     AND t.target_type = 'host'   )   ,   /* non-windows - try next by OS name */   (     SELECT       (         CASE           WHEN NLS_UPPER(sw.name) LIKE '%LINUX%'           AND sw.address_length_in_bits = '64-bit'            THEN 226           WHEN NLS_UPPER(sw.name) LIKE '%LINUX%'             /* no evidence of 64 bit, assume 32 */             THEN 46           WHEN (NLS_UPPER(sw.name) LIKE '%SOLARIS%'           OR NLS_UPPER(sw.name) LIKE '%SUNOS%')           AND sw.address_length_in_bits = '64-bit'            THEN 23           WHEN (NLS_UPPER(sw.name) LIKE '%SOLARIS%'           OR NLS_UPPER(sw.name) LIKE '%SUNOS%')             /* no evidence of 64 bit, assume 32 */             THEN 453           ELSE NULL         END)     FROM       ecm$hist_os_summary sw     WHERE       s.snapshot_guid = sw.ecm_snapshot_id   )   ,  /* use -999 if platform id unknown */  -999))"})}));
        string = "ECM$HIST_OS_COMPONENTS";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ECM_OS_COMPONENT", new String[]{"mgmt_ecm_snapshot", string}, new String[]{"name", "type", "(NVL(t1.version, 'N/A'))", "(TO_CHAR(t1.installation_date, 'YYYY-MM-DD HH24:MI:SS'))", null})}));
        string = "ECM$HIST_FS_MOUNT_DETAILS";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ECM_OS_FILESYSTEM", new String[]{"mgmt_ecm_snapshot", string}, new String[]{"resource_name", "mount_location", "type", "mount_options", null, null, null})}));
        string = "ECM$HIST_OS_PROPERTIES";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ECM_OS_PROPERTY", new String[]{"mgmt_ecm_snapshot", string}, new String[]{"type", "name", "value"})}));
        string = "ECM$HIST_OS_REGISTERED_SW";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ECM_OS_REGISTERED_SW", new String[]{"mgmt_ecm_snapshot", string}, new String[]{null, "name", "vendor_name", "(NVL(t1.version, 'N/A'))", "(TO_CHAR(t1.installation_date, 'YYYY-MM-DD HH24:MI:SS'))", "installed_location", "description", "vendor_software_specific_info"})}));
        this.addSnapshotMD(harvesterSnapshotMD);
        harvesterSnapshotMD = new HarvesterSnapshotMD("oracle_home", "oracle_home_config", "oracle_home", "oracle_home_config");
        string = "ECM$HIST_INV_COMPONENTS";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("Component", new String[]{"mgmt_ecm_snapshot", string}, new String[]{"name", "(NVL(t1.version, 'N/A'))", null, "(TO_CHAR(t1.timestamp, 'YYYY-MM-DD HH24:MI:SS'))", "is_top_level", "external_name", "description", "languages", "installed_location", "installer_version", "min_deinstaller_version"}, true), new HarvesterOCMMetricMD("ComponentDependency"), new HarvesterOCMMetricMD("VersionedPatch"), new HarvesterOCMMetricMD(PATCH_COMP_OCM_NAME), new HarvesterOCMMetricMD(HOME_INFO_OCM_NAME)}));
        string = "ECM$HIST_INV_PATCHES";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(ONEOFFS_METRIC_NAME, new String[]{"mgmt_ecm_snapshot", string}, new String[]{"id", UPI_COLUMN_NAME_OR_NULL, null, "(TO_CHAR(t1.timestamp, 'YYYY-MM-DD HH24:MI:SS'))", "is_rollbackable"}, true), new HarvesterOCMMetricMD(PATCH_COMP_OCM_NAME), new HarvesterOCMMetricMD("PatchFixedBug")}));
        string = "ECM$HIST_INV_PATCHSETS";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("Patchset", new String[]{"mgmt_ecm_snapshot", string}, new String[]{"name", "(NVL(t1.version, 'N/A'))", "(TO_CHAR(t1.timestamp, 'YYYY-MM-DD HH24:MI:SS'))", "external_name", "description", null, null, "min_deinstaller_version"}, true)}));
        this.addSnapshotMD(harvesterSnapshotMD);
        HarvesterSnapshotMD harvesterSnapshotMD2 = new HarvesterSnapshotMD("oracle_database", "oracle_storage", "oracle_database", "oracle_db_adrinfo");
        string = "MGMT_ECM_SCN_INFO";
        HarvesterEMMetricMD harvesterEMMetricMD = new HarvesterEMMetricMD(string, 2, 7.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "scn_info";
            }

            public String getQuery() {
                return "SELECT 1,2,3,4,5,6,7,SYSDATE,SYSDATE,10 FROM DUAL UNION SELECT 1,2,3,4,5,6,7,SYSDATE,SYSDATE,10 FROM MGMT_TARGETS WHERE 1=2 AND TARGET_NAME = :tn  AND TARGET_TYPE = :tt ";
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 10;
            }
        })});
        harvesterSnapshotMD2.addEMMetricMD(harvesterEMMetricMD);
        this.addSnapshotMD(harvesterSnapshotMD2);
        HarvesterSnapshotMD harvesterSnapshotMD3 = new HarvesterSnapshotMD("oracle_database", "oracle_dbconfig", "oracle_database", "oracle_dbconfig");
        HarvesterSnapshotMD harvesterSnapshotMD4 = new HarvesterSnapshotMD("rac_database", "oracle_racconfig", "rac_database", "oracle_racconfig");
        string = "MGMT_DB_CONTROLFILES_ECM";
        HarvesterEMMetricMD harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("db_controlfiles", new String[]{null, string}, new String[]{"file_name", "status", "(TO_CHAR(t1.creation_date, 'YYYY-MM-DD HH24:MI:SS'))", null, null, null})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_DB_DATAFILES_ECM";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("db_datafiles", new String[]{null, string}, new String[]{"file_name", "status", "tablespace_name", null, "autoextensible", "increment_by", "max_file_size", null, null})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_DB_DBNINSTANCEINFO_ECM";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("db_dbNInstanceInfo", new String[]{null, string}, new String[]{"database_name", "global_name", "banner", "host_name", "instance_name", "(TO_CHAR(t1.startup_time, 'YYYY-MM-DD HH24:MI:SS'))", "logins", "log_mode", "open_mode", "characterset", "national_characterset", "default_temp_tablespace", null, null, null, "(SELECT property_value FROM mgmt_target_properties WHERE target_guid = (SELECT target_guid FROM mgmt_targets WHERE target_name = s.target_name AND target_type   = s.target_type ) AND property_name='DBVersion' )", null, null})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_DB_FEATUREUSAGE";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("db_feature_usage")});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_DB_INIT_PARAMS_ECM";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("db_init_params", new String[]{null, string}, new String[]{"name", "value", "isdefault"})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_DB_LICENSE_ECM";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("db_license", new String[]{null, string}, new String[]{"sessions_max", "sessions_warning", null, "sessions_highwater", "users_max"})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_DB_OPTIONS_ECM";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("db_options", new String[]{null, string}, new String[]{"name", "selected"})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_DB_REDOLOGS_ECM";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("db_redoLogs", new String[]{null, string}, new String[]{"group_num", null, "members", "file_name", null, "logsize", null, null, null, "thread_num"})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_DB_ROLLBACK_SEGS_ECM";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("db_rollback_segs", new String[]{null, string}, new String[]{"rollname", "status", "tablespace_name", "extents", null, "initial_size", "next_size", "maximum_extents", "minimum_extents", "pct_increase", "optsize", "aveactive", "wraps", "shrinks", "aveshrink", null})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_DB_SGA_ECM";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("db_sga", new String[]{null, string}, new String[]{"sganame", "sgasize"})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_DB_TABLESPACES_ECM";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("db_tablespaces", new String[]{null, string}, new String[]{"tablespace_name", "status", "contents", "extent_management", "allocation_type", "logging", null, "initial_ext_size", "next_extent", "increment_by", "max_extents", null, "min_extents", "min_extlen", "segment_space_management", "block_size", "bigfile"})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_HA_INFO_ECM";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ha_info", new String[]{null, string}, new String[]{"dbid", "log_mode", "force_logging", "database_role", "flashback_on"})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(harvesterEMMetricMD2);
        string = "MGMT_HA_RMAN_CONFIG_ECM";
        harvesterEMMetricMD2 = new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ha_rman_config", new String[]{null, string}, new String[]{"name", "value"})});
        harvesterSnapshotMD3.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(harvesterEMMetricMD2);
        harvesterSnapshotMD4.addEMMetricMD(RacDatabaseUtil.getAssocMetric());
        this.addSnapshotMD(harvesterSnapshotMD3);
        this.addSnapshotMD(harvesterSnapshotMD4);
        harvesterSnapshotMD = new HarvesterSnapshotMD("oracle_ias", "oracle_ias_config", "oracle_ias", "oracle_ias_config");
        string = "MGMT_IAS_CONFIGFILES";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ConfigFiles", new String[]{null, string}, new String[]{"displayfilepath", "filepath", null, "(TO_CHAR(t1.modificationtime, 'YYYY-MM-DD HH24:MI:SS'))"})}));
        string = "MGMT_IAS_CONSOLECONFIG";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("ConsoleConfig", new String[]{null, string}, new String[]{"agentprotocol", "agenthost", "agentport", "agentpath", "consoleprotocol", "consolehost", "consoleport"})}));
        string = "MGMT_IAS_DCMCONFIG";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("DCMConfig", new String[]{null, string}, new String[]{"repositorytype"})}));
        string = "MGMT_IAS_DEPLOYEDAPPS";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("DeployedApps", new String[]{null, string}, new String[]{"oc4jinstancename", "applicationname"})}));
        string = "MGMT_IAS_GENERAL";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("General", new String[]{null, string}, new String[]{"installtype", "infrastructuredbname", "version"})}));
        string = "MGMT_IAS_OPMNCONFIG";
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD(string, 1, 0.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD("OPMNConfig", new String[]{null, string}, new String[]{"requestport", "remoteport", "localport", "usessl", "onsloglevel", "processmanagerloglevel"})}));
        this.addSnapshotMD(harvesterSnapshotMD);
        this.addSnapshotMD(SiebelCompGroupHarvester.createSiebelCompGroupSnapshotMD());
        this.addSnapshotMD(SiebelCompHarvester.createSiebelCompSnapshotMD());
        this.addSnapshotMD(SiebelEnterpriseHarvester.createSiebelEnterpriseSnapshotMD());
        this.addSnapshotMD(SiebelGatewayHarvester.createSiebelGatewaySnapshotMD());
        this.addSnapshotMD(SiebelServerHarvester.createSiebelServerSnapshotMD());
        this.addSnapshotMD(OVMServerHarvester.createOVMVSSnapshotMD());
        this.addSnapshotMD(OVMServerHostHarvester.createOVMVSHostSnapshotMD());
        this.addSnapshotMD(OVMGuestVMHarvester.createOVMGuestMachineSnapshotMD());
        this.addSnapshotMD(OVMServerPoolHarvester.createOVMPoolSnapshotMD());
        this.addSnapshotMD(WLServerHarvester.createWLSnapshotMD());
        this.addSnapshotMD(WLDomainHarvester.createWLDomainSnapshotMD());
        this.addSnapshotMD(WLClusterHarvester.createWLClusterSnapshotMD());
        this.addSnapshotMD(FarmHarvester.createFarmSnapshotMD());
        this.addSnapshotMD(J2eeApplicationHarvester.createJ2eeApplicationSnapshotMD());
        this.addSnapshotMD(IdmDipHarvester.createIDMDIPSnapshotMD());
        this.addSnapshotMD(IdmOifHarvester.createIDMOIFSnapshotMD());
        this.addSnapshotMD(IdmOidHarvester.createIDMOIDSnapshotMD());
        this.addSnapshotMD(IdmOvdHarvester.createIDMOVDSnapshotMD());
        this.addSnapshotMD(BIInstanceUnconvergedHarvester.createBIInstanceSnapshotMD());
        this.addSnapshotMD(BIJavaHostUnconvergedHarvester.createBIJavaHostSnapshotMD());
        this.addSnapshotMD(BIPresentationServicesUnconvergedHarvester.createBIPresentationServicesSnapshotMD());
        this.addSnapshotMD(BISchedulerUnconvergedHarvester.createBISchedulerSnapshotMD());
        this.addSnapshotMD(BIServerUnconvergedHarvester.createBIServerSnapshotMD());
        this.addSnapshotMD(BIClusterControllerUnconvergedHarvester.createBIClusterControllerSnapshotMD());
        if (!GCVersion.pre11_1GC()) {
            this.addSnapshotMD(ExadataHarvester.createExadataSnapshotMD());
        }
        if (!GCVersion.pre11_2GC()) {
            this.addSnapshotMD(DbmachineHarvester.createDbmachineSnapshotMD());
            this.addSnapshotMD(ExadataGridHarvester.createExadataGridSnapshotMD());
            this.addSnapshotMD(ClusterGrpHarvester.createClusterGrpSnapshotMD());
        }
    }

    public static synchronized HarvesterMetadata getInstance(OracleConnection oracleConnection) throws HarvesterException {
        if (s_metadata == null) {
            s_metadata = new HarvesterMetadata();
            if (GCHarvesterEnv.isTestEnv()) {
                s_metadata.addSnapshotMD(HarvesterTestTargetType.getTestSnapshot());
            }
            s_metadata.initializeConvergedTargetTypes(oracleConnection);
        }
        return s_metadata;
    }

    private void initializeConvergedTargetTypes(OracleConnection oracleConnection) throws HarvesterException {
        if (GCVersion.pre11_2GC()) {
            return;
        }
        List list = ConvergenceUtil.getListOfCovergedTargetTypes((Connection)oracleConnection);
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            this.replaceOrAddConvergedTargetType(string, oracleConnection);
        }
    }

    public HarvesterTargetTypeDO getHarvesterTargetType(String string) {
        return (HarvesterTargetTypeDO)this.m_targetTypes.get(string);
    }

    public void replaceOrAddConvergedTargetType(String string, OracleConnection oracleConnection) throws HarvesterException {
        int n;
        ConvergedTargetTypeInfo convergedTargetTypeInfo = ConvergedTargetTypeManager.getConvergedTargetTypeInfo(string);
        List list = convergedTargetTypeInfo.getHarvesterSnapshotMDs((Connection)oracleConnection);
        if (list == null && list.isEmpty()) {
            s_log.error((Object)("Converged target type " + string + " has no HarvesterSnapshotMD. " + "Ignoring this converged target type and will continue with GC Harvesting with older " + "unconverged definition of the target type (if any)."));
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = this.m_snapshots.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            HarvesterSnapshotMD harvesterSnapshotMD = (HarvesterSnapshotMD)this.m_snapshots.get(string2);
            String string3 = harvesterSnapshotMD.getHarvesterTargetType();
            String string4 = harvesterSnapshotMD.getOCMTargetType();
            if (!string3.equals(string) || !string4.equals(string)) continue;
            arrayList.add(string2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.m_snapshots.remove((String)arrayList.get(n));
        }
        for (n = 0; n < list.size(); ++n) {
            this.addSnapshotMD((HarvesterSnapshotMD)list.get(n), true, convergedTargetTypeInfo.hasFakeOracleHome((Connection)oracleConnection), convergedTargetTypeInfo.hasFakeHost((Connection)oracleConnection));
        }
    }

    private boolean addSnapshotMD(HarvesterSnapshotMD harvesterSnapshotMD) throws HarvesterException {
        return this.addSnapshotMD(harvesterSnapshotMD, false, false, false);
    }

    private boolean addSnapshotMD(HarvesterSnapshotMD harvesterSnapshotMD, boolean bl, boolean bl2, boolean bl3) throws HarvesterException {
        if (harvesterSnapshotMD == null) {
            throw new IllegalArgumentException("GC OCM Harvester: null parameter passed to HarvesterMetadata.addSnapshotMD method");
        }
        if (!GCVersion.pre11_2GC()) {
            this.addTargetVersionMetricIfRequired(harvesterSnapshotMD);
        }
        HarvesterTargetTypeDO harvesterTargetTypeDO = new HarvesterTargetTypeDO(harvesterSnapshotMD.getHarvesterTargetType(), bl, bl2, bl3);
        this.m_targetTypes.put(harvesterSnapshotMD.getHarvesterTargetType(), harvesterTargetTypeDO);
        return null != this.m_snapshots.put(harvesterSnapshotMD.getHarvesterTargetType() + KEY_SEPARATOR + harvesterSnapshotMD.getHarvesterSnapshotType(), harvesterSnapshotMD);
    }

    public void addTargetVersionMetricIfRequired(HarvesterSnapshotMD harvesterSnapshotMD) throws HarvesterException {
        String string = harvesterSnapshotMD.getOCMTargetType();
        String string2 = harvesterSnapshotMD.getOCMSnapshotType();
        try {
            CollectionList collectionList = new CollectionList(string);
            if (collectionList != null) {
                for (int i = 0; i < collectionList.size(); ++i) {
                    oracle.sysman.ccr.collector.collectionMgr.Collection collection = (oracle.sysman.ccr.collector.collectionMgr.Collection)collectionList.get(i);
                    if (!collection.getCollectionName().equals(string2)) continue;
                    Vector vector = collection.getMetrics();
                    Iterator iterator = vector.iterator();
                    while (iterator.hasNext()) {
                        if (!iterator.next().equals(TARGET_VERSION_METRIC)) continue;
                        this.processMetadataCheckForTargetVersionMetric(harvesterSnapshotMD, string);
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "Failed to get default collection file for this targettype which is " + string + fileNotFoundException.getMessage();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("GC OCM Harvester: " + string3));
            }
        }
        catch (Exception exception) {
            String string4 = "Failed to get collection data" + string + exception.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string4));
            throw new HarvesterException(string4, exception);
        }
    }

    private HarvesterEMMetricMD getPeriodicEMMetricForTargetVersion() {
        HarvesterEMMetricMD harvesterEMMetricMD = new HarvesterEMMetricMD(MGMT_TARGET_VERSION_METRIC, 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return HarvesterMetadata.TARGET_VERSION_METRIC;
            }

            public String getQuery() {
                return "select target_version from gc$global_target_properties where target_name = :tn and target_type = :tt and target_version is not null";
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 1;
            }
        })});
        return harvesterEMMetricMD;
    }

    private void processMetadataCheckForTargetVersionMetric(HarvesterSnapshotMD harvesterSnapshotMD, String string) {
        HarvesterEMMetricMD harvesterEMMetricMD;
        TargetMetadata targetMetadata = TargetMetadataUtil.getTargetMetadata(string);
        if (targetMetadata.getMetric(TARGET_VERSION_METRIC) != null && (harvesterEMMetricMD = harvesterSnapshotMD.getEMMetricMD(MGMT_TARGET_VERSION_METRIC)) == null) {
            HarvesterEMMetricMD harvesterEMMetricMD2 = this.getPeriodicEMMetricForTargetVersion();
            harvesterSnapshotMD.addEMMetricMD(harvesterEMMetricMD2);
        }
    }

    HarvesterSnapshotMD getSnapshotMD(String string, String string2) {
        return (HarvesterSnapshotMD)this.m_snapshots.get(string + KEY_SEPARATOR + string2);
    }

    static int compareVersionVsRepository(OracleConnection oracleConnection) throws HarvesterException {
        int[] nArray = HarvesterMetadata.getRepositoryMetadataVersion(oracleConnection);
        if (nArray == null) {
            return 100;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        if (n == 8) {
            if (n2 == 0) {
                return 0;
            }
            return n2 > 0 ? -1 : 1;
        }
        return n > 8 ? -2 : 2;
    }

    public void populateNewTargetsInRepository(OracleConnection oracleConnection) throws HarvesterException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall(HarvesterJobUtils.getQuery("ADD_TARGETS_FOR_NEW_TT"));
            oracleCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                String string = "Failed to add new targets to repository for OCM uploads: " + sQLException.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string));
                throw new HarvesterException(string, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(oracleCallableStatement);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)oracleCallableStatement);
    }

    public void populateRepository(OracleConnection oracleConnection) throws HarvesterException {
        String string;
        Object object;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("BEGIN EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_md_tbls';  EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_periodic_full'; END;");
            oracleCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                String string2 = "Failed to clear metadata tables before [re]populating them: " + sQLException.getMessage();
                s_log.error((Object)("GC OCM Harvester: " + string2));
                throw new HarvesterException(string2, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(oracleCallableStatement);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)oracleCallableStatement);
        boolean bl = GCVersion.pre11_1GC();
        Collection collection = this.m_snapshots.values();
        float f = 0.0f;
        if (collection != null && (object = collection.iterator()) != null) {
            while (object.hasNext()) {
                Object object2;
                Iterator iterator;
                HarvesterSnapshotMD harvesterSnapshotMD = (HarvesterSnapshotMD)object.next();
                string = harvesterSnapshotMD.getHarvesterTargetType();
                String string3 = harvesterSnapshotMD.getHarvesterSnapshotType();
                Set set = harvesterSnapshotMD.getMetricNames();
                boolean bl2 = false;
                if (("oracle_vm_server".equals(string) || "oracle_vm_server_pool".equals(string) || "oracle_vm_guest".equals(string) || "oracle_vm_server_host".equals(string)) && bl) {
                    bl2 = true;
                }
                if (("weblogic_domain".equals(string) || "weblogic_j2eeserver".equals(string) || "weblogic_cluster".equals(string) || "j2ee_application".equals(string) || "oracle_ias_farm".equals(string)) && bl) {
                    bl2 = true;
                }
                if (("oracle_eps_server".equals(string) || "oracle_federation".equals(string) || "oracle_ldap".equals(string) && "oracle_ldap_11g_config".equals(string3) || "oracle_ovd".equals(string)) && bl) {
                    bl2 = true;
                }
                if (set == null) {
                    bl2 = true;
                }
                if ("oracle_home".equals(string) && (GCVersion.pre11_2GC() || !ConvergenceUtil.isConverged(string, (Connection)oracleConnection))) {
                    bl2 = true;
                }
                if (!bl2 && (iterator = set.iterator()) != null) {
                    object2 = new ArrayList();
                    ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        HarvesterEMMetricMD harvesterEMMetricMD = harvesterSnapshotMD.getEMMetricMD(string4);
                        int n = harvesterEMMetricMD.getKind();
                        ((ArrayList)object2).add(new Object[]{string, string3, string4, new Integer(n)});
                        if (n != 2) continue;
                        f = harvesterEMMetricMD.getCollectionFrequency();
                        arrayList.add(new Object[]{string, string3, string4, "" + f});
                    }
                    boolean bl3 = false;
                    try {
                        if (!((ArrayList)object2).isEmpty()) {
                            TrackUtilities.executePreparedStatement((OracleConnection)oracleConnection, (String)"INSERT /*+ APPEND */ INTO mgmt_ocm_upl_md_tbls  (target_type, snapshot_type, table_name, kind)  VALUES (?, ?, ?, ?) ", (int[])new int[]{1, 1, 1, 2}, (ArrayList)object2, null, null, (boolean)true);
                            bl3 = true;
                        }
                        if (!arrayList.isEmpty()) {
                            TrackUtilities.executePreparedStatement((OracleConnection)oracleConnection, (String)"INSERT /*+ APPEND */ INTO mgmt_ocm_upl_periodic_full  (target_type, snapshot_type, table_name, period)  VALUES (?, ?, ?, ?) ", (int[])new int[]{1, 1, 1, 1}, arrayList, null, null, (boolean)true);
                        }
                    }
                    catch (Exception exception) {
                        String string5 = "Failed to populate " + (bl3 ? "periodic" : "overall") + " table: " + exception.getMessage();
                        s_log.error((Object)("GC OCM Harvester: " + string5));
                        Object object3 = bl3 ? arrayList : object2;
                        s_log.error((Object)"GC OCM Harvester: Parameters: ");
                        if (object3 == null) {
                            s_log.error((Object)"none");
                        } else {
                            int n = ((ArrayList)object3).size();
                            for (int i = 0; i < n; ++i) {
                                s_log.error((Object)Arrays.asList((Object[])((ArrayList)object3).get(i)).toString());
                            }
                        }
                        throw new HarvesterException(string5, exception);
                    }
                }
                try {
                    oracleConnection.commit();
                }
                catch (SQLException sQLException) {
                    object2 = "Failed to commit connection while populating metadata: " + sQLException.getMessage();
                    s_log.error((Object)("GC OCM Harvester: " + (String)object2));
                    throw new HarvesterException((String)object2, sQLException);
                }
            }
        }
        object = new ArrayList(1);
        ((ArrayList)object).add(new Object[]{new Integer(8), new Integer(8), new Integer(0), new Integer(0)});
        try {
            TrackUtilities.executeCallableStatement((OracleConnection)oracleConnection, (String)"BEGIN\n\n  MERGE INTO mgmt_ocm_upl_props p\n  USING dual \n     ON ( name = 'major_version' )\n   WHEN MATCHED THEN UPDATE SET p.num_value = ?\n   WHEN NOT MATCHED THEN INSERT (name, num_value)\n        VALUES ('major_version', ?);\n\n  MERGE INTO mgmt_ocm_upl_props p\n  USING dual \n     ON ( name = 'minor_version' )\n   WHEN MATCHED THEN UPDATE SET p.num_value = ?\n   WHEN NOT MATCHED THEN INSERT (name, num_value)\n        VALUES ('minor_version', ?);\n\n   COMMIT;\n\nEND;\n", (int[])new int[]{2, 2, 2, 2}, (Object[])new Object[]{new Integer(8), new Integer(8), new Integer(0), new Integer(0)}, (int)0);
        }
        catch (Exception exception) {
            string = "Failed to populate version information after populating metadata tables: " + exception.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string));
            throw new HarvesterException(string, exception);
        }
        if (!GCVersion.pre11_2GC()) {
            HarvesterTargetTypeDAO.insertOrUpdateTargetTypes(this.m_targetTypes, (Connection)oracleConnection);
        }
    }

    static int[] getRepositoryMetadataVersion(OracleConnection oracleConnection) throws HarvesterException {
        ArrayList arrayList;
        try {
            arrayList = TrackUtilities.executePreparedStatement((OracleConnection)oracleConnection, (String)"SELECT (SELECT num_value FROM mgmt_ocm_upl_props WHERE name = 'major_version'),    (SELECT num_value FROM mgmt_ocm_upl_props WHERE name = 'minor_version')   FROM dual ", null, null, (int[])new int[]{2, 2}, (int[])new int[]{0, 0}, (boolean)false);
        }
        catch (Exception exception) {
            String string = "Failed to get repository metadata version for OCM upload metadata: " + exception.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string));
            throw new HarvesterException(string, exception);
        }
        if (arrayList == null || arrayList.isEmpty()) {
            String string = "Failed to get repository metadata version for OCM upload metadata: no rows returned but expected exactly 1 row with version information.";
            s_log.error((Object)("GC OCM Harvester: " + string));
            throw new HarvesterException(string);
        }
        Integer n = (Integer)((Object[])arrayList.get(0))[0];
        Integer n2 = (Integer)((Object[])arrayList.get(0))[1];
        if (n == null || n2 == null) {
            return null;
        }
        return new int[]{n, n2};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface VersionCompareResult {
        public static final int SAME = 0;
        public static final int MAJOR_SAME_MINOR_GREATER_THAN_REP = 1;
        public static final int MAJOR_GREATER_THAN_REP = 2;
        public static final int MAJOR_SAME_MINOR_LESS_THAN_REP = -1;
        public static final int MAJOR_LESS_THAN_REP = -2;
        public static final int REP_IS_NOT_SET = 100;
    }
}

