/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

import oracle.sysman.ccr.gcharvester.QueryInfo;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import org.apache.log4j.Category;

public class HarvesterOCMMetricMD {
    private static final Category s_log = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$HarvesterOCMMetricMD == null ? (class$oracle$sysman$ccr$gcharvester$HarvesterOCMMetricMD = HarvesterOCMMetricMD.class$("oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD")) : class$oracle$sysman$ccr$gcharvester$HarvesterOCMMetricMD).getName());
    private static final String TABLE1_PREFIX = "t1.";
    private static final String TABLE2_PREFIX = "t2.";
    private static final String OPEN_PAREN = "(";
    private static final String AGENT_DATE_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    private String m_name;
    private String m_emToOcmQuery;
    private int m_emToOcmQueryParamLayout;
    private int m_ocmColumnCount;
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$HarvesterOCMMetricMD;

    public HarvesterOCMMetricMD(String string, String[] stringArray, String[] stringArray2) {
        this(string, stringArray, stringArray2, false, null, null);
    }

    public HarvesterOCMMetricMD(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        this(string, stringArray, stringArray2, true, null, null);
    }

    public HarvesterOCMMetricMD(String string, String[] stringArray, String[] stringArray2, String string2) {
        this(string, stringArray, stringArray2, false, string2, null);
    }

    public HarvesterOCMMetricMD(String string, String[] stringArray, String[] stringArray2, String string2, String string3) {
        this(string, stringArray, stringArray2, false, string2, string3);
    }

    public HarvesterOCMMetricMD(String string, String[] stringArray, String[] stringArray2, boolean bl, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("GC OCM Harvester: invalid parameter passed to HarvesterOCMMetricMD constructor");
        }
        this.m_name = string;
        this.m_ocmColumnCount = stringArray2.length;
        this.generateSql(stringArray, stringArray2, bl, string2, string3);
    }

    public HarvesterOCMMetricMD(QueryInfo queryInfo) {
        if (queryInfo == null) {
            throw new IllegalArgumentException("GC OCM Harvester: invalid parameter passed to HarvesterOCMMetricMD constructor(QueryInfo)");
        }
        if (queryInfo.getParameterLayout() < 1 || queryInfo.getParameterLayout() > 8) {
            throw new IllegalArgumentException("GC OCM Harvester: Incorrect value of QueryInfo.getParameterLayout()");
        }
        this.m_name = queryInfo.getMetricName();
        this.m_emToOcmQuery = queryInfo.getQuery();
        this.m_emToOcmQueryParamLayout = queryInfo.getParameterLayout();
        this.m_ocmColumnCount = queryInfo.getColumnCount();
    }

    public HarvesterOCMMetricMD(String string) {
        if (string == null) {
            throw new IllegalArgumentException("GC OCM Harvester: invalid parameter passed to HarvesterOCMMetricMD constructor(String)");
        }
        this.m_name = string;
        if ("ComponentDependency".equals(string)) {
            this.generateComponentDepsMetricQuery();
        } else if ("VersionedPatch".equals(string)) {
            this.generateVersionedPatchesMetricQuery();
        } else if ("db_feature_usage".equals(string)) {
            this.generateDbFeatureUsageMetricQuery();
        } else if ("PatchedComponent".equals(string)) {
            this.generatePatchCompMetricQuery();
        } else if ("PatchFixedBug".equals(string)) {
            this.generatePatchBugFixMetricQuery();
        } else if ("HomeInfo".equals(string)) {
            this.generateHomeInfoMetricQuery();
        } else if ("OVMVirtualServerPoolDetails".equals(string)) {
            this.generateOVMVSPDetailsMetricQuery();
        } else if ("OVMVspVmAssoc".equals(string)) {
            this.generateOVMVspVmAssocQuery();
        } else if ("OVMGvmHostAssoc".equals(string)) {
            this.generateOVMGvmHostAssocQuery();
        } else if ("OVMVsAssoc".equals(string)) {
            this.generateOVMVsAssocQuery();
        } else if ("weblogic_domain_assocs".equals(string)) {
            this.m_name = "ECM_ASSOCIATIONS";
            this.generateWLDomainAssocQuery();
        } else if ("weblogic_server_assocs".equals(string)) {
            this.m_name = "ECM_ASSOCIATIONS";
            this.generateWLServerAssocQuery();
        } else if ("weblogic_cluster_assocs".equals(string)) {
            this.m_name = "ECM_ASSOCIATIONS";
            this.generateWLClusterAssocQuery();
        } else if ("oracle_ias_farm_assocs".equals(string)) {
            this.m_name = "ECM_ASSOCIATIONS";
            this.generateFarmAssocQuery();
        } else if ("IAS_FARM_CONFIG".equals(string)) {
            this.generateFarmConfigQuery();
        } else if ("j2ee_application_assocs".equals(string)) {
            this.m_name = "ECM_ASSOCIATIONS";
            this.generateJ2eeAppAssocQuery();
        } else if ("Application".equals(string)) {
            this.generateApplicationQuery();
        } else if ("dip_assocs".equals(string)) {
            this.m_name = "ECM_ASSOCIATIONS";
            this.generateDIPAssocQuery();
        } else if ("DIPAdminServerJMX".equals(string)) {
            this.generateDIPAdminSvrQuery();
        } else if ("DIPWebApp".equals(string)) {
            this.m_name = "Application";
            this.generateDIPWebApplicationQuery();
        } else if ("oif_assocs".equals(string)) {
            this.m_name = "ECM_ASSOCIATIONS";
            this.generateOIFAssocQuery();
        } else if ("OIFAdminServerJMX".equals(string)) {
            this.generateOIFAdminSvrQuery();
        } else if ("OIFWebApp".equals(string)) {
            this.m_name = "Application";
            this.generateOIFWebApplicationQuery();
        } else if ("oid_assocs".equals(string)) {
            this.m_name = "ECM_ASSOCIATIONS";
            this.generateOIDAssocQuery();
        } else if ("OIDAdminServerJMX".equals(string)) {
            this.generateOIDAdminSvrQuery();
        } else if ("ovd_assocs".equals(string)) {
            this.m_name = "ECM_ASSOCIATIONS";
            this.generateOVDAssocQuery();
        } else if ("OVDAdminServerJMX".equals(string)) {
            this.generateOVDAdminSvrQuery();
        }
    }

    String getName() {
        return this.m_name;
    }

    String getEmToOcmQuery() {
        return this.m_emToOcmQuery;
    }

    void setEmToOcmQuery(String string) {
        this.m_emToOcmQuery = string;
    }

    int getEmToOcmQueryParamLayout() {
        return this.m_emToOcmQueryParamLayout;
    }

    int getOcmColumnCount() {
        return this.m_ocmColumnCount;
    }

    private void generateSql(String[] stringArray, String[] stringArray2, boolean bl, String string, String string2) {
        int n;
        if (string != null) {
            if (string.equals("oracle_vm_guest") && GCVersion.pre11_2GC()) {
                this.generateOVMGuestMetricQuery(stringArray, stringArray2);
                return;
            }
            if ((string.equals("oracle_vm_server") || string.equals("oracle_vm_server_host")) && string2 != null && GCVersion.pre11_2GC()) {
                this.generateOVMServerMetricQuery(stringArray, stringArray2, string2);
                return;
            }
        }
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append(string3);
            string3 = ", ";
            if (null != stringArray2[i]) {
                if (!(stringArray2[i].startsWith(TABLE1_PREFIX) || stringArray2[i].startsWith(OPEN_PAREN) || stringArray2[i].startsWith(TABLE2_PREFIX))) {
                    stringBuffer.append(TABLE1_PREFIX);
                }
                stringBuffer.append(stringArray2[i]);
                continue;
            }
            stringBuffer.append("NULL");
        }
        stringBuffer.append(" FROM ");
        String string4 = "mgmt_ecm_gen_snapshot";
        if (null != stringArray[0] && GCVersion.pre11_2GC()) {
            string4 = stringArray[0];
        }
        stringBuffer.append(string4);
        stringBuffer.append(" s ");
        for (n = 1; n < stringArray.length; ++n) {
            stringBuffer.append(", ");
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" t" + n);
            stringBuffer.append(' ');
        }
        stringBuffer.append("WHERE s.is_current = 'Y' AND s.target_name = :tn AND s.snapshot_type = :st ");
        if (bl) {
            stringBuffer.append("AND s.target_type = 'host' ");
        } else {
            stringBuffer.append("AND s.target_type = :tt ");
        }
        for (n = 1; n < stringArray.length; ++n) {
            stringBuffer.append("AND s.snapshot_guid = ");
            stringBuffer.append(" t" + n);
            stringBuffer.append(".ecm_snapshot_id ");
            if (!bl) continue;
            if (n > 1) {
                stringBuffer.append("AND t1.container_location = ");
            } else {
                stringBuffer.append("AND :hp = ");
            }
            stringBuffer.append(" t" + n);
            stringBuffer.append(".container_location ");
        }
        this.m_emToOcmQuery = "" + stringBuffer;
        this.m_emToOcmQueryParamLayout = 1;
    }

    private void generateComponentDepsMetricQuery() {
        String[] stringArray = new String[]{"r.name AS referencer", "r.version AS ref_version", "d.name AS dependee", "d.version AS dependee_version"};
        this.m_ocmColumnCount = stringArray.length;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            string = ", ";
            if (null != stringArray[i]) {
                stringBuffer.append(stringArray[i]);
                continue;
            }
            stringBuffer.append("NULL");
        }
        stringBuffer.append(" FROM mgmt_ecm_snapshot s,  mgmt_inv_container c,  mgmt_inv_component r,  mgmt_inv_dependency_rule dr,  mgmt_inv_component d WHERE s.target_name    = :tn AND s.target_type        = 'host' AND s.snapshot_type      = 'host_configuration' AND s.is_current         = 'Y' AND c.container_location = :hp AND c.snapshot_guid      = s.snapshot_guid AND r.container_guid     = c.container_guid AND dr.referencer_guid   = r.component_guid AND d.component_guid     = dr.dependee_guid AND d.container_guid     = c.container_guid ");
        this.m_emToOcmQuery = "" + stringBuffer;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateVersionedPatchesMetricQuery() {
        String[] stringArray = new String[]{"vp.name", "vp.version", null, "ps.name as ps_name", "ps.version as ps_version", "(TO_CHAR(vp.timestamp, 'YYYY-MM-DD HH24:MI:SS'))", "vp.external_name", "vp.description", null, "vp.installed_location", null, "vp.min_deinstaller_version"};
        this.m_ocmColumnCount = stringArray.length;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            string = ", ";
            if (null != stringArray[i]) {
                stringBuffer.append(stringArray[i]);
                continue;
            }
            stringBuffer.append("NULL");
        }
        stringBuffer.append(" FROM mgmt_ecm_snapshot s,  mgmt_inv_container h,  mgmt_inv_component c,  mgmt_inv_versioned_patch vp,  mgmt_inv_patchset ps WHERE s.target_name    = :tn AND s.target_type        = 'host' AND s.snapshot_type      = 'host_configuration' AND s.is_current         = 'Y' AND h.container_location = :hp AND h.snapshot_guid      = s.snapshot_guid AND c.container_guid     = h.container_guid AND vp.component_guid    = c.component_guid AND vp.patchset_guid     = ps.patchset_guid (+) ");
        this.m_emToOcmQuery = "" + stringBuffer;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateDbFeatureUsageMetricQuery() {
        String[] stringArray = GCVersion.pre11_2GC() ? new String[]{"dbid", "name", "version", "detected_usages", "total_samples", "currently_used", "(TO_CHAR(t1.first_usage_date, 'YYYY-MM-DD HH24:MI:SS'))", "(TO_CHAR(t1.last_usage_date, 'YYYY-MM-DD HH24:MI:SS'))", "aux_count", "(TO_CHAR(t1.last_sample_date, 'YYYY-MM-DD HH24:MI:SS'))", "last_sample_period", null} : new String[]{"dbid", "name", "version", "detected_usages", "total_samples", "currently_used", "(TO_CHAR(t1.first_usage_date, 'YYYY-MM-DD HH24:MI:SS'))", "(TO_CHAR(t1.last_usage_date, 'YYYY-MM-DD HH24:MI:SS'))", "aux_count", "(TO_CHAR(t1.last_sample_date, 'YYYY-MM-DD HH24:MI:SS'))", "last_sample_period", "feature_info"};
        this.m_ocmColumnCount = stringArray.length;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            string = ", ";
            if (null != stringArray[i]) {
                if (!stringArray[i].startsWith(OPEN_PAREN)) {
                    stringBuffer.append(TABLE1_PREFIX);
                }
                stringBuffer.append(stringArray[i]);
                continue;
            }
            stringBuffer.append("NULL");
        }
        if (GCVersion.pre11_2GC()) {
            stringBuffer.append(" FROM mgmt_db_featureusage t1,\n(SELECT max(dfu.collection_timestamp) max_coll_timestamp , tgt.target_guid target_guid\n FROM mgmt_db_featureusage dfu , mgmt_targets tgt\n WHERE tgt.target_guid = dfu.target_guid \n AND tgt.target_name = :tn\n AND tgt.target_type = :tt \n GROUP BY tgt.target_guid ) temp\nWHERE t1.target_guid = temp.target_guid \nAND t1.collection_timestamp = temp.max_coll_timestamp ");
            this.m_emToOcmQueryParamLayout = 2;
        } else {
            stringBuffer.append(" FROM ( SELECT \ndbid, \nname,\nversion, \nMAX(detected_usages) detected_usages, \nMAX(total_samples) total_samples, \nDECODE (MAX (currently_used_num ), 1, 'TRUE', 'FALSE' ) currently_used, \nmin (first_usage_date) first_usage_date, \nmax ( last_usage_date ) last_usage_date, \nmax (aux_count) aux_count, \nmax (last_sample_date) last_sample_date, \nmax (last_sample_period) last_sample_period, \nmax (to_char (feature_info)) feature_info\nFROM (\n\tSELECT \n\tdbfu.dbid, \n\tdbfu.name, \n\tdbfu.version, \n\tdbfu.detected_usages, \n\tdbfu.total_samples, \n\tdbfu.currently_used, \n\tdbfu.first_usage_date, \n\tdbfu.last_usage_date, \n\tdbfu.aux_count, \n\tdbfu.last_sample_date, \n\tdbfu.last_sample_period, \n\tNULL feature_info,  -- feature_info is not stored\n\ttemp.target_guid, \n\tdecode (dbfu.currently_used,'TRUE', 1, 0) currently_used_num \n\tFROM mgmt_db_featureusage dbfu , \n\t\t(SELECT max(dfu.collection_timestamp) max_coll_timestamp , tgt.target_guid target_guid\n\t\t FROM mgmt_db_featureusage dfu , mgmt_targets tgt\n\t\t WHERE tgt.target_guid = dfu.target_guid \n\t\t AND tgt.target_name = :tn\n\t\t AND tgt.target_type = :tt \n\t\t group by tgt.target_guid ) temp\n\tWHERE \n        dbfu.target_guid = temp.target_guid\n        AND dbfu.collection_timestamp = temp.max_coll_timestamp  -- to get the latest collection data\n\n\tUNION ALL\n\n\tSELECT \n\tdbfu.dbid , \n\tregis.FEATURE_name name,\n\temfu.version ,\n\temfu.DETECTED_SAMPLES detected_usages, \n\temfu.TOTAL_SAMPLES, \n\tdecode (emfu.ISUSED ,1,'TRUE','FALSE') currently_used, \n\tnull first_usage_date, -- first_usage_date not stored\n\temfu.LAST_USAGE_DATE, \n\temfu.AUX_COUNT,\n\temfu.LAST_SAMPLE_DATE, \n\tNULL last_sample_period, -- last_sample_period is not stored\n\temfu.FEATURE_INFO , \n\temfu.target_guid,\n\temfu.ISUSED currently_used_num\n\tFROM mgmt_fu_statistics emfu ,  \n\tmgmt_fu_registrations regis,\n\t\t(SELECT dbf.dbid dbid, temp.target_guid target_guid\n\t\tFROM mgmt_db_featureusage dbf , \n\t\t\t(SELECT max(dfu.collection_timestamp) max_coll_timestamp , tgt.target_guid target_guid\n\t\t\t FROM mgmt_db_featureusage dfu , mgmt_targets tgt\n\t\t\t WHERE tgt.target_guid = dfu.target_guid \n\t\t\t AND tgt.target_name = :tn\n\t\t\t AND tgt.target_type = :tt \n\t\t\t group by tgt.target_guid ) temp\n\t\tWHERE \n\t\tdbf.collection_timestamp = temp.max_coll_timestamp \n\t\tAND ROWNUM = 1 ) dbfu\n\tWHERE \n\tdbfu.target_guid = emfu.target_guid\n\tAND regis.feature_id = emfu.feature_id\n) GROUP BY name , version , dbid\n ) t1 ");
            this.m_emToOcmQueryParamLayout = 6;
        }
        this.m_emToOcmQuery = "" + stringBuffer;
    }

    private void generateOVMVSPDetailsMetricQuery() {
        String[] stringArray = new String[]{"(SELECT property_value FROM mgmt_target_properties p , mgmt_targets t WHERE p.target_guid = t.target_guid AND t.target_name = :tn AND t.target_type   = :tt AND property_name='ha_enabled' )", "(SELECT property_value FROM mgmt_target_properties p , mgmt_targets t WHERE p.target_guid = t.target_guid AND t.target_name = :tn AND t.target_type   = :tt AND property_name='master_vs_name' )", "(SELECT property_value FROM mgmt_target_properties p , mgmt_targets t WHERE p.target_guid = t.target_guid AND t.target_name = :tn AND t.target_type   = :tt AND property_name='master_vip' )"};
        this.m_ocmColumnCount = stringArray.length;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(" FROM dual");
        this.m_emToOcmQuery = "" + stringBuffer;
        this.m_emToOcmQueryParamLayout = 3;
    }

    private void generateOVMGuestMetricQuery(String[] stringArray, String[] stringArray2) {
        int n;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (n = 0; n < stringArray2.length; ++n) {
            stringBuffer.append(string);
            string = ", ";
            if (null != stringArray2[n]) {
                if (!(stringArray2[n].startsWith(TABLE1_PREFIX) || stringArray2[n].startsWith(OPEN_PAREN) || stringArray2[n].startsWith(TABLE2_PREFIX))) {
                    stringBuffer.append(TABLE1_PREFIX);
                }
                stringBuffer.append(stringArray2[n]);
                continue;
            }
            stringBuffer.append("NULL");
        }
        stringBuffer.append(" FROM ");
        if (null != stringArray[0]) {
            stringBuffer.append(stringArray[0]);
        } else {
            stringBuffer.append("mgmt_ecm_gen_snapshot");
        }
        stringBuffer.append(" s ");
        for (n = 1; n < stringArray.length; ++n) {
            stringBuffer.append(", ");
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" t" + n);
            stringBuffer.append(' ');
        }
        stringBuffer.append("WHERE s.is_current = 'Y' AND s.target_name = (select P_VS_TARGET_NAME from mgmt_ovm_gvm_summary WHERE VM_DOMAIN_NAME = :tn AND VM_UUID = (substr(:vcid, instr(:vcid,'_',1,2)+1)) ) AND s.snapshot_type = 'oracle_ovm_vm_config' AND s.target_type = 'oracle_vm_server' ");
        for (n = 1; n < stringArray.length; ++n) {
            stringBuffer.append("AND s.snapshot_guid = ");
            stringBuffer.append(" t" + n);
            stringBuffer.append(".ecm_snapshot_id ");
            if (n != 1) continue;
            stringBuffer.append("AND regexp_substr(:vcid , '[^_APPEND_]+') =  t1.vc_id ");
        }
        this.m_emToOcmQuery = "" + stringBuffer;
        this.m_emToOcmQueryParamLayout = 8;
    }

    private void generateOVMServerMetricQuery(String[] stringArray, String[] stringArray2, String string) {
        int n;
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (n = 0; n < stringArray2.length; ++n) {
            stringBuffer.append(string2);
            string2 = ", ";
            if (null != stringArray2[n]) {
                if (!(stringArray2[n].startsWith(TABLE1_PREFIX) || stringArray2[n].startsWith(OPEN_PAREN) || stringArray2[n].startsWith(TABLE2_PREFIX))) {
                    stringBuffer.append(TABLE1_PREFIX);
                }
                stringBuffer.append(stringArray2[n]);
                continue;
            }
            stringBuffer.append("NULL");
        }
        stringBuffer.append(" FROM ");
        if (null != stringArray[0]) {
            stringBuffer.append(stringArray[0]);
        } else {
            stringBuffer.append("mgmt_ecm_gen_snapshot");
        }
        stringBuffer.append(" s ");
        for (n = 1; n < stringArray.length; ++n) {
            stringBuffer.append(", ");
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" t" + n);
            stringBuffer.append(' ');
        }
        stringBuffer.append("WHERE s.is_current = 'Y' AND s.target_name = :tn AND s.snapshot_type = '" + string + "' " + "AND s.target_type = 'oracle_vm_server' ");
        for (n = 1; n < stringArray.length; ++n) {
            stringBuffer.append("AND s.snapshot_guid = ");
            stringBuffer.append(" t" + n);
            stringBuffer.append(".ecm_snapshot_id ");
        }
        this.m_emToOcmQuery = "" + stringBuffer;
        this.m_emToOcmQueryParamLayout = 5;
    }

    private void generatePatchCompMetricQuery() {
        String[] stringArray = new String[]{"p.id", "'N/A'", "'en'", "ct.name", "DECODE(vp.version, NULL, ct.version, vp.version)"};
        this.m_ocmColumnCount = stringArray.length;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(" FROM mgmt_ecm_snapshot s,   mgmt_inv_patch p,   mgmt_inv_container c,   mgmt_inv_component_patch cp,   mgmt_inv_component ct,   mgmt_inv_versioned_patch vp  WHERE s.target_name      = :tn  AND s.target_type        = 'host'  AND s.snapshot_type      = 'host_configuration'  AND s.is_current         = 'Y'  AND c.container_location = :hp  AND c.snapshot_guid      = s.snapshot_guid  AND c.container_guid     = p.container_guid  AND cp.patch_guid        = p.patch_guid  AND cp.component_guid    = ct.component_guid  AND ct.component_guid    = vp.component_guid(+)");
        this.m_emToOcmQuery = "" + stringBuffer;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generatePatchBugFixMetricQuery() {
        String[] stringArray = new String[]{"p.id", "'N/A'", "'en'", "b.bug_number"};
        this.m_ocmColumnCount = stringArray.length;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(" FROM mgmt_ecm_snapshot s,   mgmt_inv_patch p,   mgmt_inv_container c,   mgmt_inv_patch_fixed_bug b  WHERE s.target_name      = :tn  AND s.target_type        = 'host'  AND s.snapshot_type      = 'host_configuration'  AND s.is_current         = 'Y'  AND c.container_location = :hp  AND c.snapshot_guid      = s.snapshot_guid  AND c.container_guid = p.container_guid  AND b.patch_guid    = p.patch_guid");
        this.m_emToOcmQuery = "" + stringBuffer;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateHomeInfoMetricQuery() {
        String[] stringArray = new String[]{"c.container_location", "c.container_name", null, null, null, "c.is_clonable", null, "  (COALESCE(   /* if windows, return one of three aru platform ids */   (     SELECT       (         CASE           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%WINDOWS%'           AND sw.address_length_in_bits = '32-bit'             /* OS is 32 bit, home must be too */             THEN 912           /* sample Itanium/IA64 machine showed              this hw.system_config collected:              Intel Itanium processor family              GenuineIntel Itanium 2 */           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%WINDOWS%'           AND sw.address_length_in_bits = '64-bit'          AND NLS_UPPER(hw.system_config) LIKE           '%ITANIUM%'           AND (SELECT cp.property_value                FROM mgmt_inv_container_property cp                WHERE cp.container_guid  = c.container_guid                AND cp.property_name   = 'ARU_PLATFORM_ID'                AND cp.property_value IS NOT NULL) IN           /* new/old Itanium 64 (IA64) aru IDs */           ('208', '244', '287', '206')             THEN 208           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%WINDOWS%'           AND sw.address_length_in_bits = '64-bit'          AND NLS_UPPER(hw.system_config) LIKE           '%ITANIUM%'             /* no evidence of 64 bit, assume 32 */             THEN 912           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%WINDOWS%'           AND sw.address_length_in_bits = '64-bit'          AND (SELECT cp.property_value                FROM mgmt_inv_container_property cp                WHERE cp.container_guid  = c.container_guid                AND cp.property_name   = 'ARU_PLATFORM_ID'                AND cp.property_value IS NOT NULL) IN           /* new/old x86-64 (AMD64/EM64T) aru IDs */           ('233', '268', '288', '270', '232')             THEN 233           WHEN NLS_UPPER(t.category_prop_1) LIKE           '%WINDOWS%'             /* no evidence of 64 bit, assume 32 */             THEN 912           ELSE NULL         END)     FROM       mgmt_targets t,       ecm$hist_os_summary sw,       ecm$hist_hardware hw     WHERE       t.target_name   = s.target_name     AND t.target_type = 'host'     AND s.snapshot_guid = sw.ecm_snapshot_id     AND s.snapshot_guid = hw.ecm_snapshot_id     AND s.snapshot_guid = c.snapshot_guid   )   ,   /* non-windows - try next by aru platform id */   (     SELECT       TO_NUMBER(cp.property_value)     FROM       mgmt_inv_container_property cp     WHERE       c.snapshot_guid      = s.snapshot_guid     AND cp.container_guid  = c.container_guid     AND cp.property_name   = 'ARU_PLATFORM_ID'     AND cp.property_value IS NOT NULL   )   ,   /* non-windows - try next by oui platform id */  DECODE(c.oui_platform,  610,     610,  87,      87, 197,     197,   2,       2, 211,     209, 227,     227,  30,      30,  90,      93, 110,     214,  46,      46, 453,     453,  23,      23, 173,     173, 918,     501, 162,     612, 295,     724,          NULL)   ,   /* non-windows - try next by OS category prop */   (     SELECT       (         CASE           WHEN NLS_UPPER(t.category_prop_1) LIKE '%LINUX%'           AND sw.address_length_in_bits = '64-bit'            THEN 226           WHEN NLS_UPPER(t.category_prop_1) LIKE '%LINUX%'             /* no evidence of 64 bit, assume 32 */             THEN 46           WHEN NLS_UPPER(t.category_prop_1) LIKE '%SOLARIS%'           AND sw.address_length_in_bits = '64-bit'            THEN 23           WHEN NLS_UPPER(t.category_prop_1) LIKE '%SOLARIS%'             /* no evidence of 64 bit, assume 32 */             THEN 453           ELSE NULL         END)     FROM       mgmt_targets t,       ecm$hist_os_summary sw     WHERE       t.target_name   = s.target_name     AND t.target_type = 'host'     AND s.snapshot_guid = sw.ecm_snapshot_id   )   ,   /* non-windows - try next by OS name */   (     SELECT       (         CASE           WHEN NLS_UPPER(sw.name) LIKE '%LINUX%'           AND sw.address_length_in_bits = '64-bit'            THEN 226           WHEN NLS_UPPER(sw.name) LIKE '%LINUX%'             /* no evidence of 64 bit, assume 32 */             THEN 46           WHEN (NLS_UPPER(sw.name) LIKE '%SOLARIS%'           OR NLS_UPPER(sw.name) LIKE '%SUNOS%')           AND sw.address_length_in_bits = '64-bit'            THEN 23           WHEN (NLS_UPPER(sw.name) LIKE '%SOLARIS%'           OR NLS_UPPER(sw.name) LIKE '%SUNOS%')             /* no evidence of 64 bit, assume 32 */             THEN 453           ELSE NULL         END)     FROM       ecm$hist_os_summary sw     WHERE       s.snapshot_guid = sw.ecm_snapshot_id   )   ,   /* use -999 if platform id unknown */   -999))"};
        this.m_ocmColumnCount = stringArray.length;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(" FROM mgmt_ecm_snapshot s, mgmt_inv_container c WHERE s.is_current  = 'Y' AND s.target_name   = :tn AND s.snapshot_type = 'host_configuration' AND s.target_type   = 'host' AND s.snapshot_guid = c.snapshot_guid AND c.container_location = :hp");
        this.m_emToOcmQuery = "" + stringBuffer;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateOVMVspVmAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'contains' as ASSOCIATION_TYPE , mas.vm_domain_name as TARGET_NAME,\n        'oracle_vm_guest' as TARGET_TYPE , mas.vm_ovm_id as TARGET_PROPERTY \n FROM mgmt_ovm_gvm_summary gvm , mgmt_virt_vm_master mas\n WHERE gvm.p_vsp_target_name = :tn\n AND gvm.p_vsp_target_type = :tt\n AND gvm.p_vs_target_guid is null\n AND gvm.power_state != 'OPERATION_ERROR'\n AND mas.vm_uuid = gvm.vm_uuid \n AND mas.vm_domain_name = gvm.vm_domain_name\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateOVMGvmHostAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'contains' as ASSOCIATION_TYPE , gvm.target_name as TARGET_NAME,\n        'host' as TARGET_TYPE , cfg.vm_pri_mac_addr as TARGET_PROPERTY\n FROM mgmt_ovm_gvm_summary gvm , mgmt_virt_vm_config cfg\n WHERE gvm.vm_domain_name = :tn\n AND gvm.target_guid is not null\n AND gvm.vm_uuid = cfg.vm_uuid\n AND gvm.power_state != 'OPERATION_ERROR'\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 5;
    }

    private void generateOVMVsAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'contains' as ASSOCIATION_TYPE , mas.vm_domain_name as TARGET_NAME,\n        'oracle_vm_guest' as TARGET_TYPE , mas.vm_ovm_id as TARGET_PROPERTY\n FROM mgmt_ovm_gvm_summary gvm , mgmt_virt_vm_master mas\n WHERE gvm.p_vs_target_name = :tn\n AND gvm.p_vs_target_type = :tt\n AND gvm.p_vs_target_guid is not null\n AND gvm.power_state != 'OPERATION_ERROR'\n AND mas.vm_uuid = gvm.vm_uuid\n AND mas.vm_domain_name = gvm.vm_domain_name\n\nUNION\n\nSELECT 'member_of' as ASSOCIATION_TYPE , t.target_name as TARGET_NAME,\n        'oracle_vm_server_pool' as TARGET_TYPE , p.property_value as TARGET_PROPERTY\n FROM mgmt_targets t, mgmt_target_properties p, mgmt_ovm_vs_vsp_assoc vva\n WHERE vva.vs_target_name = :tn\n AND vva.vs_target_type = :tt\n AND t.target_type = 'oracle_vm_server_pool'\n AND t.target_guid = vva.vsp_target_guid\n AND t.target_guid = p.target_guid\n AND p.property_name = 'vsp_uuid'\n AND p.property_type= 'INSTANCE'\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 6;
    }

    private void generateWLDomainAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'depends_on' as ASSOCIATION_TYPE,\n        -- check isJRFApplicable property for the domain target\n       (CASE WHEN tgtProp2.property_value = 'true'\n            -- case when the isJRFApplicable property value is true\n            THEN ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1 ,\n                                 instr(assocTgt.target_name, '/', 1, 3) - instr(assocTgt.target_name, '/', 1, 2) - 1\n                                )\n                         )\n                   )\n )\n             -- case when the isJRFApplicable property value is false\n             ELSE ( substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n )\n            END) TARGET_NAME,\n 'weblogic_j2eeserver' as TARGET_TYPE, assocTgt.host_name || ':' || tgtProp1.property_value as TARGET_PROPERTY\n FROM mgmt_targets domainTgt, mgmt_targets assocTgt, mgmt_target_assocs tgtAssocs, mgmt_target_properties tgtProp, mgmt_target_properties tgtProp1, mgmt_target_properties tgtProp2\n WHERE domainTgt.target_name = :tn\n   AND domainTgt.target_type = :tt\n   AND tgtAssocs.assoc_target_guid = domainTgt.target_guid\n   AND assocTgt.target_type = 'weblogic_j2eeserver'\n   AND assocTgt.target_guid = tgtAssocs.source_target_guid\n   AND tgtProp.target_guid = assocTgt.target_guid\n   AND tgtProp.property_name = 'isAdminServer'\n   AND tgtProp.property_value = 'YES'\n   AND tgtProp1.target_guid = tgtProp.target_guid\n   AND tgtProp1.property_name = 'OracleHome'\n   AND tgtProp2.target_guid = domainTgt.target_guid\n   AND tgtProp2.property_name = 'isJRFApplicable'\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateWLServerAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'member_of' as ASSOCIATION_TYPE, \n -- check isJRFApplicable property for the domain target\n(CASE WHEN isJRFApp.property_value = 'true'\n           -- case when the isJRFApplicable property value is true\n           THEN\n             -- case when the associated target is weblogic domain\n            (CASE WHEN assocTgt.target_type = 'weblogic_domain'\n                THEN ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1\n                                )\n                         )\n                   )\n )\n                -- case when the associated target is weblogic cluster\n                ELSE ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1 ,\n                                 instr(assocTgt.target_name, '/', 1, 3) - instr(assocTgt.target_name, '/', 1, 2) - 1\n                                )\n                         )\n                   )\n )\n              END)\n             -- case when isJRFApplicable property value is false\n             ELSE ( substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n )\n            END) TARGET_NAME,\n assocTgt.target_type as TARGET_TYPE, adminSrvr.host_name || ':' || trgtProp.property_value as TARGET_PROPERTY\nFROM mgmt_targets assocTgt, mgmt_targets srvrTgt, mgmt_target_assocs tgtAssoc, mgmt_target_properties trgtProp,\n     mgmt_targets domain, mgmt_target_properties isJRFApp, mgmt_target_assocs domainAssocs, mgmt_target_assocs adminServerAssocs, mgmt_target_assoc_defs assocDef, mgmt_targets adminSrvr\nWHERE srvrTgt.target_name = :tn\n  and srvrTgt.target_type = :tt\n  and tgtAssoc.assoc_target_guid = srvrTgt.target_guid  \n  and assocTgt.target_type in ('weblogic_domain', 'weblogic_cluster')\n  and assocTgt.target_guid = tgtAssoc.source_target_guid\n  and tgtAssoc.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*')\n  and domainAssocs.source_target_guid = srvrTgt.target_guid\n  and domain.target_guid = domainAssocs.assoc_target_guid\n  and domain.target_type = 'weblogic_domain'\n  and isJRFApp.target_guid = domain.target_guid\n  and isJRFApp.property_name = 'isJRFApplicable'\n  and adminServerAssocs.source_target_guid = srvrTgt.target_guid\n  and adminServerAssocs.assoc_target_guid = adminSrvr.target_guid\n  and adminServerAssocs.assoc_guid = assocDef.assoc_guid\n  and assocDef.assoc_def_name = 'managedBy'\n  and trgtProp.target_guid = domain.target_guid\n  and trgtProp.property_name = 'WebLogicHome'\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateWLClusterAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'member_of' as ASSOCIATION_TYPE,\n -- check isJRFApplicable property for the domain target\n(CASE WHEN isJRFApp.property_value = 'true'\n            -- case when the isJRFApplicable property value is true\n            THEN ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1\n                                )\n                         )\n                   )\n )\n             -- case when the isJRFApplicable property value is false\n             ELSE ( substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n )\n            END) TARGET_NAME,\n 'weblogic_domain' as TARGET_TYPE, adminSrvr.host_name || ':' || trgtProp.property_value as TARGET_PROPERTY\nFROM mgmt_targets assocTgt, mgmt_targets clusterTgt, mgmt_target_assocs tgtAssoc, mgmt_target_properties trgtProp, mgmt_target_properties isJRFApp, mgmt_target_assocs adminServerAssocs, mgmt_target_assoc_defs assocDef, mgmt_targets adminSrvr\nWHERE clusterTgt.target_name = :tn\n  and clusterTgt.target_type = :tt\n  and tgtAssoc.assoc_target_guid = clusterTgt.target_guid\n  and assocTgt.target_type = 'weblogic_domain'\n  and assocTgt.target_guid = tgtAssoc.source_target_guid\n  and trgtProp.target_guid = assocTgt.target_guid\n  and trgtProp.property_name = 'WebLogicHome'\n  and isJRFApp.target_guid = assocTgt.target_guid\n  and isJRFapp.property_name = 'isJRFApplicable'\n  and adminServerAssocs.source_target_guid = clusterTgt.target_guid\n  and adminServerAssocs.assoc_target_guid = adminSrvr.target_guid\n  and adminServerAssocs.assoc_guid = assocDef.assoc_guid\n  and assocDef.assoc_def_name = 'managedBy'\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateFarmAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'contains' as ASSOCIATION_TYPE,\n -- check isJRFApplicable property for the domain target\n(CASE WHEN isJRFApp.property_value = 'true'\n            -- case when the isJRFApplicable property value is true\n            THEN ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1\n                                )\n                         )\n                   )\n )\n             -- case when the isJRFApplicable property value is false\n             ELSE ( substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n )\n            END) TARGET_NAME,\n 'weblogic_domain' as TARGET_TYPE, adminSrvr.host_name || ':' || trgtProp.property_value as TARGET_PROPERTY\nFROM mgmt_targets assocTgt, mgmt_targets farmTgt, mgmt_target_assocs tgtAssoc, mgmt_target_properties trgtProp, mgmt_target_properties isJRFApp, mgmt_target_assocs adminServerAssocs, mgmt_target_properties adminSrvrProps, mgmt_targets adminSrvr\nWHERE farmTgt.target_name = :tn\n  and farmTgt.target_type = :tt\n  and tgtAssoc.source_target_guid = farmTgt.target_guid\n  and assocTgt.target_type = 'weblogic_domain'\n  and assocTgt.target_guid = tgtAssoc.assoc_target_guid\n  and tgtAssoc.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*')\n  and trgtProp.target_guid = assocTgt.target_guid\n  and trgtProp.property_name = 'WebLogicHome'\n  and isJRFApp.target_guid = assocTgt.target_guid\n  and isJRFapp.property_name = 'isJRFApplicable'\n  and adminServerAssocs.source_target_guid = assocTgt.target_guid\n  and adminServerAssocs.assoc_target_guid = adminSrvr.target_guid\n  and adminServerAssocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*')\n  and adminSrvrProps.target_guid = adminSrvr.target_guid\n  and adminSrvrProps.property_name = 'isAdminServer'\n  and adminSrvrProps.property_value = 'YES'\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateFarmConfigQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT regexp_replace(farm.target_name, domainProps.property_value, 'Farm_', 1, 1) as FARMNAME, farmProps.property_value as VERSION\nFROM mgmt_targets farm, mgmt_targets domain, mgmt_target_assocs assocs, mgmt_target_properties farmProps, mgmt_target_properties domainProps\nWHERE farm.target_name = :tn\n  AND farm.target_type = :tt\n  AND farmProps.target_guid = farm.target_guid\n  AND farmProps.property_name = 'version'\n  AND assocs.source_target_guid = farm.target_guid\n  AND domain.target_guid = assocs.assoc_target_guid\n  AND assocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*')\n  AND domain.target_type = 'weblogic_domain'\n  AND domainProps.target_guid = domain.target_guid\n  AND domainProps.property_name = 'farmPrefix'\n";
        this.m_ocmColumnCount = 2;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateJ2eeAppAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'runs_on' as ASSOCIATION_TYPE,\n -- check isJRFApplicable property for the domain target\n(CASE WHEN isJRFApp.property_value = 'true'\n            -- case when the isJRFApplicable property value is true\n            THEN ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1 ,\n                                 instr(assocTgt.target_name, '/', 1, 3) - instr(assocTgt.target_name, '/', 1, 2) - 1\n                                )\n                         )\n                   )\n )\n             -- case when the isJRFApplicable property value is false\n             ELSE ( substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n )\n            END) TARGET_NAME,\n 'weblogic_j2eeserver' as TARGET_TYPE, adminSrvr.host_name || ':' || trgtProp.property_value as TARGET_PROPERTY\nFROM mgmt_targets assocTgt, mgmt_targets app, mgmt_target_assocs assocs, mgmt_target_assocs domainAssoc, mgmt_target_properties isJRFApp, mgmt_target_properties trgtProp, mgmt_target_assocs adminServerAssocs, mgmt_target_assoc_defs assocDef, mgmt_targets adminSrvr\nWHERE app.target_name = :tn\n  and app.target_type = :tt\n  and assocs.assoc_target_guid = app.target_guid\n  and assocTgt.target_guid = assocs.source_target_guid\n  and assocTgt.target_type = 'weblogic_j2eeserver'\n  and domainAssoc.source_target_guid = app.target_guid\n  and domainAssoc.assoc_target_guid  = trgtProp.target_guid\n  and domainAssoc.assoc_target_guid  = isJRFApp.target_guid\n  and isJRFApp.property_name = 'isJRFApplicable'\n  and trgtProp.property_name = 'WebLogicHome'\n  and domainAssoc.assoc_target_guid IN (select domain.target_guid from mgmt_targets domain where domain.target_type = 'weblogic_domain')\n  and adminServerAssocs.source_target_guid = app.target_guid\n  and adminServerAssocs.assoc_target_guid = adminSrvr.target_guid\n  and adminServerAssocs.assoc_guid = assocDef.assoc_guid\n  and assocDef.assoc_def_name = 'managedBy'\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateApplicationQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT app.path as PATH, app.loadorder as LOADORDER, app.type as TYPE\nFROM mgmt_ecm_gen_snapshot gen_snapshot, mgmt_targets assocTgt, mgmt_targets appTgt, mgmt_target_assocs assocs, mgmt_weblogic_application app, mgmt_target_properties appProps, mgmt_target_assoc_defs defName\nWHERE appTgt.target_name = :tn\n  AND appTgt.target_type = :tt\n  AND assocs.source_target_guid = appTgt.target_guid\n  AND assocTgt.target_guid = assocs.assoc_target_guid\n  AND assocTgt.target_type = 'weblogic_j2eeserver'\n  AND gen_snapshot.target_name = assocTgt.target_name\n  AND gen_snapshot.snapshot_type = 'weblogic_j2eeserver_config'\n  AND gen_snapshot.is_current = 'Y'  \n  AND app.ecm_snapshot_id = gen_snapshot.snapshot_guid\n  AND defName.assoc_guid = assocs.assoc_guid\n  AND defName.assoc_def_name = 'managedServer'\n  AND appProps.target_guid = appTgt.target_guid\n  AND appProps.property_name = 'simpleAppName'\n  AND appProps.property_value = (CASE WHEN instr(app.name, '#') != 0 THEN substr(app.name, 1, instr(app.name, '#') -1) ELSE app.name END )\n";
        this.m_ocmColumnCount = 3;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateDIPAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'runs_on' as ASSOCIATION_TYPE, ('/Farm_' || substr(assocTgt.target_name,instr(assocTgt.target_name,substr(assocTgt.target_name,instr(assocTgt.target_name, '/', 1, 2) + 1 ,instr(assocTgt.target_name, '/', 1, 3) - instr(assocTgt.target_name, '/', 1, 2) - 1)))) as TARGET_NAME, assocTgt.target_type as TARGET_TYPE, assocTgt.host_name || ':' || tgtProp.property_value as TARGET_PROPERTY\nFROM mgmt_targets assocTgt, mgmt_targets dipTgt, mgmt_target_assocs assocdip, mgmt_target_assocs assocsvr, mgmt_targets tgt, mgmt_target_properties props, mgmt_target_properties tgtProp\nWHERE dipTgt.target_name = :tn AND dipTgt.target_type = :tt\n  AND dipTgt.target_guid = assocdip.source_target_guid AND assocdip.assoc_target_guid= tgt.target_guid AND tgt.target_type='weblogic_domain'\n  AND props.target_guid = dipTgt.target_guid AND props.property_type='INSTANCE' AND props.property_name='ServerNames'\n  AND props.property_value = assocTgt.display_name AND assocTgt.target_type='weblogic_j2eeserver' \n  AND assocTgt.target_guid = assocsvr.source_target_guid AND assocsvr.assoc_target_guid = assocdip.assoc_target_guid\n  AND assocTgt.target_guid = tgtProp.target_guid AND tgtProp.property_name = 'OracleHome' AND tgtProp.property_type='INSTANCE'\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateDIPAdminSvrQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT hst.property_value AS ADMIN_SVR_JMX_HOST, prt.property_value AS ADMIN_SVR_JMX_PORT, \n('/Farm_' || substr(dmnTgt.target_name, instr(dmnTgt.target_name, substr(dmnTgt.target_name, instr(dmnTgt.target_name, '/', 1, 2) + 1)))) AS ADMIN_SVR_DOMAIN\nFROM mgmt_targets dipTgt, mgmt_targets dmnTgt, mgmt_target_assocs assoc, mgmt_target_properties hst, mgmt_target_properties prt\nWHERE dipTgt.target_name = :tn AND dipTgt.target_type = :tt\n  AND dipTgt.target_guid = assoc.source_target_guid AND assoc.assoc_target_guid = dmnTgt.target_guid AND dmnTgt.target_type='weblogic_domain'\n  AND hst.target_guid = dmnTgt.target_guid AND hst.property_type = 'INSTANCE' AND hst.property_name='MachineName'\n  AND prt.target_guid = dmnTgt.target_guid AND prt.property_type = 'INSTANCE' AND prt.property_name='Port'\n";
        this.m_ocmColumnCount = 3;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateDIPWebApplicationQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT app.path as PATH, app.loadorder as LOADORDER, app.type as TYPE \nFROM mgmt_targets assocTgt, mgmt_targets dipTgt, mgmt_target_assocs assocdip, mgmt_target_assocs assocsvr, mgmt_targets tgt, mgmt_target_properties props, \n  mgmt_ecm_gen_snapshot gen_snapshot, mgmt_weblogic_application app, mgmt_target_properties appProps\nWHERE dipTgt.target_name = :tn\n  AND dipTgt.target_type = :tt\n  AND dipTgt.target_guid = assocdip.source_target_guid\n  AND assocdip.assoc_target_guid= tgt.target_guid\n  AND tgt.target_type='weblogic_domain'\n  AND props.target_guid = dipTgt.target_guid \n  AND props.property_type='INSTANCE' AND props.property_name='ServerNames' AND props.property_value = assocTgt.display_name \n  AND assocTgt.target_type='weblogic_j2eeserver' AND assocTgt.target_guid = assocsvr.source_target_guid AND assocsvr.assoc_target_guid = assocdip.assoc_target_guid\n  AND gen_snapshot.target_name = assocTgt.target_name\n  AND gen_snapshot.snapshot_type = 'weblogic_j2eeserver_config'\n  AND gen_snapshot.is_current = 'Y'\n  AND app.ecm_snapshot_id = gen_snapshot.snapshot_guid\n  AND appProps.target_guid = dipTgt.target_guid AND appProps.property_type='INSTANCE' AND appProps.property_name='appName'\n  AND app.name = substr(appProps.property_value,1,3)||'#'||substr(appProps.property_value,instr(appProps.property_value,'(')+1,instr(appProps.property_value,')')-instr(appProps.property_value,'(')-1)\n";
        this.m_ocmColumnCount = 3;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateOIFAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'runs_on' as ASSOCIATION_TYPE, ('/Farm_' || substr(assocTgt.target_name,instr(assocTgt.target_name,substr(assocTgt.target_name,instr(assocTgt.target_name, '/', 1, 2) + 1 ,instr(assocTgt.target_name, '/', 1, 3) - instr(assocTgt.target_name, '/', 1, 2) - 1)))) as TARGET_NAME, assocTgt.target_type as TARGET_TYPE, assocTgt.host_name || ':' || tgtProp.property_value as TARGET_PROPERTY\nFROM mgmt_targets assocTgt, mgmt_targets oifTgt, mgmt_target_assocs assocoif, mgmt_target_assocs assocsvr, mgmt_targets tgt, mgmt_target_properties props, mgmt_target_properties tgtProp\nWHERE oifTgt.target_name = :tn AND oifTgt.target_type = :tt\n  AND oifTgt.target_guid = assocoif.source_target_guid AND assocoif.assoc_target_guid= tgt.target_guid AND tgt.target_type='weblogic_domain'\n  AND props.target_guid = oifTgt.target_guid AND props.property_type='INSTANCE' AND props.property_name='ServerNames'\n  AND props.property_value = assocTgt.display_name AND assocTgt.target_type='weblogic_j2eeserver' \n  AND assocTgt.target_guid = assocsvr.source_target_guid AND assocsvr.assoc_target_guid = assocoif.assoc_target_guid\n  AND assocTgt.target_guid = tgtProp.target_guid AND tgtProp.property_name = 'OracleHome' AND tgtProp.property_type='INSTANCE'\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateOIFAdminSvrQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT hst.property_value AS ADMIN_SVR_JMX_HOST, prt.property_value AS ADMIN_SVR_JMX_PORT, \n('/Farm_' || substr(dmnTgt.target_name, instr(dmnTgt.target_name, substr(dmnTgt.target_name, instr(dmnTgt.target_name, '/', 1, 2) + 1)))) AS ADMIN_SVR_DOMAIN\nFROM mgmt_targets oifTgt, mgmt_targets dmnTgt, mgmt_target_assocs assoc, mgmt_target_properties hst, mgmt_target_properties prt\nWHERE oifTgt.target_name = :tn AND oifTgt.target_type = :tt\n  AND oifTgt.target_guid = assoc.source_target_guid AND assoc.assoc_target_guid = dmnTgt.target_guid AND dmnTgt.target_type='weblogic_domain'\n  AND hst.target_guid = dmnTgt.target_guid AND hst.property_type = 'INSTANCE' AND hst.property_name='MachineName'\n  AND prt.target_guid = dmnTgt.target_guid AND prt.property_type = 'INSTANCE' AND prt.property_name='Port'\n";
        this.m_ocmColumnCount = 3;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateOIFWebApplicationQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT app.path as PATH, app.loadorder as LOADORDER, app.type as TYPE \nFROM mgmt_targets assocTgt, mgmt_targets oifTgt, mgmt_target_assocs assocoif, mgmt_target_assocs assocsvr, mgmt_targets tgt, mgmt_target_properties props, \n  mgmt_ecm_gen_snapshot gen_snapshot, mgmt_weblogic_application app, mgmt_target_properties appProps\nWHERE oifTgt.target_name = :tn\n  AND oifTgt.target_type = :tt\n  AND oifTgt.target_guid = assocoif.source_target_guid\n  AND assocoif.assoc_target_guid= tgt.target_guid\n  AND tgt.target_type='weblogic_domain'\n  AND props.target_guid = oifTgt.target_guid \n  AND props.property_type='INSTANCE' AND props.property_name='ServerNames' AND props.property_value = assocTgt.display_name \n  AND assocTgt.target_type='weblogic_j2eeserver' AND assocTgt.target_guid = assocsvr.source_target_guid AND assocsvr.assoc_target_guid = assocoif.assoc_target_guid\n  AND gen_snapshot.target_name = assocTgt.target_name\n  AND gen_snapshot.snapshot_type = 'weblogic_j2eeserver_config'\n  AND gen_snapshot.is_current = 'Y'\n  AND app.ecm_snapshot_id = gen_snapshot.snapshot_guid\n  AND appProps.target_guid = oifTgt.target_guid AND appProps.property_type='INSTANCE' AND appProps.property_name='appName'\n  AND app.name = substr(appProps.property_value,1,3)||'#'||substr(appProps.property_value,instr(appProps.property_value,'(')+1,instr(appProps.property_value,')')-instr(appProps.property_value,'(')-1)\n";
        this.m_ocmColumnCount = 3;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateOIDAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'member_of' as ASSOCIATION_TYPE, ('/Farm_' || substr(assocTgt.target_name,instr(assocTgt.target_name,substr(assocTgt.target_name,instr(assocTgt.target_name, '/', 1, 2) + 1)))) as TARGET_NAME, assocTgt.target_type as TARGET_TYPE, \ntgtProp1.property_value || ':' || tgtProp2.property_value || ':' || assocTgt.target_name as TARGET_PROPERTY\n FROM mgmt_targets assocTgt, mgmt_target_assocs asso, mgmt_targets oidTgt, mgmt_target_properties tgtProp1, mgmt_target_properties tgtProp2 \nWHERE oidTgt.target_name = :tn AND oidTgt.target_type = :tt\n AND oidTgt.target_guid = asso.source_target_guid AND asso.assoc_target_guid= assocTgt.target_guid AND assocTgt.target_type='weblogic_domain'\n AND tgtProp1.target_guid = oidTgt.target_guid AND tgtProp1.property_type = 'INSTANCE' AND tgtProp1.property_name = 'MachineName'\n AND tgtProp2.target_guid = oidTgt.target_guid AND tgtProp2.property_type = 'INSTANCE' AND tgtProp2.property_name = 'Port'\n\nUNION\n\nSELECT 'connects_to' as ASSOCIATION_TYPE, null as TARGET_NAME, 'oracle_database' as TARGET_TYPE, (substr(props.property_value, instr(props.property_value,'HOST')+5,instr(props.property_value,')',1,2)-instr(props.property_value,'HOST')-5)||':'||substr(props.property_value, instr(props.property_value,'SERVICE_NAME')+13,instr(props.property_value,')',1,6)-instr(props.property_value,'SERVICE_NAME')-13)) as TARGET_PROPERTY\nFROM mgmt_target_properties props, mgmt_targets oidTgt\nWHERE oidTgt.target_name = :tn and oidTgt.target_type = :tt\n  and oidTgt.target_guid = props.target_guid and props.property_type = 'INSTANCE' and props.property_name='ConnectDescriptor'\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 6;
    }

    private void generateOIDAdminSvrQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT hst.property_value AS ADMIN_SVR_JMX_HOST, prt.property_value AS ADMIN_SVR_JMX_PORT, \n('/Farm_' || substr(dmnTgt.target_name, instr(dmnTgt.target_name, substr(dmnTgt.target_name, instr(dmnTgt.target_name, '/', 1, 2) + 1)))) AS ADMIN_SVR_DOMAIN\nFROM mgmt_targets oidTgt, mgmt_targets dmnTgt, mgmt_target_assocs assoc, mgmt_target_properties hst, mgmt_target_properties prt\nWHERE oidTgt.target_name = :tn AND oidTgt.target_type = :tt\n  AND oidTgt.target_guid = assoc.source_target_guid AND assoc.assoc_target_guid = dmnTgt.target_guid AND dmnTgt.target_type='weblogic_domain'\n  AND hst.target_guid = dmnTgt.target_guid AND hst.property_type = 'INSTANCE' AND hst.property_name='MachineName'\n  AND prt.target_guid = dmnTgt.target_guid AND prt.property_type = 'INSTANCE' AND prt.property_name='Port'\n";
        this.m_ocmColumnCount = 3;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateOVDAssocQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT 'member_of' as ASSOCIATION_TYPE, ('/Farm_' || substr(assocTgt.target_name,instr(assocTgt.target_name,substr(assocTgt.target_name,instr(assocTgt.target_name, '/', 1, 2) + 1)))) as TARGET_NAME, assocTgt.target_type as TARGET_TYPE, \ntgtProp1.property_value || ':' || tgtProp2.property_value || ':' || assocTgt.target_name as TARGET_PROPERTY\n FROM mgmt_targets assocTgt, mgmt_target_assocs asso, mgmt_targets ovdTgt, mgmt_target_properties tgtProp1, mgmt_target_properties tgtProp2 \nWHERE ovdTgt.target_name = :tn AND ovdTgt.target_type = :tt\n  AND ovdTgt.target_guid = asso.source_target_guid AND asso.assoc_target_guid= assocTgt.target_guid AND assocTgt.target_type='weblogic_domain'\n AND tgtProp1.target_guid = ovdTgt.target_guid AND tgtProp1.property_type = 'INSTANCE' AND tgtProp1.property_name = 'MachineName'\n AND tgtProp2.target_guid = ovdTgt.target_guid AND tgtProp2.property_type = 'INSTANCE' AND tgtProp2.property_name = 'Port'\n";
        this.m_ocmColumnCount = 4;
        this.m_emToOcmQueryParamLayout = 2;
    }

    private void generateOVDAdminSvrQuery() {
        String string;
        this.m_emToOcmQuery = string = "SELECT hst.property_value AS ADMIN_SVR_JMX_HOST, prt.property_value AS ADMIN_SVR_JMX_PORT, \n('/Farm_' || substr(dmnTgt.target_name, instr(dmnTgt.target_name, substr(dmnTgt.target_name, instr(dmnTgt.target_name, '/', 1, 2) + 1)))) AS ADMIN_SVR_DOMAIN\nFROM mgmt_targets ovdTgt, mgmt_targets dmnTgt, mgmt_target_assocs assoc, mgmt_target_properties hst, mgmt_target_properties prt\nWHERE ovdTgt.target_name = :tn AND ovdTgt.target_type = :tt\n  AND ovdTgt.target_guid = assoc.source_target_guid AND assoc.assoc_target_guid = dmnTgt.target_guid AND dmnTgt.target_type='weblogic_domain'\n  AND hst.target_guid = dmnTgt.target_guid AND hst.property_type = 'INSTANCE' AND hst.property_name='MachineName'\n  AND prt.target_guid = dmnTgt.target_guid AND prt.property_type = 'INSTANCE' AND prt.property_name='Port'\n";
        this.m_ocmColumnCount = 3;
        this.m_emToOcmQueryParamLayout = 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

