/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

public class HarvesterSql {
    static final String GET_NUMERIC_PROPERTY = "SELECT num_value FROM mgmt_ocm_upl_props WHERE NAME = ?";
    static final String GET_TS_PROPERTY = "SELECT ts_value FROM mgmt_ocm_upl_props WHERE NAME = ?";
    static final String GET_STRING_PROPERTY = "SELECT str_value FROM mgmt_ocm_upl_props WHERE NAME = ?";
    static final String DELETE_PROPERTY = "DELETE FROM mgmt_ocm_upl_props WHERE NAME = ?";
    static final String GET_CHANGES_AND_RESYNC_TS = "  SELECT \n    (SELECT CASE WHEN ts_value IS NULL THEN NULL ELSE 'a' END\n       FROM mgmt_ocm_upl_props\n      WHERE NAME = 'changes_ts') s1,\n    (SELECT CASE WHEN ts_value IS NULL THEN NULL ELSE\n              to_char(ts_value, 'YYYY-MM-DD HH24:MI:SS') || ' GMT' \n            END\n       FROM mgmt_ocm_upl_props\n      WHERE NAME = 'last_full_resync_ts_gmt') s2 \n    FROM DUAL\n";
    static final String GET_MAX_STAGING_IDX = "SELECT max(idx) FROM mgmt_ocm_upl_metrics_tmp";
    static final String RELEASE_TMP_TABLES = "BEGIN EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_metrics_tmp'; END;";
    static final String CLEAR_MD_TBLS = "BEGIN EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_md_tbls';  EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_periodic_full'; END;";
    static final String POPULATE_MD_TBL = "INSERT /*+ APPEND */ INTO mgmt_ocm_upl_md_tbls  (target_type, snapshot_type, table_name, kind)  VALUES (?, ?, ?, ?) ";
    static final String POPULATE_PERIODIC_FULL_TBL = "INSERT /*+ APPEND */ INTO mgmt_ocm_upl_periodic_full  (target_type, snapshot_type, table_name, period)  VALUES (?, ?, ?, ?) ";
    static final String UPDATE_METADATA_VERSION = "BEGIN\n\n  MERGE INTO mgmt_ocm_upl_props p\n  USING dual \n     ON ( name = 'major_version' )\n   WHEN MATCHED THEN UPDATE SET p.num_value = ?\n   WHEN NOT MATCHED THEN INSERT (name, num_value)\n        VALUES ('major_version', ?);\n\n  MERGE INTO mgmt_ocm_upl_props p\n  USING dual \n     ON ( name = 'minor_version' )\n   WHEN MATCHED THEN UPDATE SET p.num_value = ?\n   WHEN NOT MATCHED THEN INSERT (name, num_value)\n        VALUES ('minor_version', ?);\n\n   COMMIT;\n\nEND;\n";
    static final String GET_REPOSITORY_METADATA_VERSION = "SELECT (SELECT num_value FROM mgmt_ocm_upl_props WHERE name = 'major_version'),    (SELECT num_value FROM mgmt_ocm_upl_props WHERE name = 'minor_version')   FROM dual ";
    static final String GET_TARGET_BATCH = "  SELECT temp.target_name, temp.target_type, temp.display_name, temp.host_name, temp.timezone_region,  \n    (  /* lowercase home path if find host and it runs any kind of Windows */\n                  COALESCE (  \n           (SELECT (      \n              CASE       \n            WHEN INSTR(NLS_UPPER(t2.category_prop_1), 'WINDOWS') != 0 THEN  \n              NLS_LOWER(p.property_value) \n            ELSE p.property_value \n              END) \n            FROM mgmt_targets t2 \n            WHERE t2.target_name = temp.host_name \n            AND t2.target_type = 'host'), \n           p.property_value) ) home,                        \n           null discovered_name --mgmt_targets.discovered_name is not present in pre112 so null\n  FROM mgmt_target_properties p,  \n     (SELECT t.target_guid, (CASE WHEN o.target_type = 'oracle_vm_guest' THEN o.target_name ELSE t.target_name END) target_name, \n             o.target_type ,(CASE WHEN o.target_type = 'oracle_vm_guest' THEN o.target_name ELSE t.display_name END) display_name, \n             t.host_name, t.timezone_region , o.idx\n      FROM   mgmt_ocm_upl_metrics_tmp o, mgmt_targets t \n      WHERE \n             /* look for GVM and its target_guid */\n             ( o.target_type = 'oracle_vm_guest' AND\n\n               t.target_guid in (\n\n               SELECT distinct server_pool_guid from mgmt_virt_vm_master, mgmt_ocm_upl_metrics tgt_info \n                    where vm_uuid = (substr ( tgt_info.addl_target_info, instr( tgt_info.addl_target_info,'_',1,2 )+1 ) )\n                    and tgt_info.target_name = o.target_name\n                    and tgt_info.target_type = 'oracle_vm_guest'\n\n\n               )\n             )\n      OR (\n               o.target_type = 'oracle_vm_server_host' AND\n               t.target_type = 'oracle_vm_server' AND\n               t.target_name = o.target_name\n      )\n             /* or look for other target types and there target_guid */\n      OR     ( o.target_type = t.target_type  AND \n               o.target_name = t.target_name \n             )\n\n      AND o.idx >= ? AND o.idx < ? )temp  \n\n  WHERE temp.target_guid = p.target_guid (+) \n  AND 'OracleHome' = p.property_name(+) \n  ORDER BY temp.idx\n";
    static final String GET_OMS_VERSION = " SELECT version FROM mgmt_versions WHERE component_name= 'CORE' ";
    static final String HALTED_GVM_QUERY = "SELECT\tvm.server_pool_guid\n FROM mgmt_virt_vm_master vm, mgmt_virt_vm_perf perf, mgmt_virt_vm_op_status opstat\n WHERE vm.vm_uuid = perf.vm_uuid (+) \n AND vm.vm_uuid = opstat.vm_uuid (+) \n AND perf.virtual_server_guid is null \n AND vm.vm_uuid = substr(:vcid,  instr(:vcid, '_',1,2)+1) \n AND nvl(opstat.op_status_name,perf.vm_power_state) != 'OPERATION_ERROR'\n";
    static final String VSP_VM_ASSOC_QUERY = "SELECT 'contains' as ASSOCIATION_TYPE , mas.vm_domain_name as TARGET_NAME,\n        'oracle_vm_guest' as TARGET_TYPE , mas.vm_ovm_id as TARGET_PROPERTY \n FROM mgmt_ovm_gvm_summary gvm , mgmt_virt_vm_master mas\n WHERE gvm.p_vsp_target_name = :tn\n AND gvm.p_vsp_target_type = :tt\n AND gvm.p_vs_target_guid is null\n AND gvm.power_state != 'OPERATION_ERROR'\n AND mas.vm_uuid = gvm.vm_uuid \n AND mas.vm_domain_name = gvm.vm_domain_name\n";
    static final String VS_ASSOC_QUERY = "SELECT 'contains' as ASSOCIATION_TYPE , mas.vm_domain_name as TARGET_NAME,\n        'oracle_vm_guest' as TARGET_TYPE , mas.vm_ovm_id as TARGET_PROPERTY\n FROM mgmt_ovm_gvm_summary gvm , mgmt_virt_vm_master mas\n WHERE gvm.p_vs_target_name = :tn\n AND gvm.p_vs_target_type = :tt\n AND gvm.p_vs_target_guid is not null\n AND gvm.power_state != 'OPERATION_ERROR'\n AND mas.vm_uuid = gvm.vm_uuid\n AND mas.vm_domain_name = gvm.vm_domain_name\n\nUNION\n\nSELECT 'member_of' as ASSOCIATION_TYPE , t.target_name as TARGET_NAME,\n        'oracle_vm_server_pool' as TARGET_TYPE , p.property_value as TARGET_PROPERTY\n FROM mgmt_targets t, mgmt_target_properties p, mgmt_ovm_vs_vsp_assoc vva\n WHERE vva.vs_target_name = :tn\n AND vva.vs_target_type = :tt\n AND t.target_type = 'oracle_vm_server_pool'\n AND t.target_guid = vva.vsp_target_guid\n AND t.target_guid = p.target_guid\n AND p.property_name = 'vsp_uuid'\n AND p.property_type= 'INSTANCE'\n";
    static final String GVM_HOST_ASSOC_QUERY = "SELECT 'contains' as ASSOCIATION_TYPE , gvm.target_name as TARGET_NAME,\n        'host' as TARGET_TYPE , cfg.vm_pri_mac_addr as TARGET_PROPERTY\n FROM mgmt_ovm_gvm_summary gvm , mgmt_virt_vm_config cfg\n WHERE gvm.vm_domain_name = :tn\n AND gvm.target_guid is not null\n AND gvm.vm_uuid = cfg.vm_uuid\n AND gvm.power_state != 'OPERATION_ERROR'\n";
    public static final String WL_TGTNAME_WITH_JRF = "'/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1 ,\n                                 instr(assocTgt.target_name, '/', 1, 3) - instr(assocTgt.target_name, '/', 1, 2) - 1\n                                )\n                         )\n                   )\n";
    public static final String WLDOMAIN_NAME_WITH_JRF = "'/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1\n                                )\n                         )\n                   )\n";
    public static final String WLTGTNAME_WITHOUT_JRF = "substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n";
    public static final String WLDOMAIN_ASSOC_QUERY = "SELECT 'depends_on' as ASSOCIATION_TYPE,\n        -- check isJRFApplicable property for the domain target\n       (CASE WHEN tgtProp2.property_value = 'true'\n            -- case when the isJRFApplicable property value is true\n            THEN ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1 ,\n                                 instr(assocTgt.target_name, '/', 1, 3) - instr(assocTgt.target_name, '/', 1, 2) - 1\n                                )\n                         )\n                   )\n )\n             -- case when the isJRFApplicable property value is false\n             ELSE ( substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n )\n            END) TARGET_NAME,\n 'weblogic_j2eeserver' as TARGET_TYPE, assocTgt.host_name || ':' || tgtProp1.property_value as TARGET_PROPERTY\n FROM mgmt_targets domainTgt, mgmt_targets assocTgt, mgmt_target_assocs tgtAssocs, mgmt_target_properties tgtProp, mgmt_target_properties tgtProp1, mgmt_target_properties tgtProp2\n WHERE domainTgt.target_name = :tn\n   AND domainTgt.target_type = :tt\n   AND tgtAssocs.assoc_target_guid = domainTgt.target_guid\n   AND assocTgt.target_type = 'weblogic_j2eeserver'\n   AND assocTgt.target_guid = tgtAssocs.source_target_guid\n   AND tgtProp.target_guid = assocTgt.target_guid\n   AND tgtProp.property_name = 'isAdminServer'\n   AND tgtProp.property_value = 'YES'\n   AND tgtProp1.target_guid = tgtProp.target_guid\n   AND tgtProp1.property_name = 'OracleHome'\n   AND tgtProp2.target_guid = domainTgt.target_guid\n   AND tgtProp2.property_name = 'isJRFApplicable'\n";
    static final String WLSERVER_ASSOC_QUERY = "SELECT 'member_of' as ASSOCIATION_TYPE, \n -- check isJRFApplicable property for the domain target\n(CASE WHEN isJRFApp.property_value = 'true'\n           -- case when the isJRFApplicable property value is true\n           THEN\n             -- case when the associated target is weblogic domain\n            (CASE WHEN assocTgt.target_type = 'weblogic_domain'\n                THEN ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1\n                                )\n                         )\n                   )\n )\n                -- case when the associated target is weblogic cluster\n                ELSE ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1 ,\n                                 instr(assocTgt.target_name, '/', 1, 3) - instr(assocTgt.target_name, '/', 1, 2) - 1\n                                )\n                         )\n                   )\n )\n              END)\n             -- case when isJRFApplicable property value is false\n             ELSE ( substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n )\n            END) TARGET_NAME,\n assocTgt.target_type as TARGET_TYPE, adminSrvr.host_name || ':' || trgtProp.property_value as TARGET_PROPERTY\nFROM mgmt_targets assocTgt, mgmt_targets srvrTgt, mgmt_target_assocs tgtAssoc, mgmt_target_properties trgtProp,\n     mgmt_targets domain, mgmt_target_properties isJRFApp, mgmt_target_assocs domainAssocs, mgmt_target_assocs adminServerAssocs, mgmt_target_assoc_defs assocDef, mgmt_targets adminSrvr\nWHERE srvrTgt.target_name = :tn\n  and srvrTgt.target_type = :tt\n  and tgtAssoc.assoc_target_guid = srvrTgt.target_guid  \n  and assocTgt.target_type in ('weblogic_domain', 'weblogic_cluster')\n  and assocTgt.target_guid = tgtAssoc.source_target_guid\n  and tgtAssoc.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*')\n  and domainAssocs.source_target_guid = srvrTgt.target_guid\n  and domain.target_guid = domainAssocs.assoc_target_guid\n  and domain.target_type = 'weblogic_domain'\n  and isJRFApp.target_guid = domain.target_guid\n  and isJRFApp.property_name = 'isJRFApplicable'\n  and adminServerAssocs.source_target_guid = srvrTgt.target_guid\n  and adminServerAssocs.assoc_target_guid = adminSrvr.target_guid\n  and adminServerAssocs.assoc_guid = assocDef.assoc_guid\n  and assocDef.assoc_def_name = 'managedBy'\n  and trgtProp.target_guid = domain.target_guid\n  and trgtProp.property_name = 'WebLogicHome'\n";
    static final String WLCLUSTER_ASSOC_QUERY = "SELECT 'member_of' as ASSOCIATION_TYPE,\n -- check isJRFApplicable property for the domain target\n(CASE WHEN isJRFApp.property_value = 'true'\n            -- case when the isJRFApplicable property value is true\n            THEN ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1\n                                )\n                         )\n                   )\n )\n             -- case when the isJRFApplicable property value is false\n             ELSE ( substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n )\n            END) TARGET_NAME,\n 'weblogic_domain' as TARGET_TYPE, adminSrvr.host_name || ':' || trgtProp.property_value as TARGET_PROPERTY\nFROM mgmt_targets assocTgt, mgmt_targets clusterTgt, mgmt_target_assocs tgtAssoc, mgmt_target_properties trgtProp, mgmt_target_properties isJRFApp, mgmt_target_assocs adminServerAssocs, mgmt_target_assoc_defs assocDef, mgmt_targets adminSrvr\nWHERE clusterTgt.target_name = :tn\n  and clusterTgt.target_type = :tt\n  and tgtAssoc.assoc_target_guid = clusterTgt.target_guid\n  and assocTgt.target_type = 'weblogic_domain'\n  and assocTgt.target_guid = tgtAssoc.source_target_guid\n  and trgtProp.target_guid = assocTgt.target_guid\n  and trgtProp.property_name = 'WebLogicHome'\n  and isJRFApp.target_guid = assocTgt.target_guid\n  and isJRFapp.property_name = 'isJRFApplicable'\n  and adminServerAssocs.source_target_guid = clusterTgt.target_guid\n  and adminServerAssocs.assoc_target_guid = adminSrvr.target_guid\n  and adminServerAssocs.assoc_guid = assocDef.assoc_guid\n  and assocDef.assoc_def_name = 'managedBy'\n";
    static final String FARM_ASSOC_QUERY = "SELECT 'contains' as ASSOCIATION_TYPE,\n -- check isJRFApplicable property for the domain target\n(CASE WHEN isJRFApp.property_value = 'true'\n            -- case when the isJRFApplicable property value is true\n            THEN ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1\n                                )\n                         )\n                   )\n )\n             -- case when the isJRFApplicable property value is false\n             ELSE ( substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n )\n            END) TARGET_NAME,\n 'weblogic_domain' as TARGET_TYPE, adminSrvr.host_name || ':' || trgtProp.property_value as TARGET_PROPERTY\nFROM mgmt_targets assocTgt, mgmt_targets farmTgt, mgmt_target_assocs tgtAssoc, mgmt_target_properties trgtProp, mgmt_target_properties isJRFApp, mgmt_target_assocs adminServerAssocs, mgmt_target_properties adminSrvrProps, mgmt_targets adminSrvr\nWHERE farmTgt.target_name = :tn\n  and farmTgt.target_type = :tt\n  and tgtAssoc.source_target_guid = farmTgt.target_guid\n  and assocTgt.target_type = 'weblogic_domain'\n  and assocTgt.target_guid = tgtAssoc.assoc_target_guid\n  and tgtAssoc.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*')\n  and trgtProp.target_guid = assocTgt.target_guid\n  and trgtProp.property_name = 'WebLogicHome'\n  and isJRFApp.target_guid = assocTgt.target_guid\n  and isJRFapp.property_name = 'isJRFApplicable'\n  and adminServerAssocs.source_target_guid = assocTgt.target_guid\n  and adminServerAssocs.assoc_target_guid = adminSrvr.target_guid\n  and adminServerAssocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*')\n  and adminSrvrProps.target_guid = adminSrvr.target_guid\n  and adminSrvrProps.property_name = 'isAdminServer'\n  and adminSrvrProps.property_value = 'YES'\n";
    static final String FARM_CONFIG_QUERY = "SELECT regexp_replace(farm.target_name, domainProps.property_value, 'Farm_', 1, 1) as FARMNAME, farmProps.property_value as VERSION\nFROM mgmt_targets farm, mgmt_targets domain, mgmt_target_assocs assocs, mgmt_target_properties farmProps, mgmt_target_properties domainProps\nWHERE farm.target_name = :tn\n  AND farm.target_type = :tt\n  AND farmProps.target_guid = farm.target_guid\n  AND farmProps.property_name = 'version'\n  AND assocs.source_target_guid = farm.target_guid\n  AND domain.target_guid = assocs.assoc_target_guid\n  AND assocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*')\n  AND domain.target_type = 'weblogic_domain'\n  AND domainProps.target_guid = domain.target_guid\n  AND domainProps.property_name = 'farmPrefix'\n";
    static final String J2EE_APP_ASSOC_QUERY = "SELECT 'runs_on' as ASSOCIATION_TYPE,\n -- check isJRFApplicable property for the domain target\n(CASE WHEN isJRFApp.property_value = 'true'\n            -- case when the isJRFApplicable property value is true\n            THEN ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1 ,\n                                 instr(assocTgt.target_name, '/', 1, 3) - instr(assocTgt.target_name, '/', 1, 2) - 1\n                                )\n                         )\n                   )\n )\n             -- case when the isJRFApplicable property value is false\n             ELSE ( substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n )\n            END) TARGET_NAME,\n 'weblogic_j2eeserver' as TARGET_TYPE, adminSrvr.host_name || ':' || trgtProp.property_value as TARGET_PROPERTY\nFROM mgmt_targets assocTgt, mgmt_targets app, mgmt_target_assocs assocs, mgmt_target_assocs domainAssoc, mgmt_target_properties isJRFApp, mgmt_target_properties trgtProp, mgmt_target_assocs adminServerAssocs, mgmt_target_assoc_defs assocDef, mgmt_targets adminSrvr\nWHERE app.target_name = :tn\n  and app.target_type = :tt\n  and assocs.assoc_target_guid = app.target_guid\n  and assocTgt.target_guid = assocs.source_target_guid\n  and assocTgt.target_type = 'weblogic_j2eeserver'\n  and domainAssoc.source_target_guid = app.target_guid\n  and domainAssoc.assoc_target_guid  = trgtProp.target_guid\n  and domainAssoc.assoc_target_guid  = isJRFApp.target_guid\n  and isJRFApp.property_name = 'isJRFApplicable'\n  and trgtProp.property_name = 'WebLogicHome'\n  and domainAssoc.assoc_target_guid IN (select domain.target_guid from mgmt_targets domain where domain.target_type = 'weblogic_domain')\n  and adminServerAssocs.source_target_guid = app.target_guid\n  and adminServerAssocs.assoc_target_guid = adminSrvr.target_guid\n  and adminServerAssocs.assoc_guid = assocDef.assoc_guid\n  and assocDef.assoc_def_name = 'managedBy'\n";
    static final String APPLICATION_QUERY = "SELECT app.path as PATH, app.loadorder as LOADORDER, app.type as TYPE\nFROM mgmt_ecm_gen_snapshot gen_snapshot, mgmt_targets assocTgt, mgmt_targets appTgt, mgmt_target_assocs assocs, mgmt_weblogic_application app, mgmt_target_properties appProps, mgmt_target_assoc_defs defName\nWHERE appTgt.target_name = :tn\n  AND appTgt.target_type = :tt\n  AND assocs.source_target_guid = appTgt.target_guid\n  AND assocTgt.target_guid = assocs.assoc_target_guid\n  AND assocTgt.target_type = 'weblogic_j2eeserver'\n  AND gen_snapshot.target_name = assocTgt.target_name\n  AND gen_snapshot.snapshot_type = 'weblogic_j2eeserver_config'\n  AND gen_snapshot.is_current = 'Y'  \n  AND app.ecm_snapshot_id = gen_snapshot.snapshot_guid\n  AND defName.assoc_guid = assocs.assoc_guid\n  AND defName.assoc_def_name = 'managedServer'\n  AND appProps.target_guid = appTgt.target_guid\n  AND appProps.property_name = 'simpleAppName'\n  AND appProps.property_value = (CASE WHEN instr(app.name, '#') != 0 THEN substr(app.name, 1, instr(app.name, '#') -1) ELSE app.name END )\n";
    static final String GET_HALTED_GVM_DATA = "SELECT vm_pri_mac_addr, vm_memory, vm_num_cpus, vm_num_nics, vm_power_state \n        ,null, null, null,  null,  null,  null,  null,  null,  null,  null, null \n FROM mgmt_virt_vm_config c, mgmt_virt_vm_perf p  \n WHERE c.vm_uuid = substr(:vcid,  instr(:vcid, '_',1,2)+1) \n and c.vm_uuid=p.vm_uuid \n";
    public static final String UPDATE_HARVESTER_TARGET_PROPS = "BEGIN \n    MERGE INTO mgmt_ocm_upl_metrics um \n      USING ( \n       SELECT ? target_name, ? target_type, ? table_name, ? addl_target_info FROM dual) tmp \n         ON (   um.target_name = tmp.target_name \n             AND um.target_type = tmp.target_type \n             AND um.snapshot_type = 'internal_props' \n             AND um.table_name = tmp.table_name \n             ) \n        WHEN MATCHED THEN UPDATE SET um.addl_target_info = tmp.addl_target_info \n        WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info) \n             VALUES (tmp.target_name, tmp.target_type, 'internal_props', tmp.table_name, tmp.addl_target_info); \nEND; \n";
    public static final String GET_HARVESTER_TARGET_PROPS = "SELECT addl_target_info FROM mgmt_ocm_upl_metrics \n         WHERE snapshot_type='internal_props' \n         AND target_name = ? \n         AND target_type = ? \n         AND table_name = ? \n";
    public static final String CLEAR_HARVESTER_TARGET_PROPS = "DELETE FROM mgmt_ocm_upl_metrics \n         WHERE snapshot_type = 'internal_props' \n         AND target_name = ? \n         AND target_type = ? \n         AND table_name = ? \n";
    static final String GET_TARGET_METRICS = "  SELECT DISTINCT um.addl_target_info, um.snapshot_type, \n         CASE WHEN um.is_changed = 1 THEN um.table_name\n              ELSE NULL END AS table_name,\n         (SELECT (\n            CASE \n              WHEN INSTR(NLS_UPPER(t2.category_prop_1), 'WINDOWS') != 0 THEN\n                NLS_LOWER(um.addl_target_info)\n              ELSE NULL\n            END)\n          FROM mgmt_targets t2\n          WHERE t2.target_name = um.target_name\n          AND t2.target_type = 'host') addl_target_info_lower\n    FROM mgmt_ocm_upl_metrics um\n   WHERE um.target_type = ?\n     AND um.target_name = ?  \n     AND um.snapshot_type <> 'internal_props' \n   ORDER BY um.addl_target_info NULLS FIRST, um.snapshot_type,\n            table_name DESC NULLS FIRST \n";
    public static final String CLEAR_TARGET_METRICS_W_NULL_ADDL_INFO = "UPDATE mgmt_ocm_upl_metrics    SET is_changed = 0  WHERE target_name = ?    AND target_type = ?    AND snapshot_type = ?    AND addl_target_info IS NULL";
    public static final String CLEAR_TARGET_METRICS_W_NON_NULL_ADDL_INFO = "UPDATE mgmt_ocm_upl_metrics    SET is_changed = 0  WHERE target_name = ?    AND target_type = ?    AND snapshot_type = ?    AND addl_target_info = ?";
    static final String ADD_TARGETS_FOR_NEW_TT = "BEGIN  \n     -- This is the harvester upgarde scenario WHERE the major version gets upgraded , the procedure will take   \n     -- care of adding the new targets coming FROM new target type if were introduced with upgrade  \n\n     -- Find all the target types which are present in mgmt_ocm_upl_md_tbls but not in mgmt_ocm_upl_metrics  \n     -- Loop over each target type and update the mgmt_ocm_upl_metrics if new targets found  \n\n     FOR record IN ( SELECT DISTINCT(target_type) FROM mgmt_ocm_upl_md_tbls mt    \n                     WHERE NOT EXISTS (SELECT target_type FROM mgmt_ocm_upl_metrics um \n                                       WHERE um.target_type = mt.target_type))  \n     LOOP  \n\n        -- GVM target type requires special casing\n        -- GVM is not a target in EMGC and its snapshot comes from oracle_vm_server target\n        IF record.target_type = 'oracle_vm_guest' THEN  \n\n               -- populate oracle guest vm target type metrics  \n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)  \n                 -- defaults used for:  is_changed  \n               SELECT gvm.vm_domain_name, h.target_type, h.snapshot_type, \n                      h.table_name, (gvm.vm_ovm_id  || '_APPEND_' || gvm.vm_uuid)  \n                 FROM mgmt_virt_vm_master gvm, mgmt_ocm_upl_md_tbls h  \n                WHERE h.target_type = 'oracle_vm_guest'\n                  AND gvm.vm_ovm_id is not null\n                  AND h.snapshot_type = 'oracle_ovm_vm_config';  \n\n        -- OVSP target type requires special casing\n        -- OVSP is a repository side target in EMGC and does not have any snapshot\n        ELSIF  record.target_type = 'oracle_vm_server_pool' THEN  \n\n             -- populate oracle vm server pool target type metrics  \n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name)  \n                 -- defaults used for:  addl_target_info, is_changed  \n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name  \n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h  \n                WHERE t.target_type = 'oracle_vm_server_pool'  \n                  AND h.target_type = 'oracle_vm_server_pool';  \n\n        ELSIF  record.target_type = 'oracle_vm_server_host' THEN\n\n             -- populate oracle vm server host target type metrics\n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name)\n                 -- defaults used for:  addl_target_info, is_changed\n               SELECT t.target_name, 'oracle_vm_server_host', h.snapshot_type, h.table_name\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h\n                WHERE t.target_type = 'oracle_vm_server'\n                  AND h.target_type = 'oracle_vm_server_host';\n\n        -- weblogic domain target type requires special casing\n        ELSIF  record.target_type = 'weblogic_domain' THEN  \n             -- populate weblogic domain target type metrics  \n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)  \n                 -- defaults used for:  is_changed  \n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value \n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p  \n                WHERE t.target_type = 'weblogic_domain'\n                  AND h.target_type = t.target_type \n                  AND p.target_guid = t.target_guid \n\t\t  AND p.property_name = 'WebLogicHome';\n\n        -- weblogic_cluster/j2ee_application target types requires special casing\n        ELSIF  (record.target_type = 'weblogic_cluster' OR\n\t\trecord.target_type = 'j2ee_application') THEN\n             -- populate weblogic cluster target type metrics\n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)\n                 -- defaults used for:  is_changed\n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n                WHERE t.target_type = record.target_type\n                  AND h.target_type = t.target_type\n\t\t  AND assocs.source_target_guid = t.target_guid\n\t\t  AND domain.target_guid = assocs.assoc_target_guid\n\t\t  AND domain.target_type = 'weblogic_domain'\n                  AND p.target_guid = domain.target_guid\n                  AND p.property_name = 'WebLogicHome'; \n\n        -- oracle_ias_farm target type requires special casing\n        ELSIF  record.target_type = 'oracle_ias_farm' THEN\n              -- populate oracle ias farm target type metric\n                INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)\n                 -- defaults used for:  is_changed\n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n                WHERE t.target_type = record.target_type\n                  AND h.target_type = t.target_type\n                  AND assocs.source_target_guid = t.target_guid\n                  AND domain.target_guid = assocs.assoc_target_guid\n                  AND domain.target_type = 'weblogic_domain'\n                  AND p.target_guid = domain.target_guid\n                  AND p.property_name = 'WebLogicHome'\n                  AND assocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*');\n\n        --if a new target type requires special casing , add a new ELSIF  \n        -- This is for generic target types  \n        ELSE  \n               -- populate metrics other than host config and oracle home target type  \n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name)  \n                 -- defaults used for:  addl_target_info, is_changed  \n               SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name  \n                 FROM mgmt_ecm_gen_snapshot s, mgmt_ocm_upl_md_tbls h  \n                WHERE s.is_current = 'Y'  \n                  AND s.target_type = h.target_type  \n                  AND s.snapshot_type = h.snapshot_type  \n                  AND NOT (s.target_type = 'host' and s.snapshot_type = 'host_configuration')  \n                  AND s.target_type = record.target_type;  \n\n        END IF;  \n       COMMIT;\n     END LOOP;  \n\n     EXCEPTION WHEN OTHERS THEN   \n\n       MGMT_LOG.LOG_ERROR('GCHARVESTER', -201,   \n         'Encountered a problem during addtion of new targets for OCM upload: ' ||   \n           SQLCODE || ': ' || SQLERRM,   \n         v_log_level_in =>  MGMT_GLOBAL.G_ERROR);   \n\n       RAISE;   \n\nEND;  \n";
    static final String RESYNC_CODE = "DECLARE\n  l_changes_ts DATE;\nBEGIN\n  -- Initialization / resynch code\n  EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_metrics';\n\n  -- would rather later send duplicate config than miss some changes\n  -- assumption: history code does not take more than 10 minutes\n  l_changes_ts := sysdate - 1 / (24 * 6); \n\n  -- populate metrics other than host config and oracle home target type\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics \n    (target_name, target_type, snapshot_type, table_name)\n    -- defaults used for:  addl_target_info, is_changed\n  SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name\n    FROM mgmt_ecm_gen_snapshot s, mgmt_ocm_upl_md_tbls h\n   WHERE s.is_current = 'Y'\n     AND s.target_type = h.target_type \n     AND s.snapshot_type = h.snapshot_type\n     AND NOT (s.target_type = 'host' and s.snapshot_type = 'host_configuration');\n\n  COMMIT;\n\n  -- populate oracle vm server pool target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name)\n    -- defaults used for:  addl_target_info, is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name\n      FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h\n    WHERE t.target_type = 'oracle_vm_server_pool' \n     AND h.target_type = 'oracle_vm_server_pool';\n\n  COMMIT;\n\n  -- populate oracle guest vm target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for:  is_changed\n  SELECT gvm.vm_domain_name, h.target_type, h.snapshot_type, h.table_name, (gvm.vm_ovm_id  || '_APPEND_' || gvm.vm_uuid) \n      FROM mgmt_virt_vm_master gvm, mgmt_ocm_upl_md_tbls h \n    WHERE h.target_type = 'oracle_vm_guest' \n     AND gvm.vm_ovm_id is not null\n     AND h.snapshot_type = 'oracle_ovm_vm_config'; \n\n  COMMIT;\n\n -- populate vm_server as host\n INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name)\n    -- defaults used for:  addl_target_info, is_changed\n  SELECT s.target_name, 'oracle_vm_server_host', s.snapshot_type, h.table_name\n    FROM mgmt_ecm_gen_snapshot s, mgmt_ocm_upl_md_tbls h\n   WHERE s.is_current = 'Y'\n     AND s.target_type = 'oracle_vm_server'\n     AND h.target_type = 'oracle_vm_server_host'\n     AND s.snapshot_type = h.snapshot_type;\n\n  COMMIT;\n\n  -- populate weblogic domain target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p\n    WHERE t.target_type = 'weblogic_domain' \n     AND h.target_type = t.target_type\n     AND p.target_guid = t.target_guid\n     AND p.property_name = 'WebLogicHome';\n\n  COMMIT;\n\n  -- populate weblogic_cluster/j2ee_application target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n    WHERE t.target_type in ('weblogic_cluster', 'j2ee_application')\n     AND h.target_type = t.target_type\n     AND assocs.source_target_guid = t.target_guid\n     AND domain.target_guid = assocs.assoc_target_guid\n     AND domain.target_type = 'weblogic_domain'\n     AND p.target_guid = domain.target_guid\n     AND p.property_name = 'WebLogicHome';\n\n  COMMIT;\n\n  -- populate oracle_ias_farm target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n    WHERE t.target_type = 'oracle_ias_farm'\n     AND h.target_type = t.target_type\n     AND assocs.source_target_guid = t.target_guid\n     AND domain.target_guid = assocs.assoc_target_guid\n     AND domain.target_type = 'weblogic_domain'\n     AND p.target_guid = domain.target_guid\n     AND p.property_name = 'WebLogicHome'\n     AND assocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*');\n\n  COMMIT;\n\n  -- populate metrics for host configs\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name) \n    -- defaults used for:  addl_target_info, is_changed\n  SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name\n    FROM mgmt_ecm_snapshot s, mgmt_ocm_upl_md_tbls h\n   WHERE s.is_current = 'Y'\n     AND s.target_type = h.target_type\n     AND s.snapshot_type = h.snapshot_type\n     AND s.target_type = 'host' \n     AND s.snapshot_type = 'host_configuration';\n\n  COMMIT;\n\n  -- populate oracle home target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for:  is_changed\n  SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name, c.container_location\n    FROM mgmt_ecm_snapshot s, mgmt_inv_container c, \n         (SELECT 'ECM$HIST_INV_COMPONENTS' as table_name FROM DUAL \n           UNION ALL SELECT 'ECM$HIST_INV_PATCHES' FROM DUAL\n           UNION ALL SELECT 'ECM$HIST_INV_PATCHSETS' FROM DUAL) h \n   WHERE s.is_current = 'Y'\n     AND s.target_type = 'host' \n     AND s.snapshot_type = 'host_configuration'\n     AND s.snapshot_guid = c.snapshot_guid\n     AND c.container_type != 'I';\n\n  COMMIT;\n\n  MERGE INTO mgmt_ocm_upl_props p\n  USING dual \n     ON ( name = 'changes_ts' )\n   WHEN MATCHED THEN UPDATE SET p.ts_value = l_changes_ts\n   WHEN NOT MATCHED THEN INSERT (name, ts_value)\n        VALUES ('changes_ts', l_changes_ts);\n\n  -- update periodic full table since all its metrics are marked\n  UPDATE mgmt_ocm_upl_periodic_full\n     SET last_update = sysdate;\n\n  -- increment resync_seq_num for older code\n  UPDATE mgmt_ocm_upl_props\n     SET num_value = num_value + 1\n   WHERE name = 'resync_seq_num';\n\n  -- update last full resynch timestamp\n  MERGE INTO mgmt_ocm_upl_props p\n  USING (SELECT SYSTIMESTAMP AT TIME ZONE 'GMT' AS ts FROM dual) t\n     ON ( name = 'last_full_resync_ts_gmt' )\n   WHEN MATCHED THEN UPDATE SET p.ts_value = t.ts\n   WHEN NOT MATCHED THEN INSERT (name, ts_value) values\n        ('last_full_resync_ts_gmt', t.ts);\n\n  COMMIT;\n\nEXCEPTION WHEN OTHERS THEN\n\n  MGMT_LOG.LOG_ERROR('GCHARVESTER', -201,\n    'Encountered a problem during [re]initialization of OCM upload: ' ||\n      SQLCODE || ': ' || SQLERRM,\n    v_log_level_in =>  MGMT_GLOBAL.G_ERROR);\n\n  RAISE;\n\nEND;\n";
    static final String HISTORY_POPULATE_CODE = "DECLARE\n  l_min_ts DATE := NULL;\n  l_max_ts DATE := NULL;\n  l_prev_ts DATE := NULL;\n  l_next_ts DATE := NULL;\n  l_overall_interval NUMBER; -- overall number of days\n  l_interval_div_by_4 NUMBER; -- above number divided by 4\n  l_interval NUMBER := 1; -- number of days (used to split overall interval)\n  l_split BOOLEAN := false; -- are we splitting into intervals?\n  l_last_interval BOOLEAN := true; -- are we processing last interval?\nBEGIN\n  BEGIN\n    SELECT ts_value INTO l_min_ts\n      FROM mgmt_ocm_upl_props\n     WHERE name = 'changes_ts';\n  EXCEPTION WHEN NO_DATA_FOUND THEN\n    raise_application_error(-20000, \n      'Internal error: last update timestamp is unavailable to history-based code');\n  END;\n\n  -- select current timestamp minus 10 minutes (assumption: ECM history computation\n  -- should be done within 10 minutes of when it starts)\n  l_max_ts := sysdate - 1 / (24 * 6);\n\n  l_prev_ts := l_min_ts;\n  l_next_ts := l_max_ts;\n  LOOP -- over intervals\n    BEGIN\n\n      -- update mgmt_ocm_upl_metrics with changes in the l_prev_ts to l_next_ts interval\n\n      -- first, handle all new and old targets except for oracle homes \n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT DISTINCT s.new_left_target_name as target_name, s.target_type , \n               s.snapshot_type, null as addl_target_info, h.table_name\n          FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_ocm_upl_md_tbls h\n         WHERE\n           s.delta_type = 'HISTORY'\n           AND e.row_guid = i.row_guid (+)\n           AND s.delta_guid = e.delta_guid (+)\n           AND s.delta_timestamp > l_prev_ts \n           AND s.delta_timestamp <= l_next_ts \n           AND s.target_type =  h.target_type\n           AND s.snapshot_type = h.snapshot_type\n           AND ( (e.delta_guid IS NULL AND s.old_right_snapshot_guid IS NULL)\n               OR\n               ( e.operation != 'SAME' AND i.collection_type = h.table_name) )\n\n         ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null \n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- handle oracle homes on new hosts\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT DISTINCT s.target_name, 'host' as target_type, 'host_configuration' as snapshot_type, \n               i.container_location as addl_target_info, h.table_name\n          FROM (SELECT s.new_left_target_name as target_name -- cardinality hint? to drive overall query by timestamp index?\n                  FROM mgmt_delta_snap s\n                 WHERE s.delta_type = 'HISTORY'\n                   AND s.delta_timestamp > l_prev_ts \n                   AND s.delta_timestamp <= l_next_ts \n                   AND s.target_type =  'host'\n                   AND s.snapshot_type = 'host_configuration'\n                   AND s.old_right_snapshot_guid IS NULL\n               ) new_hosts,\n               mgmt_ecm_snapshot s, mgmt_inv_container i,\n               (SELECT 'ECM$HIST_INV_COMPONENTS' as table_name FROM DUAL \n                   UNION ALL SELECT 'ECM$HIST_INV_PATCHES' FROM DUAL\n                   UNION ALL SELECT 'ECM$HIST_INV_PATCHSETS' FROM DUAL) h\n         WHERE s.target_name = new_hosts.target_name\n           AND s.target_type = 'host'\n           AND s.snapshot_type = 'host_configuration'\n           AND s.is_current = 'Y'\n           AND s.snapshot_guid = i.snapshot_guid   \n           AND i.container_type != 'I'\n\n          ) t \n         ON (   p.target_type = t.target_type \n            AND p.target_name = t.target_name \n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- handle inserts/deletes/updates to oracle homes on existing hosts\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT DISTINCT s.new_left_target_name as target_name, \n               'host' as target_type, 'host_configuration' as snapshot_type, \n               iv.value as addl_target_info, i.collection_type as table_name\n          FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_delta_id_values iv\n         WHERE s.delta_type = 'HISTORY' \n           AND s.delta_timestamp > l_prev_ts \n           AND s.delta_timestamp <= l_next_ts \n           AND s.target_type = 'host'\n           AND s.snapshot_type = 'host_configuration'\n           AND s.delta_guid = e.delta_guid\n           AND e.operation != 'SAME' \n           AND e.row_guid = i.row_guid\n           and i.collection_type in \n               ('ECM$HIST_INV_COMPONENTS', \n                'ECM$HIST_INV_PATCHSETS',\n                'ECM$HIST_INV_PATCHES')\n           and iv.delta_ids_guid = i.row_guid\n           and iv.name = 'CONTAINER_LOCATION'\n           and iv.value not like 'N/A%'\n\n      ) t\n         ON (    p.target_type = t.target_type\n             AND p.target_name = t.target_name\n             AND p.snapshot_type = t.snapshot_type\n             AND p.table_name = t.table_name\n             AND p.addl_target_info = t.addl_target_info\n             )\n        WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n        WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n             VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- OVSP target depends on OVS target for snapshot and history changes as it does not have any snapshot in EMGC\n      -- First get the new OVS target or for which snapshot has chaned, now from assocs table get the corresponding\n      -- OVSP target and other data from upl_md_table\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n         SELECT DISTINCT vva.vsp_target_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type, \n                         null as addl_target_info, h.table_name as table_name\n           FROM (SELECT s.new_left_target_name as target_name , s.target_type as target_type\n                           FROM mgmt_delta_snap s\n                          WHERE s.delta_type = 'HISTORY'\n                            AND s.delta_timestamp > l_prev_ts \n                            AND s.delta_timestamp <= l_next_ts \n                            AND s.target_type =  'oracle_vm_server'\n                            AND s.snapshot_type = 'oracle_ovm_vs_config'\n                            AND s.old_right_snapshot_guid IS NULL\n                 ) new_vs, \n                   mgmt_ovm_vs_vsp_assoc vva, mgmt_ovm_vsp_summary vsp, mgmt_ocm_upl_md_tbls h\n          WHERE vva.vs_target_name = new_vs.target_name\n            AND vva.vs_target_type = new_vs.target_type\n            AND vva.vsp_target_guid = vsp.target_guid\n            AND vva.vs_target_guid = vsp.mas_target_guid\n            AND h.target_type = 'oracle_vm_server_pool'\n            AND h.snapshot_type = 'oracle_ovm_vsp_config'\n\n          ) t \n         ON (   p.target_type = t.target_type \n            AND p.target_name = t.target_name \n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null \n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- handle modifications to existing OVSPs\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n         SELECT DISTINCT vva.vsp_target_name as target_name , h.target_type as target_type, h.snapshot_type as snapshot_type, \n                         null as addl_target_info, h.table_name as table_name\n           FROM (SELECT s.new_left_target_name as target_name, s.target_type as target_type\n                  FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_delta_id_values iv\n                 WHERE s.delta_type = 'HISTORY' \n                   AND s.delta_timestamp > l_prev_ts \n                   AND s.delta_timestamp <= l_next_ts \n                   AND s.target_type = 'oracle_vm_server'\n                   AND s.snapshot_type = 'oracle_ovm_vs_config'\n                   AND s.delta_guid = e.delta_guid\n                   AND e.operation != 'SAME' \n                   AND e.row_guid = i.row_guid\n                   AND iv.delta_ids_guid = i.row_guid\n                ) changed_vs,\n                  mgmt_ovm_vs_vsp_assoc vva,  mgmt_ovm_vsp_summary vsp, mgmt_ocm_upl_md_tbls h\n          WHERE vva.vs_target_name = changed_vs.target_name\n            AND vva.vs_target_type = changed_vs.target_type\n            AND vva.vsp_target_guid = vsp.target_guid\n            AND vva.vs_target_guid = vsp.mas_target_guid\n            AND h.target_type = 'oracle_vm_server_pool'\n            AND h.snapshot_type = 'oracle_ovm_vsp_config'\n\n          ) t \n         ON (   p.target_type = t.target_type \n            AND p.target_name = t.target_name \n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null \n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- GVM target depends on OVS target for snapshot and history as it does not exists as a target in EMGC\n      -- First get the new OVS target or for which snapshot has chaned, now from assocs table get the corresponding\n      -- OVSP target guid , use the guid to find the GVMs from master table\n      -- and other data from upl_md_table\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT  DISTINCT gvm.vm_domain_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type, \n                (gvm.vm_ovm_id  || '_APPEND_' || gvm.vm_uuid) as addl_target_info, h.table_name as table_name\n          FROM  (SELECT s.new_left_target_name as target_name, s.target_type as target_type\n                          FROM mgmt_delta_snap s\n                         WHERE s.delta_type = 'HISTORY'\n                           AND s.delta_timestamp > l_prev_ts \n                           AND s.delta_timestamp <= l_next_ts \n                           AND s.target_type =  'oracle_vm_server'\n                           AND s.snapshot_type = 'oracle_ovm_vs_config'\n                           AND s.old_right_snapshot_guid IS NULL\n                ) new_vs,\n                  mgmt_virt_vm_master gvm, mgmt_ocm_upl_md_tbls h,mgmt_ovm_vs_vsp_assoc vva\n         WHERE  vva.vs_target_name = new_vs.target_name\n           AND  vva.vs_target_type = new_vs.target_type\n           AND  vva.vsp_target_guid =gvm.server_pool_guid\n           AND  h.target_type = 'oracle_vm_guest'\n           AND  h.snapshot_type = 'oracle_ovm_vm_config'\n           AND  gvm.vm_ovm_id is not null\n\n          ) t \n         ON (   p.target_type = t.target_type \n            AND p.target_name = t.target_name \n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- handle modifications to existing GVMs\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT  DISTINCT gvm.vm_domain_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type, \n                (gvm.vm_ovm_id  || '_APPEND_' || gvm.vm_uuid) as addl_target_info, h.table_name as table_name\n          FROM  (SELECT s.new_left_target_name as target_name, s.target_type as target_type\n                  FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_delta_id_values iv\n                 WHERE s.delta_type = 'HISTORY' \n                   AND s.delta_timestamp > l_prev_ts \n                   AND s.delta_timestamp <= l_next_ts \n                   AND s.target_type = 'oracle_vm_server'\n                   AND s.snapshot_type = 'oracle_ovm_vs_config'\n                   AND s.delta_guid = e.delta_guid\n                   AND e.operation != 'SAME' \n                   AND e.row_guid = i.row_guid\n                   AND iv.delta_ids_guid = i.row_guid\n                ) changed_vs,\n                  mgmt_virt_vm_master gvm, mgmt_ocm_upl_md_tbls h,mgmt_ovm_vs_vsp_assoc vva\n         WHERE  vva.vs_target_name = changed_vs.target_name\n           AND  vva.vs_target_type = changed_vs.target_type\n           AND  vva.vsp_target_guid =gvm.server_pool_guid\n           AND  h.target_type = 'oracle_vm_guest'\n           AND  h.snapshot_type = 'oracle_ovm_vm_config'\n           AND  gvm.vm_ovm_id is not null\n\n          ) t \n         ON (   p.target_type = t.target_type \n            AND p.target_name = t.target_name \n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- oracle_vm_server_host target type depend on oracle_vm_server target types , handle new and existing  oracle_vm_server_host targets\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (  \n\n       SELECT DISTINCT s.new_left_target_name as target_name, h.target_type,\n               s.snapshot_type, null as addl_target_info, h.table_name\n          FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_ocm_upl_md_tbls h\n         WHERE\n           s.delta_type = 'HISTORY'\n           AND e.row_guid = i.row_guid (+)\n           AND s.delta_guid = e.delta_guid (+)\n           AND s.delta_timestamp > l_prev_ts\n           AND s.delta_timestamp <= l_next_ts\n           AND s.target_type =  'oracle_vm_server'\n           AND h.target_type = 'oracle_vm_server_host'\n           AND s.snapshot_type = h.snapshot_type\n           AND ( (e.delta_guid IS NULL AND s.old_right_snapshot_guid IS NULL)\n               OR\n               ( e.operation != 'SAME' AND i.collection_type = h.table_name) )\n\n         ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- Fix for bug#9980503\n      -- MGMT_ECM_ASSOCIATIONS is a periodically collected metric for weblogic_j2eeserver target.\n      -- Adding the following query to minimize the time lag in collecting the MGMT_ECM_ASSOCIATIONS metric which would otherwise be collected periodically i.e 30 days\n      -- Following query would enable the MGMT_ECM_ASSOCIATIONS metric collection when there is any change in the existing server cofiguration\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT DISTINCT s.new_left_target_name as target_name, 'weblogic_j2eeserver' as target_type ,\n               'weblogic_j2eeserver_config' as snapshot_type, null as addl_target_info, 'MGMT_ECM_ASSOCIATIONS' as table_name\n          FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i\n         WHERE s.delta_type = 'HISTORY'\n           AND e.row_guid = i.row_guid\n           AND e.operation != 'SAME'\n           AND s.delta_guid = e.delta_guid\n           AND s.delta_timestamp > l_prev_ts\n           AND s.delta_timestamp <= l_next_ts\n           AND s.target_type = 'weblogic_j2eeserver'\n           AND s.snapshot_type = 'weblogic_j2eeserver_config'\n\n         ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- weblogic_domain/weblogic_cluster/j2ee_application targets depends on weblogic server target for snapshot and history as there is no snapshot for domain target in EMGC\n      -- First get the new weblogic server target or for which snapshot has chaned, now from targets table get the corresponding\n      -- weblogic server target guid , use the guid to find the domain/cluster/j2ee_application target from assocs table\n      -- and other data from upl_md_table\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT  DISTINCT assocTgt.target_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type,\n                prop.property_value as addl_target_info, h.table_name as table_name\n          FROM  (SELECT s.new_left_target_name as target_name, s.target_type as target_type\n                          FROM mgmt_delta_snap s\n                         WHERE s.delta_type = 'HISTORY'\n                           AND s.delta_timestamp > l_prev_ts\n                           AND s.delta_timestamp <= l_next_ts\n                           AND s.target_type =  'weblogic_j2eeserver'\n                           AND s.snapshot_type = 'weblogic_j2eeserver_config'\n                           AND s.old_right_snapshot_guid IS NULL\n                ) new_wlserver,\n                  mgmt_targets assocTgt, mgmt_targets server, mgmt_ocm_upl_md_tbls h, mgmt_target_assocs tgtAssocs, \n\t\t  mgmt_target_properties prop, mgmt_targets domain, mgmt_target_assocs domainAssocs\n        WHERE  server.target_name = new_wlserver.target_name\n           AND  server.target_type = new_wlserver.target_type\n           AND  tgtAssocs.assoc_target_guid = server.target_guid \n\t   AND  assocTgt.target_guid = tgtAssocs.source_target_guid\n\t   AND  assocTgt.target_type in ('weblogic_domain', 'weblogic_cluster', 'j2ee_application')\n\t   AND  h.target_type = assocTgt.target_type\n\t   AND  h.snapshot_type in ('weblogic_domain_config', 'weblogic_cluster_config', 'j2ee_application_config')\n\t   AND  domainAssocs.source_target_guid = server.target_guid\n           AND  domain.target_guid = domainAssocs.assoc_target_guid\n           AND  prop.target_guid = domain.target_guid\n           AND  prop.property_name = 'WebLogicHome'                \n           AND  prop.property_value is not null\n\n          ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- oracle_ias_farm target has an association with weblogic domain target\n      -- weblogic domain target depends on weblogic server target for snapshot and history as there is no snapshot for domain target in EMGC\n      -- First get the new weblogic server target or for which snapshot has chaned, then get the corresponding domain target from the assocs table.\n      -- finally use the domain target guid to find the oracle ias farm target from assocs table\n      -- and other data from upl_md_table\n      -- For oracle_ias_farm target we are only collecting association with the wl adminserver target.\n      -- The association with the wl adminserver target will not change if there are any config changes for the wlserver target.\n      -- So we are not collecting data for oracle_ias_farm target when there are changes to the wlserver.\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n\tWITH tbls AS\n\t(SELECT /*+ materialize */ table_name\n\t FROM mgmt_ocm_upl_md_tbls\n\t WHERE target_Type = 'oracle_ias_farm'\n\t   AND snapshot_type = 'oracle_ias_farm_config')\n\n        SELECT  DISTINCT farm.target_name as target_name, 'oracle_ias_farm' as target_type, 'oracle_ias_farm_config' as snapshot_type,\n                prop.property_value as addl_target_info, h.table_name as table_name\n          FROM  (SELECT s.new_left_target_name as target_name, 'weblogic_j2eeserver' as target_type\n                          FROM mgmt_delta_snap s\n                         WHERE s.delta_type = 'HISTORY'\n                           AND s.delta_timestamp > l_prev_ts \n                           AND s.delta_timestamp <= l_next_ts\n                           AND s.target_type =  'weblogic_j2eeserver'\n                           AND s.snapshot_type = 'weblogic_j2eeserver_config'\n                           AND s.old_right_snapshot_guid IS NULL\n                ) new_wlserver,\n                  mgmt_targets domain, mgmt_targets server, tbls h, mgmt_target_assocs tgtAssocs, mgmt_target_properties prop,\n\t\t  mgmt_targets farm, mgmt_target_assocs farmAssoc\n         WHERE  server.target_name = new_wlserver.target_name\n           AND  server.target_type = new_wlserver.target_type\n           AND  tgtAssocs.source_target_guid = server.target_guid\n           AND  domain.target_guid = tgtAssocs.assoc_target_guid\n\t   AND  domain.target_type = 'weblogic_domain'\n\t   AND  farmAssoc.assoc_target_guid = domain.target_guid\n\t   AND  farm.target_guid = farmAssoc.source_target_guid\n\t   AND  farm.target_type = 'oracle_ias_farm'\t\n           AND  prop.target_guid = domain.target_guid\n           AND  prop.property_name = 'WebLogicHome'\n           AND  prop.property_value is not null\n\n          ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- weblogic_cluster and j2ee_application targets for existing weblogic_server targets that have had config changes.     \n      -- An existing wlserver could be added as part of a cluster or a new j2ee_application can be deployed to a existing wlserver.\n      -- So we are collecting the data for cluster and j2ee_app targets where there are changes to wlserver. \n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n         SELECT  DISTINCT assocTgt.target_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type,\n                prop.property_value as addl_target_info, h.table_name as table_name\n           FROM (SELECT s.new_left_target_name as target_name, s.target_type as target_type\n                  FROM mgmt_delta_snap s, mgmt_delta_entry e, mgmt_delta_ids i, mgmt_delta_id_values iv\n                 WHERE s.delta_type = 'HISTORY'\n                   AND s.delta_timestamp > l_prev_ts\n                   AND s.delta_timestamp <= l_next_ts\n                   AND s.target_type = 'weblogic_j2eeserver'\n                   AND s.snapshot_type = 'weblogic_j2eeserver_config'\n                   AND s.delta_guid = e.delta_guid\n                   AND e.operation != 'SAME'\n                   AND e.row_guid = i.row_guid\n                   AND iv.delta_ids_guid = i.row_guid\n                ) changed_wlserver,\n                  mgmt_targets assocTgt, mgmt_targets server, mgmt_ocm_upl_md_tbls h, mgmt_target_assocs tgtAssocs, \n                  mgmt_target_properties prop, mgmt_targets domain, mgmt_target_assocs domainAssocs, mgmt_target_assoc_defs assocDefs\n         WHERE  server.target_name = changed_wlserver.target_name\n           AND  server.target_type = changed_wlserver.target_type\n           AND  tgtAssocs.assoc_target_guid = server.target_guid \n           AND  assocTgt.target_guid = tgtAssocs.source_target_guid\n           AND  assocTgt.target_type in ('weblogic_cluster', 'j2ee_application')\n           AND  assocDefs.assoc_def_name = (CASE WHEN assocTgt.target_type = 'weblogic_cluster' THEN 'contains' ELSE 'managedServer' END)\n           AND  assocDefs.assoc_guid = tgtAssocs.assoc_guid\n           AND  h.target_type = assocTgt.target_type\n           AND  h.snapshot_type in ('weblogic_cluster_config', 'j2ee_application_config')\n           AND  domainAssocs.source_target_guid = server.target_guid\n           AND  domain.target_guid = domainAssocs.assoc_target_guid\n           AND  prop.target_guid = domain.target_guid\n           AND  prop.property_name = 'WebLogicHome'\n           AND  prop.property_value is not null\n\n          ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      IF (NOT l_split) OR l_last_interval THEN\n        EXIT;\n      ELSE -- split is on and this was not the last interval\n        l_prev_ts := l_next_ts;\n        l_next_ts := l_next_ts + l_interval;\n        IF l_next_ts >= l_max_ts THEN\n          l_next_ts := l_max_ts;\n          l_last_interval := true;\n        END IF;\n      END IF;\n\n    EXCEPTION WHEN OTHERS THEN\n      -- did we already try to split?\n      IF l_split THEN \n        IF l_interval > 0.04 THEN\n          -- last try: attempt minimal interval\n          l_interval := 0.04;\n        ELSE -- already tried minimal interval\n          RAISE;\n        END IF;\n      ELSE -- had not tried to split yet\n        -- split interval: try to split into at least 4 parts\n        -- but no more than one day and no less than about an hour each.\n        l_overall_interval := l_max_ts - l_min_ts;\n        l_interval_div_by_4 := l_overall_interval / 4;\n        IF l_interval_div_by_4 >= 1 THEN -- 1 day\n          l_interval := 1;\n        ELSIF l_interval_div_by_4 >= 0.5 THEN -- 12 hours\n          l_interval := 0.5;\n        ELSIF l_interval_div_by_4 >= 0.25 THEN -- 6 hours\n          l_interval := 0.25;\n        ELSIF l_interval_div_by_4 >= 0.125 THEN -- 3 hours\n          l_interval := 1/8;\n        ELSIF l_overall_interval > 0.04 THEN -- just less than an hour \n          l_interval := 0.04;\n        ELSE\n          RAISE; -- overall interval is already too short\n        END IF;\n      END IF;\n\n      l_split := true;\n      l_last_interval := false;\n      l_prev_ts := l_min_ts;\n      l_next_ts := l_prev_ts + l_interval;\n    END;\n  END LOOP;\n\n  UPDATE mgmt_ocm_upl_props\n     SET ts_value = l_max_ts\n   WHERE name = 'changes_ts';\n\n  COMMIT;\nEXCEPTION WHEN OTHERS THEN\n\n  MGMT_LOG.LOG_ERROR('GCHARVESTER', -202, \n    'Encountered a problem during history-based updates: ' ||\n      SQLCODE || ': ' || SQLERRM,\n    v_log_level_in =>  MGMT_GLOBAL.G_ERROR); \n  RAISE;\n\nEND;\n";
    static final String PERIODIC_NON_HISTORY_POPULATE_CODE = "DECLARE \n  l_cur_date DATE := sysdate;\n\n  -- selects metrics to be updated \n  CURSOR full_update_metrics IS\n    SELECT target_type, snapshot_type, table_name\n      FROM mgmt_ocm_upl_periodic_full f\n     WHERE f.last_update IS NULL\n        OR f.last_update + f.period < l_cur_date;\nBEGIN\n\n  FOR f IN full_update_metrics LOOP\n    BEGIN \n      UPDATE mgmt_ocm_upl_metrics m\n         SET m.is_changed = 1\n       WHERE m.target_type = f.target_type\n         AND m.snapshot_type = f.snapshot_type\n         AND m.table_name = f.table_name;\n\n      UPDATE mgmt_ocm_upl_periodic_full pf \n         SET pf.last_update = l_cur_date\n       WHERE pf.target_type = f.target_type\n         AND pf.snapshot_type = f.snapshot_type\n         AND pf.table_name = f.table_name; \n\n      COMMIT;\n\n    EXCEPTION WHEN OTHERS THEN\n\n      -- perform update in chunks\n      DECLARE\n        l_num NUMBER;\n      BEGIN\n\n        LOOP\n          UPDATE mgmt_ocm_upl_metrics m\n           SET m.is_changed = 1\n         WHERE m.is_changed = 0\n           AND m.target_type = f.target_type\n           AND m.snapshot_type = f.snapshot_type\n           AND m.table_name = f.table_name\n           AND ROWNUM <= MGMT_GLOBAL.MAX_COMMIT; \n\n          l_num := SQL%ROWCOUNT;\n\n          COMMIT;\n\n          EXIT WHEN l_num < MGMT_GLOBAL.MAX_COMMIT;\n        END LOOP; \n\n        UPDATE mgmt_ocm_upl_periodic_full pf\n           SET pf.last_update = l_cur_date\n         WHERE pf.target_type = f.target_type\n           AND pf.snapshot_type = f.snapshot_type\n           AND pf.table_name = f.table_name;\n\n        COMMIT;\n\n      EXCEPTION WHEN OTHERS THEN\n\n        MGMT_LOG.LOG_ERROR('GCHARVESTER', -203, \n          'Encountered a problem during full periodic updates for target type ' ||\n          f.target_type || ', snapshot type ' || f.snapshot_type || ', metric ' || \n          f.table_name || ': ' || SQLCODE || ': ' || SQLERRM,\n          v_log_level_in =>  MGMT_GLOBAL.G_ERROR); \n\n        RAISE;\n\n      END;\n    END;\n  END LOOP; -- over full_update_metrics\nEND;\n";
    static final String PREPARE_DATA_SHIPMENT_SQL = "BEGIN\n  EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_metrics_tmp';\n\n  BEGIN\n    EXECUTE IMMEDIATE 'DROP SEQUENCE mgmt_ocm_upl_seq';\n  EXCEPTION WHEN OTHERS THEN NULL; -- ignore if it did not exist\n  END;\n\n  EXECUTE IMMEDIATE 'CREATE SEQUENCE mgmt_ocm_upl_seq INCREMENT BY 1 START WITH 1 \n    MAXVALUE 1.0E28 MINVALUE 1 CYCLE NOORDER';\n\n  EXECUTE IMMEDIATE\n  'INSERT INTO mgmt_ocm_upl_metrics_tmp (target_name, target_type, idx)\n   SELECT target_name, target_type, mgmt_ocm_upl_seq.nextval\n     FROM (SELECT DISTINCT target_name, target_type \n             FROM mgmt_ocm_upl_metrics\n            ORDER BY target_name, target_type)';\n\n  COMMIT;\n\nEND;\n";
    static final String FIXUP_METRICS_SQL = "DECLARE \n  BATCH_SIZE CONSTANT NUMBER := 512;\n\n  l_prev_idx NUMBER := 1; -- previous index (inclusive)\n  l_next_idx NUMBER := l_prev_idx + BATCH_SIZE; -- next index (exclusive)\n  l_max_idx NUMBER := 1;\n  l_ignore_all_targets VARCHAR2(256):= 'FALSE';\nBEGIN\n\n  begin\n     select upper(str_value) \n        into l_ignore_all_targets \n       from mgmt_ocm_upl_props \n      where name = 'ignore_all_if_not_marked';\n   Exception \n     WHEN NO_DATA_FOUND THEN\n       l_ignore_all_targets := 'FALSE';\n  end;\n\n  SELECT max(idx) INTO l_max_idx FROM mgmt_ocm_upl_metrics_tmp;\n\n  WHILE l_prev_idx <= l_max_idx LOOP -- for each batch of EM targets\n\n    -- delete targets that no longer exist\n    DELETE FROM mgmt_ocm_upl_metrics m \n     WHERE EXISTS (\n             SELECT * \n               FROM mgmt_ocm_upl_metrics_tmp t\n              WHERE t.IDX >= l_prev_idx AND t.IDX < l_next_idx\n                AND t.target_name = m.target_name\n                -- skip GVM targets as they do not exists as targets in EM\n                AND t.target_type != 'oracle_vm_guest'\n                AND t.target_type != 'oracle_vm_server_host'\n                AND t.target_type = m.target_type)\n       AND NOT EXISTS (\n             SELECT *\n               FROM mgmt_targets tgt \n              WHERE m.target_name = tgt.target_name\n                AND m.target_type = tgt.target_type);\n\n    COMMIT;\n\n    -- delete no longer existing Oracle homes on hosts in the batch\n    DELETE FROM mgmt_ocm_upl_metrics m \n     WHERE m.target_type = 'host'\n       AND m.addl_target_info IS NOT NULL\n       AND EXISTS (\n             SELECT * \n               FROM mgmt_ocm_upl_metrics_tmp t\n              WHERE t.IDX >= l_prev_idx AND t.IDX < l_next_idx\n                AND t.target_name = m.target_name\n                AND t.target_type = m.target_type)\n       AND NOT EXISTS (\n             SELECT *\n               FROM mgmt_ecm_snapshot s, mgmt_inv_container c\n              WHERE s.target_name = m.target_name\n                AND s.target_type = m.target_type\n                AND s.snapshot_type = 'host_configuration'\n                AND s.is_current = 'Y'\n                AND s.snapshot_guid = c.snapshot_guid\n                AND c.container_location = m.addl_target_info);\n\n    COMMIT;\n\n    FOR home IN -- get homes with missing metrics\n      (SELECT target_name, addl_target_info\n        FROM (SELECT /*+ LEADING(T)  USE_NL(T,M) INDEX(M MGMT_OCM_UPL_METRICS_UK) */ \n                      m.target_name, m.addl_target_info, COUNT(*) metric_count\n                 FROM mgmt_ocm_upl_metrics_tmp t, mgmt_ocm_upl_metrics m\n                WHERE t.IDX >= l_prev_idx AND t.IDX < l_next_idx\n                  AND t.target_name = m.target_name\n                  AND t.target_type = m.target_type\n                  AND t.target_type = 'host'\n                  AND m.addl_target_info IS NOT NULL\n                  GROUP BY m.target_name, m.addl_target_info)\n       WHERE metric_count < 3)\n    LOOP\n      -- insert missing metric rows\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (SELECT 'ECM$HIST_INV_COMPONENTS' as table_name FROM DUAL \n               UNION ALL SELECT 'ECM$HIST_INV_PATCHES' FROM DUAL\n               UNION ALL SELECT 'ECM$HIST_INV_PATCHSETS' FROM DUAL) h\n         ON (p.target_type = 'host'\n        AND p.target_name = home.target_name\n        AND p.snapshot_type = 'host_configuration'\n        AND p.table_name = h.table_name)\n       WHEN MATCHED THEN UPDATE SET p.is_changed = p.is_changed \n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (home.target_name, 'host', 'host_configuration', h.table_name, home.addl_target_info);\n    END LOOP;\n\n    COMMIT;\n\n    --delete target marked to be ignored\n    if(l_ignore_all_targets = 'TRUE')\n    then\n      --delete all the target except for those not marked\n      -- to ignore\n      DELETE FROM mgmt_ocm_upl_metrics m\n        WHERE NOT EXISTS (\n              select 'X' from\n                     mgmt_ocm_upl_metrics_tmp t,\n                     mgmt_target_prop_defs d,\n                     mgmt$target_properties p\n              WHERE  t.IDX >= l_prev_idx AND\n                     t.IDX < l_next_idx AND\n                     t.target_name = m.target_name AND\n                     t.target_type = m.target_type and\n                     p.target_name = t.target_name and\n                     p.target_type = t.target_type and\n                     p.property_name = d.property_name and\n                     p.property_value = 'false' and\n                     p.target_type = d.target_type and\n                     d.property_display_name = 'Harvester Ignore' and\n                     d.property_name like 'udtp%'\n        );\n\n        commit;\n\n    else\n        --delete the targets marked to ignore\n        DELETE FROM mgmt_ocm_upl_metrics m\n        WHERE EXISTS (\n              select 'X' from \n                     mgmt_ocm_upl_metrics_tmp t,\n                     mgmt_target_prop_defs d, \n                     mgmt$target_properties p \n              WHERE  t.IDX >= l_prev_idx AND \n                     t.IDX < l_next_idx AND \n                     t.target_name = m.target_name AND\n                     t.target_type = m.target_type and\n                     p.target_name = t.target_name and \n                     p.target_type = t.target_type and \n                     p.property_name = d.property_name and \n                     p.property_value = 'true' and \n                     p.target_type = d.target_type and \n                     d.property_display_name = 'Harvester Ignore' and \n                     d.property_name like 'udtp%' \n        );\n\n        commit;\n    end if;\n\n    l_prev_idx := l_next_idx;  \n    l_next_idx := l_next_idx + BATCH_SIZE;\n\n  END LOOP; -- for each target batch\nEND;\n";
    public static final String LOG_ERROR_TO_REP = "BEGIN\n  MGMT_LOG.LOG_ERROR('GCHARVESTER', -200, ?,\n    v_log_level_in => MGMT_GLOBAL.G_ERROR);\nEND;    \n";
    static final String DB_FU_11_2_QUERY = "SELECT \ndbid, \nname,\nversion, \nMAX(detected_usages) detected_usages, \nMAX(total_samples) total_samples, \nDECODE (MAX (currently_used_num ), 1, 'TRUE', 'FALSE' ) currently_used, \nmin (first_usage_date) first_usage_date, \nmax ( last_usage_date ) last_usage_date, \nmax (aux_count) aux_count, \nmax (last_sample_date) last_sample_date, \nmax (last_sample_period) last_sample_period, \nmax (to_char (feature_info)) feature_info\nFROM (\n\tSELECT \n\tdbfu.dbid, \n\tdbfu.name, \n\tdbfu.version, \n\tdbfu.detected_usages, \n\tdbfu.total_samples, \n\tdbfu.currently_used, \n\tdbfu.first_usage_date, \n\tdbfu.last_usage_date, \n\tdbfu.aux_count, \n\tdbfu.last_sample_date, \n\tdbfu.last_sample_period, \n\tNULL feature_info,  -- feature_info is not stored\n\ttemp.target_guid, \n\tdecode (dbfu.currently_used,'TRUE', 1, 0) currently_used_num \n\tFROM mgmt_db_featureusage dbfu , \n\t\t(SELECT max(dfu.collection_timestamp) max_coll_timestamp , tgt.target_guid target_guid\n\t\t FROM mgmt_db_featureusage dfu , mgmt_targets tgt\n\t\t WHERE tgt.target_guid = dfu.target_guid \n\t\t AND tgt.target_name = :tn\n\t\t AND tgt.target_type = :tt \n\t\t group by tgt.target_guid ) temp\n\tWHERE \n        dbfu.target_guid = temp.target_guid\n        AND dbfu.collection_timestamp = temp.max_coll_timestamp  -- to get the latest collection data\n\n\tUNION ALL\n\n\tSELECT \n\tdbfu.dbid , \n\tregis.FEATURE_name name,\n\temfu.version ,\n\temfu.DETECTED_SAMPLES detected_usages, \n\temfu.TOTAL_SAMPLES, \n\tdecode (emfu.ISUSED ,1,'TRUE','FALSE') currently_used, \n\tnull first_usage_date, -- first_usage_date not stored\n\temfu.LAST_USAGE_DATE, \n\temfu.AUX_COUNT,\n\temfu.LAST_SAMPLE_DATE, \n\tNULL last_sample_period, -- last_sample_period is not stored\n\temfu.FEATURE_INFO , \n\temfu.target_guid,\n\temfu.ISUSED currently_used_num\n\tFROM mgmt_fu_statistics emfu ,  \n\tmgmt_fu_registrations regis,\n\t\t(SELECT dbf.dbid dbid, temp.target_guid target_guid\n\t\tFROM mgmt_db_featureusage dbf , \n\t\t\t(SELECT max(dfu.collection_timestamp) max_coll_timestamp , tgt.target_guid target_guid\n\t\t\t FROM mgmt_db_featureusage dfu , mgmt_targets tgt\n\t\t\t WHERE tgt.target_guid = dfu.target_guid \n\t\t\t AND tgt.target_name = :tn\n\t\t\t AND tgt.target_type = :tt \n\t\t\t group by tgt.target_guid ) temp\n\t\tWHERE \n\t\tdbf.collection_timestamp = temp.max_coll_timestamp \n\t\tAND ROWNUM = 1 ) dbfu\n\tWHERE \n\tdbfu.target_guid = emfu.target_guid\n\tAND regis.feature_id = emfu.feature_id\n) GROUP BY name , version , dbid\n";
    public static final String MERGE_ERROR_FLAG = "      MERGE INTO mgmt_ocm_upl_props p\n      USING dual\n      ON ( name = 'harv_error' )\n      WHEN MATCHED THEN UPDATE SET p.str_value = ?, p.num_value = ?, p.ts_value = systimestamp\n      WHEN NOT MATCHED THEN INSERT (name, str_value, num_value, ts_value)\n      VALUES ('harv_error', ?, ?, systimestamp)\n";
    public static final String SCNINFO_HARVEST_SQL = "DECLARE  \n  l_max_rate      NUMBER := 16*1024;\n  l_seconds_1988  NUMBER := 0;\n  l_maximum_scn   NUMBER;\n  l_base_year     NUMBER := 1988;\n  l_db_version    VARCHAR2(10);\n  l_patch         NUMBER;\n\n  l_current_scn   NUMBER;\n  l_headroom      NUMBER;\n  l_growth_24hrs  NUMBER;\n  l_scn_calls     NUMBER;\n  l_dblink_out    NUMBER;\n  l_dblink_in     NUMBER;\n  l_max_jump      NUMBER ;\n  l_max_jump_time VARCHAR2(32);\n  l_created       VARCHAR2(32);\n  l_reject_thresh NUMBER;\n\n  c_time_16       NUMBER;\n  c_time_32       NUMBER;\n\n  l_end_done      BOOLEAN := FALSE;\n  l_sql_text      VARCHAR2(2000);\n  l_sql_piece VARCHAR2(200);\n  l_is_gmt VARCHAR2(10);\n\n  L_HROOM_THRESHOLD NUMBER := ?;\n  TYPE RESULT_CRSR IS REF CURSOR;\n  CRSR_TEST_RESULT   RESULT_CRSR;  \nBEGIN\n  select 16*1024*24*60*60, 32*1024*24*60*60 into c_time_16, c_time_32 from dual;\n\n  SELECT LPAD(version, 10, '0') into l_db_version from v$instance;\n  IF (l_db_version = '11.2.0.2.0' OR l_db_version = '11.2.0.3.0') THEN\n    l_sql_text :=\n      'SELECT count(*) from dba_registry_history ' ||\n      'where comments=''CPUJan2012'' OR comments=''CPUApr2012''';\n    -- presence of this parameter indicates CPU patch is installed.\n    EXECUTE IMMEDIATE l_sql_text INTO l_patch;\n    -- if no rows, then patch is not installed on 11.2.0.2 and 11.2.0.3\n    IF (l_patch = 0) THEN\n      l_max_rate := 32*1024;\n      l_base_year := 2009;\n      select 4*1024*1024*1024*2575 into l_seconds_1988 from dual;\n    END IF;\n  END IF;\n  -- current_scn, intrinsic change (not rate!)\n  IF (l_db_version > '10.0.0.0.0') THEN\n    l_sql_text :=\n    'SELECT d.current_scn, svalue ' ||\n    'FROM v$database d, ' ||\n    '(SELECT sum(s.value) svalue from v$sysstat s WHERE s.name in (''calls to kcmgas'', ''redo writes''))';\n    EXECUTE IMMEDIATE l_sql_text INTO l_current_scn, l_scn_calls;\n  ELSE\n    l_sql_text :=\n    'select dbms_flashback.get_system_change_number from dual';\n    EXECUTE IMMEDIATE l_sql_text INTO l_current_scn;\n    l_sql_text :=\n    'SELECT sum(s.value) svalue from v$sysstat s WHERE s.name in (''calls to kcmgas'', ''redo writes'')';\n    EXECUTE IMMEDIATE l_sql_text INTO l_scn_calls;\n  END IF;\n\n  -- this formula comes from kcmbts\n  SELECT\n    (((((( (to_number(to_char(sysdate,'YYYY'))-l_base_year)* 12  \n          +(to_number(to_char(sysdate,'MM'))-1))           * 31  \n         + (to_number(to_char(sysdate,'DD'))-1))           * 24  \n        +  (to_number(to_char(sysdate,'HH24'))))           * 60  \n       +   (to_number(to_char(sysdate,'MI'  ))))           * 60  \n      +    (to_number(to_char(sysdate,'SS'  ))))\n     * l_max_rate) + l_seconds_1988\n    INTO l_maximum_scn FROM dual;\n\n  -- scn_headroom\n  IF (l_max_rate = 32768) THEN\n    IF (l_current_scn > l_seconds_1988) THEN\n      SELECT to_char(((l_maximum_scn - l_current_scn) / c_time_32),'99999D99')\n        INTO l_headroom FROM dual;        \n    ELSE\n      SELECT to_char((((l_maximum_scn - l_seconds_1988) / c_time_32) +\n                     ((l_seconds_1988 - l_current_scn) / c_time_16)),'99999D99')\n          INTO l_headroom FROM dual; \n    END IF;\n  ELSE\n    SELECT to_char(((l_maximum_scn - l_current_scn) / c_time_16),'99999D99')\n      INTO l_headroom FROM dual;\n  END IF;\n\n   IF(l_headroom > L_HROOM_THRESHOLD ) THEN  GOTO OPENCURSOR; END IF;\n\n  -- outgoing DB links\n  SELECT count(*) INTO l_dblink_out FROM DBA_DB_LINKS;\n\n  -- incoming DB links\n  SELECT count(*) INTO l_dblink_in FROM dba_audit_trail \n    WHERE action_name='LOGON' AND comment_text LIKE '%DBLINK_INFO%' AND timestamp > (sysdate-1) ORDER BY timestamp;\n\n  -- max jump size, average (total) growth rate, max jump timestamp\n  IF (l_db_version > '10.0.0.0.0') THEN\n    begin\n      EXECUTE IMMEDIATE 'select PROPERTY_VALUE from DATABASE_PROPERTIES where PROPERTY_NAME=''Flashback Timestamp TimeZone''' INTO l_is_gmt;\n    EXCEPTION\n\tWHEN OTHERS THEN\n\tl_is_gmt := '';\n    end;\n    IF (l_is_gmt = 'GMT') THEN\n      l_sql_piece := 'WHERE time_dp > sys_extract_utc(systimestamp)-1';\n    ELSE\n      l_sql_piece := 'WHERE time_dp > sysdate-1';\n    END IF;\n    l_sql_text := \n    'SELECT scn_per_sec, round(avg_scn_per_sec), to_char(time_stamp, ''YYYY-MM-DD HH24:MI:SS'') ' ||\n    'FROM ' ||\n      '( SELECT time_stamp, scn_per_sec, avg(scn_per_sec) over() avg_scn_per_sec, max(scn_per_sec) over() max_scn_per_sec ' ||\n        'FROM ' ||\n          '( SELECT time_dp time_stamp, scn, ' ||\n                 'round ((scn - lag(scn,1) over(ORDER BY time_dp))/ ' ||\n                        '(60*60*24 * (time_dp - lag(time_dp,1) over(ORDER BY time_dp))), ' ||\n                        '0) scn_per_sec ' ||\n            'FROM sys.smon_scn_time ' ||\n            l_sql_piece ||\n          ') ' ||\n        'WHERE scn_per_sec IS NOT NULL order by time_stamp desc ' ||\n      ') ' || -- remove first entry which will have null because of lag()\n    'WHERE scn_per_sec = max_scn_per_sec and rownum = 1';\n    EXECUTE IMMEDIATE l_sql_text INTO l_max_jump, l_growth_24hrs, l_max_jump_time;\n  END IF;\n  -- db creation time\n  SELECT to_char(created,'YYYY-MM-DD HH24:MI:SS') INTO l_created FROM v$database;\n\n  -- reject threshold (may not exist, catch that)\n  BEGIN\n    SELECT value INTO l_reject_thresh FROM v$parameter WHERE name='_external_scn_rejection_threshold_hours';\n    EXCEPTION\n      WHEN NO_DATA_FOUND THEN\n        l_reject_thresh := -1;\n  END;\n\n    <<OPENCURSOR>>\n    OPEN CRSR_TEST_RESULT FOR\n        SELECT  \n\t\t\tl_current_scn, \n\t\t\tl_headroom ,   \n\t\t\tl_growth_24hrs,\n\t\t\tl_scn_calls,\n\t\t\tl_dblink_out,\n\t\t\tl_dblink_in,\n\t\t\tl_max_jump,\n\t\t\tl_max_jump_time,\n\t\t\tl_created,\n\t\t\tl_reject_thresh\n        FROM DUAL where l_headroom < l_hroom_threshold;\n\n     ? := crsr_test_result;\n\nEND ;  \n";
}

