/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester;

public class HarvesterSql112 {
    public static final String GET_OCM_TARGET = " SELECT  t.target_name, \n         t.target_type, \n         t.display_name, \n         t.host_name, \n         t.timezone_region,\n         /* lowercase home path if find host and it runs any kind of Windows */\n         COALESCE (\n           (SELECT (\n              CASE \n                WHEN INSTR(NLS_UPPER(t2.category_prop_1), 'WINDOWS') != 0 THEN\n                  NLS_LOWER(p.property_value)\n                ELSE p.property_value\n              END)\n            FROM mgmt_targets t2\n            WHERE t2.target_name = t.host_name\n            AND t2.target_type = 'host'),\n           p.property_value) home,\n         t.discovered_name discovered_name\n    FROM mgmt_targets t, \n         mgmt_target_properties p\n   WHERE t.target_guid = hextoraw(?)\n     AND t.target_guid = p.target_guid (+)\n     AND 'OracleHome' = p.property_name(+)\n";
    static final String GET_TARGET_BATCH = " SELECT  t.target_name, \n         t.target_type, \n         t.display_name, \n         t.host_name, \n         t.timezone_region,\n         /* lowercase home path if find host and it runs any kind of Windows */\n         COALESCE (\n           (SELECT (\n              CASE \n                WHEN INSTR(NLS_UPPER(t2.category_prop_1), 'WINDOWS') != 0 THEN\n                  NLS_LOWER(p.property_value)\n                ELSE p.property_value\n              END)\n            FROM mgmt_targets t2\n            WHERE t2.target_name = t.host_name\n            AND t2.target_type = 'host'),\n           p.property_value) home,\n         t.discovered_name discovered_name\n    FROM mgmt_ocm_upl_metrics_tmp o, \n           mgmt_targets t, \n         mgmt_target_properties p\n   WHERE o.idx >= ? AND o.idx < ?\n     AND t.target_name = o.target_name\n     AND t.target_type = o.target_type\n     AND t.target_guid = p.target_guid (+)\n     AND 'OracleHome' = p.property_name(+)\n   ORDER BY o.idx\n";
    static final String ADD_TARGETS_FOR_NEW_TT = "BEGIN  \n     -- This is the harvester upgarde scenario WHERE the major version gets upgraded , the procedure will take   \n     -- care of adding the new targets coming FROM new target type if were introduced with upgrade  \n\n     -- Find all the target types which are present in mgmt_ocm_upl_md_tbls but not in mgmt_ocm_upl_metrics  \n     -- Loop over each target type and update the mgmt_ocm_upl_metrics if new targets found  \n\n     FOR record IN ( SELECT DISTINCT(target_type) FROM mgmt_ocm_upl_md_tbls mt    \n                     WHERE NOT EXISTS (SELECT target_type FROM mgmt_ocm_upl_metrics um \n                                       WHERE um.target_type = mt.target_type))  \n     LOOP  \n         -- weblogic domain target type requires special casing\n        IF  record.target_type = 'weblogic_domain' THEN\n             -- populate weblogic domain target type metrics\n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)\n                 -- defaults used for:  is_changed\n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p\n                WHERE t.target_type = 'weblogic_domain'\n                  AND h.target_type = t.target_type\n                  AND p.target_guid = t.target_guid\n                  AND p.property_name = 'WebLogicHome';\n\n        -- weblogic_cluster/j2ee_application target types requires special casing\n        ELSIF  (record.target_type = 'weblogic_cluster' OR\n                record.target_type = 'j2ee_application') THEN\n             -- populate weblogic cluster target type metrics\n               INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)\n                 -- defaults used for:  is_changed\n               SELECT distinct t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n                WHERE t.target_type = record.target_type\n                  AND h.target_type = t.target_type\n                  AND assocs.source_target_guid = t.target_guid\n                  AND domain.target_guid = assocs.assoc_target_guid\n                  AND domain.target_type = 'weblogic_domain'\n                  AND p.target_guid = domain.target_guid\n                  AND p.property_name = 'WebLogicHome';\n\n        -- oracle_ias_farm target type requires special casing\n        ELSIF  record.target_type = 'oracle_ias_farm' THEN\n              -- populate oracle ias farm target type metric\n                INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n                 (target_name, target_type, snapshot_type, table_name, addl_target_info)\n                 -- defaults used for:  is_changed\n               SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n                 FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n                WHERE t.target_type = record.target_type\n                  AND h.target_type = t.target_type\n                  AND assocs.source_target_guid = t.target_guid\n                  AND domain.target_guid = assocs.assoc_target_guid\n                  AND domain.target_type = 'weblogic_domain'\n                  AND p.target_guid = domain.target_guid\n                  AND p.property_name = 'WebLogicHome'\n                  AND assocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*');\n\n           --if a new target type requires special casing , add a new ELSIF\n           -- This is for generic target types\n        ELSE\n          -- populate metrics other than host config and oracle home target type  \n             INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name)  \n                 -- defaults used for:  addl_target_info, is_changed  \n             SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name  \n             FROM mgmt_ecm_gen_snapshot s, mgmt_ocm_upl_md_tbls h  \n             WHERE s.is_current = 'Y'  \n               AND s.target_type = h.target_type  \n               AND s.snapshot_type = h.snapshot_type  \n             --AND NOT (s.target_type = 'host' and s.snapshot_type = 'host_configuration')  \n               AND s.target_type = record.target_type\n               AND exists (select 'x' from mgmt_targets where target_guid = s.target_guid);  \n         END IF;\n         COMMIT;\n\n         INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics  \n                 (target_name, target_type, snapshot_type, table_name)  \n                 -- defaults used for:  addl_target_info, is_changed  \n         SELECT distinct tg.target_name, tg.target_type, \n                    'OCheck' snapshot_type, \n                   'MGMT_DIAGNOSTIC_CHECK_ROWS' table_name\n           FROM MGMT_DIAGNOSTIC_CHECK_ROWS d, mgmt_targets tg\n          WHERE tg.target_guid = d.target_guid\n            AND tg.target_type = record.target_type;  \n         COMMIT;\n     END LOOP;  \n\n     EXCEPTION WHEN OTHERS THEN   \n\n       MGMT_LOG.LOG_ERROR('GCHARVESTER', -201,   \n         'Encountered a problem during addtion of new targets for OCM upload: ' ||   \n           SQLCODE || ': ' || SQLERRM,   \n         v_log_level_in =>  MGMT_GLOBAL.G_ERROR);   \n\n       RAISE;   \n\nEND;  \n";
    static final String RESYNC_CODE = "DECLARE\n  l_changes_ts DATE;\nBEGIN\n  -- Initialization / resynch code\n  EXECUTE IMMEDIATE 'TRUNCATE TABLE mgmt_ocm_upl_metrics';\n\n  -- would rather later send duplicate config than miss some changes\n  -- assumption: history code does not take more than 10 minutes\n  l_changes_ts := sysdate - 1 / (24 * 6); \n\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics \n    (target_name, target_type, snapshot_type, table_name)\n    -- defaults used for:  addl_target_info, is_changed\n  SELECT s.target_name, s.target_type, s.snapshot_type, h.table_name\n    FROM mgmt_ecm_gen_snapshot s, mgmt_ocm_upl_md_tbls h\n   WHERE s.is_current = 'Y'\n     AND s.target_type = h.target_type \n     AND s.snapshot_type = h.snapshot_type \n     --wls targets need to populate additional info with oracle home value\n     --so populating them is custom query\n     AND h.target_type not in ('weblogic_domain', 'weblogic_cluster',\n                               'oracle_ias_farm', 'j2ee_application')\n     AND exists (select 'x' from mgmt_targets where target_guid = s.target_guid);  \n\n  COMMIT;\n\n   -- populate weblogic domain target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p\n    WHERE t.target_type = 'weblogic_domain'\n     AND h.target_type = t.target_type\n     AND p.target_guid = t.target_guid\n     AND p.property_name = 'WebLogicHome';\n\n  COMMIT;\n\n  -- populate weblogic_cluster/j2ee_application target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT distinct  t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n    WHERE t.target_type in ('weblogic_cluster', 'j2ee_application')\n     AND h.target_type = t.target_type\n     AND assocs.source_target_guid = t.target_guid\n     AND domain.target_guid = assocs.assoc_target_guid\n     AND domain.target_type = 'weblogic_domain'\n     AND p.target_guid = domain.target_guid\n     AND p.property_name = 'WebLogicHome';\n\n  COMMIT;\n\n  -- populate oracle_ias_farm target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info)\n    -- defaults used for: is_changed\n  SELECT t.target_name, t.target_type, h.snapshot_type, h.table_name, p.property_value\n     FROM mgmt_targets t, mgmt_ocm_upl_md_tbls h, mgmt_target_properties p, mgmt_target_assocs assocs, mgmt_targets domain\n    WHERE t.target_type = 'oracle_ias_farm'\n     AND h.target_type = t.target_type\n     AND assocs.source_target_guid = t.target_guid\n     AND domain.target_guid = assocs.assoc_target_guid\n     AND domain.target_type = 'weblogic_domain'\n     AND p.target_guid = domain.target_guid \n     AND p.property_name = 'WebLogicHome' \n     AND assocs.assoc_guid = mgmt_assoc.get_assoc_def_guid('contains', '*');\n\n  COMMIT;\n\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics \n    (target_name, target_type, snapshot_type, table_name)\n    -- defaults used for:  addl_target_info, is_changed\n  SELECT distinct tg.target_name, tg.target_type, \n         'OCheck' snapshot_type, \n         'MGMT_DIAGNOSTIC_CHECK_ROWS' table_name\n    FROM MGMT_DIAGNOSTIC_CHECK_ROWS d, mgmt_targets tg\n   WHERE tg.target_guid = d.target_guid;\n\n  COMMIT;\n\n  INSERT /*+ APPEND */ INTO MGMT_OCM_UPL_METRICS(target_name, target_type, snapshot_type, table_name, last_harvest_ts)\n  /* \n   * Association to get database from dbmachine\n   * rac_database -> deployed_on -> oracle_dbmachine\n   * rac_databas -> cluster_contains -> oracle_database\n   */\n  SELECT \n         --RAC2DBMC.ASSOC_TYPE, DBMC.TARGET_TYPE, RAC2DB.ASSOC_TYPE, DB.TARGET_TYPE,\n         DB.TARGET_NAME, \n         DB.TARGET_TYPE, \n         'oracle_db_adrinfo' SNAPSHOT_TYPE, \n         'MGMT_ECM_ADR_INFO' TABLE_NAME,\n         add_months(sysdate , -12) LAST_HARVEST_TS\n  FROM GC_ASSOC_INSTANCES RAC2DBMC \n  JOIN MGMT_TARGETS DBMC ON DBMC.TARGET_TYPE = 'oracle_dbmachine' AND DBMC.TARGET_GUID = RAC2DBMC.DEST_ME_GUID \n  JOIN GC_ASSOC_INSTANCES RAC2DB ON RAC2DB.SOURCE_ME_GUID = RAC2DBMC.SOURCE_ME_GUID \n  JOIN MGMT_TARGETS DB ON DB.TARGET_TYPE = 'oracle_database' AND DB.TARGET_GUID = RAC2DB.DEST_ME_GUID \n  WHERE RAC2DBMC.ASSOC_TYPE = 'deployed_on' AND RAC2DB.ASSOC_TYPE = 'cluster_contains';\n\n  COMMIT;\n\n   -- populate SCN metric target type metrics\n  INSERT /*+ APPEND */ INTO mgmt_ocm_upl_metrics\n    (target_name, target_type, snapshot_type, table_name, addl_target_info, last_harvest_ts)\n     SELECT DISTINCT  \n            T.TARGET_NAME, \n            T.TARGET_TYPE,   \n            H.SNAPSHOT_TYPE , \n            H.TABLE_NAME, \n            NULL AS ADDL_TARGET_INFO, \n            add_months(sysdate , -12) LAST_HARVEST_TS\n     FROM MGMT_TARGETS T, MGMT_OCM_UPL_MD_TBLS H\n     WHERE T.TARGET_TYPE = H.TARGET_TYPE\n        AND  H.SNAPSHOT_TYPE = 'oracle_db_adrinfo'\n        AND T.TARGET_TYPE = 'oracle_database' \n        AND H.TABLE_NAME='MGMT_ECM_SCN_INFO' ;\n\n  COMMIT;\n\n\n  MERGE INTO mgmt_ocm_upl_props p\n  USING dual \n     ON ( name = 'changes_ts' )\n   WHEN MATCHED THEN UPDATE SET p.ts_value = l_changes_ts\n   WHEN NOT MATCHED THEN INSERT (name, ts_value)\n        VALUES ('changes_ts', l_changes_ts);\n\n  -- update periodic full table since all its metrics are marked\n  UPDATE mgmt_ocm_upl_periodic_full\n     SET last_update = sysdate;\n\n  -- increment resync_seq_num for older code\n  UPDATE mgmt_ocm_upl_props\n     SET num_value = num_value + 1\n   WHERE name = 'resync_seq_num';\n\n  -- update last full resynch timestamp\n  MERGE INTO mgmt_ocm_upl_props p\n  USING (SELECT SYSTIMESTAMP AT TIME ZONE 'GMT' AS ts FROM dual) t\n     ON ( name = 'last_full_resync_ts_gmt' )\n   WHEN MATCHED THEN UPDATE SET p.ts_value = t.ts\n   WHEN NOT MATCHED THEN INSERT (name, ts_value) values\n        ('last_full_resync_ts_gmt', t.ts);\n\n  COMMIT;\n\nEXCEPTION WHEN OTHERS THEN\n\n  MGMT_LOG.LOG_ERROR('GCHARVESTER', -201,\n    'Encountered a problem during [re]initialization of OCM upload: ' ||\n      SQLCODE || ': ' || SQLERRM,\n    v_log_level_in =>  MGMT_GLOBAL.G_ERROR);\n\n  RAISE;\n\nEND;\n";
    static final String HISTORY_POPULATE_CODE = "DECLARE\n  l_min_ts DATE := NULL;\n  l_max_ts DATE := NULL;\n  l_prev_ts DATE := NULL;\n  l_next_ts DATE := NULL;\n  l_overall_interval NUMBER; -- overall number of days\n  l_interval_div_by_4 NUMBER; -- above number divided by 4\n  l_interval NUMBER := 1; -- number of days (used to split overall interval)\n  l_split BOOLEAN := false; -- are we splitting into intervals?\n  l_last_interval BOOLEAN := true; -- are we processing last interval?\nBEGIN\n  BEGIN\n    SELECT ts_value INTO l_min_ts\n      FROM mgmt_ocm_upl_props\n     WHERE name = 'changes_ts';\n  EXCEPTION WHEN NO_DATA_FOUND THEN\n    raise_application_error(-20000, \n      'Internal error: last update timestamp is unavailable to history-based code');\n  END;\n\n  -- select current timestamp minus 10 minutes (assumption: ECM history computation\n  -- should be done within 10 minutes of when it starts)\n  l_max_ts := sysdate - 1 / (24 * 6);\n\n  l_prev_ts := l_min_ts;\n  l_next_ts := l_max_ts;\n  LOOP -- over intervals\n    BEGIN\n\n      -- update mgmt_ocm_upl_metrics with changes in the l_prev_ts to l_next_ts interval\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n        SELECT DISTINCT s.target_name as target_name, s.target_type ,\n                        s.snapshot_type, null as addl_target_info, h.table_name\n        from EM_ECM_ALL_CONFIG_METRICS a,\n             mgmt_ecm_gen_snapshot s,\n             mgmt_ocm_upl_md_tbls  h\n        where\n             --addl_target_info should never be null for these wls target types\n             --so not considering for this query\n             h.TARGET_TYPE not in ('weblogic_domain', 'weblogic_cluster',\n                               'oracle_ias_farm', 'j2ee_application') and\n             h.TARGET_TYPE = s.TARGET_TYPE and\n             h.snapshot_type = s.snapshot_type and\n             a.ecm_snapshot_id = s.SNAPSHOT_GUID and\n             s.is_current in ('Y', 'P') and\n             h.table_name = a.table_name and\n             a.collection_timestamp > l_prev_ts and\n             a.collection_timestamp <= l_next_ts\n        ) t\n          ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- Fix for bug#9980503\n      -- MGMT_ECM_ASSOCIATIONS is a periodically collected metric for weblogic_j2eeserver target.\n      -- Adding the following query to minimize the time lag in collecting the MGMT_ECM_ASSOCIATIONS metric which would otherwise be collected periodically i.e 30 days\n      -- Following query would enable the MGMT_ECM_ASSOCIATIONS metric collection when there is any change in the existing server cofiguration\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n         SELECT DISTINCT s.target_name  as target_name, 'weblogic_j2eeserver' as target_type,\n                'weblogic_j2eeserver_config' as snapshot_type,  null as addl_target_info,\n                'MGMT_ECM_ASSOCIATIONS' as table_name\n          from mgmt_ecm_gen_snapshot s\n           where s.target_type = 'weblogic_j2eeserver' and\n                 s.snapshot_type = 'weblogic_j2eeserver_config' and\n                  s.is_current in ('Y', 'P') and\n                   exists (select 'x' from EM_ECM_ALL_CONFIG_METRICS a\n                               where a.ecm_snapshot_id = s.SNAPSHOT_GUID and\n                                     a.collection_timestamp > l_prev_ts and\n                                     a.collection_timestamp <= l_next_ts\n                           )\n\n         ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null \n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- weblogic_domain/weblogic_cluster/j2ee_application targets depends on weblogic server target for snapshot and history as there is no snapshot for domain target in EMGC\n      -- First get the new weblogic server target or for which snapshot has chaned, now from targets table get the corresponding\n      -- weblogic server target guid , use the guid to find the domain/cluster/j2ee_application target from assocs table\n      -- and other data from upl_md_table\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        SELECT  DISTINCT assocTgt.target_name as target_name, h.target_type as target_type, h.snapshot_type as snapshot_type,\n                prop.property_value as addl_target_info, h.table_name as table_name\n          FROM  (\n                    SELECT s.target_name  as target_name, s.target_type as target_type\n                      from mgmt_ecm_gen_snapshot s\n                     where s.target_type = 'weblogic_j2eeserver' and\n                           s.snapshot_type = 'weblogic_j2eeserver_config' and\n                           s.is_current in ('Y', 'P') and\n                           exists\n                              (select 'x' from EM_ECM_ALL_CONFIG_METRICS a\n                               where a.ecm_snapshot_id = s.SNAPSHOT_GUID and\n                                     a.collection_timestamp > l_prev_ts and\n                                     a.collection_timestamp <= l_next_ts\n                               )\n\n                ) new_wlserver,\n                  mgmt_targets assocTgt, mgmt_targets server, mgmt_ocm_upl_md_tbls h, mgmt_target_assocs tgtAssocs,\n                  mgmt_target_properties prop, mgmt_targets domain, mgmt_target_assocs domainAssocs\n        WHERE  server.target_name = new_wlserver.target_name\n           AND  server.target_type = new_wlserver.target_type\n           AND  tgtAssocs.assoc_target_guid = server.target_guid\n           AND  assocTgt.target_guid = tgtAssocs.source_target_guid\n           AND  assocTgt.target_type in ('weblogic_domain', 'weblogic_cluster', 'j2ee_application')\n           AND  h.target_type = assocTgt.target_type\n           AND  h.snapshot_type in ('weblogic_domain_config', 'weblogic_cluster_config', 'j2ee_application_config')\n           AND  domainAssocs.source_target_guid = server.target_guid\n           AND  domain.target_guid = domainAssocs.assoc_target_guid\n           AND  prop.target_guid = domain.target_guid\n           AND  prop.property_name = 'WebLogicHome'\n           AND  prop.property_value is not null\n\n          ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      -- oracle_ias_farm target has an association with weblogic domain target\n      -- weblogic domain target depends on weblogic server target for snapshot and history as there is no snapshot for domain target in EMGC\n      -- First get the new weblogic server target or for which snapshot has chaned, then get the corresponding domain target from the assocs table.\n      -- finally use the domain target guid to find the oracle ias farm target from assocs table\n      -- and other data from upl_md_table\n      -- For oracle_ias_farm target we are only collecting association with the wl adminserver target.\n      -- The association with the wl adminserver target will not change if there are any config changes for the wlserver target.\n      -- So we are not collecting data for oracle_ias_farm target when there are changes to the wlserver.\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n\n        WITH tbls AS\n        (SELECT /*+ materialize */ table_name\n         FROM mgmt_ocm_upl_md_tbls\n         WHERE target_Type = 'oracle_ias_farm'\n           AND snapshot_type = 'oracle_ias_farm_config')\n\n        SELECT  DISTINCT farm.target_name as target_name, 'oracle_ias_farm' as target_type, 'oracle_ias_farm_config' as snapshot_type,\n                prop.property_value as addl_target_info, h.table_name as table_name\n          FROM  ( SELECT s.target_name  as target_name, s.target_type as target_type\n                      from mgmt_ecm_gen_snapshot s\n                     where s.target_type = 'weblogic_j2eeserver' and\n                           s.snapshot_type = 'weblogic_j2eeserver_config' and\n                           s.is_current in ('Y', 'P') and\n                           exists\n                              (select 'x' from EM_ECM_ALL_CONFIG_METRICS a\n                               where a.ecm_snapshot_id = s.SNAPSHOT_GUID and\n                                     a.collection_timestamp > l_prev_ts and\n                                     a.collection_timestamp <= l_next_ts\n                               )\n\n                ) new_wlserver,\n                  mgmt_targets domain, mgmt_targets server, tbls h, mgmt_target_assocs tgtAssocs, mgmt_target_properties prop,\n                  mgmt_targets farm, mgmt_target_assocs farmAssoc\n         WHERE  server.target_name = new_wlserver.target_name\n           AND  server.target_type = new_wlserver.target_type\n           AND  tgtAssocs.source_target_guid = server.target_guid\n           AND  domain.target_guid = tgtAssocs.assoc_target_guid\n           AND  domain.target_type = 'weblogic_domain'\n           AND  farmAssoc.assoc_target_guid = domain.target_guid\n           AND  farm.target_guid = farmAssoc.source_target_guid\n           AND  farm.target_type = 'oracle_ias_farm'\n           AND  prop.target_guid = domain.target_guid\n           AND  prop.property_name = 'WebLogicHome'\n           AND  prop.property_value is not null\n\n          ) t\n         ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info = t.addl_target_info\n            )\n       WHEN MATCHED THEN UPDATE SET p.is_changed = 1\n       WHEN NOT MATCHED THEN INSERT (target_name, target_type, snapshot_type, table_name, addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n      --insert for Periodic metric for the target, first time when target is added\n      insert into mgmt_ocm_upl_metrics \n       (target_name, target_type, snapshot_type, table_name, addl_target_info)\n      SELECT DISTINCT s.target_name as target_name, s.target_type ,s.snapshot_type, h.table_name,  null as addl_target_info\n         from mgmt_ecm_gen_snapshot s,\n               mgmt_ocm_upl_md_tbls  h\n         where h.kind = 2 and\n               --addl_target_info should never be null for thee wls target types\n               --so not considering for this query\n               h.target_type not in ('weblogic_domain', 'weblogic_cluster',\n                               'oracle_ias_farm', 'j2ee_application') and \n               s.target_type = h.target_type and\n               s.snapshot_type = h.snapshot_type and \n               s.is_current in('Y','P') and\n               s.START_TIMESTAMP > l_prev_ts and\n               s.START_TIMESTAMP <= l_next_ts and\n           not exists (\n             select 'x' from mgmt_ocm_upl_metrics m\n              where m.target_name = s.target_name and\n                    m.target_type = s.target_type and\n                    m.snapshot_type = s.snapshot_type and\n                    m.table_name = h.table_name\n           );\n       COMMIT;\n\n\n      MERGE INTO mgmt_ocm_upl_metrics p\n      USING (\n        SELECT DISTINCT tg.target_name as target_name, tg.target_type ,\n                        'OCheck' as snapshot_type, null as addl_target_info, \n                        'MGMT_DIAGNOSTIC_CHECK_ROWS' as table_name\n        FROM MGMT_DIAGNOSTIC_CHECK_ROWS d,\n             mgmt_targets tg\n        WHERE tg.target_guid = d.target_guid \n          AND (l_prev_ts is null \n               OR d.collection_timestamp > l_prev_ts)\n          AND d.collection_timestamp <= l_next_ts\n        ) t\n          ON (   p.target_type = t.target_type\n            AND p.target_name = t.target_name\n            AND p.snapshot_type = t.snapshot_type\n            AND p.table_name = t.table_name\n            AND p.addl_target_info is null\n            )\n       WHEN MATCHED THEN \n          UPDATE SET p.last_harvest_ts = l_prev_ts, p.is_changed = 1 \n                 WHERE p.is_changed=0\n       WHEN NOT MATCHED THEN \n            INSERT (target_name, target_type, snapshot_type, table_name, \n                    addl_target_info)\n            VALUES (t.target_name, t.target_type, t.snapshot_type, \n                    t.table_name, t.addl_target_info);\n\n      COMMIT;\n\n\n        MERGE INTO MGMT_OCM_UPL_METRICS P \n        USING \n        (   \n            SELECT DISTINCT \n               T.TARGET_NAME, \n               T.TARGET_TYPE, \n               'oracle_db_adrinfo' AS SNAPSHOT_TYPE, \n               'MGMT_ECM_ADR_INFO' AS TABLE_NAME, \n                NULL AS ADDL_TARGET_INFO \n                FROM EM_ISSUES_INTERNAL PARTITION(OPEN) I \n                JOIN EM_PROBLEM_ISSUE PARTITION(OPEN) P ON P.PROBLEM_ID = I.RELATED_PROBLEM_ID \n                            AND P.OPEN_STATUS = I.OPEN_STATUS \n                            AND P.CLOSED_DATE = I.CLOSED_DATE \n                JOIN EM_EVENTS_INCIDENT PARTITION(OPEN) EI ON EI.INCIDENT_ID = I.ISSUE_ID \n                JOIN MGMT_TARGETS T ON T.TARGET_GUID = EI.TARGET_GUID \n                WHERE I.ISSUE_TYPE = 1 \n                    AND I.IS_ADR_AWARE = 1 \n                    AND T.TARGET_TYPE = 'oracle_database' \n                    AND I.CREATION_DATE >  MGMT_GLOBAL.TO_UTC_DST(l_prev_ts, sessiontimezone) \n                    AND I.CREATION_DATE <= MGMT_GLOBAL.TO_UTC_DST(l_next_ts, sessiontimezone) \n        ) T \n        ON \n        ( \n            P.TARGET_TYPE = T.TARGET_TYPE \n            AND p.target_name = t.target_name \n            AND P.SNAPSHOT_TYPE = T.SNAPSHOT_TYPE \n            AND P.TABLE_NAME = T.TABLE_NAME \n            AND P.ADDL_TARGET_INFO IS NULL \n        )\n        WHEN MATCHED THEN        \n            UPDATE SET P.LAST_HARVEST_TS = L_PREV_TS, P.IS_CHANGED = 1 WHERE P.IS_CHANGED=0\n        WHEN NOT MATCHED THEN         \n            INSERT (TARGET_NAME, TARGET_TYPE, SNAPSHOT_TYPE, TABLE_NAME, ADDL_TARGET_INFO, LAST_HARVEST_TS, IS_CHANGED ) \n            VALUES (T.TARGET_NAME, T.TARGET_TYPE, T.SNAPSHOT_TYPE, t.table_name, t.addl_target_info, L_PREV_TS, 1); \n\n        COMMIT;\n\n        -- SCN Info: Add entry in MGMT_OCM_UPL_METRICS for new target  \n        MERGE INTO MGMT_OCM_UPL_METRICS P \n        USING \n        (   \n              SELECT DISTINCT \n                  T.TARGET_NAME, \n                  T.TARGET_TYPE, \n                  H.SNAPSHOT_TYPE , \n                  H.TABLE_NAME, \n                  NULL AS ADDL_TARGET_INFO \n              FROM MGMT_TARGETS T, MGMT_OCM_UPL_MD_TBLS H\n                  WHERE T.TARGET_TYPE = H.TARGET_TYPE\n                  AND  H.SNAPSHOT_TYPE = 'oracle_db_adrinfo'\n                  AND T.TARGET_TYPE = 'oracle_database' \n                  AND H.TABLE_NAME='MGMT_ECM_SCN_INFO'\n        ) T \n        ON \n        ( \n            P.TARGET_TYPE = T.TARGET_TYPE \n            AND P.TARGET_NAME = T.TARGET_NAME \n            AND P.SNAPSHOT_TYPE = T.SNAPSHOT_TYPE \n            AND P.TABLE_NAME = T.TABLE_NAME \n            AND P.ADDL_TARGET_INFO IS NULL \n        )\n        WHEN NOT MATCHED THEN         \n            INSERT (TARGET_NAME, TARGET_TYPE, SNAPSHOT_TYPE, TABLE_NAME, ADDL_TARGET_INFO, LAST_HARVEST_TS ) \n            VALUES (T.TARGET_NAME, T.TARGET_TYPE, T.SNAPSHOT_TYPE, t.table_name, t.addl_target_info, add_months(sysdate , -12) ); \n\n        COMMIT;        \n\n      IF (NOT l_split) OR l_last_interval THEN\n        EXIT;\n      ELSE -- split is on and this was not the last interval\n        l_prev_ts := l_next_ts;\n        l_next_ts := l_next_ts + l_interval;\n        IF l_next_ts >= l_max_ts THEN\n          l_next_ts := l_max_ts;\n          l_last_interval := true;\n        END IF;\n      END IF;\n\n    EXCEPTION WHEN OTHERS THEN\n      -- did we already try to split?\n      IF l_split THEN \n        IF l_interval > 0.04 THEN\n          -- last try: attempt minimal interval\n          l_interval := 0.04;\n        ELSE -- already tried minimal interval\n          RAISE;\n        END IF;\n      ELSE -- had not tried to split yet\n        -- split interval: try to split into at least 4 parts\n        -- but no more than one day and no less than about an hour each.\n        l_overall_interval := l_max_ts - l_min_ts;\n        l_interval_div_by_4 := l_overall_interval / 4;\n        IF l_interval_div_by_4 >= 1 THEN -- 1 day\n          l_interval := 1;\n        ELSIF l_interval_div_by_4 >= 0.5 THEN -- 12 hours\n          l_interval := 0.5;\n        ELSIF l_interval_div_by_4 >= 0.25 THEN -- 6 hours\n          l_interval := 0.25;\n        ELSIF l_interval_div_by_4 >= 0.125 THEN -- 3 hours\n          l_interval := 1/8;\n        ELSIF l_overall_interval > 0.04 THEN -- just less than an hour \n          l_interval := 0.04;\n        ELSE\n          RAISE; -- overall interval is already too short\n        END IF;\n      END IF;\n\n      l_split := true;\n      l_last_interval := false;\n      l_prev_ts := l_min_ts;\n      l_next_ts := l_prev_ts + l_interval;\n    END;\n  END LOOP;\n\n  UPDATE mgmt_ocm_upl_props\n     SET ts_value = l_max_ts\n   WHERE name = 'changes_ts';\n\n  COMMIT;\nEXCEPTION WHEN OTHERS THEN\n\n  MGMT_LOG.LOG_ERROR('GCHARVESTER', -202, \n    'Encountered a problem during history-based updates: ' ||\n      SQLCODE || ': ' || SQLERRM,\n    v_log_level_in =>  MGMT_GLOBAL.G_ERROR); \n  RAISE;\n\nEND;\n";
    static final String FIXUP_METRICS_SQL = "DECLARE \n  BATCH_SIZE CONSTANT NUMBER := 512;\n\n  l_prev_idx NUMBER := 1; -- previous index (inclusive)\n  l_next_idx NUMBER := l_prev_idx + BATCH_SIZE; -- next index (exclusive)\n  l_max_idx NUMBER := 1;\n  l_ignore_all_targets VARCHAR2(256):= 'FALSE';\nBEGIN\n\n  begin\n     select upper(str_value)\n        into l_ignore_all_targets\n       from mgmt_ocm_upl_props\n      where name = 'ignore_all_if_not_marked';\n   Exception\n     WHEN NO_DATA_FOUND THEN\n       l_ignore_all_targets := 'FALSE';\n  end;\n\n  SELECT max(idx) INTO l_max_idx FROM mgmt_ocm_upl_metrics_tmp;\n\n  WHILE l_prev_idx <= l_max_idx LOOP -- for each batch of EM targets\n\n    -- delete targets that no longer exist\n    DELETE FROM mgmt_ocm_upl_metrics \n    WHERE (target_name,target_type) IN\n       (SELECT t.target_name, t.target_type \n        FROM mgmt_ocm_upl_metrics_tmp t                      \n        WHERE t.IDX >= l_prev_idx AND t.IDX < l_next_idx\n        AND NOT EXISTS (SELECT * FROM mgmt_targets tgt             \n                        WHERE t.target_type=tgt.target_type\n                        AND  t.target_name=tgt.target_name) );\n    COMMIT;\n\n    delete  FROM MGMT_OCM_UPL_METRICS UM \n    WHERE 1=1\n    AND TARGET_TYPE = 'rac_database' \n    AND SNAPSHOT_TYPE = 'orcl_tp_config' \n    AND TABLE_NAME ='MGMT_ECM_ASSOCIATIONS' \n    AND not EXISTS \n    (\n    SELECT 1\n      FROM MGMT_OCM_UPL_METRICS_TMP UMT \n      JOIN MGMT_TARGETS src  ON src.TARGET_NAME = UMT.TARGET_NAME AND src.TARGET_TYPE = UMT.TARGET_TYPE\n      JOIN GC_ASSOC_INSTANCES RAC2DB ON RAC2DB.SOURCE_ME_GUID = SRC.TARGET_GUID \n      JOIN MGMT_TARGETS DEST  ON DEST.TARGET_GUID= RAC2DB.DEST_ME_GUID \n      WHERE  1=1\n      AND UMT.IDX >= L_PREV_IDX AND UMT.IDX < L_NEXT_IDX\n      AND UMT.TARGET_TYPE = UM.TARGET_TYPE\n      AND UMT.TARGET_NAME = UM.TARGET_NAME\n      --AND UMT.TARGET_TYPE='rac_database'\n      AND RAC2DB.ASSOC_TYPE = 'deployed_on' \n      AND DEST.TARGET_TYPE    ='oracle_dbmachine' \n    );\n\n    COMMIT;\n\n\n    --delete target marked to be ignored\n    if(l_ignore_all_targets = 'TRUE')\n    then\n      --delete all the target except for those not marked\n      -- to ignore\n      DELETE FROM mgmt_ocm_upl_metrics m\n        WHERE NOT EXISTS (\n              select 'X' from\n                     mgmt_ocm_upl_metrics_tmp t,\n                     mgmt_target_prop_defs d,\n                     mgmt$target_properties p\n              WHERE  t.IDX >= l_prev_idx AND\n                     t.IDX < l_next_idx AND\n                     t.target_name = m.target_name AND\n                     t.target_type = m.target_type and\n                     p.target_name = t.target_name and\n                     p.target_type = t.target_type and\n                     p.property_name = d.property_name and\n                     p.property_value = 'false' and\n                     p.target_type = d.target_type and\n                     d.property_display_name = 'Harvester Ignore' and\n                     d.property_name like 'udtp%'\n        );\n\n        commit;\n\n    else\n        --delete the targets marked to ignore\n        DELETE FROM mgmt_ocm_upl_metrics m\n        WHERE EXISTS (\n              select 'X' from\n                     mgmt_ocm_upl_metrics_tmp t,\n                     mgmt_target_prop_defs d,\n                     mgmt$target_properties p\n              WHERE  t.IDX >= l_prev_idx AND\n                     t.IDX < l_next_idx AND\n                     t.target_name = m.target_name AND\n                     t.target_type = m.target_type and\n                     p.target_name = t.target_name and\n                     p.target_type = t.target_type and\n                     p.property_name = d.property_name and\n                     p.property_value = 'true' and\n                     p.target_type = d.target_type and\n                     d.property_display_name = 'Harvester Ignore' and\n                     d.property_name like 'udtp%'\n        );\n\n        commit;\n    end if;\n\n    l_prev_idx := l_next_idx;  \n    l_next_idx := l_next_idx + BATCH_SIZE;\n\n  END LOOP; -- for each target batch\nEND;\n";
    static final String OCHECK_HARVEST_SQL = "  SELECT d.diag_name, d.data_type, d.key, d.value, d.context_value1, \n         d.context_value2, d.context_value3, d.context_value4, \n         d.context_value5\n   FROM MGMT_DIAGNOSTIC_CHECK_ROWS d,\n        MGMT_TARGETS tg, \n        MGMT_OCM_UPL_METRICS om\n        WHERE tg.target_name = om.target_name\n          AND tg.target_type = om.target_type \n          AND om.snapshot_type = 'OCheck' \n          AND (om.last_harvest_ts is null\n               OR d.collection_timestamp >= om.last_harvest_ts)\n          AND d.collection_timestamp < ( select ts_value \n                                         from mgmt_ocm_upl_props\n                                         WHERE name = 'changes_ts') \n          AND d.target_guid = tg.target_guid\n          AND tg.target_type = :tt\n          AND tg.target_name = :tn\n";
    static final String ADRINFO_HARVEST_SQL = "    SELECT \n        PROBLEM_KEY, \n        TO_CHAR(STARTTIME,'YYYY-MM-DD HH24:MI:SS TZH:TZM' ) STARTTIME, \n        TO_CHAR(ENDTIME ,'YYYY-MM-DD HH24:MI:SS TZH:TZM' ) ENDTIME, \n        COUNT (*) COUNT \n    FROM \n    ( \n        SELECT \n            PROBLEM_KEY, \n            -- Convert date to timestamp and add timezone\n            FROM_TZ( CAST ( STARTTIME  AS TIMESTAMP) , TIMEZONE_REGION) STARTTIME, \n            FROM_TZ( CAST ( (STARTTIME + 1/24)  AS TIMESTAMP) , TIMEZONE_REGION) ENDTIME \n        FROM \n        (  \n            SELECT \n                P.PROBLEM_KEY,  \n                -- Convert CREATION_DATE which is in UTC time to Target timezone and truncate till hour\n                TRUNC( MGMT_GLOBAL.FROM_UTC_DST(I.CREATION_DATE, TG.TIMEZONE_REGION ) ,'HH') AS STARTTIME ,\n                TG.TIMEZONE_REGION \n            FROM EM_PROBLEM_ISSUE PARTITION(OPEN) P     \n            JOIN EM_ISSUES_INTERNAL PARTITION(OPEN) I ON P.PROBLEM_ID = I.RELATED_PROBLEM_ID \n                 AND P.OPEN_STATUS = I.OPEN_STATUS AND P.CLOSED_DATE = I.CLOSED_DATE\n            JOIN EM_EVENTS_INCIDENT PARTITION(OPEN) EI ON EI.INCIDENT_ID = I.ISSUE_ID \n            JOIN MGMT_TARGETS TG ON TG.TARGET_GUID = EI.TARGET_GUID \n            JOIN MGMT_OCM_UPL_METRICS OM ON TG.TARGET_NAME = OM.TARGET_NAME \n            WHERE  \n                    OM.TARGET_NAME= :tn   \n                AND OM.TARGET_TYPE = :tt \n                AND OM.SNAPSHOT_TYPE= 'oracle_db_adrinfo' \n                AND OM.TABLE_NAME = 'MGMT_ECM_ADR_INFO' \n                AND I.ISSUE_TYPE = 1 \n                AND I.IS_ADR_AWARE = 1 \n                AND I.CREATION_DATE >=  MGMT_GLOBAL.TO_UTC_DST(OM.LAST_HARVEST_TS, sessiontimezone) \n                AND i.creation_date < ( select MGMT_GLOBAL.TO_UTC_DST(ts_value, sessiontimezone)  \n                                        FROM MGMT_OCM_UPL_PROPS WHERE name = 'changes_ts') \n        ) \n    ) \n    GROUP BY PROBLEM_KEY, STARTTIME, ENDTIME\n";
}

