/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.gcontext;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.ccr.collector.gcontext.GCContextList;
import oracle.sysman.ccr.collector.gcontext.GCContextManager;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.gcontext.GCContextImpl;
import oracle.sysman.ccr.gcharvester.gcontext.GCContextSimple;
import oracle.sysman.ccr.gcharvester.gcontext.OCContextImpl;
import oracle.sysman.ccr.gcharvester.gcontext.STContextImpl;
import oracle.sysman.ccr.gcharvester.registration.RegistrationDAO;
import oracle.sysman.ccr.gcharvester.registration.RegistrationDO;
import oracle.sysman.ccr.gcharvester.registration.RegistrationUtil;
import oracle.sysman.ccr.gcharvester.targettype.HarvesterTargetPropUtil;
import oracle.sysman.ccr.gcharvester.ti.common.HarvesterTargetProperies;
import oracle.sysman.ccr.gcharvester.util.GCHarvesterEnv;
import oracle.sysman.ccr.gcharvester.util.GCVersion;

public class GCContextFactory {
    public static GCContextList getGCContext(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2, boolean bl3, Connection connection) throws HarvesterException {
        String string8;
        if (GCVersion.pre11_2GC() || GCHarvesterEnv.disableCSIAssign()) {
            ArrayList<GCContextSimple> arrayList = new ArrayList<GCContextSimple>();
            arrayList.add(new GCContextSimple(bl3));
            return new GCContextList(arrayList);
        }
        if (string5.equals("host")) {
            return new GCContextList(GCContextFactory.getContextListForHost(string6, bl3, connection));
        }
        HashMap<String, String> hashMap = null;
        RegistrationDO registrationDO = RegistrationDAO.getRegrForTarget(string, string2, connection);
        if (registrationDO != null) {
            String string9 = registrationDO.getOracleHome();
            string8 = registrationDO.getHostName();
            if (!(string9 == null || string8 == null || string9.equals(string7) && string8.equals(string6))) {
                hashMap = new HashMap<String, String>();
                hashMap.put("IS_OUT_OF_PLACE_UPGRADE", "true");
                if (!string9.equals(string7)) {
                    hashMap.put(HarvesterTargetProperies.OLD_OH_PROP, string9);
                }
                if (!string8.equals(string6)) {
                    hashMap.put(HarvesterTargetProperies.OLD_HOST_PROP, string8);
                }
                registrationDO = RegistrationDAO.performOutOfPlaceUpgrade(registrationDO, string, string2, string6, string7, string3, string4, bl, bl2, connection);
                if (string2 != null && !string2.equals("oracle_emrep")) {
                    HarvesterTargetPropUtil.persistHarvesterTargetProperties(connection, hashMap, string, string2);
                }
            }
        } else {
            registrationDO = RegistrationDAO.getRegrForHostAndOracleHome(string6, string7, connection);
            if (registrationDO != null) {
                RegistrationDAO.addTargetToRegr(registrationDO, string, string2, connection);
            } else {
                registrationDO = RegistrationDO.getProxyRegrInstance(string6, string7, string3, string4, bl, bl2, connection);
                RegistrationDAO.insertRegistrationWithTarget(registrationDO, string, string2, connection);
            }
        }
        registrationDO = GCContextFactory.performRegistrationIfRequired(registrationDO, string6, string7, bl, bl2, false, connection);
        boolean bl4 = "true".equals(HarvesterTargetPropUtil.getHarvesterTargetProperty(connection, string, string2, "IS_OUT_OF_PLACE_UPGRADE"));
        string8 = HarvesterTargetPropUtil.getHarvesterTargetProperty(connection, string, string2, HarvesterTargetProperies.OLD_OH_PROP);
        String string10 = HarvesterTargetPropUtil.getHarvesterTargetProperty(connection, string, string2, HarvesterTargetProperies.OLD_HOST_PROP);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        if (bl4 && string8 != null) {
            hashMap2.put(HarvesterTargetProperies.OLD_OH_PROP, string8);
        }
        if (bl4 && string10 != null) {
            hashMap.put(HarvesterTargetProperies.OLD_HOST_PROP, string10);
        }
        GCContextImpl gCContextImpl = new GCContextImpl(registrationDO, bl3, bl4, hashMap2, connection);
        ArrayList<GCContextImpl> arrayList = new ArrayList<GCContextImpl>();
        arrayList.add(gCContextImpl);
        return new GCContextList(arrayList);
    }

    public static void setOPCenterContext() {
        ArrayList<OCContextImpl> arrayList = new ArrayList<OCContextImpl>();
        OCContextImpl oCContextImpl = new OCContextImpl();
        arrayList.add(oCContextImpl);
        GCContextList gCContextList = new GCContextList(arrayList);
        gCContextList.setCurrentGCContext(oCContextImpl);
        GCContextManager.setGCContext(gCContextList);
    }

    public static void setSTImporterContext() {
        ArrayList<STContextImpl> arrayList = new ArrayList<STContextImpl>();
        STContextImpl sTContextImpl = new STContextImpl();
        arrayList.add(sTContextImpl);
        GCContextList gCContextList = new GCContextList(arrayList);
        gCContextList.setCurrentGCContext(sTContextImpl);
        GCContextManager.setGCContext(gCContextList);
    }

    private static List getContextListForHost(String string, boolean bl, Connection connection) throws HarvesterException {
        List list = RegistrationDAO.getRegsForHost(string, connection);
        ArrayList<GCContextImpl> arrayList = new ArrayList<GCContextImpl>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (list == null || list.isEmpty()) {
            RegistrationDO registrationDO = RegistrationDO.getProxyRegrInstance(string, "N/A", string, "N/A", false, false, connection);
            GCContextImpl gCContextImpl = new GCContextImpl(registrationDO, bl, false, null, connection);
            arrayList.add(gCContextImpl);
            return arrayList;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RegistrationDO registrationDO = (RegistrationDO)iterator.next();
            String string2 = (registrationDO = GCContextFactory.performRegistrationIfRequired(registrationDO, connection)).getOrgId();
            if (hashMap.get(string2) != null) continue;
            arrayList.add(new GCContextImpl(registrationDO, bl, false, null, connection));
            hashMap.put(string2, "true");
        }
        return arrayList;
    }

    private static RegistrationDO performRegistrationIfRequired(RegistrationDO registrationDO, Connection connection) throws HarvesterException {
        return GCContextFactory.performRegistrationIfRequired(registrationDO, null, null, false, false, true, connection);
    }

    private static RegistrationDO performRegistrationIfRequired(RegistrationDO registrationDO, String string, String string2, boolean bl, boolean bl2, boolean bl3, Connection connection) throws HarvesterException {
        String string3 = registrationDO.getRegrStat();
        RegistrationDO registrationDO2 = registrationDO;
        if (string3 != null && (string3.equals("PENDING") || string3.equals("PENDING_FULL"))) {
            throw new HarvesterException("Registration in PENDING status for Host:" + registrationDO.getHostName() + ", OracleHome:" + registrationDO.getOracleHome());
        }
        if (string3 != null && string3.equals("PENDING2")) {
            RegistrationUtil.performRegistration(registrationDO, connection);
        }
        if (string3 != null && string3.equals("PENDING_FAKE")) {
            if (bl3) {
                throw new HarvesterException("Cannot process this host as we cannot process some of the fake registeration");
            }
            registrationDO2 = RegistrationUtil.fixFakeRegistration(registrationDO, string, string2, bl, bl2, connection);
        }
        return registrationDO2;
    }
}

