/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.gcontext;

import java.sql.Connection;
import java.util.Map;
import oracle.sysman.ccr.collector.gcontext.GCContext;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.registration.RegistrationDAO;
import oracle.sysman.ccr.gcharvester.registration.RegistrationDO;
import oracle.sysman.ccr.gcharvester.util.SecurityUtil;

class GCContextImpl
implements GCContext {
    private String oracleHome;
    private String oracleConfigHome;
    private String hostName;
    private String orgId;
    private String clientKey;
    private boolean proxy;
    private boolean authenticated;
    private boolean uniqueCSI;
    private long registrationId;
    private boolean gcForced;
    private boolean outOfPlaceUpgrade;
    private Map outOfPlaceUpgradeProps;

    GCContextImpl(RegistrationDO registrationDO, boolean bl, boolean bl2, Map map, Connection connection) throws HarvesterException {
        RegistrationDO registrationDO2 = null;
        this.registrationId = registrationDO.getRegrId();
        this.proxy = registrationDO.isProxy();
        this.gcForced = bl;
        registrationDO2 = this.proxy ? RegistrationDAO.getDefaultRegr(connection) : registrationDO;
        this.oracleHome = registrationDO2.getOracleHome();
        this.oracleConfigHome = registrationDO2.getOracleConfigHome();
        this.hostName = registrationDO2.getHostName();
        this.orgId = registrationDO2.getOrgId();
        this.clientKey = SecurityUtil.getSecureInfo(registrationDO2.getClientKey(), connection);
        this.authenticated = registrationDO2.isAuth();
        this.uniqueCSI = registrationDO2.isUniqueCSI();
        this.outOfPlaceUpgrade = bl2;
        this.outOfPlaceUpgradeProps = map;
    }

    public String getOracleHome() {
        return this.oracleHome;
    }

    public String getOracleConfigHome() {
        return this.oracleConfigHome;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean hasUniqueCSI() {
        return this.uniqueCSI;
    }

    public boolean isForceUpload() {
        return this.gcForced;
    }

    public String getHarvesterSource() {
        return "GC";
    }

    public long getRegistrationId() {
        return this.registrationId;
    }

    public boolean isOutOfPlaceUpgrade() {
        return this.outOfPlaceUpgrade;
    }

    public Map outOfPlaceUpgradeProps() {
        return this.outOfPlaceUpgradeProps;
    }
}

