/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.gcontext;

import java.util.Map;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.gcontext.GCContext;
import oracle.sysman.ccr.collector.security.AnonAuthenticationKey;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.AuthenticationKey;
import oracle.sysman.ccr.collector.security.CSIAuthenticationKey;
import oracle.sysman.ccr.collector.security.CSIV2AuthenticationKey;
import oracle.sysman.ccr.collector.security.EmailAuthenticationKey;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.util.Hostname;

public class GCContextSimple
implements GCContext {
    private boolean gcUpload = false;

    public GCContextSimple(boolean bl) {
        this.gcUpload = bl;
    }

    public GCContextSimple() {
    }

    public String getOracleHome() {
        return Collector.getOracleHome();
    }

    public String getOracleConfigHome() {
        return Collector.getConfigHome();
    }

    public String getHostName() {
        return Hostname.getHostname();
    }

    public String getOrgId() {
        SecurityMgr securityMgr = SecurityMgr.getInstance();
        return securityMgr.getCustomerOrgId();
    }

    public boolean isProxy() {
        return true;
    }

    public String getClientKey() {
        throw new UnsupportedOperationException("This method is not supported for pre-11.2GC Harvester.");
    }

    public boolean isAuthenticated() {
        try {
            AuthenticationKey authenticationKey = SecurityMgr.getInstance().getAuthenticationKey();
            if (authenticationKey != null && !(authenticationKey instanceof AnonAuthenticationKey)) {
                return true;
            }
        }
        catch (AuthenticationFailure authenticationFailure) {
            // empty catch block
        }
        return false;
    }

    public boolean hasUniqueCSI() {
        try {
            AuthenticationKey authenticationKey = SecurityMgr.getInstance().getAuthenticationKey();
            if (authenticationKey != null && !(authenticationKey instanceof AnonAuthenticationKey)) {
                if (authenticationKey instanceof CSIV2AuthenticationKey || authenticationKey instanceof CSIAuthenticationKey) {
                    return true;
                }
                if (authenticationKey instanceof EmailAuthenticationKey && authenticationKey.holdsUniqueCSI()) {
                    return true;
                }
            }
        }
        catch (AuthenticationFailure authenticationFailure) {
            // empty catch block
        }
        return false;
    }

    public boolean isForceUpload() {
        return this.gcUpload;
    }

    public String getHarvesterSource() {
        return "GC";
    }

    public long getRegistrationId() {
        return 0L;
    }

    public boolean isOutOfPlaceUpgrade() {
        return false;
    }

    public Map outOfPlaceUpgradeProps() {
        return null;
    }
}

