/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.perf;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class GCHarvesterPerf {
    public static final String PERF_ALL = "perf_all";
    public static final String PERF_METADATA = "perf_metadata";
    public static final String PERF_REGN = "perf_regn";
    public static final String PERF_STAGE = "perf_stage";
    public static final String PERF_COLL_UPLOAD = "perf_coll_upl";
    public static final String PERF_TARGET_CNT = "perf_tg_total";
    public static final String PERF_TARGET_IGNORE = "perf_tg_ignore";
    public static final String PERF_TARGET_SUCCESS = "perf_tg_suc";
    private static final String IS_FULL = "is_full";
    private static final String UNITS_COUNT = "count";
    private static final String UNITS_TIME = "seconds";
    private static final String[] perfList = new String[]{"perf_all", "perf_metadata", "perf_regn", "perf_stage", "perf_coll_upl", "perf_tg_total", "perf_tg_ignore", "perf_tg_suc"};
    private static ThreadLocal perfThreadLocal = new ThreadLocal();
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$perf$GCHarvesterPerf == null ? (class$oracle$sysman$ccr$gcharvester$perf$GCHarvesterPerf = GCHarvesterPerf.class$("oracle.sysman.ccr.gcharvester.perf.GCHarvesterPerf")) : class$oracle$sysman$ccr$gcharvester$perf$GCHarvesterPerf).getName());
    private static final String PERF_SQL = "declare\n  l_name VARCHAR2(100) := ?;\n  l_value NUMBER := ?;\n  l_full NUMBER := ?;\n  l_units VARCHAR2(100) := ?;\nbegin\n  delete from mgmt_ocm_upl_props where name = l_name || '.4';\n  update mgmt_ocm_upl_props set name = l_name || '.4' where name =  l_name || '.3';\n  update mgmt_ocm_upl_props set name = l_name || '.3' where name = l_name || '.2' ;\n  update mgmt_ocm_upl_props set name = l_name || '.2' where name = l_name || '.1' ;\n  update mgmt_ocm_upl_props set name = l_name || '.1' where name = l_name ;\n  insert into mgmt_ocm_upl_props (name, num_value, ts_value, str_value)\n  values(l_name, l_value, systimestamp, l_units);\n  if(l_full = 1)\n  then\n     MERGE INTO mgmt_ocm_upl_props p\n       USING dual\n       ON ( name = l_name || '.full' )\n     WHEN MATCHED THEN UPDATE SET p.num_value = l_value, p.ts_value = systimestamp, p.str_value = l_units\n     WHEN NOT MATCHED THEN INSERT (name, num_value, ts_value, str_value)\n          VALUES (l_name || '.full', l_value, systimestamp, l_units);\n  end if;\nend;\n";
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$perf$GCHarvesterPerf;

    public static void init() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < perfList.length; ++i) {
            GCHarvesterPerf.addPerfData(perfList[i], hashMap);
        }
        hashMap.put(IS_FULL, "false");
        perfThreadLocal.set(hashMap);
    }

    public static void setFullCollection() {
        HashMap hashMap = (HashMap)perfThreadLocal.get();
        if (hashMap != null) {
            hashMap.put(IS_FULL, "true");
        }
    }

    public static void startPerf(String string) {
        PerfData perfData;
        HashMap hashMap = (HashMap)perfThreadLocal.get();
        if (hashMap != null && (perfData = (PerfData)hashMap.get(string)) != null) {
            perfData.startTime = System.currentTimeMillis();
        }
    }

    public static void endPerf(String string) {
        PerfData perfData;
        HashMap hashMap = (HashMap)perfThreadLocal.get();
        if (hashMap != null && (perfData = (PerfData)hashMap.get(string)) != null) {
            perfData.endTime = System.currentTimeMillis();
            perfData.value = (perfData.endTime - perfData.startTime) / 1000L;
            perfData.units = UNITS_TIME;
        }
    }

    public static void incrementPerf(String string, long l) {
        PerfData perfData;
        HashMap hashMap = (HashMap)perfThreadLocal.get();
        if (hashMap != null && (perfData = (PerfData)hashMap.get(string)) != null) {
            perfData.value += l;
            perfData.units = UNITS_COUNT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commit(Connection connection) {
        HashMap hashMap = (HashMap)perfThreadLocal.get();
        if (hashMap != null) {
            boolean bl = false;
            String string = (String)hashMap.get(IS_FULL);
            if (string != null && string.equalsIgnoreCase("true")) {
                bl = true;
            }
            try {
                for (int i = 0; i < perfList.length; ++i) {
                    PerfData perfData = (PerfData)hashMap.get(perfList[i]);
                    if (perfData == null) continue;
                    GCHarvesterPerf.addDatatoRepo(connection, perfData.perfName, perfData.units, perfData.value, bl);
                }
                connection.commit();
            }
            catch (Throwable throwable) {
                sLog.debug((Object)"GCHarvesterPerf: Error in logging the perf data: ", throwable);
                JDBCUtil.forceTransactionRollback((Connection)connection);
            }
            finally {
                perfThreadLocal.set(null);
            }
        }
    }

    private static void addPerfData(String string, HashMap hashMap) {
        hashMap.put(string, new PerfData(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDatatoRepo(Connection connection, String string, String string2, long l, boolean bl) throws SQLException {
        int n = 0;
        if (bl) {
            n = 1;
        }
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(PERF_SQL);
            callableStatement.setString(1, string);
            callableStatement.setLong(2, l);
            callableStatement.setInt(3, n);
            callableStatement.setString(4, string2);
            callableStatement.execute();
        }
        finally {
            JDBCUtil.close((Statement)callableStatement);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PerfData {
        String perfName;
        String units = "count";
        long startTime = 0L;
        long endTime = 0L;
        long value = 0L;

        PerfData(String string) {
            this.perfName = string;
        }
    }
}

