/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.registration;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.registration.RegistrationDO;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.ccr.gcharvester.util.SecurityUtil;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class RegistrationDAO {
    private static final String GC_HARVESTER_JOB_NM = "<GCHarvesterJob>";
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$registration$RegistrationDAO == null ? (class$oracle$sysman$ccr$gcharvester$registration$RegistrationDAO = RegistrationDAO.class$("oracle.sysman.ccr.gcharvester.registration.RegistrationDAO")) : class$oracle$sysman$ccr$gcharvester$registration$RegistrationDAO).getName());
    private static volatile RegistrationDO cacheDefultRegistration = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$registration$RegistrationDAO;

    public static void insertRegistration(RegistrationDO registrationDO, Connection connection) throws HarvesterException {
        long l = RegistrationDAO.nextSequenceNumber("EM_OCM_REGISTRATIONS_SEQ", connection);
        RegistrationDAO.insertRegistrationInternal(registrationDO, l, true, connection);
    }

    public static void insertDefaultRegistration(RegistrationDO registrationDO, String string, String string2, Connection connection) throws HarvesterException {
        long l = RegistrationDAO.nextSequenceNumber("EM_OCM_REGISTRATIONS_SEQ", connection);
        try {
            if (string2 != null) {
                String string3 = SecurityUtil.insertSecureInfo(string2, connection);
                registrationDO.setCipherTxtId(string3);
            }
            RegistrationDAO.insertRegistrationInternal(registrationDO, l, false, connection);
            RegistrationDAO.insertDefaultId(l, connection);
            RegistrationDAO.insertRepoUrl(string, connection);
            RegistrationDAO.deleteChangeTS(connection);
            connection.commit();
        }
        catch (SQLException sQLException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            String string4 = "Error while inserting default registration";
            HarvesterUtil.logErrorMessage(sLog, sQLException, string4);
            throw new HarvesterException(string4, sQLException);
        }
        catch (HarvesterException harvesterException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            throw harvesterException;
        }
    }

    public static void insertRegistrationWithTarget(RegistrationDO registrationDO, String string, String string2, Connection connection) throws HarvesterException {
        long l = RegistrationDAO.nextSequenceNumber("EM_OCM_REGISTRATIONS_SEQ", connection);
        try {
            RegistrationDAO.insertRegistrationInternal(registrationDO, l, false, connection);
            RegistrationDAO.addTargetToRegrInternal(registrationDO, l, string, string2, false, connection);
            connection.commit();
        }
        catch (SQLException sQLException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            String string3 = "Error for target " + string + "(" + string2 + ") while inserting a registration with oh: " + registrationDO.getOracleHome() + " host: " + registrationDO.getHostName();
            HarvesterUtil.logErrorMessage(sLog, sQLException, string3);
            throw new HarvesterException(string3, sQLException);
        }
        catch (HarvesterException harvesterException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            throw harvesterException;
        }
    }

    public static void addTargetToRegr(RegistrationDO registrationDO, String string, String string2, Connection connection) throws HarvesterException {
        RegistrationDAO.addTargetToRegrInternal(registrationDO, registrationDO.getRegrId(), string, string2, true, connection);
    }

    public static void updateRegistration(RegistrationDO registrationDO, Connection connection) throws HarvesterException {
        RegistrationDAO.updateRegistrationInternal(registrationDO, true, false, connection);
    }

    public static void updateDefaultRegistration(RegistrationDO registrationDO, RegistrationDO registrationDO2, String string, Connection connection) throws HarvesterException {
        try {
            RegistrationDAO.updateRegistrationInternal(registrationDO, false, true, connection);
            RegistrationDAO.updateRepoUrl(string, connection);
            RegistrationDAO.updateProxyRegistrations(registrationDO, registrationDO2, connection);
            RegistrationDAO.updateProxyTargetCSIPropInternal(connection);
            connection.commit();
            cacheDefultRegistration = RegistrationDAO.getDefaultRegrInternal(connection);
        }
        catch (SQLException sQLException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            String string2 = "Error while updating a registration with registration id: " + registrationDO.getRegrId();
            HarvesterUtil.logErrorMessage(sLog, sQLException, string2);
            throw new HarvesterException(string2, sQLException);
        }
        catch (HarvesterException harvesterException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            throw harvesterException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateProxyRegistrations(RegistrationDO registrationDO, RegistrationDO registrationDO2, Connection connection) throws SQLException {
        String string = registrationDO2.getOrgId();
        String string2 = registrationDO.getOrgId();
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Org ID for registrations cannot be null");
        }
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        String string3 = "PROXY";
        if (!string.equals(string2)) {
            bl = true;
            string3 = "PROXY_FULL";
        }
        String string4 = registrationDO.getCsi();
        String string5 = registrationDO2.getCsi();
        if (string5 != null && !string5.equals(string4) || string4 != null && !string4.equals(string5)) {
            bl = true;
        }
        if (registrationDO.isAuth() != registrationDO2.isAuth() || registrationDO.isUniqueCSI() != registrationDO2.isUniqueCSI()) {
            bl = true;
        }
        String string6 = registrationDO.getMetalinkId();
        String string7 = registrationDO2.getMetalinkId();
        if (string7 != null && !string7.equals(string6) || string6 != null && !string6.equals(string7)) {
            bl = true;
        }
        if (!bl) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"Ignore Proxy reg update as no change");
            }
            return;
        }
        try {
            preparedStatement = connection.prepareStatement("UPDATE em_ocm_registrations set CSI = ?, ORG_ID = ?, IS_AUTHENTICATED = ?, IS_UNIQUE_CSI = ?, UPDATED_BY = ?, UPDATE_DT = sysdate, RGTR_STATUS = ? ,METALINK_ID =  ? WHERE RGTR_TYP = 'GC' and RGTR_STATUS = 'PROXY'");
            RegistrationDAO.setNullOrString(preparedStatement, 1, string4);
            RegistrationDAO.setNullOrString(preparedStatement, 2, string2);
            preparedStatement.setInt(3, RegistrationDAO.bolToInt(registrationDO.isAuth()));
            preparedStatement.setInt(4, RegistrationDAO.bolToInt(registrationDO.isUniqueCSI()));
            preparedStatement.setString(5, GC_HARVESTER_JOB_NM);
            preparedStatement.setString(6, string3);
            RegistrationDAO.setNullOrString(preparedStatement, 7, string6);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    private static void updateProxyTargetCSIPropInternal(Connection connection) throws HarvesterException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("DECLARE l_prop_error               NUMBER; l_prop_error_record        MGMT_TARGET_PROPERTY_OBJ; l_prop_obj_array           MGMT_TARGET_PROPERTY_OBJ_ARRAY; begin select MGMT_TARGET_PROPERTY_OBJ(t.target_name,            t.target_type,            em_properties.csi_display_name,            mgmt_properties.INSTANCE,            r.csi)     bulk collect into l_prop_obj_array     from em_ocm_registrations r,          em_ocm_rgtr_target_map m,          mgmt_targets t     where r.rgtr_typ = 'GC'      and r.rgtr_status in ('PROXY' , 'PROXY_FULL')      and m.rgtr_id = r.rgtr_id      and t.target_guid = m.target_guid;     em_properties.bulk_update_properties  (l_prop_obj_array,l_prop_error,l_prop_error_record);  END; ");
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            String string = "Error while updating csi target property for some proxy registered target. See logs for more information.";
            HarvesterUtil.logErrorMessage(sLog, sQLException, string);
            throw new HarvesterException(string, sQLException);
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    public static void fixFakeRegistration(RegistrationDO registrationDO, RegistrationDO registrationDO2, boolean bl, Connection connection) throws HarvesterException {
        try {
            RegistrationDAO.moveTargets(registrationDO.getRegrId(), registrationDO2.getRegrId(), connection);
            if (bl) {
                registrationDO2.setCsi(registrationDO.getCsi());
                registrationDO2.setMetalinkId(registrationDO.getMetalinkId());
                registrationDO2.setCipherTxtId(registrationDO.getCipherTxtId());
                registrationDO2.setRegrStat("PENDING2");
                RegistrationDAO.updateRegistrationInternal(registrationDO2, false, false, connection);
            }
            RegistrationDAO.deleteRegistration(registrationDO.getRegrId(), connection);
            connection.commit();
        }
        catch (SQLException sQLException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            String string = "Error while processing the pending registration records";
            HarvesterUtil.logErrorMessage(sLog, sQLException, string);
            throw new HarvesterException(string, sQLException);
        }
        catch (HarvesterException harvesterException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            throw harvesterException;
        }
    }

    public static boolean processReSyncSignal(String string, String string2, String string3, String string4, String string5, Connection connection) throws HarvesterException {
        if (string == null || string2 == null || string3 == null || string4 == null || string5 == null) {
            return false;
        }
        String string6 = SecurityUtil.insertSecureInfo(string5, connection);
        boolean bl = false;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("UPDATE em_ocm_registrations set CSI = ?, CIPHER_TXT_ID = ?, IS_AUTHENTICATED = 1, IS_UNIQUE_CSI = 1, UPDATED_BY = ?, UPDATE_DT = sysdate, RGTR_STATUS = 'PENDING' WHERE HOSTNAME = ? and ORACLE_HOME = ? and ORACLE_CONFIG_HOME = ? and RGTR_TYP = 'GC' and RGTR_STATUS != 'PENDING'");
            preparedStatement.setString(1, string4);
            preparedStatement.setString(2, string6);
            preparedStatement.setString(3, GC_HARVESTER_JOB_NM);
            preparedStatement.setString(4, string);
            preparedStatement.setString(5, string2);
            preparedStatement.setString(6, string3);
            int n = preparedStatement.executeUpdate();
            if (n > 0) {
                bl = true;
                RegistrationDO registrationDO = RegistrationDAO.getRegrForHostAndOracleHome(string, string2, connection);
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)("Updating registration for registration id: " + registrationDO.getRegrId()));
                }
                RegistrationDAO.updateCSIForTargetRegrInternal(registrationDO.getRegrId(), connection);
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)("Resync update for this oracle home: " + string2 + " and this host: " + string + " is successfull "));
                }
            } else if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Ignoring Re-registration signal for host: " + string + ", oracleHome: " + string2 + ", oracleConfigHome: " + string3));
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            String string7 = "Error while processing the Resync signal for host: " + string + ", oracleHome: " + string2 + ", oracleConfigHome: " + string3;
            HarvesterUtil.logErrorMessage(sLog, sQLException, string7);
            throw new HarvesterException(string7, sQLException);
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
        return bl;
    }

    public static void processPendingRegistrations(Connection connection) throws HarvesterException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("BEGIN \nupdate em_ocm_registrations set rgtr_status = 'PENDING2' where rgtr_status = 'PENDING'; \nupdate em_ocm_registrations set rgtr_status = 'PENDING_FULL2'  where rgtr_status = 'PENDING_FULL'; \nMERGE into mgmt_ocm_upl_metrics p using ( select t.target_name as target_name, t.target_type as target_type from em_ocm_registrations r, em_ocm_rgtr_target_map m, mgmt_targets t where r.rgtr_status in( 'PENDING2' , 'PENDING_FULL2', 'PROXY_FULL') and r.RGTR_ID = m.rgtr_id and m.target_guid = t.target_guid) tab on ( p.target_name = tab.target_name and p.target_type = tab.target_type) WHEN MATCHED THEN UPDATE SET p.is_changed = 1; \nupdate em_ocm_registrations  set rgtr_status = 'RGSTRD' where rgtr_status = 'PENDING_FULL2'; \nupdate em_ocm_registrations  set rgtr_status = 'PROXY' where rgtr_status = 'PROXY_FULL'; \nEND; \n");
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException sQLException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            String string = "Error while processing the pending registration records";
            HarvesterUtil.logErrorMessage(sLog, sQLException, string);
            throw new HarvesterException(string, sQLException);
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    public static RegistrationDO performOutOfPlaceUpgrade(RegistrationDO registrationDO, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, Connection connection) throws HarvesterException {
        boolean bl3 = false;
        RegistrationDO registrationDO2 = RegistrationDAO.getRegrForHostAndOracleHome(string3, string4, connection);
        try {
            if (registrationDO2 == null) {
                registrationDO2 = RegistrationDO.cloneRegistration(registrationDO, string3, string4, string5, string6, bl, bl2);
                long l = RegistrationDAO.nextSequenceNumber("EM_OCM_REGISTRATIONS_SEQ", connection);
                RegistrationDAO.insertRegistrationInternal(registrationDO2, l, false, connection);
            }
            RegistrationDAO.addTargetToRegrInternal(registrationDO2, registrationDO2.getRegrId(), string, string2, false, connection);
            RegistrationDAO.deleteTargetFromRegr(registrationDO, string, string2, false, connection);
            RegistrationDAO.triggerFullCollection(string, string2, connection);
            connection.commit();
            bl3 = true;
        }
        catch (SQLException sQLException) {
            String string7 = "Error while processing the out of place record for target (name, type): " + string + ", " + string2;
            HarvesterUtil.logErrorMessage(sLog, sQLException, string7);
            throw new HarvesterException(string7, sQLException);
        }
        finally {
            if (!bl3) {
                JDBCUtil.forceTransactionRollback((Connection)connection);
            }
        }
        return registrationDO2;
    }

    public static void deleteTargetFromRegr(RegistrationDO registrationDO, String string, String string2, boolean bl, Connection connection) throws HarvesterException {
        PreparedStatement preparedStatement = null;
        long l = registrationDO.getRegrId();
        try {
            preparedStatement = connection.prepareStatement("begin \ndelete from em_ocm_rgtr_target_map where rgtr_id = ? and target_guid in (select target_guid from mgmt_targets where target_name = ? and target_type = ?); \ndelete from em_ocm_registrations r where r.rgtr_id = ? and not exists (select 'x' from em_ocm_rgtr_target_map where rgtr_id = r.rgtr_id); \nend;\n");
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.setLong(4, l);
            preparedStatement.executeUpdate();
            if (bl) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                JDBCUtil.forceTransactionRollback((Connection)connection);
            }
            String string3 = "Deleting target : " + string + "," + string2 + " from registration with rgtr id: " + l;
            HarvesterUtil.logErrorMessage(sLog, sQLException, string3);
            throw new HarvesterException(string3, sQLException);
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    public static boolean isPendingRegistration(long l, Connection connection) throws HarvesterException {
        RegistrationDO registrationDO = RegistrationDAO.getRegrForId(l, connection);
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("Registration id: " + l));
            sLog.debug((Object)("Reg obj: " + registrationDO));
            sLog.debug((Object)("Reg obj getRegrStat(): " + (registrationDO != null ? registrationDO.getRegrStat() : "null")));
        }
        if (registrationDO == null) {
            return false;
        }
        String string = registrationDO.getRegrStat();
        return string.equals("PENDING");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RegistrationDO getRegrForId(long l, Connection connection) throws HarvesterException {
        RegistrationDO registrationDO;
        PreparedStatement preparedStatement;
        block6: {
            preparedStatement = null;
            ResultSet resultSet = null;
            registrationDO = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement("select r.RGTR_ID, r.HOSTNAME, r.ORACLE_HOME, r.ORACLE_CONFIG_HOME, r.RGTR_TYP, r.GC_HOSTNAME, r.GC_ORACLE_HOME, r.GC_RGTR_KEY, r.ORG_ID, r.METALINK_ID, r.CSI, r.CLIENT_KEY, r.IS_AUTHENTICATED, r.IS_UNIQUE_CSI, r.IS_FAKE_OH, r.IS_FAKE_HOST, r.RGTR_STATUS, r.CIPHER_TXT_ID from em_ocm_registrations r  where r.RGTR_ID = ?");
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    registrationDO = RegistrationDAO.processRegResultSet(resultSet);
                }
                catch (SQLException sQLException) {
                    String string = "Error in getting registration for registration id: " + l;
                    HarvesterUtil.logErrorMessage(sLog, sQLException, string);
                    throw new HarvesterException(string, sQLException);
                }
                Object var9_5 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var9_6 = null;
                if (resultSet != null) {
                    JDBCUtil.close(resultSet);
                }
                if (preparedStatement == null) throw throwable;
                JDBCUtil.close((Statement)preparedStatement);
                throw throwable;
            }
            JDBCUtil.close((ResultSet)resultSet);
        }
        if (preparedStatement == null) return registrationDO;
        JDBCUtil.close((Statement)preparedStatement);
        return registrationDO;
    }

    public static RegistrationDO getDefaultRegr(Connection connection) throws HarvesterException {
        if (cacheDefultRegistration == null) {
            RegistrationDO registrationDO;
            cacheDefultRegistration = registrationDO = RegistrationDAO.getDefaultRegrInternal(connection);
        }
        return cacheDefultRegistration;
    }

    public static boolean isDefaultRegPending(Connection connection) throws HarvesterException {
        RegistrationDO registrationDO = RegistrationDAO.getDefaultRegrInternal(connection);
        return registrationDO.getRegrStat().equals("PENDING");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean resyncWithOCMCollector(Connection connection) throws HarvesterException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block15: {
            boolean bl;
            block16: {
                boolean bl2;
                block13: {
                    block14: {
                        preparedStatement = null;
                        resultSet = null;
                        String string = null;
                        try {
                            try {
                                preparedStatement = connection.prepareStatement("select str_value from mgmt_ocm_upl_props where name = 'resynWithOCMCollector'");
                                resultSet = preparedStatement.executeQuery();
                                while (resultSet.next()) {
                                    string = resultSet.getString(1);
                                }
                                if (sLog.isDebugEnabled()) {
                                    sLog.debug((Object)("resyncWithOCMCollector value of resyncVal: " + string));
                                }
                                if (string != null && string.equalsIgnoreCase("anon_to_auth")) {
                                    RegistrationDO registrationDO = RegistrationDAO.getDefaultRegrInternal(connection);
                                    if (!registrationDO.isAuth()) {
                                        bl2 = true;
                                        Object var7_9 = null;
                                        if (resultSet == null) break block13;
                                        break block14;
                                    }
                                    RegistrationDAO.clearResyncWithOCMSignal(connection);
                                }
                                if (string == null || !string.equalsIgnoreCase("true")) break block15;
                                bl = true;
                                break block16;
                            }
                            catch (SQLException sQLException) {
                                String string2 = "Error in getting resyncWithCollector signal";
                                HarvesterUtil.logErrorMessage(sLog, sQLException, string2);
                                throw new HarvesterException(string2, sQLException);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_12 = null;
                            if (resultSet != null) {
                                JDBCUtil.close((ResultSet)resultSet);
                            }
                            if (preparedStatement == null) throw throwable;
                            JDBCUtil.close((Statement)preparedStatement);
                            throw throwable;
                        }
                    }
                    JDBCUtil.close((ResultSet)resultSet);
                }
                if (preparedStatement == null) return bl2;
                JDBCUtil.close((Statement)preparedStatement);
                return bl2;
            }
            Object var7_10 = null;
            if (resultSet != null) {
                JDBCUtil.close((ResultSet)resultSet);
            }
            if (preparedStatement == null) return bl;
            JDBCUtil.close((Statement)preparedStatement);
            return bl;
        }
        Object var7_11 = null;
        if (resultSet != null) {
            JDBCUtil.close((ResultSet)resultSet);
        }
        if (preparedStatement == null) return false;
        JDBCUtil.close((Statement)preparedStatement);
        return false;
    }

    public static void addResyncWithOCMSignal(Connection connection) throws HarvesterException {
        RegistrationDAO.updateResyncWithOCMSignal(connection, "anon_to_auth");
    }

    public static void clearResyncWithOCMSignal(Connection connection) throws HarvesterException {
        RegistrationDAO.updateResyncWithOCMSignal(connection, "false");
    }

    private static void updateResyncWithOCMSignal(Connection connection, String string) throws HarvesterException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("MERGE INTO mgmt_ocm_upl_props p  USING dual ON ( name = 'resynWithOCMCollector' ) WHEN MATCHED THEN UPDATE SET p.str_value = ? WHEN NOT MATCHED THEN INSERT (name, str_value) VALUES ('resynWithOCMCollector', ?)");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException sQLException) {
            String string2 = "Error in updating the resynWithOCMCollector value to " + string;
            HarvesterUtil.logErrorMessage(sLog, sQLException, string2);
            throw new HarvesterException(string2, sQLException);
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RegistrationDO getRegrForTarget(String string, String string2, Connection connection) throws HarvesterException {
        RegistrationDO registrationDO;
        PreparedStatement preparedStatement;
        block6: {
            preparedStatement = null;
            ResultSet resultSet = null;
            registrationDO = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement("select r.RGTR_ID, r.HOSTNAME, r.ORACLE_HOME, r.ORACLE_CONFIG_HOME, r.RGTR_TYP, r.GC_HOSTNAME, r.GC_ORACLE_HOME, r.GC_RGTR_KEY, r.ORG_ID, r.METALINK_ID, r.CSI, r.CLIENT_KEY, r.IS_AUTHENTICATED, r.IS_UNIQUE_CSI, r.IS_FAKE_OH, r.IS_FAKE_HOST, r.RGTR_STATUS, r.CIPHER_TXT_ID from em_ocm_registrations r , em_ocm_rgtr_target_map m, mgmt_targets t where r.RGTR_ID = m.rgtr_id and m.target_guid = t.target_guid and t.target_name = ? and t.target_type = ?");
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    resultSet = preparedStatement.executeQuery();
                    registrationDO = RegistrationDAO.processRegResultSet(resultSet);
                }
                catch (SQLException sQLException) {
                    String string3 = "Error in getting registration for target with target_name=" + string + ", targetType=" + string2;
                    HarvesterUtil.logErrorMessage(sLog, sQLException, string3);
                    throw new HarvesterException(string3, sQLException);
                }
                Object var9_6 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (resultSet != null) {
                    JDBCUtil.close(resultSet);
                }
                if (preparedStatement == null) throw throwable;
                JDBCUtil.close((Statement)preparedStatement);
                throw throwable;
            }
            JDBCUtil.close((ResultSet)resultSet);
        }
        if (preparedStatement == null) return registrationDO;
        JDBCUtil.close((Statement)preparedStatement);
        return registrationDO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RegistrationDO getRegrForHostAndOracleHome(String string, String string2, Connection connection) throws HarvesterException {
        RegistrationDO registrationDO;
        PreparedStatement preparedStatement;
        block6: {
            preparedStatement = null;
            ResultSet resultSet = null;
            registrationDO = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement("select r.RGTR_ID, r.HOSTNAME, r.ORACLE_HOME, r.ORACLE_CONFIG_HOME, r.RGTR_TYP, r.GC_HOSTNAME, r.GC_ORACLE_HOME, r.GC_RGTR_KEY, r.ORG_ID, r.METALINK_ID, r.CSI, r.CLIENT_KEY, r.IS_AUTHENTICATED, r.IS_UNIQUE_CSI, r.IS_FAKE_OH, r.IS_FAKE_HOST, r.RGTR_STATUS, r.CIPHER_TXT_ID from em_ocm_registrations r  where r.hostname = ? and r.oracle_home = ? and r.oracle_config_home = 'NONE' and RGTR_TYP = 'GC'");
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    resultSet = preparedStatement.executeQuery();
                    registrationDO = RegistrationDAO.processRegResultSet(resultSet);
                }
                catch (SQLException sQLException) {
                    String string3 = "Error in getting registration for host=" + string + " and  oracleHome=" + string2;
                    HarvesterUtil.logErrorMessage(sLog, sQLException, string3);
                    throw new HarvesterException(string3, sQLException);
                }
                Object var9_6 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (resultSet != null) {
                    JDBCUtil.close(resultSet);
                }
                if (preparedStatement == null) throw throwable;
                JDBCUtil.close((Statement)preparedStatement);
                throw throwable;
            }
            JDBCUtil.close((ResultSet)resultSet);
        }
        if (preparedStatement == null) return registrationDO;
        JDBCUtil.close((Statement)preparedStatement);
        return registrationDO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getRegsForHost(String string, Connection connection) throws HarvesterException {
        ArrayList arrayList;
        PreparedStatement preparedStatement;
        block6: {
            preparedStatement = null;
            ResultSet resultSet = null;
            arrayList = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement("select r.RGTR_ID, r.HOSTNAME, r.ORACLE_HOME, r.ORACLE_CONFIG_HOME, r.RGTR_TYP, r.GC_HOSTNAME, r.GC_ORACLE_HOME, r.GC_RGTR_KEY, r.ORG_ID, r.METALINK_ID, r.CSI, r.CLIENT_KEY, r.IS_AUTHENTICATED, r.IS_UNIQUE_CSI, r.IS_FAKE_OH, r.IS_FAKE_HOST, r.RGTR_STATUS, r.CIPHER_TXT_ID from em_ocm_registrations r  where r.hostname = ? and RGTR_TYP = 'GC'");
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    arrayList = RegistrationDAO.processRegResultSetWithList(resultSet);
                }
                catch (SQLException sQLException) {
                    String string2 = "Error in getting registration for host=" + string;
                    HarvesterUtil.logErrorMessage(sLog, sQLException, string2);
                    throw new HarvesterException(string2, sQLException);
                }
                Object var8_5 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (resultSet != null) {
                    JDBCUtil.close(resultSet);
                }
                if (preparedStatement == null) throw throwable;
                JDBCUtil.close((Statement)preparedStatement);
                throw throwable;
            }
            JDBCUtil.close((ResultSet)resultSet);
        }
        if (preparedStatement == null) return arrayList;
        JDBCUtil.close((Statement)preparedStatement);
        return arrayList;
    }

    public static String gcRegrGuid(Connection connection) throws HarvesterException {
        RegistrationDO registrationDO = RegistrationDAO.getDefaultRegr(connection);
        if (registrationDO != null) {
            return SecurityUtil.getSecureInfo(registrationDO.getGcGuid(), connection);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getRepoUrl(Connection connection) throws HarvesterException {
        String string;
        PreparedStatement preparedStatement;
        block7: {
            preparedStatement = null;
            ResultSet resultSet = null;
            string = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement("select str_value from mgmt_ocm_upl_props where name = 'gc_repo_url'");
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        string = resultSet.getString(1);
                    }
                    Object var7_4 = null;
                    if (resultSet == null) break block7;
                }
                catch (SQLException sQLException) {
                    String string2 = "Error in getting repoUrl for GCHarvester";
                    HarvesterUtil.logErrorMessage(sLog, sQLException, string2);
                    throw new HarvesterException(string2, sQLException);
                }
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                if (resultSet != null) {
                    JDBCUtil.close((ResultSet)resultSet);
                }
                if (preparedStatement == null) throw throwable;
                JDBCUtil.close((Statement)preparedStatement);
                throw throwable;
            }
            JDBCUtil.close((ResultSet)resultSet);
        }
        if (preparedStatement == null) return string;
        JDBCUtil.close((Statement)preparedStatement);
        return string;
    }

    public static String getCipherTxt(RegistrationDO registrationDO, Connection connection) throws HarvesterException {
        String string = registrationDO.getCipherTxtId();
        return SecurityUtil.getSecureInfo(string, connection);
    }

    public static String getCipherTxtForDefaultReg(Connection connection) throws HarvesterException {
        return RegistrationDAO.getCipherTxt(RegistrationDAO.getDefaultRegrInternal(connection), connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RegistrationDO getDefaultRegrInternal(Connection connection) throws HarvesterException {
        RegistrationDO registrationDO;
        PreparedStatement preparedStatement;
        block6: {
            preparedStatement = null;
            ResultSet resultSet = null;
            registrationDO = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement("select r.RGTR_ID, r.HOSTNAME, r.ORACLE_HOME, r.ORACLE_CONFIG_HOME, r.RGTR_TYP, r.GC_HOSTNAME, r.GC_ORACLE_HOME, r.GC_RGTR_KEY, r.ORG_ID, r.METALINK_ID, r.CSI, r.CLIENT_KEY, r.IS_AUTHENTICATED, r.IS_UNIQUE_CSI, r.IS_FAKE_OH, r.IS_FAKE_HOST, r.RGTR_STATUS, r.CIPHER_TXT_ID from em_ocm_registrations r , mgmt_ocm_upl_props p where r.RGTR_ID = p.num_value and p.name = 'default_reg_id'");
                    resultSet = preparedStatement.executeQuery();
                    registrationDO = RegistrationDAO.processRegResultSet(resultSet);
                }
                catch (SQLException sQLException) {
                    String string = "Error in getting default registration";
                    HarvesterUtil.logErrorMessage(sLog, sQLException, string);
                    throw new HarvesterException(string, sQLException);
                }
                Object var7_4 = null;
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                if (resultSet != null) {
                    JDBCUtil.close((ResultSet)resultSet);
                }
                if (preparedStatement == null) throw throwable;
                JDBCUtil.close((Statement)preparedStatement);
                throw throwable;
            }
            JDBCUtil.close((ResultSet)resultSet);
        }
        if (preparedStatement == null) return registrationDO;
        JDBCUtil.close((Statement)preparedStatement);
        return registrationDO;
    }

    private static void insertRegistrationInternal(RegistrationDO registrationDO, long l, boolean bl, Connection connection) throws HarvesterException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("insert into em_ocm_registrations(RGTR_ID, HOSTNAME, ORACLE_HOME, ORACLE_CONFIG_HOME, RGTR_TYP, GC_HOSTNAME, GC_ORACLE_HOME, GC_RGTR_KEY, ORG_ID, METALINK_ID, CSI, CLIENT_KEY, IS_AUTHENTICATED, IS_UNIQUE_CSI, IS_FAKE_OH, IS_FAKE_HOST, RGTR_STATUS, CIPHER_TXT_ID, CREATE_DT, CREATED_BY) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, sysdate, ?)");
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, registrationDO.getHostName());
            preparedStatement.setString(3, registrationDO.getOracleHome());
            preparedStatement.setString(4, registrationDO.getOracleConfigHome());
            preparedStatement.setString(5, registrationDO.getRegrType());
            RegistrationDAO.setNullOrString(preparedStatement, 6, registrationDO.getGcHostName());
            RegistrationDAO.setNullOrString(preparedStatement, 7, registrationDO.getGcOracleHome());
            RegistrationDAO.setNullOrString(preparedStatement, 8, registrationDO.getGcGuid());
            RegistrationDAO.setNullOrString(preparedStatement, 9, registrationDO.getOrgId());
            RegistrationDAO.setNullOrString(preparedStatement, 10, registrationDO.getMetalinkId());
            RegistrationDAO.setNullOrString(preparedStatement, 11, registrationDO.getCsi());
            RegistrationDAO.setNullOrString(preparedStatement, 12, registrationDO.getClientKey());
            preparedStatement.setInt(13, RegistrationDAO.bolToInt(registrationDO.isAuth()));
            preparedStatement.setInt(14, RegistrationDAO.bolToInt(registrationDO.isUniqueCSI()));
            preparedStatement.setInt(15, RegistrationDAO.bolToInt(registrationDO.isFakeOH()));
            preparedStatement.setInt(16, RegistrationDAO.bolToInt(registrationDO.isFakeHost()));
            preparedStatement.setString(17, registrationDO.getRegrStat());
            RegistrationDAO.setNullOrString(preparedStatement, 18, registrationDO.getCipherTxtId());
            preparedStatement.setString(19, GC_HARVESTER_JOB_NM);
            preparedStatement.executeUpdate();
            registrationDO.setRegrId(l);
            if (bl) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                JDBCUtil.forceTransactionRollback((Connection)connection);
            }
            String string = "host: " + registrationDO.getHostName() + ",oh: " + registrationDO.getOracleHome() + " registration has error while inserting the record";
            HarvesterUtil.logErrorMessage(sLog, sQLException, string);
            throw new HarvesterException(string, sQLException);
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void updateRegistrationInternal(RegistrationDO registrationDO, boolean bl, boolean bl2, Connection connection) throws HarvesterException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "update em_ocm_registrations set HOSTNAME = ?, ORACLE_HOME = ?, ORACLE_CONFIG_HOME = ?, RGTR_TYP = ?, GC_HOSTNAME = ?, GC_ORACLE_HOME = ?, GC_RGTR_KEY = ?, ORG_ID = ?, METALINK_ID = ?, CSI = ?, CLIENT_KEY = ?, IS_AUTHENTICATED = ?, IS_UNIQUE_CSI = ?, IS_FAKE_OH = ?, IS_FAKE_HOST = ?, RGTR_STATUS = ?, CIPHER_TXT_ID = ?, UPDATE_DT = sysdate, UPDATED_BY = ?  where RGTR_ID = ? and RGTR_STATUS != 'PENDING'";
            if (bl2) {
                string = "update em_ocm_registrations set HOSTNAME = ?, ORACLE_HOME = ?, ORACLE_CONFIG_HOME = ?, RGTR_TYP = ?, GC_HOSTNAME = ?, GC_ORACLE_HOME = ?, GC_RGTR_KEY = ?, ORG_ID = ?, METALINK_ID = ?, CSI = ?, CLIENT_KEY = ?, IS_AUTHENTICATED = ?, IS_UNIQUE_CSI = ?, IS_FAKE_OH = ?, IS_FAKE_HOST = ?, RGTR_STATUS = ?, CIPHER_TXT_ID = ?, UPDATE_DT = sysdate, UPDATED_BY = ?  where RGTR_ID = ?";
            }
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, registrationDO.getHostName());
            preparedStatement.setString(2, registrationDO.getOracleHome());
            preparedStatement.setString(3, registrationDO.getOracleConfigHome());
            preparedStatement.setString(4, registrationDO.getRegrType());
            RegistrationDAO.setNullOrString(preparedStatement, 5, registrationDO.getGcHostName());
            RegistrationDAO.setNullOrString(preparedStatement, 6, registrationDO.getGcOracleHome());
            RegistrationDAO.setNullOrString(preparedStatement, 7, registrationDO.getGcGuid());
            RegistrationDAO.setNullOrString(preparedStatement, 8, registrationDO.getOrgId());
            RegistrationDAO.setNullOrString(preparedStatement, 9, registrationDO.getMetalinkId());
            RegistrationDAO.setNullOrString(preparedStatement, 10, registrationDO.getCsi());
            RegistrationDAO.setNullOrString(preparedStatement, 11, registrationDO.getClientKey());
            preparedStatement.setInt(12, RegistrationDAO.bolToInt(registrationDO.isAuth()));
            preparedStatement.setInt(13, RegistrationDAO.bolToInt(registrationDO.isUniqueCSI()));
            preparedStatement.setInt(14, RegistrationDAO.bolToInt(registrationDO.isFakeOH()));
            preparedStatement.setInt(15, RegistrationDAO.bolToInt(registrationDO.isFakeHost()));
            preparedStatement.setString(16, registrationDO.getRegrStat());
            RegistrationDAO.setNullOrString(preparedStatement, 17, registrationDO.getCipherTxtId());
            preparedStatement.setString(18, GC_HARVESTER_JOB_NM);
            preparedStatement.setLong(19, registrationDO.getRegrId());
            int n = preparedStatement.executeUpdate();
            if (n == 0) {
                if (!sLog.isDebugEnabled()) throw new HarvesterException("Update of registration failed as it is PENDING status. This will be processed in next GC Harvester run. Registration Id: " + registrationDO.getRegrId());
                sLog.debug((Object)("Update of registration failed as it is PENDING status. This will be processed in next GC Harvester run. Registration Id: " + registrationDO.getRegrId()));
                throw new HarvesterException("Update of registration failed as it is PENDING status. This will be processed in next GC Harvester run. Registration Id: " + registrationDO.getRegrId());
            }
            if (bl) {
                connection.commit();
            }
            if (preparedStatement == null) return;
        }
        catch (SQLException sQLException) {
            try {
                if (bl) {
                    JDBCUtil.forceTransactionRollback((Connection)connection);
                }
                String string = "Error while updating a registration with registration id: " + registrationDO.getRegrId();
                HarvesterUtil.logErrorMessage(sLog, sQLException, string);
                throw new HarvesterException(string, sQLException);
            }
            catch (Throwable throwable) {
                if (preparedStatement == null) throw throwable;
                JDBCUtil.close(preparedStatement);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)preparedStatement);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void triggerFullCollection(String string, String string2, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("update mgmt_ocm_upl_metrics set is_changed = 1 where target_type = ? and target_name = ?");
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveTargets(long l, long l2, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("insert into em_ocm_rgtr_target_map(rgtr_id, target_guid) select ?, target_guid from em_ocm_rgtr_target_map where rgtr_id = ?");
            preparedStatement.setLong(1, l2);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteRegistration(long l, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("begin \ndelete from em_ocm_rgtr_target_map where rgtr_id = ?; \ndelete from em_ocm_registrations where rgtr_id = ?; \nend; \n");
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    private static void setNullOrString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (string == null) {
            preparedStatement.setNull(n, 12);
        } else {
            preparedStatement.setString(n, string);
        }
    }

    private static RegistrationDO processRegResultSet(ResultSet resultSet) throws SQLException {
        RegistrationDO registrationDO = null;
        ArrayList arrayList = RegistrationDAO.processRegResultSetWithList(resultSet);
        if (arrayList != null && arrayList.size() > 0) {
            registrationDO = (RegistrationDO)arrayList.get(0);
        }
        return registrationDO;
    }

    private static ArrayList processRegResultSetWithList(ResultSet resultSet) throws SQLException {
        ArrayList<RegistrationDO> arrayList = new ArrayList<RegistrationDO>();
        while (resultSet.next()) {
            RegistrationDO registrationDO = new RegistrationDO();
            registrationDO.setRegrId(resultSet.getLong(1));
            registrationDO.setHostName(resultSet.getString(2));
            registrationDO.setOracleHome(resultSet.getString(3));
            registrationDO.setOracleConfigHome(resultSet.getString(4));
            registrationDO.setRegrType(resultSet.getString(5));
            registrationDO.setGcHostName(resultSet.getString(6));
            registrationDO.setGcOracleHome(resultSet.getString(7));
            registrationDO.setGcGuid(resultSet.getString(8));
            registrationDO.setOrgId(resultSet.getString(9));
            registrationDO.setMetalinkId(resultSet.getString(10));
            registrationDO.setCsi(resultSet.getString(11));
            registrationDO.setClientKey(resultSet.getString(12));
            registrationDO.setIsAuth(RegistrationDAO.intToBol(resultSet.getInt(13)));
            registrationDO.setIsuniqueCSI(RegistrationDAO.intToBol(resultSet.getInt(14)));
            registrationDO.setIsFakeOH(RegistrationDAO.intToBol(resultSet.getInt(15)));
            registrationDO.setIsFakeHost(RegistrationDAO.intToBol(resultSet.getInt(16)));
            registrationDO.setRegrStat(resultSet.getString(17));
            registrationDO.setCipherTxtId(resultSet.getString(18));
            arrayList.add(registrationDO);
        }
        return arrayList;
    }

    private static int bolToInt(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    private static boolean intToBol(int n) {
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertDefaultId(long l, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("insert into mgmt_ocm_upl_props(name, num_value) values('default_reg_id', ?)");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertRepoUrl(String string, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("insert into mgmt_ocm_upl_props(name, str_value) values('gc_repo_url',?)");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRepoUrl(String string, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("update mgmt_ocm_upl_props set str_value = ? where name = 'gc_repo_url'");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteChangeTS(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("delete from mgmt_ocm_upl_props where name = 'changes_ts'");
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    private static void addTargetToRegrInternal(RegistrationDO registrationDO, long l, String string, String string2, boolean bl, Connection connection) throws HarvesterException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("insert into em_ocm_rgtr_target_map(rgtr_id, target_guid) values( ?, (select target_guid from mgmt_targets where target_name = ? and target_type = ? ))");
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.executeUpdate();
            RegistrationDAO.updateCSIForNewTargetInternal(registrationDO, string, string2, connection);
            if (bl) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            if (bl) {
                JDBCUtil.forceTransactionRollback((Connection)connection);
            }
            String string3 = "Error while inserting target to a registration: REGR_ID: " + l + ", TargetName: " + string + ", TargetType: " + string2;
            HarvesterUtil.logErrorMessage(sLog, sQLException, string3);
            throw new HarvesterException(string3, sQLException);
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    private static void updateCSIForNewTargetInternal(RegistrationDO registrationDO, String string, String string2, Connection connection) throws HarvesterException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall("begin mgmt_properties.set_target_property(?, ?, mgmt_properties.ORCL_GTP_CSI, mgmt_properties.INSTANCE, ?); end;");
            callableStatement.setString(1, string);
            callableStatement.setString(2, string2);
            callableStatement.setString(3, registrationDO.getCsi());
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            String string3 = "Error while updating csi target property for the target belonging to the registration with: REGR_ID, TargetName, TargetType as : " + registrationDO.getRegrId() + " " + string + " " + string2;
            HarvesterUtil.logErrorMessage(sLog, sQLException, string3);
            throw new HarvesterException(string3, sQLException);
        }
        finally {
            if (callableStatement != null) {
                JDBCUtil.close((Statement)callableStatement);
            }
        }
    }

    private static void updateCSIForTargetRegrInternal(long l, Connection connection) throws HarvesterException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("DECLARE l_prop_error               NUMBER; l_prop_error_record        MGMT_TARGET_PROPERTY_OBJ; l_prop_obj_array           MGMT_TARGET_PROPERTY_OBJ_ARRAY; begin select MGMT_TARGET_PROPERTY_OBJ(t.target_name,            t.target_type,            em_properties.csi_display_name,            mgmt_properties.INSTANCE,            r.csi)     bulk collect into l_prop_obj_array     from em_ocm_registrations r,          em_ocm_rgtr_target_map m,          mgmt_targets t     where r.rgtr_id = ?      and m.rgtr_id = r.rgtr_id      and t.target_guid = m.target_guid;     em_properties.bulk_update_properties  (l_prop_obj_array,l_prop_error,l_prop_error_record);  END; ");
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string = "Error while updating csi target property of all the targets belonging to the registration: REGR_ID: " + l;
            HarvesterUtil.logErrorMessage(sLog, sQLException, string);
            throw new HarvesterException(string, sQLException);
        }
        finally {
            if (preparedStatement != null) {
                JDBCUtil.close((Statement)preparedStatement);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long nextSequenceNumber(String string, Connection connection) throws HarvesterException {
        long l;
        PreparedStatement preparedStatement;
        block7: {
            String string2 = "select " + string + ".nextval from dual";
            preparedStatement = null;
            ResultSet resultSet = null;
            l = 0L;
            try {
                try {
                    preparedStatement = connection.prepareStatement(string2);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        l = resultSet.getLong(1);
                    }
                    Object var10_6 = null;
                    if (resultSet == null) break block7;
                }
                catch (SQLException sQLException) {
                    String string3 = "Error in get sequence number for the database sequence " + string;
                    HarvesterUtil.logErrorMessage(sLog, sQLException, string3);
                    throw new HarvesterException(string3, sQLException);
                }
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                if (resultSet != null) {
                    JDBCUtil.close((ResultSet)resultSet);
                }
                if (preparedStatement == null) throw throwable;
                JDBCUtil.close((Statement)preparedStatement);
                throw throwable;
            }
            JDBCUtil.close((ResultSet)resultSet);
        }
        if (preparedStatement == null) return l;
        JDBCUtil.close((Statement)preparedStatement);
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

