/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.registration;

import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.registration.RegistrationDAO;
import oracle.sysman.ccr.gcharvester.registration.RegistrationDO;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.ccr.gcharvester.util.NetworkUtil;
import oracle.sysman.ccr.gcharvester.util.SecurityUtil;
import oracle.sysman.ccr.netmgr.HarvesterClientAction;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.netmgr.RegistrationKeyDoc;
import org.apache.log4j.Category;

public class RegistrationUtil {
    private static final String DEFAULT_OCH = "NONE";
    private static volatile String sGCRegistrationGuid = null;
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$registration$RegistrationUtil == null ? (class$oracle$sysman$ccr$gcharvester$registration$RegistrationUtil = RegistrationUtil.class$("oracle.sysman.ccr.gcharvester.registration.RegistrationUtil")) : class$oracle$sysman$ccr$gcharvester$registration$RegistrationUtil).getName());
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$registration$RegistrationUtil;

    public static void processGCDefaultRegistration(Connection connection, ServletContext servletContext) throws HarvesterException {
        String string;
        Object object;
        String string2;
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)"Inside processGCDefaultRegistration to check for default registration");
        }
        if ((string2 = RegistrationUtil.getRepoUrl(servletContext)) == null) {
            throw new HarvesterException("Repository URL not present in the servlet contxt");
        }
        if (sGCRegistrationGuid == null) {
            object = RegistrationDAO.gcRegrGuid(connection);
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"sGCRegistrationGuid is null. Either first Harvester run for 11.2+ or running after OMS restart");
                sLog.debug((Object)("repoURL: " + string2));
                sLog.debug((Object)("gcRegGuid: " + (String)object));
            }
            if (object == null) {
                object = RegistrationUtil.performDefaultRegistration(string2, connection);
            } else {
                string = RegistrationDAO.getRepoUrl(connection);
                if (string == null) {
                    throw new HarvesterException("Repository URL null in the GC Harvester table");
                }
                if (!string.equals(string2)) {
                    RegistrationUtil.peformDefaultReRegistration(string2, connection, null, null, null, false);
                }
            }
            sGCRegistrationGuid = object;
        }
        if (RegistrationUtil.pendingDefaultReg(connection)) {
            RegistrationUtil.peformDefaultReRegistration(string2, connection, null, null, null, false);
        }
        object = UplinkSystemConfig.getInstance();
        if (RegistrationUtil.resyncWithOCMCollector(connection)) {
            string = ((Config)object).getProperty("ccr.metalink_email.address");
            String string3 = ((Config)object).getProperty("ccr.registration_ct");
            if (string3 != null) {
                RegistrationUtil.peformDefaultReRegistration(string2, connection, null, string3, string, false);
                RegistrationDAO.clearResyncWithOCMSignal(connection);
            }
        }
        RegistrationUtil.performHarvesterSyncUp(sGCRegistrationGuid, connection, servletContext);
    }

    public static void processPendingRegistrations(Connection connection) throws HarvesterException {
        RegistrationDAO.processPendingRegistrations(connection);
    }

    public static RegistrationDO fixFakeRegistration(RegistrationDO registrationDO, String string, String string2, boolean bl, boolean bl2, Connection connection) throws HarvesterException {
        RegistrationDO registrationDO2 = RegistrationDAO.getRegrForHostAndOracleHome(string, string2, connection);
        if (registrationDO2 != null && registrationDO2.getRegrId() != registrationDO.getRegrId()) {
            String string3 = registrationDO2.getRegrStat();
            boolean bl3 = true;
            if (string3 != null && (string3.equals("PENDING") || string3.equals("PENDING2"))) {
                bl3 = false;
            }
            RegistrationDAO.fixFakeRegistration(registrationDO, registrationDO2, bl3, connection);
            if (string3.equals("PENDING")) {
                throw new HarvesterException("Pending registration for oracle home: " + string2 + ",host: " + string);
            }
            if (string3.equals("PENDING2")) {
                RegistrationUtil.performRegistration(registrationDO, connection);
            } else {
                RegistrationUtil.performRegistration(registrationDO, "PENDING_FULL", connection);
            }
        } else {
            registrationDO.setHostName(string);
            registrationDO.setOracleHome(string2);
            registrationDO.setIsFakeHost(bl2);
            registrationDO.setIsFakeOH(bl);
            RegistrationUtil.performRegistration(registrationDO, connection);
            registrationDO2 = registrationDO;
        }
        return registrationDO2;
    }

    public static void performRegistration(RegistrationDO registrationDO, Connection connection) throws HarvesterException {
        RegistrationUtil.performRegistration(registrationDO, "RGSTRD", connection);
    }

    private static boolean pendingDefaultReg(Connection connection) throws HarvesterException {
        return RegistrationDAO.isDefaultRegPending(connection);
    }

    private static boolean resyncWithOCMCollector(Connection connection) throws HarvesterException {
        boolean bl = false;
        RegistrationDO registrationDO = RegistrationDAO.getDefaultRegr(connection);
        Config config = UplinkSystemConfig.getInstance();
        String string = config.getProperty("ccr.registration_mode");
        String string2 = config.getProperty("ccr.metalink_email.address");
        String string3 = config.getProperty("ccr.support_id");
        String string4 = registrationDO.getMetalinkId();
        String string5 = registrationDO.getCsi();
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("Harvester: resyncWithOCMCollector regisMode: " + string));
            sLog.debug((Object)("Harvester: resyncWithOCMCollector metalinkEmailFromOCM: " + string2));
            sLog.debug((Object)("Harvester: resyncWithOCMCollector csiFromOCM: " + string3));
            sLog.debug((Object)("Harvester: resyncWithOCMCollector metalinkEmailFromGC: " + string4));
            sLog.debug((Object)("Harvester: resyncWithOCMCollector csiFromGC: " + string5));
        }
        if (string != null && !string.equals("anon")) {
            if (!registrationDO.isAuth()) {
                bl = true;
            } else if (registrationDO.isAuth() && !registrationDO.isUniqueCSI()) {
                if (string.equals("email")) {
                    if (string2 != null && !string2.equalsIgnoreCase(string4)) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            } else if (string.equals("email")) {
                if (string2 != null && !string2.equalsIgnoreCase(string4)) {
                    bl = true;
                }
            } else if (!string3.equals(string5)) {
                bl = true;
            }
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("Harvester: resyncWithOCMCollector returning: " + bl));
        }
        return bl;
    }

    private static void performHarvesterSyncUp(String string, Connection connection, ServletContext servletContext) throws HarvesterException {
        HarvesterClientAction harvesterClientAction = null;
        OCMEndPoint oCMEndPoint = NetworkUtil.ocmEndPoint();
        List list = null;
        try {
            list = oCMEndPoint.getHarvesterClientActions(string);
        }
        catch (NetworkException networkException) {
            HarvesterUtil.logErrorMessage(sLog, networkException, "Error during performHarvesterSyncUp");
            throw new HarvesterException("Error during performHarvesterSyncUp", networkException);
        }
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                HarvesterClientAction harvesterClientAction2 = (HarvesterClientAction)iterator.next();
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)("Processing HarvesterClientAction object: type: " + harvesterClientAction2.getRegistrationType() + ", host: " + harvesterClientAction2.getHost() + ", Home: " + harvesterClientAction2.getHome() + ", OCH: " + harvesterClientAction2.getConfigHome() + ", CSI: " + harvesterClientAction2.getCSI() + ", Cipher Text: " + harvesterClientAction2.getCipherText()));
                }
                if ((string2 = harvesterClientAction2.getRegistrationType()).equals("GC_HARVESTER_DEFAULT")) {
                    harvesterClientAction = harvesterClientAction2;
                    continue;
                }
                RegistrationDAO.processReSyncSignal(harvesterClientAction2.getHost(), harvesterClientAction2.getHome(), harvesterClientAction2.getConfigHome(), harvesterClientAction2.getCSI(), harvesterClientAction2.getCipherText(), connection);
            }
            if (harvesterClientAction != null) {
                RegistrationUtil.peformDefaultReRegistration(RegistrationUtil.getRepoUrl(servletContext), connection, harvesterClientAction.getCSI(), harvesterClientAction.getCipherText(), null, false);
            }
        }
    }

    private static void performRegistration(RegistrationDO registrationDO, String string, Connection connection) throws HarvesterException {
        String string2 = RegistrationDAO.getCipherTxt(registrationDO, connection);
        if (string2 == null || registrationDO.getCsi() == null) {
            throw new HarvesterException("Cipher text or/and CSI is/are null for PENDING registration.");
        }
        RegistrationKeyDoc registrationKeyDoc = RegistrationUtil.registerTargetHomeWithCCR(registrationDO.getHostName(), registrationDO.getOracleHome(), string2);
        String string3 = registrationDO.getClientKey();
        String string4 = registrationKeyDoc.getKey();
        String string5 = registrationKeyDoc.getGCID();
        boolean bl = registrationKeyDoc.holdsUniqueCSI();
        registrationDO.setClientKey(SecurityUtil.insertSecureInfo(string4, connection));
        registrationDO.setOrgId(string5);
        registrationDO.setIsuniqueCSI(bl);
        registrationDO.setIsAuth(true);
        registrationDO.setRegrStat(string);
        RegistrationDAO.updateRegistration(registrationDO, connection);
        if (string3 != null) {
            SecurityUtil.deleteSecureInfo(string3, connection);
        }
    }

    private static String getRepoUrl(ServletContext servletContext) {
        return (String)servletContext.getAttribute("oracle.sysman.eml.mntr.emdRepConnectDescriptor");
    }

    private static String performDefaultRegistration(String string, Connection connection) throws HarvesterException {
        String string2 = Hostname.getHostname();
        String string3 = Collector.getOracleHome();
        Config config = UplinkSystemConfig.getInstance();
        String string4 = config.getProperty("ccr.registration_mode");
        String string5 = config.getProperty("ccr.metalink_email.address");
        String string6 = config.getProperty("ccr.registration_ct");
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)"Inside performDefaultRegistration");
            sLog.debug((Object)("hostName: " + string2));
            sLog.debug((Object)("oracle home: " + string3));
            sLog.debug((Object)("strRegistrationMethod: " + string4));
            sLog.debug((Object)("metalinkEmail: " + string5));
            sLog.debug((Object)("cipherTxt: " + string6));
        }
        String string7 = null;
        if (string4 == null) {
            string7 = "ccr.registration_mode is null in ccr.properties.";
            sLog.error((Object)("GC OCM Harvester: " + string7));
            throw new HarvesterException(string7);
        }
        if (string4.equals("email") && (string5 == null || string6 == null)) {
            string7 = "ccr.metalink_email.address or/and ccr.registration_ct is/are null with email registration.";
            sLog.error((Object)("GC OCM Harvester: " + string7));
            throw new HarvesterException(string7);
        }
        if (string4.equals("csi") && string6 == null) {
            string7 = "ccr.registration_ct is null with csi registration.";
            sLog.error((Object)("GC OCM Harvester: " + string7));
            throw new HarvesterException(string7);
        }
        RegistrationKeyDoc registrationKeyDoc = RegistrationUtil.registerDefaultWithCCR(string4, string2, string3, string5, string6, string, null, null, false);
        String string8 = registrationKeyDoc.getKey();
        String string9 = registrationKeyDoc.getGCID();
        boolean bl = registrationKeyDoc.holdsUniqueCSI();
        String string10 = registrationKeyDoc.getGcRegGuid();
        String string11 = null;
        String string12 = registrationKeyDoc.getCSI();
        if (string12 != null && !string12.equals("")) {
            string11 = string12;
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("clientKey: " + string8));
            sLog.debug((Object)("orgId: " + string9));
            sLog.debug((Object)("uniqueCSI: " + bl));
            sLog.debug((Object)("gcGuid: " + string10));
            sLog.debug((Object)("regDoc csi: " + string12));
        }
        String string13 = SecurityUtil.insertSecureInfo(string8, connection);
        String string14 = SecurityUtil.insertSecureInfo(string10, connection);
        RegistrationDO registrationDO = RegistrationDO.getDefaultRegrInstance(string4, string2, string3, DEFAULT_OCH, string5, string11, string9, string13, string14, bl);
        RegistrationDAO.insertDefaultRegistration(registrationDO, string, string6, connection);
        return string10;
    }

    private static void peformDefaultReRegistration(String string, Connection connection, String string2, String string3, String string4, boolean bl) throws HarvesterException {
        RegistrationDO registrationDO = RegistrationDAO.getDefaultRegr(connection);
        String string5 = null;
        String string6 = "email";
        boolean bl2 = registrationDO.isAuth();
        String string7 = registrationDO.getCipherTxtId();
        if (string3 != null) {
            string5 = string3;
            string6 = "csi";
            string7 = SecurityUtil.insertSecureInfo(string3, connection);
            bl2 = true;
        } else {
            string5 = RegistrationDAO.getCipherTxtForDefaultReg(connection);
            if (bl2) {
                if (registrationDO.getCsi() != null) {
                    string6 = "csi";
                }
            } else {
                string6 = "anon";
            }
        }
        String string8 = registrationDO.getClientKey();
        String string9 = SecurityUtil.getSecureInfo(string8, connection);
        RegistrationKeyDoc registrationKeyDoc = RegistrationUtil.registerDefaultWithCCR(string6, registrationDO.getHostName(), registrationDO.getOracleHome(), registrationDO.getMetalinkId(), string5, string, registrationDO.getOrgId(), string9, bl);
        String string10 = registrationKeyDoc.getKey();
        String string11 = SecurityUtil.insertSecureInfo(string10, connection);
        String string12 = registrationKeyDoc.getGCID();
        boolean bl3 = registrationKeyDoc.holdsUniqueCSI();
        String string13 = registrationKeyDoc.getCSI();
        RegistrationDO registrationDO2 = RegistrationDO.copyObject(registrationDO);
        registrationDO2.setClientKey(string11);
        registrationDO2.setOrgId(string12);
        registrationDO2.setIsuniqueCSI(bl3);
        registrationDO2.setIsAuth(bl2);
        registrationDO2.setCsi(string13);
        registrationDO2.setCipherTxtId(string7);
        registrationDO2.setRegrStat("RGSTRD");
        registrationDO2.setMetalinkId(string4);
        RegistrationDAO.updateDefaultRegistration(registrationDO2, registrationDO, string, connection);
        SecurityUtil.deleteSecureInfo(string8, connection);
    }

    private static RegistrationKeyDoc registerDefaultWithCCR(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) throws HarvesterException {
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)"Inside registerDefaultWithCCR");
            sLog.debug((Object)("regMethod: " + string));
            sLog.debug((Object)("hostName: " + string2));
            sLog.debug((Object)("oracleHome: " + string3));
            sLog.debug((Object)("email: " + string4));
            sLog.debug((Object)("cipherTxt: " + string5));
            sLog.debug((Object)("repoURL: " + string6));
            sLog.debug((Object)("orgId: " + string7));
            sLog.debug((Object)("clientId: " + string8));
        }
        OCMEndPoint oCMEndPoint = NetworkUtil.ocmEndPoint();
        try {
            if (string.equals("anon")) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)"Triggering Anonymous registrations");
                }
                if (string8 != null && string7 != null) {
                    return oCMEndPoint.registerGcHarvesterDefaultAnonymous(string8, string7, string2, string3, string6);
                }
                return oCMEndPoint.registerGcHarvesterDefaultAnonymous(string4, string2, string3, string6);
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"Triggering Auth registrations");
            }
            return oCMEndPoint.registerGcHarvesterDefault(string5, string2, string3, string6);
        }
        catch (NetworkException networkException) {
            HarvesterUtil.logErrorMessage(sLog, networkException, "Error during gc registration");
            throw new HarvesterException("Error during GC registration", networkException);
        }
    }

    private static RegistrationKeyDoc registerTargetHomeWithCCR(String string, String string2, String string3) throws HarvesterException {
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)"Inside registerTargetHomeWithCCR");
            sLog.debug((Object)("hostName: " + string));
            sLog.debug((Object)("oracleHome: " + string2));
            sLog.debug((Object)("cipherTxt: " + string3));
        }
        OCMEndPoint oCMEndPoint = NetworkUtil.ocmEndPoint();
        try {
            return oCMEndPoint.registerGcHarvestedTargetHome(string3, string, string2, sGCRegistrationGuid);
        }
        catch (NetworkException networkException) {
            HarvesterUtil.logErrorMessage(sLog, networkException, "Error during gc registration");
            throw new HarvesterException("Error during GC registration", networkException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

