/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.targettype;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.targettype.HarvesterTargetTypeDO;
import oracle.sysman.ccr.gcharvester.targettype.TargetMetadataUtil;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class HarvesterTargetTypeDAO {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$targettype$HarvesterTargetTypeDAO == null ? (class$oracle$sysman$ccr$gcharvester$targettype$HarvesterTargetTypeDAO = HarvesterTargetTypeDAO.class$("oracle.sysman.ccr.gcharvester.targettype.HarvesterTargetTypeDAO")) : class$oracle$sysman$ccr$gcharvester$targettype$HarvesterTargetTypeDAO).getName());
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$targettype$HarvesterTargetTypeDAO;

    public static void insertOrUpdateTargetTypes(HashMap hashMap, Connection connection) throws HarvesterException {
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            HarvesterTargetTypeDO harvesterTargetTypeDO = (HarvesterTargetTypeDO)hashMap.get(string);
            HarvesterTargetTypeDAO.insertOrUpdateTargeType(harvesterTargetTypeDO, connection);
        }
    }

    public static List getPendingConvergedTargetType(Connection connection) throws HarvesterException {
        ArrayList<String> arrayList = new ArrayList<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("select target_type from mgmt_target_types ty where ty.ocm_gc_merged = 1 and not exists ( select 'x' from EM_OCM_TARGET_TYPES where target_type = ty.target_type and is_converged = 1)");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                TargetMetadata targetMetadata = TargetMetadataUtil.getTargetMetadata(string);
                if (targetMetadata == null) {
                    if (!sLog.isDebugEnabled()) continue;
                    sLog.debug((Object)("Target Type " + string + " not present in OCM, so ignoring for this harvester run"));
                    continue;
                }
                if (!targetMetadata.isMetadataConverged()) {
                    if (!sLog.isDebugEnabled()) continue;
                    sLog.debug((Object)("Target Type " + string + " not converged in OCM, so ignoring for this harvester run"));
                    continue;
                }
                arrayList.add(string);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string = "Error while getting pending converged target type";
                HarvesterUtil.logErrorMessage(sLog, sQLException, string);
                throw new HarvesterException(string, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close((Statement)preparedStatement);
                JDBCUtil.close(resultSet);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)preparedStatement);
        JDBCUtil.close((ResultSet)resultSet);
        return arrayList;
    }

    public static List getConvergedTargetTypes(Connection connection) throws HarvesterException {
        ArrayList<String> arrayList = new ArrayList<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("select target_type from EM_OCM_TARGET_TYPES where is_converged = 1");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                arrayList.add(string);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string = "Error while getting the converged target type";
                HarvesterUtil.logErrorMessage(sLog, sQLException, string);
                throw new HarvesterException(string, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close((Statement)preparedStatement);
                JDBCUtil.close(resultSet);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)preparedStatement);
        JDBCUtil.close((ResultSet)resultSet);
        return arrayList;
    }

    private static void insertOrUpdateTargeType(HarvesterTargetTypeDO harvesterTargetTypeDO, Connection connection) throws HarvesterException {
        PreparedStatement preparedStatement = null;
        String string = harvesterTargetTypeDO.getTargetType();
        int n = HarvesterTargetTypeDAO.bolToInt(harvesterTargetTypeDO.isConverged());
        int n2 = HarvesterTargetTypeDAO.bolToInt(harvesterTargetTypeDO.hasFakeOH());
        int n3 = HarvesterTargetTypeDAO.bolToInt(harvesterTargetTypeDO.hasFakeHost());
        try {
            preparedStatement = connection.prepareStatement("MERGE INTO EM_OCM_TARGET_TYPES p USING dual ON ( target_type = ? ) WHEN MATCHED THEN UPDATE SET p.is_converged = ?, p.has_fake_oh = ?, p.has_fake_host = ? WHEN NOT MATCHED THEN INSERT (target_type,is_converged, has_fake_oh,has_fake_host) VALUES (?,?,?,?)");
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            preparedStatement.setInt(3, n2);
            preparedStatement.setInt(4, n3);
            preparedStatement.setString(5, string);
            preparedStatement.setInt(6, n);
            preparedStatement.setInt(7, n2);
            preparedStatement.setInt(8, n3);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException sQLException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            String string2 = "Error while updating/inserting target type: " + string;
            HarvesterUtil.logErrorMessage(sLog, sQLException, string2);
            throw new HarvesterException(string2, sQLException);
        }
        finally {
            JDBCUtil.close((Statement)preparedStatement);
        }
    }

    private static int bolToInt(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

