/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.targettype;

import java.util.HashMap;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadataManager;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import org.apache.log4j.Category;

public class TargetMetadataUtil {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$targettype$TargetMetadataUtil == null ? (class$oracle$sysman$ccr$gcharvester$targettype$TargetMetadataUtil = TargetMetadataUtil.class$("oracle.sysman.ccr.gcharvester.targettype.TargetMetadataUtil")) : class$oracle$sysman$ccr$gcharvester$targettype$TargetMetadataUtil).getName());
    private static HashMap oldMetadataCache = new HashMap();
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$targettype$TargetMetadataUtil;

    public static TargetMetadata getTargetMetadata(String string) {
        TargetMetadata targetMetadata = null;
        if (TargetMetadataUtil.loadOldMetadata(string)) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Loading old metadata for " + string));
            }
            if ((targetMetadata = (TargetMetadata)oldMetadataCache.get(string)) == null) {
                try {
                    targetMetadata = new TargetMetadata(string, true);
                    oldMetadataCache.put(string, targetMetadata);
                }
                catch (Exception exception) {
                    sLog.error((Object)("Error in loading metadata for target type: " + string));
                }
            }
        } else {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Loading new metadata for " + string));
            }
            targetMetadata = TargetMetadataManager.getTargetMetadata(string);
        }
        return targetMetadata;
    }

    public static void cleanup() {
        oldMetadataCache = new HashMap();
        if (!GCVersion.pre11_1GC()) {
            TargetMetadataManager.reinitialize();
        }
    }

    private static boolean loadOldMetadata(String string) {
        return GCVersion.pre11_2GC() && (string.equals("oracle_vm_guest") || string.equals("oracle_vm_server") || string.equals("oracle_vm_server_pool"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

