/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.targettype.convergence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.Collection;
import oracle.sysman.ccr.collector.collectionMgr.CollectionList;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.gcharvester.HarvesterEMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterSnapshotMD;
import oracle.sysman.ccr.gcharvester.targettype.TargetMetadataUtil;
import oracle.sysman.ccr.gcharvester.ti.common.HarvesterTargetProperies;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class ConvergedTargetTypeInfo {
    private static final String DEFAULT_FAKE_OH = "N/A";
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$targettype$convergence$ConvergedTargetTypeInfo == null ? (class$oracle$sysman$ccr$gcharvester$targettype$convergence$ConvergedTargetTypeInfo = ConvergedTargetTypeInfo.class$("oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergedTargetTypeInfo")) : class$oracle$sysman$ccr$gcharvester$targettype$convergence$ConvergedTargetTypeInfo).getName());
    private String mTargetType;
    private volatile String mNoOHProp = null;
    private static final String NO_ORACLE_HOME_PROP = "select property_value from mgmt_type_properties where target_type = ? and property_name= 'NoOracleHome'";
    private static final String ECM_METADATA_ID = "select rawtohex(metadata_id) from mgmt_ecm_snapshot_metadata where snapshot_type = ? and target_type = ?";
    private static final String ECM_METRIC_TABLE_NAME = "select name from mgmt_ecm_snapshot_md_tables where metadata_Id = hextoraw(?) and name = ?";
    private static final String ECM_METRIC_COLUMN_NAME = "select type from mgmt_ecm_md_all_tbl_columns where metadata_Id = hextoraw(?) and table_name = ? and name = ?";
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$targettype$convergence$ConvergedTargetTypeInfo;

    public ConvergedTargetTypeInfo(String string) {
        this.mTargetType = string;
    }

    public List getHarvesterSnapshotMDs(Connection connection) throws HarvesterException {
        ArrayList<HarvesterSnapshotMD> arrayList = new ArrayList<HarvesterSnapshotMD>();
        CollectionList collectionList = this.getCollectionList();
        TargetMetadata targetMetadata = TargetMetadataUtil.getTargetMetadata(this.mTargetType);
        if (collectionList != null) {
            for (int i = 0; i < collectionList.size(); ++i) {
                Collection collection = (Collection)collectionList.get(i);
                String string = collection.getCollectionName();
                if (!collection.isApplicableForGC()) {
                    if (!sLog.isDebugEnabled()) continue;
                    sLog.debug((Object)("For target Type " + this.mTargetType + " Collection item " + string + " is being skipped as in it not applicable for GC"));
                    continue;
                }
                String string2 = this.getECMMetadataID(string, connection);
                if (string2 == null) {
                    if (!sLog.isDebugEnabled()) continue;
                    sLog.debug((Object)("For target Type " + this.mTargetType + " Collection item " + string + " is being skipped"));
                    continue;
                }
                HarvesterSnapshotMD harvesterSnapshotMD = new HarvesterSnapshotMD(this.mTargetType, string, this.mTargetType, string);
                Vector vector = collection.getMetrics();
                for (int j = 0; j < vector.size(); ++j) {
                    Metric metric;
                    String string3 = (String)vector.get(j);
                    if (sLog.isDebugEnabled()) {
                        sLog.debug((Object)("Processing Metric: target Type " + this.mTargetType + ", collection item " + string + " and metric " + string3));
                    }
                    if ((metric = targetMetadata.getMetric(string3)) == null) {
                        if (!sLog.isDebugEnabled()) continue;
                        sLog.debug((Object)("For target Type " + this.mTargetType + " and collection item " + string + " metric " + string3 + " is being skipped as metric obj is null"));
                        continue;
                    }
                    if (!metric.isApplicableForGC()) {
                        if (!sLog.isDebugEnabled()) continue;
                        sLog.debug((Object)("For target Type " + this.mTargetType + " Collection item " + string + " metric " + string3 + " is being skipped as it not applicable for GC"));
                        continue;
                    }
                    String string4 = this.getTableName(metric, string2, connection);
                    if (string4 == null) {
                        if (!sLog.isDebugEnabled()) continue;
                        sLog.debug((Object)("For target Type " + this.mTargetType + " and collection item " + string + " metric " + string3 + " is being skipped as tableName is null"));
                        continue;
                    }
                    String[] stringArray = this.getColumns(metric, string2, connection);
                    if (stringArray == null || stringArray.length == 0) {
                        if (!sLog.isDebugEnabled()) continue;
                        sLog.debug((Object)("For target Type " + this.mTargetType + " and collection item " + string + " metric " + string3 + " is being skipped as no column could be found"));
                        continue;
                    }
                    HarvesterEMMetricMD harvesterEMMetricMD = this.getHarvesterEMMetricMD(string3, string4, stringArray);
                    harvesterSnapshotMD.addEMMetricMD(harvesterEMMetricMD);
                }
                arrayList.add(harvesterSnapshotMD);
            }
        }
        return arrayList;
    }

    public final String getTargetType() {
        return this.mTargetType;
    }

    public String getTargetName(String string, String string2, Connection connection) throws HarvesterException {
        String string3 = string2;
        if (string2 == null) {
            string3 = string;
        }
        return string3;
    }

    public Map getTargetProperties(String string, String string2, String string3, String string4, String string5, String string6, Connection connection) throws HarvesterException {
        return HarvesterTargetProperies.getTargetProperties(string, this.mTargetType, string2, string3, string4, string5, string6, connection);
    }

    public String getUniqueId(String string, Connection connection) throws HarvesterException {
        return null;
    }

    public boolean hasFakeHost(Connection connection) throws HarvesterException {
        return false;
    }

    public String getHostName(String string, String string2, Connection connection) throws HarvesterException {
        return null;
    }

    public boolean hasFakeOracleHome(Connection connection) throws HarvesterException {
        if (this.mNoOHProp == null) {
            this.mNoOHProp = this.noOracleHomePropValue(connection);
        }
        return this.mNoOHProp.equalsIgnoreCase("true");
    }

    public String getOracleHome(String string, String string2, Connection connection) throws HarvesterException {
        if (this.hasFakeOracleHome(connection)) {
            return DEFAULT_FAKE_OH;
        }
        return null;
    }

    public boolean isProxyForced() {
        return false;
    }

    private CollectionList getCollectionList() {
        CollectionList collectionList = null;
        try {
            collectionList = new CollectionList(this.mTargetType);
        }
        catch (Exception exception) {
            HarvesterUtil.logErrorMessage(sLog, exception, "Error in getting the Collection Items for target type " + this.mTargetType);
        }
        return collectionList;
    }

    private String getTableName(Metric metric, String string, Connection connection) throws HarvesterException {
        String string2 = null;
        TableDescriptor tableDescriptor = metric.getTblDesc();
        if (tableDescriptor != null && (string2 = tableDescriptor.getTableName()) != null && !this.checkECMTable(string2 = string2.toUpperCase(), string, connection)) {
            string2 = null;
        }
        return string2;
    }

    private String[] getColumns(Metric metric, String string, Connection connection) throws HarvesterException {
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        TableDescriptor tableDescriptor = metric.getTblDesc();
        boolean bl = false;
        if (tableDescriptor != null) {
            String string2 = tableDescriptor.getTableName();
            Vector vector = tableDescriptor.getColDescs();
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.get(i);
                    String string3 = columnDescriptor.getColumnName();
                    String string4 = this.checkECMColumn(string3, string2, string, connection);
                    if (string4 == null || string4.trim().equals("")) {
                        if (sLog.isDebugEnabled()) {
                            sLog.debug((Object)("Columns " + string3 + " for table " + string2 + " is not present in GC, so replacing column name with null"));
                        }
                        string3 = null;
                    } else {
                        bl = true;
                        if (string4.equals("D")) {
                            String string5 = "(TO_CHAR(t1." + string3 + ", '" + "YYYY-MM-DD HH24:MI:SS" + "'))";
                            if (sLog.isDebugEnabled()) {
                                sLog.debug((Object)("Column " + string3 + " is a date column. New column name is " + string5));
                            }
                            string3 = string5;
                        }
                    }
                    arrayList.add(string3);
                }
            }
        }
        if (!arrayList.isEmpty() && bl) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    private HarvesterEMMetricMD getHarvesterEMMetricMD(String string, String string2, String[] stringArray) {
        HarvesterOCMMetricMD[] harvesterOCMMetricMDArray = new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(string, new String[]{null, string2}, stringArray)};
        HarvesterEMMetricMD harvesterEMMetricMD = new HarvesterEMMetricMD(string2, 1, 0.0f, harvesterOCMMetricMDArray);
        return harvesterEMMetricMD;
    }

    private String noOracleHomePropValue(Connection connection) throws HarvesterException {
        String[] stringArray = new String[]{this.mTargetType};
        String string = this.queryStringValue(NO_ORACLE_HOME_PROP, connection, stringArray);
        if (string == null) {
            string = "false";
        }
        return string;
    }

    private String getECMMetadataID(String string, Connection connection) throws HarvesterException {
        String[] stringArray = new String[]{string, this.mTargetType};
        return this.queryStringValue(ECM_METADATA_ID, connection, stringArray);
    }

    private boolean checkECMTable(String string, String string2, Connection connection) throws HarvesterException {
        String[] stringArray = new String[]{string2, string.toUpperCase()};
        String string3 = this.queryStringValue(ECM_METRIC_TABLE_NAME, connection, stringArray);
        return string3 != null;
    }

    private String checkECMColumn(String string, String string2, String string3, Connection connection) throws HarvesterException {
        String[] stringArray = new String[]{string3, string2.toUpperCase(), string.toUpperCase()};
        String string4 = this.queryStringValue(ECM_METRIC_COLUMN_NAME, connection, stringArray);
        return string4;
    }

    private String queryStringValue(String string, Connection connection, String[] stringArray) throws HarvesterException {
        String string2 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            for (int i = 1; i <= stringArray.length; ++i) {
                preparedStatement.setString(i, stringArray[i - 1]);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string3 = "Error while getting string value for query: " + string;
                HarvesterUtil.logErrorMessage(sLog, sQLException, string3);
                throw new HarvesterException(string3, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close((Statement)preparedStatement);
                JDBCUtil.close(resultSet);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)preparedStatement);
        JDBCUtil.close((ResultSet)resultSet);
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

