/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.targettype.convergence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.jdbc.OracleConnection;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterMetadata;
import oracle.sysman.ccr.gcharvester.targettype.HarvesterTargetTypeDAO;
import oracle.sysman.ccr.gcharvester.targettype.HarvesterTargetTypeDO;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class ConvergenceUtil {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$targettype$convergence$ConvergenceUtil == null ? (class$oracle$sysman$ccr$gcharvester$targettype$convergence$ConvergenceUtil = ConvergenceUtil.class$("oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergenceUtil")) : class$oracle$sysman$ccr$gcharvester$targettype$convergence$ConvergenceUtil).getName());
    private static final String DELETE_FROM_METRICS = "delete from mgmt_ocm_upl_metrics where target_type = ?";
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$targettype$convergence$ConvergenceUtil;

    public static List getListOfCovergedTargetTypes(Connection connection) throws HarvesterException {
        return HarvesterTargetTypeDAO.getConvergedTargetTypes(connection);
    }

    public static void processPendingConvergedTargetTypes(Connection connection) throws HarvesterException {
        OracleConnection oracleConnection = (OracleConnection)connection;
        HarvesterMetadata harvesterMetadata = HarvesterMetadata.getInstance(oracleConnection);
        try {
            List list = HarvesterTargetTypeDAO.getPendingConvergedTargetType(connection);
            if (list == null || list.isEmpty()) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)("Converged target type" + string + " found."));
                }
                harvesterMetadata.replaceOrAddConvergedTargetType(string, oracleConnection);
                ConvergenceUtil.deleteOldDataForTargetType(string, (Connection)oracleConnection);
            }
            harvesterMetadata.populateRepository(oracleConnection);
            harvesterMetadata.populateNewTargetsInRepository(oracleConnection);
            connection.commit();
        }
        catch (HarvesterException harvesterException) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            throw harvesterException;
        }
        catch (Exception exception) {
            JDBCUtil.forceTransactionRollback((Connection)connection);
            String string = "Error in processing the pending converged targets: " + exception;
            HarvesterUtil.logErrorMessage(sLog, exception, string);
            throw new HarvesterException(string, exception);
        }
    }

    public static boolean isConverged(String string, Connection connection) throws HarvesterException {
        return ConvergenceUtil.isConverged(string, string, connection);
    }

    public static boolean isConverged(String string, String string2, Connection connection) throws HarvesterException {
        OracleConnection oracleConnection;
        HarvesterMetadata harvesterMetadata;
        HarvesterTargetTypeDO harvesterTargetTypeDO;
        return string.equals(string2) && (harvesterTargetTypeDO = (harvesterMetadata = HarvesterMetadata.getInstance(oracleConnection = (OracleConnection)connection)).getHarvesterTargetType(string)) != null && harvesterTargetTypeDO.isConverged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteOldDataForTargetType(String string, Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(DELETE_FROM_METRICS);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        finally {
            JDBCUtil.close((Statement)preparedStatement);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

