/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.ti.common;

import java.util.HashMap;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.targettype.TargetMetadataUtil;
import oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergedTargetTypeInfo;
import oracle.sysman.ccr.gcharvester.ti.database.HarvesterForClusterTarget;
import oracle.sysman.ccr.gcharvester.ti.database.HarvesterForDatabaseTarget;
import oracle.sysman.ccr.gcharvester.ti.database.HarvesterForPdbTarget;
import oracle.sysman.ccr.gcharvester.ti.database.HarvesterForRacTarget;
import oracle.sysman.ccr.gcharvester.ti.exalogic.ELSystemConvergedTargetInfo;
import oracle.sysman.ccr.gcharvester.ti.exalogic.ExaRackConvergedTargetInfo;
import oracle.sysman.ccr.gcharvester.ti.fusionapps.HarvesterForFusionClusterApp;
import oracle.sysman.ccr.gcharvester.ti.fusionapps.HarvesterForFusionInstance;
import oracle.sysman.ccr.gcharvester.ti.fusionapps.HarvesterForFusionJ2eeApp;
import oracle.sysman.ccr.gcharvester.ti.fusionapps.HarvesterForFusionPf;
import oracle.sysman.ccr.gcharvester.ti.fusionapps.HarvesterForFusionProduct;
import oracle.sysman.ccr.gcharvester.ti.host.HarvesterForHost;
import oracle.sysman.ccr.gcharvester.ti.oh.HarvesterForOracleHome;
import oracle.sysman.ccr.gcharvester.ti.otd.OTDHarvester;
import oracle.sysman.ccr.gcharvester.ti.self_monitor.HarvesterForEmrepTarget;
import oracle.sysman.ccr.gcharvester.ti.self_monitor.HarvesterForOmsTarget;
import oracle.sysman.ccr.gcharvester.ti.soa.SOAHarvester;
import oracle.sysman.ccr.gcharvester.ti.soa.bpel.BPELHarvester;
import oracle.sysman.ccr.gcharvester.ti.test.HarvesterTestConvergedTargetType;
import oracle.sysman.ccr.gcharvester.ti.vt.HarvesterForGuestTarget;
import oracle.sysman.ccr.gcharvester.ti.vt.HarvesterForServerPoolTarget;
import oracle.sysman.ccr.gcharvester.ti.vt.HarvesterForServerTarget;
import oracle.sysman.ccr.gcharvester.ti.vt.HarvesterForZoneTarget;
import oracle.sysman.ccr.gcharvester.ti.weblogic.FarmConvergedTargetInfo;
import oracle.sysman.ccr.gcharvester.ti.weblogic.J2eeAppConvergedTargetInfo;
import oracle.sysman.ccr.gcharvester.ti.weblogic.WLClusterConvergedTargetInfo;
import oracle.sysman.ccr.gcharvester.ti.weblogic.WLDomainConvergedTargetInfo;
import oracle.sysman.ccr.gcharvester.ti.weblogic.WLServerConvergedTargetInfo;
import oracle.sysman.ccr.gcharvester.util.GCHarvesterEnv;
import org.apache.log4j.Category;

public class ConvergedTargetTypeManager {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$ti$common$ConvergedTargetTypeManager == null ? (class$oracle$sysman$ccr$gcharvester$ti$common$ConvergedTargetTypeManager = ConvergedTargetTypeManager.class$("oracle.sysman.ccr.gcharvester.ti.common.ConvergedTargetTypeManager")) : class$oracle$sysman$ccr$gcharvester$ti$common$ConvergedTargetTypeManager).getName());
    private static HashMap sTargetTypeInfoMap = null;
    private static final String SOA_TARGET_TYPE = "oracle_soainfra";
    private static final String BPEL_TARGET_TYPE = "oracle_integrationbpm";
    private static final String OTD_CL_TARGET_TYPE = "oracle_otd_cluster";
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$ti$common$ConvergedTargetTypeManager;

    private static ConvergedTargetTypeInfo basedOnStartWith(String string) {
        if (string.startsWith("fusion_apps_pf")) {
            return new HarvesterForFusionPf(string);
        }
        if (string.startsWith("fusion_apps_product")) {
            return new HarvesterForFusionProduct(string);
        }
        return null;
    }

    public static ConvergedTargetTypeInfo getConvergedTargetTypeInfo(String string) throws HarvesterException {
        TargetMetadata targetMetadata = TargetMetadataUtil.getTargetMetadata(string);
        if (targetMetadata == null) {
            String string2 = "Unable to get metadata for target type " + string;
            sLog.error((Object)string2);
            throw new HarvesterException(string2);
        }
        if (!targetMetadata.isMetadataConverged()) {
            String string3 = "Trying to ConvergedTargetTypeInfo object for unconverged target type " + string;
            sLog.error((Object)string3);
            throw new HarvesterException(string3);
        }
        ConvergedTargetTypeInfo convergedTargetTypeInfo = (ConvergedTargetTypeInfo)sTargetTypeInfoMap.get(string);
        if (convergedTargetTypeInfo == null) {
            convergedTargetTypeInfo = ConvergedTargetTypeManager.basedOnStartWith(string);
            if (convergedTargetTypeInfo == null) {
                convergedTargetTypeInfo = new ConvergedTargetTypeInfo(string);
            }
            sTargetTypeInfoMap.put(string, convergedTargetTypeInfo);
        }
        return convergedTargetTypeInfo;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sTargetTypeInfoMap = new HashMap();
        if (GCHarvesterEnv.isTestEnv() && GCHarvesterEnv.overrideTestConverged()) {
            sTargetTypeInfoMap.put("test_target_1", new HarvesterTestConvergedTargetType("test_target_1"));
        }
        sTargetTypeInfoMap.put("oracle_database", new HarvesterForDatabaseTarget("oracle_database"));
        sTargetTypeInfoMap.put("rac_database", new HarvesterForRacTarget("rac_database"));
        sTargetTypeInfoMap.put("cluster", new HarvesterForClusterTarget("cluster"));
        sTargetTypeInfoMap.put("oracle_pdb", new HarvesterForPdbTarget("oracle_pdb"));
        sTargetTypeInfoMap.put("host", new HarvesterForHost("host"));
        sTargetTypeInfoMap.put("oracle_home", new HarvesterForOracleHome("oracle_home"));
        sTargetTypeInfoMap.put(SOA_TARGET_TYPE, new SOAHarvester(SOA_TARGET_TYPE));
        sTargetTypeInfoMap.put(OTD_CL_TARGET_TYPE, new OTDHarvester(OTD_CL_TARGET_TYPE));
        sTargetTypeInfoMap.put(BPEL_TARGET_TYPE, new BPELHarvester(BPEL_TARGET_TYPE));
        sTargetTypeInfoMap.put("oracle_emrep", new HarvesterForEmrepTarget("oracle_emrep"));
        sTargetTypeInfoMap.put("oracle_oms", new HarvesterForOmsTarget("oracle_oms"));
        sTargetTypeInfoMap.put("oracle_vm_server", new HarvesterForServerTarget("oracle_vm_server"));
        sTargetTypeInfoMap.put("oracle_vm_server_pool", new HarvesterForServerPoolTarget("oracle_vm_server_pool"));
        sTargetTypeInfoMap.put("oracle_vm_zone", new HarvesterForZoneTarget("oracle_vm_zone"));
        sTargetTypeInfoMap.put("oracle_vm_guest", new HarvesterForGuestTarget("oracle_vm_guest"));
        sTargetTypeInfoMap.put("fusion_apps_instance", new HarvesterForFusionInstance("fusion_apps_instance"));
        sTargetTypeInfoMap.put("fusion_apps_cluster_app", new HarvesterForFusionClusterApp("fusion_apps_cluster_app"));
        sTargetTypeInfoMap.put("fusion_apps_j2ee_app", new HarvesterForFusionJ2eeApp("fusion_apps_j2ee_app"));
        sTargetTypeInfoMap.put("weblogic_j2eeserver", new WLServerConvergedTargetInfo("weblogic_j2eeserver"));
        sTargetTypeInfoMap.put("weblogic_domain", new WLDomainConvergedTargetInfo("weblogic_domain"));
        sTargetTypeInfoMap.put("weblogic_cluster", new WLClusterConvergedTargetInfo("weblogic_cluster"));
        sTargetTypeInfoMap.put("oracle_ias_farm", new FarmConvergedTargetInfo("oracle_ias_farm"));
        sTargetTypeInfoMap.put("j2ee_application", new J2eeAppConvergedTargetInfo("j2ee_application"));
        sTargetTypeInfoMap.put("exa_rack", new ExaRackConvergedTargetInfo());
        sTargetTypeInfoMap.put("exalogic_system", new ELSystemConvergedTargetInfo());
    }
}

