/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.ti.database;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.targettype.MetricResultCallback;
import oracle.sysman.ccr.gcharvester.util.GCHarvesterEnv;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.ccr.gcharvester.util.IRemoteDBConAdapter;
import oracle.sysman.util.jdbc.EMConnection;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class DatabaseMetricCallback
implements MetricResultCallback {
    private static final Category s_log = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$ti$database$DatabaseMetricCallback == null ? (class$oracle$sysman$ccr$gcharvester$ti$database$DatabaseMetricCallback = DatabaseMetricCallback.class$("oracle.sysman.ccr.gcharvester.ti.database.DatabaseMetricCallback")) : class$oracle$sysman$ccr$gcharvester$ti$database$DatabaseMetricCallback).getName());
    private static final String UPL_PROP_SCN_COL_STOPFLAG = "scn_stop_flag";
    private static final String UPL_PROP_SCN_MAX_COLTIME = "scn_max_col_time";
    private static final String UPL_PROP_SCN_HEADROOM_THRESHOLD = "scn_headroom_threshold";
    private static double totalSCNColMin = 0.0;
    private static double maxSCNColMin = 30.0;
    private static double maxSCNHeadroomThresh = 62.0;
    private static boolean stopSCNCol = false;
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$ti$database$DatabaseMetricCallback;

    public MetricResult callback(Metric metric, MetricResult metricResult, String string, String string2, String string3, String string4, String string5, String string6, Connection connection) throws HarvesterException {
        String string7 = metric.getMetricId();
        if ("oracle_db_adrinfo".equals(string3) && "scn_info".equals(string7)) {
            metricResult.getValueRows().clear();
            if (DatabaseMetricCallback.isSCNCollectionAllowd()) {
                long l = System.currentTimeMillis();
                this.createMericResultForSCN(connection, string4, string5, metricResult, metric);
                long l2 = System.currentTimeMillis();
                double d = (double)(l2 - l) / 60000.0;
                totalSCNColMin += d;
            }
        }
        return metricResult;
    }

    private MetricResult createMericResultForSCN(Connection connection, String string, String string2, MetricResult metricResult, Metric metric) throws HarvesterException {
        try {
            EMConnection eMConnection;
            IRemoteDBConAdapter iRemoteDBConAdapter = HarvesterUtil.getRemoteDBConAdapter();
            EMConnection eMConnection2 = (EMConnection)connection;
            EMConnection eMConnection3 = eMConnection = iRemoteDBConAdapter.getConection(eMConnection2, string, string2);
            this.getSCNDataFromRemoteDB(metricResult, (Connection)eMConnection3);
        }
        catch (Exception exception) {
            s_log.warn((Object)("Error in getting  Remote SCN Data for  GC targetType " + string2 + " and GC TargetName: " + string + " : "), (Throwable)exception);
        }
        return metricResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricResult getSCNDataFromRemoteDB(MetricResult metricResult, Connection connection) throws SQLException {
        Vector vector = metricResult.getValueRows();
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            s_log.debug((Object)"DECLARE  \n  l_max_rate      NUMBER := 16*1024;\n  l_seconds_1988  NUMBER := 0;\n  l_maximum_scn   NUMBER;\n  l_base_year     NUMBER := 1988;\n  l_db_version    VARCHAR2(10);\n  l_patch         NUMBER;\n\n  l_current_scn   NUMBER;\n  l_headroom      NUMBER;\n  l_growth_24hrs  NUMBER;\n  l_scn_calls     NUMBER;\n  l_dblink_out    NUMBER;\n  l_dblink_in     NUMBER;\n  l_max_jump      NUMBER ;\n  l_max_jump_time VARCHAR2(32);\n  l_created       VARCHAR2(32);\n  l_reject_thresh NUMBER;\n\n  c_time_16       NUMBER;\n  c_time_32       NUMBER;\n\n  l_end_done      BOOLEAN := FALSE;\n  l_sql_text      VARCHAR2(2000);\n  l_sql_piece VARCHAR2(200);\n  l_is_gmt VARCHAR2(10);\n\n  L_HROOM_THRESHOLD NUMBER := ?;\n  TYPE RESULT_CRSR IS REF CURSOR;\n  CRSR_TEST_RESULT   RESULT_CRSR;  \nBEGIN\n  select 16*1024*24*60*60, 32*1024*24*60*60 into c_time_16, c_time_32 from dual;\n\n  SELECT LPAD(version, 10, '0') into l_db_version from v$instance;\n  IF (l_db_version = '11.2.0.2.0' OR l_db_version = '11.2.0.3.0') THEN\n    l_sql_text :=\n      'SELECT count(*) from dba_registry_history ' ||\n      'where comments=''CPUJan2012'' OR comments=''CPUApr2012''';\n    -- presence of this parameter indicates CPU patch is installed.\n    EXECUTE IMMEDIATE l_sql_text INTO l_patch;\n    -- if no rows, then patch is not installed on 11.2.0.2 and 11.2.0.3\n    IF (l_patch = 0) THEN\n      l_max_rate := 32*1024;\n      l_base_year := 2009;\n      select 4*1024*1024*1024*2575 into l_seconds_1988 from dual;\n    END IF;\n  END IF;\n  -- current_scn, intrinsic change (not rate!)\n  IF (l_db_version > '10.0.0.0.0') THEN\n    l_sql_text :=\n    'SELECT d.current_scn, svalue ' ||\n    'FROM v$database d, ' ||\n    '(SELECT sum(s.value) svalue from v$sysstat s WHERE s.name in (''calls to kcmgas'', ''redo writes''))';\n    EXECUTE IMMEDIATE l_sql_text INTO l_current_scn, l_scn_calls;\n  ELSE\n    l_sql_text :=\n    'select dbms_flashback.get_system_change_number from dual';\n    EXECUTE IMMEDIATE l_sql_text INTO l_current_scn;\n    l_sql_text :=\n    'SELECT sum(s.value) svalue from v$sysstat s WHERE s.name in (''calls to kcmgas'', ''redo writes'')';\n    EXECUTE IMMEDIATE l_sql_text INTO l_scn_calls;\n  END IF;\n\n  -- this formula comes from kcmbts\n  SELECT\n    (((((( (to_number(to_char(sysdate,'YYYY'))-l_base_year)* 12  \n          +(to_number(to_char(sysdate,'MM'))-1))           * 31  \n         + (to_number(to_char(sysdate,'DD'))-1))           * 24  \n        +  (to_number(to_char(sysdate,'HH24'))))           * 60  \n       +   (to_number(to_char(sysdate,'MI'  ))))           * 60  \n      +    (to_number(to_char(sysdate,'SS'  ))))\n     * l_max_rate) + l_seconds_1988\n    INTO l_maximum_scn FROM dual;\n\n  -- scn_headroom\n  IF (l_max_rate = 32768) THEN\n    IF (l_current_scn > l_seconds_1988) THEN\n      SELECT to_char(((l_maximum_scn - l_current_scn) / c_time_32),'99999D99')\n        INTO l_headroom FROM dual;        \n    ELSE\n      SELECT to_char((((l_maximum_scn - l_seconds_1988) / c_time_32) +\n                     ((l_seconds_1988 - l_current_scn) / c_time_16)),'99999D99')\n          INTO l_headroom FROM dual; \n    END IF;\n  ELSE\n    SELECT to_char(((l_maximum_scn - l_current_scn) / c_time_16),'99999D99')\n      INTO l_headroom FROM dual;\n  END IF;\n\n   IF(l_headroom > L_HROOM_THRESHOLD ) THEN  GOTO OPENCURSOR; END IF;\n\n  -- outgoing DB links\n  SELECT count(*) INTO l_dblink_out FROM DBA_DB_LINKS;\n\n  -- incoming DB links\n  SELECT count(*) INTO l_dblink_in FROM dba_audit_trail \n    WHERE action_name='LOGON' AND comment_text LIKE '%DBLINK_INFO%' AND timestamp > (sysdate-1) ORDER BY timestamp;\n\n  -- max jump size, average (total) growth rate, max jump timestamp\n  IF (l_db_version > '10.0.0.0.0') THEN\n    begin\n      EXECUTE IMMEDIATE 'select PROPERTY_VALUE from DATABASE_PROPERTIES where PROPERTY_NAME=''Flashback Timestamp TimeZone''' INTO l_is_gmt;\n    EXCEPTION\n\tWHEN OTHERS THEN\n\tl_is_gmt := '';\n    end;\n    IF (l_is_gmt = 'GMT') THEN\n      l_sql_piece := 'WHERE time_dp > sys_extract_utc(systimestamp)-1';\n    ELSE\n      l_sql_piece := 'WHERE time_dp > sysdate-1';\n    END IF;\n    l_sql_text := \n    'SELECT scn_per_sec, round(avg_scn_per_sec), to_char(time_stamp, ''YYYY-MM-DD HH24:MI:SS'') ' ||\n    'FROM ' ||\n      '( SELECT time_stamp, scn_per_sec, avg(scn_per_sec) over() avg_scn_per_sec, max(scn_per_sec) over() max_scn_per_sec ' ||\n        'FROM ' ||\n          '( SELECT time_dp time_stamp, scn, ' ||\n                 'round ((scn - lag(scn,1) over(ORDER BY time_dp))/ ' ||\n                        '(60*60*24 * (time_dp - lag(time_dp,1) over(ORDER BY time_dp))), ' ||\n                        '0) scn_per_sec ' ||\n            'FROM sys.smon_scn_time ' ||\n            l_sql_piece ||\n          ') ' ||\n        'WHERE scn_per_sec IS NOT NULL order by time_stamp desc ' ||\n      ') ' || -- remove first entry which will have null because of lag()\n    'WHERE scn_per_sec = max_scn_per_sec and rownum = 1';\n    EXECUTE IMMEDIATE l_sql_text INTO l_max_jump, l_growth_24hrs, l_max_jump_time;\n  END IF;\n  -- db creation time\n  SELECT to_char(created,'YYYY-MM-DD HH24:MI:SS') INTO l_created FROM v$database;\n\n  -- reject threshold (may not exist, catch that)\n  BEGIN\n    SELECT value INTO l_reject_thresh FROM v$parameter WHERE name='_external_scn_rejection_threshold_hours';\n    EXCEPTION\n      WHEN NO_DATA_FOUND THEN\n        l_reject_thresh := -1;\n  END;\n\n    <<OPENCURSOR>>\n    OPEN CRSR_TEST_RESULT FOR\n        SELECT  \n\t\t\tl_current_scn, \n\t\t\tl_headroom ,   \n\t\t\tl_growth_24hrs,\n\t\t\tl_scn_calls,\n\t\t\tl_dblink_out,\n\t\t\tl_dblink_in,\n\t\t\tl_max_jump,\n\t\t\tl_max_jump_time,\n\t\t\tl_created,\n\t\t\tl_reject_thresh\n        FROM DUAL where l_headroom < l_hroom_threshold;\n\n     ? := crsr_test_result;\n\nEND ;  \n");
            callableStatement = connection.prepareCall("DECLARE  \n  l_max_rate      NUMBER := 16*1024;\n  l_seconds_1988  NUMBER := 0;\n  l_maximum_scn   NUMBER;\n  l_base_year     NUMBER := 1988;\n  l_db_version    VARCHAR2(10);\n  l_patch         NUMBER;\n\n  l_current_scn   NUMBER;\n  l_headroom      NUMBER;\n  l_growth_24hrs  NUMBER;\n  l_scn_calls     NUMBER;\n  l_dblink_out    NUMBER;\n  l_dblink_in     NUMBER;\n  l_max_jump      NUMBER ;\n  l_max_jump_time VARCHAR2(32);\n  l_created       VARCHAR2(32);\n  l_reject_thresh NUMBER;\n\n  c_time_16       NUMBER;\n  c_time_32       NUMBER;\n\n  l_end_done      BOOLEAN := FALSE;\n  l_sql_text      VARCHAR2(2000);\n  l_sql_piece VARCHAR2(200);\n  l_is_gmt VARCHAR2(10);\n\n  L_HROOM_THRESHOLD NUMBER := ?;\n  TYPE RESULT_CRSR IS REF CURSOR;\n  CRSR_TEST_RESULT   RESULT_CRSR;  \nBEGIN\n  select 16*1024*24*60*60, 32*1024*24*60*60 into c_time_16, c_time_32 from dual;\n\n  SELECT LPAD(version, 10, '0') into l_db_version from v$instance;\n  IF (l_db_version = '11.2.0.2.0' OR l_db_version = '11.2.0.3.0') THEN\n    l_sql_text :=\n      'SELECT count(*) from dba_registry_history ' ||\n      'where comments=''CPUJan2012'' OR comments=''CPUApr2012''';\n    -- presence of this parameter indicates CPU patch is installed.\n    EXECUTE IMMEDIATE l_sql_text INTO l_patch;\n    -- if no rows, then patch is not installed on 11.2.0.2 and 11.2.0.3\n    IF (l_patch = 0) THEN\n      l_max_rate := 32*1024;\n      l_base_year := 2009;\n      select 4*1024*1024*1024*2575 into l_seconds_1988 from dual;\n    END IF;\n  END IF;\n  -- current_scn, intrinsic change (not rate!)\n  IF (l_db_version > '10.0.0.0.0') THEN\n    l_sql_text :=\n    'SELECT d.current_scn, svalue ' ||\n    'FROM v$database d, ' ||\n    '(SELECT sum(s.value) svalue from v$sysstat s WHERE s.name in (''calls to kcmgas'', ''redo writes''))';\n    EXECUTE IMMEDIATE l_sql_text INTO l_current_scn, l_scn_calls;\n  ELSE\n    l_sql_text :=\n    'select dbms_flashback.get_system_change_number from dual';\n    EXECUTE IMMEDIATE l_sql_text INTO l_current_scn;\n    l_sql_text :=\n    'SELECT sum(s.value) svalue from v$sysstat s WHERE s.name in (''calls to kcmgas'', ''redo writes'')';\n    EXECUTE IMMEDIATE l_sql_text INTO l_scn_calls;\n  END IF;\n\n  -- this formula comes from kcmbts\n  SELECT\n    (((((( (to_number(to_char(sysdate,'YYYY'))-l_base_year)* 12  \n          +(to_number(to_char(sysdate,'MM'))-1))           * 31  \n         + (to_number(to_char(sysdate,'DD'))-1))           * 24  \n        +  (to_number(to_char(sysdate,'HH24'))))           * 60  \n       +   (to_number(to_char(sysdate,'MI'  ))))           * 60  \n      +    (to_number(to_char(sysdate,'SS'  ))))\n     * l_max_rate) + l_seconds_1988\n    INTO l_maximum_scn FROM dual;\n\n  -- scn_headroom\n  IF (l_max_rate = 32768) THEN\n    IF (l_current_scn > l_seconds_1988) THEN\n      SELECT to_char(((l_maximum_scn - l_current_scn) / c_time_32),'99999D99')\n        INTO l_headroom FROM dual;        \n    ELSE\n      SELECT to_char((((l_maximum_scn - l_seconds_1988) / c_time_32) +\n                     ((l_seconds_1988 - l_current_scn) / c_time_16)),'99999D99')\n          INTO l_headroom FROM dual; \n    END IF;\n  ELSE\n    SELECT to_char(((l_maximum_scn - l_current_scn) / c_time_16),'99999D99')\n      INTO l_headroom FROM dual;\n  END IF;\n\n   IF(l_headroom > L_HROOM_THRESHOLD ) THEN  GOTO OPENCURSOR; END IF;\n\n  -- outgoing DB links\n  SELECT count(*) INTO l_dblink_out FROM DBA_DB_LINKS;\n\n  -- incoming DB links\n  SELECT count(*) INTO l_dblink_in FROM dba_audit_trail \n    WHERE action_name='LOGON' AND comment_text LIKE '%DBLINK_INFO%' AND timestamp > (sysdate-1) ORDER BY timestamp;\n\n  -- max jump size, average (total) growth rate, max jump timestamp\n  IF (l_db_version > '10.0.0.0.0') THEN\n    begin\n      EXECUTE IMMEDIATE 'select PROPERTY_VALUE from DATABASE_PROPERTIES where PROPERTY_NAME=''Flashback Timestamp TimeZone''' INTO l_is_gmt;\n    EXCEPTION\n\tWHEN OTHERS THEN\n\tl_is_gmt := '';\n    end;\n    IF (l_is_gmt = 'GMT') THEN\n      l_sql_piece := 'WHERE time_dp > sys_extract_utc(systimestamp)-1';\n    ELSE\n      l_sql_piece := 'WHERE time_dp > sysdate-1';\n    END IF;\n    l_sql_text := \n    'SELECT scn_per_sec, round(avg_scn_per_sec), to_char(time_stamp, ''YYYY-MM-DD HH24:MI:SS'') ' ||\n    'FROM ' ||\n      '( SELECT time_stamp, scn_per_sec, avg(scn_per_sec) over() avg_scn_per_sec, max(scn_per_sec) over() max_scn_per_sec ' ||\n        'FROM ' ||\n          '( SELECT time_dp time_stamp, scn, ' ||\n                 'round ((scn - lag(scn,1) over(ORDER BY time_dp))/ ' ||\n                        '(60*60*24 * (time_dp - lag(time_dp,1) over(ORDER BY time_dp))), ' ||\n                        '0) scn_per_sec ' ||\n            'FROM sys.smon_scn_time ' ||\n            l_sql_piece ||\n          ') ' ||\n        'WHERE scn_per_sec IS NOT NULL order by time_stamp desc ' ||\n      ') ' || -- remove first entry which will have null because of lag()\n    'WHERE scn_per_sec = max_scn_per_sec and rownum = 1';\n    EXECUTE IMMEDIATE l_sql_text INTO l_max_jump, l_growth_24hrs, l_max_jump_time;\n  END IF;\n  -- db creation time\n  SELECT to_char(created,'YYYY-MM-DD HH24:MI:SS') INTO l_created FROM v$database;\n\n  -- reject threshold (may not exist, catch that)\n  BEGIN\n    SELECT value INTO l_reject_thresh FROM v$parameter WHERE name='_external_scn_rejection_threshold_hours';\n    EXCEPTION\n      WHEN NO_DATA_FOUND THEN\n        l_reject_thresh := -1;\n  END;\n\n    <<OPENCURSOR>>\n    OPEN CRSR_TEST_RESULT FOR\n        SELECT  \n\t\t\tl_current_scn, \n\t\t\tl_headroom ,   \n\t\t\tl_growth_24hrs,\n\t\t\tl_scn_calls,\n\t\t\tl_dblink_out,\n\t\t\tl_dblink_in,\n\t\t\tl_max_jump,\n\t\t\tl_max_jump_time,\n\t\t\tl_created,\n\t\t\tl_reject_thresh\n        FROM DUAL where l_headroom < l_hroom_threshold;\n\n     ? := crsr_test_result;\n\nEND ;  \n");
            callableStatement.setDouble(1, maxSCNHeadroomThresh);
            callableStatement.registerOutParameter(2, -10);
            callableStatement.execute();
            resultSet = (ResultSet)callableStatement.getObject(2);
            if (resultSet != null) {
                while (resultSet.next()) {
                    ValueRow valueRow = new ValueRow();
                    valueRow.setValue(0, resultSet.getString(1));
                    valueRow.setValue(1, resultSet.getString(2));
                    valueRow.setValue(2, resultSet.getString(3));
                    valueRow.setValue(3, resultSet.getString(4));
                    valueRow.setValue(4, resultSet.getString(5));
                    valueRow.setValue(5, resultSet.getString(6));
                    valueRow.setValue(6, resultSet.getString(7));
                    valueRow.setValue(7, resultSet.getString(8));
                    valueRow.setValue(8, resultSet.getString(9));
                    valueRow.setValue(9, resultSet.getString(10));
                    vector.add(valueRow);
                }
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.close(callableStatement, resultSet);
            JDBCUtil.close((Connection)connection);
            throw throwable;
        }
        JDBCUtil.close((Statement)callableStatement, (ResultSet)resultSet);
        JDBCUtil.close((Connection)connection);
        return metricResult;
    }

    public static void setGCHarvInitProperties() {
        totalSCNColMin = 0.0;
        String string = GCHarvesterEnv.getProperty(UPL_PROP_SCN_COL_STOPFLAG);
        String string2 = GCHarvesterEnv.getProperty(UPL_PROP_SCN_MAX_COLTIME);
        String string3 = GCHarvesterEnv.getProperty(UPL_PROP_SCN_HEADROOM_THRESHOLD);
        s_log.debug((Object)("strStopSCNCol: " + string));
        s_log.debug((Object)("strMaxColMin: " + string2));
        s_log.debug((Object)("strThreshold: " + string3));
        boolean bl = stopSCNCol = "true".equals(string);
        if (string2 != null) {
            try {
                maxSCNColMin = Double.parseDouble(string2);
            }
            catch (Exception exception) {
                s_log.error((Object)"Error in parsing SCN max upload time configured in MGMT_OCM_UPL_PROPS table.");
            }
        }
        if (string3 != null) {
            try {
                maxSCNHeadroomThresh = Double.parseDouble(string3);
            }
            catch (Exception exception) {
                s_log.error((Object)"Error in parsing SCN headroom threshold configured in MGMT_OCM_UPL_PROPS table.");
            }
        }
    }

    private static boolean isSCNCollectionAllowd() {
        return !stopSCNCol && totalSCNColMin < maxSCNColMin;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

