/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.ti.database;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.sysman.ccr.gcharvester.HarvesterEMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD;
import oracle.sysman.ccr.gcharvester.QueryInfo;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import oracle.sysman.ccr.util.Utils;
import oracle.sysman.eml.ecm.track.TrackUtilities;
import org.apache.log4j.Category;

public class RacDatabaseUtil {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$ti$database$RacDatabaseUtil == null ? (class$oracle$sysman$ccr$gcharvester$ti$database$RacDatabaseUtil = RacDatabaseUtil.class$("oracle.sysman.ccr.gcharvester.ti.database.RacDatabaseUtil")) : class$oracle$sysman$ccr$gcharvester$ti$database$RacDatabaseUtil).getName());
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$ti$database$RacDatabaseUtil;

    public static HarvesterEMMetricMD getAssocMetric() {
        return new HarvesterEMMetricMD("MGMT_ECM_ASSOCIATIONS", 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "ECM_ASSOCIATIONS";
            }

            public String getQuery() {
                if (GCVersion.pre11_2GC()) {
                    return " select 'contains', null, 'oracle_database',              i.database_name ||     '_' || i.instance_name  FROM         mgmt_target_assocs a,       mgmt_target_assoc_defs d,       mgmt_targets t,        mgmt_db_dbninstanceinfo_ecm i,        mgmt_ecm_gen_snapshot s  WHERE t.target_name = :tn    and t.target_type = :tt    and a.source_target_guid = t.target_guid     and d.assoc_def_name = 'contains'     and d.assoc_guid = a.assoc_guid    and s.target_guid = a.assoc_target_guid    and s.target_type = 'oracle_database'     and s.snapshot_type = 'oracle_dbconfig'    and s.is_current = 'Y'    and i.ecm_snapshot_id = s.snapshot_guid  UNION ALL   SELECT 'runs_on', null, 'cluster',         c.target_name || ':' ||          decode(instr(c.host_name,'.'),0,c.host_name,          substr(c.host_name,0,instr(c.host_name,'.')-1) ) || ';'      FROM mgmt_targets t,        mgmt_target_properties tp,       mgmt_targets c      WHERE t.target_name = :tn       and t.target_type = :tt       and tp.target_guid = t.target_guid       and tp.property_name = 'ClusterName'        and c.target_name = tp.property_value        and c.target_type = 'cluster' ";
                }
                return " SELECT  'depends_on', NULL, 'oracle_exadata_dbsys', null  FROM GC_ASSOC_INSTANCES DBSYS2RAC  JOIN MGMT_TARGETS SRC_TARGETS ON DBSYS2RAC.SOURCE_ME_GUID = SRC_TARGETS.TARGET_GUID  JOIN MGMT_TARGETS DEST_TARGETS ON DBSYS2RAC.DEST_ME_GUID = DEST_TARGETS.TARGET_GUID  WHERE 1=1    AND SRC_TARGETS.TARGET_NAME = :tn   AND SRC_TARGETS.TARGET_TYPE = :tt   AND DEST_TARGETS.TARGET_TYPE = 'oracle_exadata_dbsys'   AND DBSYS2RAC.ASSOC_TYPE ='stores_on'  UNION ALL  SELECT 'member_of', NULL,  'oracle_exadata_clustergrp',        'exadata_databasesystem_' || TP1.PROPERTY_VALUE || DECODE(TP2.PROPERTY_VALUE, NULL,'', ('_' || TP2.PROPERTY_VALUE) )  FROM  GC_ASSOC_INSTANCES  RAC2DB  JOIN MGMT_TARGETS SRC_TARGETS  ON RAC2DB.SOURCE_ME_GUID = SRC_TARGETS.TARGET_GUID  JOIN MGMT$TARGET_PROPERTIES TP1 ON TP1.TARGET_GUID = RAC2DB.DEST_ME_GUID   LEFT JOIN MGMT_TARGET_PROP_DEFS TPD ON TPD.TARGET_TYPE = TP1.TARGET_TYPE AND TPD.PROPERTY_DISPLAY_NAME='split_no'  LEFT JOIN MGMT$TARGET_PROPERTIES TP2 ON TP2.TARGET_GUID = RAC2DB.DEST_ME_GUID AND TP2.PROPERTY_NAME= tpd.property_name  WHERE 1=1   AND SRC_TARGETS.TARGET_NAME = :tn    AND SRC_TARGETS.TARGET_TYPE = :tt    AND RAC2DB.ASSOC_TYPE = 'deployed_on'   AND TP1.TARGET_TYPE    ='oracle_dbmachine'   AND TP1.PROPERTY_NAME  ='DBMachineID'   AND ROWNUM < 2  UNION ALL  select 'contains', null, 'oracle_database',              i.database_name ||     '_' || i.instance_name  FROM         mgmt_target_assocs a,       mgmt_target_assoc_defs d,       mgmt_targets t,        mgmt_db_dbninstanceinfo_ecm i,        mgmt_ecm_gen_snapshot s  WHERE t.target_name = :tn    and t.target_type = :tt    and a.source_target_guid = t.target_guid     and d.assoc_def_name = 'contains'     and d.assoc_guid = a.assoc_guid    and s.target_guid = a.assoc_target_guid    and s.target_type = 'oracle_database'     and s.snapshot_type = 'oracle_dbconfig'    and s.is_current = 'Y'    and i.ecm_snapshot_id = s.snapshot_guid  UNION ALL   SELECT 'runs_on', null, 'cluster',         c.target_name || ':' ||          decode(instr(c.host_name,'.'),0,c.host_name,          substr(c.host_name,0,instr(c.host_name,'.')-1) ) || ';'      FROM mgmt_targets t,        mgmt_target_properties tp,       mgmt_targets c      WHERE t.target_name = :tn       and t.target_type = :tt       and tp.target_guid = t.target_guid       and tp.property_name = 'ClusterName'        and c.target_name = tp.property_value        and c.target_type = 'cluster' ";
            }

            public int getParameterLayout() {
                if (GCVersion.pre11_2GC()) {
                    return 6;
                }
                return 7;
            }

            public int getColumnCount() {
                return 4;
            }
        })});
    }

    public static String getDBTargetName(String string, Connection connection) throws HarvesterException {
        boolean bl = false;
        if (GCVersion.pre11_1GC()) {
            bl = true;
        }
        return RacDatabaseUtil.getDBTargetName(string, connection, bl);
    }

    private static String getDBTargetName(String string, Connection connection, boolean bl) throws HarvesterException {
        String string2 = RacDatabaseUtil.getRacTargetForDbTarget(string, connection);
        String string3 = "";
        if (string2 != null) {
            string3 = RacDatabaseUtil.getDbName(string, "InstanceName", connection);
            String string4 = RacDatabaseUtil.getRacTargetName(string2, connection, bl);
            if (string4 != null && !string4.equals("") && string3 != null) {
                string3 = string4 + "_" + string3;
            }
        } else {
            if (bl && !GCVersion.pre11_1GC()) {
                return null;
            }
            string3 = RacDatabaseUtil.getDbName(string, "DBName", connection);
            if (string3 != null) {
                string3 = string3.toUpperCase();
            }
        }
        return string3;
    }

    public static String getRacTargetName(String string, Connection connection) throws HarvesterException {
        boolean bl = false;
        if (GCVersion.pre11_1GC()) {
            bl = true;
        }
        return RacDatabaseUtil.getRacTargetName(string, connection, bl);
    }

    private static String getRacTargetName(String string, Connection connection, boolean bl) throws HarvesterException {
        String string2 = null;
        String[] stringArray = RacDatabaseUtil.getRacDbPropertyValues(string, connection);
        if (null != stringArray) {
            string2 = stringArray[0];
            if (string2 == null) {
                return null;
            }
            String string3 = stringArray[4];
            if (string2 != null && string3 != null && string3.length() > 0 && Utils.compareVersions(string3, "10.0.0.0.0", 0) < 0) {
                string2 = string2.toUpperCase();
            }
            if (null != stringArray[1] && !"".equals(stringArray[1])) {
                string2 = string2 + "." + stringArray[1];
            }
            boolean bl2 = null != stringArray[2] && !"".equals(stringArray[2]) && !"".equals(stringArray[2].trim()) && !"Primary".equals(stringArray[2]);
            String string4 = string2 + "_" + stringArray[3];
            String string5 = string2 + "_def_ll_cluster_name";
            string2 = bl ? (bl2 ? string4 : string5) : (stringArray[3] != null && !stringArray[3].equals("") ? string4 : string5);
        }
        return string2;
    }

    public static Map databaseTargetProperties(String string, Connection connection) throws HarvesterException {
        if (GCVersion.pre11_1GC()) {
            return null;
        }
        HashMap<String, String> hashMap = null;
        String string2 = RacDatabaseUtil.getDBTargetName(string, connection, true);
        if (string2 != null) {
            hashMap = new HashMap<String, String>();
            hashMap.put("OLD_NAME", string2);
        }
        return hashMap;
    }

    public static Map racTargetProperties(String string, Connection connection) throws HarvesterException {
        if (GCVersion.pre11_1GC()) {
            return null;
        }
        HashMap<String, String> hashMap = null;
        String string2 = RacDatabaseUtil.getRacTargetName(string, connection, true);
        if (string2 != null) {
            hashMap = new HashMap<String, String>();
            hashMap.put("OLD_NAME", string2);
        }
        return hashMap;
    }

    private static String getDbName(String string, String string2, Connection connection) throws HarvesterException {
        String string3 = null;
        String string4 = "SELECT p.property_value FROM mgmt_target_properties p, mgmt_targets t WHERE t.target_name = :tn AND t.target_type = 'oracle_database' AND t.target_guid = p.target_guid AND p.property_name = :pn AND p.property_type = 'INSTANCE'";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{string, string2});
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1024};
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)connection), (String)string4, (int[])new int[]{1, 1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Throwable throwable) {
            String string5 = "Getting db name failed: " + throwable.getMessage();
            sLog.error((Object)("GC OCM Harvester: " + string5));
            throw new HarvesterException(string5, throwable);
        }
        if (null != arrayList2) {
            Object[] objectArray = (Object[])arrayList2.get(0);
            string3 = (String)objectArray[0];
        }
        return string3;
    }

    private static String getRacTargetForDbTarget(String string, Connection connection) throws HarvesterException {
        String string2 = null;
        String string3 = "select rac.target_name  from mgmt_flat_target_assoc a, mgmt_targets db, mgmt_targets rac where db.target_name = :tn and db.target_type = 'oracle_database' and a.assoc_target_guid  = db.target_guid and a.is_membership      = 1 and a.source_target_guid =  rac.target_guid and rac.target_type = 'rac_database'";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{string});
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1024};
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)connection), (String)string3, (int[])new int[]{1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Throwable throwable) {
            String string4 = "Getting rac name for db failed: " + throwable.getMessage();
            sLog.error((Object)("GC OCM Harvester: " + string4));
            throw new HarvesterException(string4, throwable);
        }
        if (null != arrayList2) {
            Object[] objectArray = (Object[])arrayList2.get(0);
            string2 = (String)objectArray[0];
        }
        return string2;
    }

    private static String[] getRacDbPropertyValues(String string, Connection connection) throws HarvesterException {
        Object[] objectArray = null;
        String string2 = "SELECT p.property_name, p.property_value FROM mgmt_target_properties p, mgmt_targets t WHERE t.target_name = :tn AND t.target_type = 'rac_database' AND t.target_guid = p.target_guid AND p.property_name IN ('DBName', 'DBDomain', 'DataGuardStatus', 'ClusterName', 'DBVersion') AND p.property_type = 'INSTANCE'";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
        arrayList.add(new Object[]{string});
        ArrayList arrayList2 = null;
        int[] nArray = new int[]{1, 1};
        int[] nArray2 = new int[]{64, 1024};
        try {
            arrayList2 = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)connection), (String)string2, (int[])new int[]{1}, arrayList, (int[])nArray, (int[])nArray2, (boolean)false);
        }
        catch (Throwable throwable) {
            String string3 = "Getting rac db properties failed: " + throwable.getMessage();
            sLog.error((Object)("GC OCM Harvester: " + string3));
            throw new HarvesterException(string3, throwable);
        }
        if (null != arrayList2) {
            objectArray = new String[5];
            Arrays.fill(objectArray, null);
            for (int i = 0; i < arrayList2.size(); ++i) {
                Object[] objectArray2 = (Object[])arrayList2.get(i);
                String string4 = (String)objectArray2[0];
                String string5 = (String)objectArray2[1];
                if ("DBName".equals(string4)) {
                    objectArray[0] = string5;
                    continue;
                }
                if ("DBDomain".equals(string4)) {
                    objectArray[1] = string5;
                    continue;
                }
                if ("DataGuardStatus".equals(string4)) {
                    objectArray[2] = string5;
                    continue;
                }
                if ("ClusterName".equals(string4)) {
                    objectArray[3] = string5;
                    continue;
                }
                if (!"DBVersion".equals(string4)) continue;
                objectArray[4] = string5;
            }
        }
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

