/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.ti.exadata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResult;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResultList;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.metadata.ColumnDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.collector.targets.metadata.TableDescriptor;
import oracle.sysman.ccr.collector.targets.metadata.TargetMetadata;
import oracle.sysman.ccr.gcharvester.GcCollectionInfo;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.targettype.HarvesterAddTargetCallback;
import oracle.sysman.ccr.gcharvester.targettype.TargetMetadataUtil;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class ExaDataAddTargetCallback
implements HarvesterAddTargetCallback {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$ti$exadata$ExaDataAddTargetCallback == null ? (class$oracle$sysman$ccr$gcharvester$ti$exadata$ExaDataAddTargetCallback = ExaDataAddTargetCallback.class$("oracle.sysman.ccr.gcharvester.ti.exadata.ExaDataAddTargetCallback")) : class$oracle$sysman$ccr$gcharvester$ti$exadata$ExaDataAddTargetCallback).getName());
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$ti$exadata$ExaDataAddTargetCallback;

    public CollectionResultList getCollectionResultList(GcCollectionInfo gcCollectionInfo, Connection connection) throws HarvesterException {
        try {
            CollectionResult collectionResult;
            MetricResult metricResult;
            Metric metric;
            HashMap<String, String> hashMap;
            String string;
            if (null == gcCollectionInfo) {
                throw new HarvesterException("The GcCollectionInfo object provided is null.");
            }
            List list = gcCollectionInfo.getOcmTargets();
            if (null == list || list.isEmpty()) {
                throw new HarvesterException("No Collected OCM Targets was present in the GCCollection Info object provided. Hence host target cannot be created.");
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Number of Exadata System Base Targets is " + list.size()));
                sLog.debug((Object)("Base Targets recieved for ExaDataAddTargetCallback are " + list));
            }
            Target target = null;
            Object object = list.iterator();
            while (object.hasNext() && null == (target = (Target)object.next())) {
            }
            if (null == target) {
                throw new HarvesterException("Collected Exadata OCM target was not found in GcCollectionInfo Object provided. Hence host target cannot be created.");
            }
            object = this.getKernalVersion(gcCollectionInfo, connection);
            TargetMetadata targetMetadata = TargetMetadataUtil.getTargetMetadata("host");
            Target target2 = new Target(target.getTargetHost(), "host", false, null, false, target.getTargetHost(), target.getTargetHome(), target.getConfigHome(), target.isProxyTarget(), target.getTargetHost(), gcCollectionInfo.getTargetTimezone(), targetMetadata.getMetadataVersion(), null, null);
            CollectionResultList collectionResultList = new CollectionResultList(target2, "ll_host_config", targetMetadata.getMetadataVersion());
            if (object != null && ((String)object).matches(".*[el5].*")) {
                string = "ECM_OS";
                hashMap = new HashMap();
                hashMap.put("Name", "Oracle Enterprise Linux 5");
                hashMap.put("PlatformId", "46");
                hashMap.put("PlatformVersionId", "6021");
                metric = targetMetadata.getMetric(string, target2);
                if (null == metric) {
                    throw new HarvesterException("Collected Exadata OCM metric was not found in GcCollectionInfo Object provided. Hence host target cannot be created.");
                }
                metricResult = this.populateMetricResultObject(metric, hashMap);
                collectionResult = new CollectionResult(string, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
                collectionResultList.put(string, collectionResult);
            }
            string = "ECM_HW";
            hashMap = new HashMap<String, String>();
            hashMap.put("SystemSerialNumber", target.getUniqueId());
            metric = targetMetadata.getMetric(string, target2);
            if (null == metric) {
                throw new HarvesterException("Collected Exadata OCM metric was not found in GcCollectionInfo Object provided. Hence host target cannot be created.");
            }
            metricResult = this.populateMetricResultObject(metric, hashMap);
            collectionResult = new CollectionResult(string, metric.isIncremental(), false, metric.getTblDesc(), metricResult);
            collectionResultList.put(string, collectionResult);
            return collectionResultList;
        }
        catch (Exception exception) {
            String string = "Exception occured while adding Host Target for Exadata.";
            HarvesterUtil.logErrorMessage(sLog, exception, string);
            throw new HarvesterException(string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getKernalVersion(GcCollectionInfo gcCollectionInfo, Connection connection) {
        PreparedStatement preparedStatement;
        String string;
        block8: {
            String string2 = gcCollectionInfo.getTargetName();
            String string3 = gcCollectionInfo.getTargetType();
            String string4 = "select kernel_version from CM$EM_EXADATA_CELL where cm_target_name = ? and cm_target_type = ?";
            string = null;
            ResultSet resultSet = null;
            preparedStatement = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement(string4);
                    preparedStatement.setString(1, string2);
                    preparedStatement.setString(2, string3);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string = resultSet.getString(1);
                    }
                }
                catch (SQLException sQLException) {
                    String string5 = "Exception occured while quring DB.";
                    HarvesterUtil.logErrorMessage(sLog, sQLException, string5);
                    Object var12_10 = null;
                    if (resultSet != null) {
                        JDBCUtil.close((ResultSet)resultSet);
                    }
                    if (preparedStatement == null) return string;
                    JDBCUtil.close((Statement)preparedStatement);
                    return string;
                }
                Object var12_9 = null;
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                if (resultSet != null) {
                    JDBCUtil.close(resultSet);
                }
                if (preparedStatement == null) throw throwable;
                JDBCUtil.close((Statement)preparedStatement);
                throw throwable;
            }
            JDBCUtil.close((ResultSet)resultSet);
        }
        if (preparedStatement == null) return string;
        JDBCUtil.close((Statement)preparedStatement);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricResult populateMetricResultObject(Metric metric, Map map) {
        MetricResult metricResult = new MetricResult();
        ValueRow valueRow = metricResult.addValueRow();
        try {
            TableDescriptor tableDescriptor = metric.getTblDesc();
            Vector vector = tableDescriptor.getColDescs();
            for (int i = 0; i < vector.size(); ++i) {
                ColumnDescriptor columnDescriptor = (ColumnDescriptor)vector.get(i);
                if (map.get(columnDescriptor.getName()) == null) continue;
                valueRow.setValue(metric.findColumnId(columnDescriptor.getName()), (String)map.get(columnDescriptor.getName()));
            }
        }
        catch (Exception exception) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)exception, (Throwable)exception);
            }
        }
        return metricResult;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

