/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.ti.exalogic;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.sysman.ccr.gcharvester.HarvesterEMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterSnapshotMD;
import oracle.sysman.ccr.gcharvester.QueryInfo;
import oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergedTargetTypeInfo;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class ELSystemConvergedTargetInfo
extends ConvergedTargetTypeInfo {
    static final String EXALOGIC_ID_STRING = "ExalogicId";
    public static final String ELSYSTEM_TYPE = "exalogic_system";
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$ti$exalogic$ELSystemConvergedTargetInfo == null ? (class$oracle$sysman$ccr$gcharvester$ti$exalogic$ELSystemConvergedTargetInfo = ELSystemConvergedTargetInfo.class$("oracle.sysman.ccr.gcharvester.ti.exalogic.ELSystemConvergedTargetInfo")) : class$oracle$sysman$ccr$gcharvester$ti$exalogic$ELSystemConvergedTargetInfo).getName());
    private static final String GET_EXALOGIC_SYSTEM_PROPERTIES_QUERY = "SELECT PROPERTY_NAME, PROPERTY_VALUE FROM " + "MGMT$TARGET_PROPERTIES WHERE TARGET_TYPE = '" + "exalogic_system" + "' AND TARGET_NAME = ?";
    private static final String GET_EXALOGIC_SYSTEM_ID_PROPERTY_QUERY = "SELECT PROPERTY_VALUE FROM MGMT$TARGET_PROPERTIES " + "WHERE TARGET_TYPE = '" + "exalogic_system" + "' AND PROPERTY_NAME = '" + "ExalogicId" + "' AND TARGET_NAME = ?";
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$ti$exalogic$ELSystemConvergedTargetInfo;

    public ELSystemConvergedTargetInfo() {
        this(ELSYSTEM_TYPE);
    }

    public ELSystemConvergedTargetInfo(String string) {
        super(string);
    }

    public String getTargetName(String string, String string2, Connection connection) throws HarvesterException {
        return "/ExalogicCloud_" + this.getUniqueId(string, connection);
    }

    public boolean hasFakeOracleHome(Connection connection) {
        return true;
    }

    public String getOracleHome(String string, String string2, Connection connection) {
        return "N/A";
    }

    public Map getTargetProperties(String string, String string2, String string3, String string4, String string5, String string6, Connection connection) throws HarvesterException {
        Properties properties;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(GET_EXALOGIC_SYSTEM_PROPERTIES_QUERY);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            String string7 = null;
            String string8 = null;
            Properties properties2 = new Properties();
            while (resultSet.next()) {
                string7 = resultSet.getString(1);
                string8 = resultSet.getString(2);
                if (EXALOGIC_ID_STRING.equals(string7)) {
                    properties2.setProperty(EXALOGIC_ID_STRING, string8);
                }
                if (!"version".equals(string7)) continue;
                properties2.setProperty("version_value", string8);
            }
            properties2.setProperty("OCM_CROSS_HOST", "TRUE");
            properties = properties2;
        }
        catch (SQLException sQLException) {
            try {
                String string9 = "SQL Exception occurred " + "while retrieving the instance properties of Exalogic" + " System Target : " + string;
                HarvesterUtil.logErrorMessage(sLog, sQLException, string9);
                throw new HarvesterException(string9, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close((Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)preparedStatement, (ResultSet)resultSet);
        return properties;
    }

    public String getUniqueId(String string, Connection connection) throws HarvesterException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            preparedStatement = null;
            resultSet = null;
            preparedStatement = connection.prepareStatement(GET_EXALOGIC_SYSTEM_ID_PROPERTY_QUERY);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            String string2 = resultSet.getString(1);
            JDBCUtil.close((Statement)preparedStatement, (ResultSet)resultSet);
            return string2;
        }
        try {
            try {
                String string3 = "Could not retrieve the" + " ExalogicId property of Exalogic System Target : " + string;
                sLog.error((Object)string3);
                throw new HarvesterException(string3);
            }
            catch (SQLException sQLException) {
                String string4 = "SQL Exception occurred " + "while retrieving the instance properties of Exalogic" + " System Target : " + string;
                HarvesterUtil.logErrorMessage(sLog, sQLException, string4);
                throw new HarvesterException(string4, sQLException);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.close((Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    public List getHarvesterSnapshotMDs(Connection connection) throws HarvesterException {
        HarvesterSnapshotMD harvesterSnapshotMD;
        ArrayList<HarvesterSnapshotMD> arrayList = super.getHarvesterSnapshotMDs(connection);
        if (null == arrayList) {
            arrayList = new ArrayList<HarvesterSnapshotMD>();
        }
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        boolean bl2 = GCVersion.pre12_102GC();
        while (iterator.hasNext()) {
            harvesterSnapshotMD = (HarvesterSnapshotMD)iterator.next();
            if (!"exalogic_system_config".equals(harvesterSnapshotMD.getHarvesterSnapshotType()) || !"exalogic_system_config".equals(harvesterSnapshotMD.getOCMSnapshotType())) continue;
            harvesterSnapshotMD.addEMMetricMD(this.getTargetVersionMetric());
            if (!bl2) {
                harvesterSnapshotMD.addEMMetricMD(this.getLatestExalogicMetric());
                harvesterSnapshotMD.addEMMetricMD(this.getProductUsageMonthlyMetric());
                harvesterSnapshotMD.addEMMetricMD(this.getProductUsageMonthlyPeakMetric());
                harvesterSnapshotMD.addEMMetricMD(this.getLicenseUsageMonthlyMetric());
                harvesterSnapshotMD.addEMMetricMD(this.getLicenseUsageMonthlyPeakMetric());
            }
            bl = true;
        }
        if (!bl) {
            harvesterSnapshotMD = new HarvesterSnapshotMD(ELSYSTEM_TYPE, "orcl_tp_config", ELSYSTEM_TYPE, "exalogic_system_config");
            harvesterSnapshotMD.addEMMetricMD(this.getTargetVersionMetric());
            if (!bl2) {
                harvesterSnapshotMD.addEMMetricMD(this.getLatestExalogicMetric());
                harvesterSnapshotMD.addEMMetricMD(this.getProductUsageMonthlyMetric());
                harvesterSnapshotMD.addEMMetricMD(this.getProductUsageMonthlyPeakMetric());
                harvesterSnapshotMD.addEMMetricMD(this.getLicenseUsageMonthlyMetric());
                harvesterSnapshotMD.addEMMetricMD(this.getLicenseUsageMonthlyPeakMetric());
            }
            arrayList.add(harvesterSnapshotMD);
        }
        return arrayList;
    }

    private HarvesterEMMetricMD getTargetVersionMetric() {
        return new HarvesterEMMetricMD("MGMT_ECM_TARGET_VERSIONS", 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "ECM_TARGET_VERSIONS";
            }

            public String getQuery() {
                return "select target_version from gc$global_target_properties where target_name = :tn and target_type = :tt and target_version is not null";
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 1;
            }
        })});
    }

    private HarvesterEMMetricMD getLatestExalogicMetric() {
        return new HarvesterEMMetricMD("EM_VM_LATEST_EXALOGIC", 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "EM_VM_LATEST_EXALOGIC";
            }

            public String getQuery() {
                return "select TO_CHAR(COLLECTION_TIME, 'YYYY-MM-DD HH24:MI:SS'), RACK_NAME, RACK_TYPE, RACK_SETUP, RACK_MODEL, RACK_ID, RACK_IS_DELETED from EM$ECM_VM_CURR_EXALOGIC where EXALOGIC_NAME = :tn and EXALOGIC_TYPE = :tt";
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 7;
            }
        })});
    }

    private HarvesterEMMetricMD getProductUsageMonthlyMetric() {
        return new HarvesterEMMetricMD("EM_VM_PROD_MONTHLY", 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "EM_VM_PROD_MONTHLY";
            }

            public String getQuery() {
                return "select TO_CHAR(COLLECTION_MONTH, 'YYYY-MM-DD HH24:MI:SS'), RACK_NAME, RACK_TYPE, PRODUCT_ID, PRODUCT_NAME, TO_CHAR(PEAK_COLLECTION_DAY,'YYYY-MM-DD HH24:MI:SS'), PEAK_VCPUS from EM$ECM_VM_PROD_SUM_MONTH where EXALOGIC_NAME = :tn and EXALOGIC_TYPE = :tt";
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 7;
            }
        })});
    }

    private HarvesterEMMetricMD getProductUsageMonthlyPeakMetric() {
        return new HarvesterEMMetricMD("EM_VM_PROD_MONTHLY_PEAK", 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "EM_VM_PROD_MONTHLY_PEAK";
            }

            public String getQuery() {
                return "select TO_CHAR(PEAK_COLLECTION_DAY, 'YYYY-MM-DD HH24:MI:SS'), RACK_NAME, RACK_TYPE, VM_SERVER_NAME, HOST_NAME, TARGET_NAME, TARGET_TYPE, PRODUCT_ID, PRODUCT_NAME, LICENSE_EDITION_NAME, HOST_PEAK_VCPUS from EM$ECM_VM_PROD_SUM_MONTH_PEAK where EXALOGIC_NAME = :tn and EXALOGIC_TYPE = :tt";
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 11;
            }
        })});
    }

    private HarvesterEMMetricMD getLicenseUsageMonthlyMetric() {
        return new HarvesterEMMetricMD("EM_VM_LIC_MONTHLY", 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "EM_VM_LIC_MONTHLY";
            }

            public String getQuery() {
                return "select TO_CHAR(COLLECTION_MONTH, 'YYYY-MM-DD HH24:MI:SS'), RACK_NAME, RACK_TYPE, LICENSE_EDITION_NAME, TO_CHAR(PEAK_COLLECTION_DAY, 'YYYY-MM-DD HH24:MI:SS'), PEAK_VCPUS from EM$ECM_VM_LIC_SUM_MONTH where EXALOGIC_NAME = :tn and EXALOGIC_TYPE = :tt";
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 6;
            }
        })});
    }

    private HarvesterEMMetricMD getLicenseUsageMonthlyPeakMetric() {
        return new HarvesterEMMetricMD("EM_VM_LIC_MONTHLY_PEAK", 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "EM_VM_LIC_MONTHLY_PEAK";
            }

            public String getQuery() {
                return "select TO_CHAR(PEAK_COLLECTION_DAY, 'YYYY-MM-DD HH24:MI:SS'), RACK_NAME, RACK_TYPE, VM_SERVER_NAME, HOST_NAME, TARGET_NAME, TARGET_TYPE, LICENSE_EDITION_NAME, HOST_PEAK_VCPUS from EM$ECM_VM_LIC_SUM_MONTH_PEAK where EXALOGIC_NAME = :tn and EXALOGIC_TYPE = :tt";
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 9;
            }
        })});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

