/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.ti.exalogic;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.sysman.ccr.gcharvester.HarvesterEMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterSnapshotMD;
import oracle.sysman.ccr.gcharvester.QueryInfo;
import oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergedTargetTypeInfo;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class ExaRackConvergedTargetInfo
extends ConvergedTargetTypeInfo {
    static final String EXARACK_ORACLE_HOME = "/opt/exalogic";
    public static final String RACK_ID_STRING = "RackId";
    private static final String EXARACK_SNAPSHOT_TYPE = "exa_rack_config";
    public static final String EXARACK_TYPE = "exa_rack";
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$ti$exalogic$ExaRackConvergedTargetInfo == null ? (class$oracle$sysman$ccr$gcharvester$ti$exalogic$ExaRackConvergedTargetInfo = ExaRackConvergedTargetInfo.class$("oracle.sysman.ccr.gcharvester.ti.exalogic.ExaRackConvergedTargetInfo")) : class$oracle$sysman$ccr$gcharvester$ti$exalogic$ExaRackConvergedTargetInfo).getName());
    private static final String GET_EXA_RACK_UNIQUE_ID_QUERY = "SELECT PROPERTY_VALUE FROM MGMT$TARGET_PROPERTIES WHERE " + "TARGET_TYPE = '" + "exa_rack" + "' AND PROPERTY_NAME = '" + "RackId" + "' AND TARGET_NAME = ?";
    private static final String GET_EXA_RACK_TARGET_PROPERTIES_QUERY = "SELECT PROPERTY_NAME, PROPERTY_VALUE FROM " + "MGMT$TARGET_PROPERTIES WHERE TARGET_TYPE = '" + "exa_rack" + "' AND TARGET_NAME = ?";
    protected static final String GET_ECM_ASSOCIATIONS_METRIC_QUERY = "SELECT 'member_of' as ASSOCIATION_TYPE, " + "'' as TARGET_NAME, " + "M.AGGREGATE_TARGET_TYPE as TARGET_TYPE, " + "P.PROPERTY_VALUE as TARGET_PROPERTY " + "FROM MGMT$TARGET_PROPERTIES P, " + "MGMT$TARGET_FLAT_MEMBERS M WHERE " + "P.TARGET_GUID = M.AGGREGATE_TARGET_GUID AND " + "M.AGGREGATE_TARGET_TYPE = '" + "exalogic_system" + "' AND P.PROPERTY_NAME = '" + "ExalogicId" + "' AND M.MEMBER_TARGET_NAME = :tn" + " AND M.MEMBER_TARGET_TYPE = :tt";
    private static final String GET_EXALOGIC_SYSTEM_ID_TARGET_PROPERTY_QUERY = "SELECT P.PROPERTY_VALUE FROM " + "MGMT$TARGET_PROPERTIES P, MGMT$TARGET_FLAT_MEMBERS M " + "WHERE P.TARGET_GUID = M.AGGREGATE_TARGET_GUID AND " + "M.AGGREGATE_TARGET_TYPE = '" + "exalogic_system" + "' AND P.PROPERTY_NAME = '" + "ExalogicId" + "' AND M.MEMBER_TARGET_TYPE = '" + "exa_rack" + "' AND M.MEMBER_TARGET_NAME = ?";
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$ti$exalogic$ExaRackConvergedTargetInfo;

    public ExaRackConvergedTargetInfo() {
        this(EXARACK_TYPE);
    }

    public ExaRackConvergedTargetInfo(String string) {
        super(string);
    }

    public List getHarvesterSnapshotMDs(Connection connection) throws HarvesterException {
        HarvesterSnapshotMD harvesterSnapshotMD;
        ArrayList<HarvesterSnapshotMD> arrayList = super.getHarvesterSnapshotMDs(connection);
        if (null == arrayList) {
            arrayList = new ArrayList<HarvesterSnapshotMD>();
        }
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            harvesterSnapshotMD = (HarvesterSnapshotMD)iterator.next();
            if (!EXARACK_SNAPSHOT_TYPE.equals(harvesterSnapshotMD.getHarvesterSnapshotType())) continue;
            harvesterSnapshotMD.addEMMetricMD(this.getExaRackAssocMetric());
            bl = true;
        }
        if (!bl) {
            harvesterSnapshotMD = new HarvesterSnapshotMD(EXARACK_TYPE, EXARACK_SNAPSHOT_TYPE, EXARACK_TYPE, EXARACK_SNAPSHOT_TYPE);
            harvesterSnapshotMD.addEMMetricMD(this.getExaRackAssocMetric());
            arrayList.add(harvesterSnapshotMD);
        }
        return arrayList;
    }

    public String getTargetName(String string, String string2, Connection connection) throws HarvesterException {
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("In getTargetName() for Harvesting exa_rack : " + string));
        }
        String string3 = this.getExalogicId(string, connection);
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("ExalogicId of exa_rack : " + string + "is : " + string3));
        }
        String string4 = this.getUniqueId(string, connection);
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("RackId of exa_rack : " + string + "is : " + string4));
        }
        String string5 = "/ExalogicCloud_" + string3 + "/" + string4;
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("OCM Name of Exa Rack, " + string + ", being harvested is : " + string5));
        }
        return string5;
    }

    private String getExalogicId(String string, Connection connection) throws HarvesterException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            preparedStatement = null;
            resultSet = null;
            preparedStatement = connection.prepareStatement(GET_EXALOGIC_SYSTEM_ID_TARGET_PROPERTY_QUERY);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            String string2 = resultSet.getString(1);
            JDBCUtil.close((Statement)preparedStatement, (ResultSet)resultSet);
            return string2;
        }
        try {
            try {
                String string3 = "Could not retrive the Exalogic System Id for exa_rack: " + string;
                sLog.error((Object)string3);
                throw new HarvesterException(string3);
            }
            catch (SQLException sQLException) {
                String string4 = "SQL Exception while retriving the Exalogic System Id for exa_rack: " + string;
                HarvesterUtil.logErrorMessage(sLog, sQLException, string4);
                throw new HarvesterException(string4, sQLException);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.close((Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    public String getOracleHome(String string, String string2, Connection connection) {
        return EXARACK_ORACLE_HOME;
    }

    public boolean hasFakeOracleHome(Connection connection) {
        return true;
    }

    public Map getTargetProperties(String string, String string2, String string3, String string4, String string5, String string6, Connection connection) throws HarvesterException {
        Properties properties;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(GET_EXA_RACK_TARGET_PROPERTIES_QUERY);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            String string7 = null;
            String string8 = null;
            Properties properties2 = new Properties();
            while (resultSet.next()) {
                string7 = resultSet.getString(1);
                string8 = resultSet.getString(2);
                if (RACK_ID_STRING.equals(string7)) {
                    properties2.setProperty(RACK_ID_STRING, string8);
                }
                if (!"version".equals(string7)) continue;
                properties2.setProperty("version_value", string8);
            }
            properties2.setProperty("OcmProxyOracleHome", this.getOracleHome(string, null, connection));
            properties2.setProperty("OCM_CROSS_HOST", "TRUE");
            properties = properties2;
        }
        catch (SQLException sQLException) {
            try {
                String string9 = "SQL Exception while retriving the properties for exa_rack: " + string;
                HarvesterUtil.logErrorMessage(sLog, sQLException, string9);
                throw new HarvesterException(string9, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close((Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        JDBCUtil.close((Statement)preparedStatement, (ResultSet)resultSet);
        return properties;
    }

    public String getUniqueId(String string, Connection connection) throws HarvesterException {
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        block5: {
            resultSet = null;
            preparedStatement = null;
            preparedStatement = connection.prepareStatement(GET_EXA_RACK_UNIQUE_ID_QUERY);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (null == resultSet || !resultSet.next()) break block5;
            String string2 = resultSet.getString(1);
            JDBCUtil.close((Statement)preparedStatement, (ResultSet)resultSet);
            return string2;
        }
        try {
            try {
                String string3 = "Could not find the " + "rackId of exa_rack : " + string + " from the target properties";
                sLog.error((Object)string3);
                throw new HarvesterException(string3);
            }
            catch (SQLException sQLException) {
                String string4 = "SQL Exception occured while retriving UniqueId of exa_rack: " + string;
                HarvesterUtil.logErrorMessage(sLog, sQLException, string4);
                throw new HarvesterException(string4, sQLException);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.close((Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    private HarvesterEMMetricMD getExaRackAssocMetric() {
        HarvesterEMMetricMD harvesterEMMetricMD = new HarvesterEMMetricMD("MGMT_ECM_ASSOCIATIONS", 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "ECM_ASSOCIATIONS";
            }

            public String getQuery() {
                return GET_ECM_ASSOCIATIONS_METRIC_QUERY;
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 4;
            }
        })});
        return harvesterEMMetricMD;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

