/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.ti.host;

import java.sql.Connection;
import java.util.MissingResourceException;
import java.util.Vector;
import oracle.sysman.ccr.collector.fetchlets.MetricResult;
import oracle.sysman.ccr.collector.fetchlets.ValueRow;
import oracle.sysman.ccr.collector.targets.host.HostPlatformMap;
import oracle.sysman.ccr.collector.targets.host.HostPlatformMappingException;
import oracle.sysman.ccr.collector.targets.metadata.Metric;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.targettype.MetricResultCallback;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import org.apache.log4j.Category;

public class HostMetricResultCallback
implements MetricResultCallback {
    private static final Category s_log = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$ti$host$HostMetricResultCallback == null ? (class$oracle$sysman$ccr$gcharvester$ti$host$HostMetricResultCallback = HostMetricResultCallback.class$("oracle.sysman.ccr.gcharvester.ti.host.HostMetricResultCallback")) : class$oracle$sysman$ccr$gcharvester$ti$host$HostMetricResultCallback).getName());
    private static HostPlatformMap m_hostPlatMap = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$ti$host$HostMetricResultCallback;

    public MetricResult callback(Metric metric, MetricResult metricResult, String string, String string2, String string3, String string4, String string5, String string6, Connection connection) throws HarvesterException {
        if (!GCVersion.pre11_2GC()) {
            return metricResult;
        }
        if (string2.equals("host") && string3.equals("ll_host_config")) {
            String string7 = metric.getMetricId();
            if (string7.equals("ECM_OS")) {
                return this.computePlatformVersionId(metricResult, metric);
            }
            if (string7.equals("ECM_HW_IOCARD")) {
                return this.fixMericResultForIOCard(metricResult, metric);
            }
            if (string7.equals("ECM_HW_CPU")) {
                return this.fixMericResultForECM_HW_CPU(metricResult, metric);
            }
            if (string7.equals("ECM_HW_NIC")) {
                return this.fixMericResultForECM_HW_NIC(metricResult, metric);
            }
            if (string7.equals("ECM_HW")) {
                return this.fixMericResultForECM_HW(metricResult, metric);
            }
        }
        return metricResult;
    }

    private MetricResult computePlatformVersionId(MetricResult metricResult, Metric metric) {
        ValueRow valueRow;
        Vector vector;
        if (m_hostPlatMap != null && (vector = metricResult.getValueRows()) != null && (valueRow = (ValueRow)vector.firstElement()) != null) {
            String string = valueRow.getValue(0);
            String string2 = valueRow.getValue(1);
            String string3 = valueRow.getValue(2);
            String string4 = valueRow.getValue(11);
            Integer n = new Integer(-1);
            if (string4 != null) {
                n = m_hostPlatMap.getPlatformVersionID(string4, string, string3, string2);
            }
            int n2 = metric.findColumnId("PlatformVersionId");
            valueRow.setValue(n2, n.toString());
            vector.setElementAt(valueRow, 0);
            metricResult.setValueRows(vector);
        }
        return metricResult;
    }

    private MetricResult fixMericResultForIOCard(MetricResult metricResult, Metric metric) {
        int n = metric.findColumnId("InstanceCount");
        if (n == -1) {
            Vector vector = metricResult.getValueRows();
            if (vector == null) {
                return metricResult;
            }
            for (int i = 0; i < vector.size(); ++i) {
                ValueRow valueRow = (ValueRow)vector.get(i);
                if (valueRow == null) continue;
                for (int j = 1; j <= 5; ++j) {
                    valueRow.setValue(j - 1, valueRow.getValue(j));
                }
                valueRow.setValue(5, "");
            }
        }
        return metricResult;
    }

    private MetricResult fixMericResultForECM_HW_CPU(MetricResult metricResult, Metric metric) {
        int n = metric.findColumnId("InstanceCount");
        if (n == -1) {
            Vector vector = metricResult.getValueRows();
            if (vector == null) {
                return metricResult;
            }
            for (int i = 0; i < vector.size(); ++i) {
                ValueRow valueRow = (ValueRow)vector.get(i);
                if (valueRow == null) continue;
                for (int j = 1; j <= 6; ++j) {
                    valueRow.setValue(j - 1, valueRow.getValue(j));
                }
                valueRow.setValue(6, "");
            }
        }
        return metricResult;
    }

    private MetricResult fixMericResultForECM_HW_NIC(MetricResult metricResult, Metric metric) {
        int n = metric.findColumnId("Inet6Address");
        if (n == -1) {
            Vector vector = metricResult.getValueRows();
            if (vector == null) {
                return metricResult;
            }
            for (int i = 0; i < vector.size(); ++i) {
                ValueRow valueRow = (ValueRow)vector.get(i);
                if (valueRow == null) continue;
                for (int j = 5; j <= 8; ++j) {
                    valueRow.setValue(j - 1, valueRow.getValue(j));
                }
                valueRow.setValue(8, "");
            }
        }
        return metricResult;
    }

    private MetricResult fixMericResultForECM_HW(MetricResult metricResult, Metric metric) {
        int n;
        ValueRow valueRow;
        int n2;
        Vector vector;
        int n3 = metric.findColumnId("PhysicalCpuCount");
        if (n3 == -1) {
            vector = metricResult.getValueRows();
            if (vector == null) {
                return metricResult;
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                valueRow = (ValueRow)vector.get(n2);
                if (valueRow == null) continue;
                for (n = 9; n <= 12; ++n) {
                    valueRow.setValue(n - 1, valueRow.getValue(n));
                }
                valueRow.setValue(12, "");
            }
        }
        if ((n3 = metric.findColumnId("LogicalCpuCount")) == -1) {
            vector = metricResult.getValueRows();
            if (vector == null) {
                return metricResult;
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                valueRow = (ValueRow)vector.get(n2);
                if (valueRow == null) continue;
                for (n = 10; n <= 11; ++n) {
                    valueRow.setValue(n - 1, valueRow.getValue(n));
                }
                valueRow.setValue(11, "");
            }
        }
        return metricResult;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            m_hostPlatMap = HostPlatformMap.getInstance();
        }
        catch (HostPlatformMappingException hostPlatformMappingException) {
            String string = "Error loading HostPlatformMap; Will be unable to compute Platform Version ID for host targets: " + hostPlatformMappingException.getMessage();
            s_log.error((Object)("GC OCM Harvester: " + string));
        }
        catch (MissingResourceException missingResourceException) {
            String string = "Error loading message bundle for HostPlatformMap. Will be unable to compute Platform Version ID for host targets.";
            s_log.error((Object)("GC OCM Harvester: " + string));
        }
    }
}

