/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.ti.self_monitor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.sysman.ccr.gcharvester.HarvesterEMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterSnapshotMD;
import oracle.sysman.ccr.gcharvester.IgnoreTargetException;
import oracle.sysman.ccr.gcharvester.QueryInfo;
import oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergedTargetTypeInfo;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class HarvesterForEmrepTarget
extends ConvergedTargetTypeInfo {
    private String m_isCrossHost;
    private String m_oracleHome;
    private String m_hostName;
    private String m_targetName;
    private String m_emsystemName;
    private String m_hostName_vInstance;
    private String m_omsHostName;
    private static String DB_ORACLE_HOME_NOT_AVAIL = "NA";
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$ti$self_monitor$HarvesterForEmrepTarget == null ? (class$oracle$sysman$ccr$gcharvester$ti$self_monitor$HarvesterForEmrepTarget = HarvesterForEmrepTarget.class$("oracle.sysman.ccr.gcharvester.ti.self_monitor.HarvesterForEmrepTarget")) : class$oracle$sysman$ccr$gcharvester$ti$self_monitor$HarvesterForEmrepTarget).getName());
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$ti$self_monitor$HarvesterForEmrepTarget;

    public HarvesterForEmrepTarget(String string) {
        super(string);
    }

    public List getHarvesterSnapshotMDs(Connection connection) throws HarvesterException {
        List list = super.getHarvesterSnapshotMDs(connection);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HarvesterSnapshotMD harvesterSnapshotMD = (HarvesterSnapshotMD)iterator.next();
            if (!harvesterSnapshotMD.getHarvesterSnapshotType().equals("oracle_emrep_config")) continue;
            harvesterSnapshotMD.addEMMetricMD(this.getPeriodicMetric());
        }
        list.add(this.getEMSystemSnapshot());
        return list;
    }

    public HarvesterEMMetricMD getPeriodicMetric() {
        return new HarvesterEMMetricMD("MGMT_ECM_ASSOCIATIONS", 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "ECM_ASSOCIATIONS";
            }

            public String getQuery() {
                String string = " select 'connects_to' assoc_type ,  null target_name, tgt.target_type target_type,  tgt.host_name||':'|| prop2.property_value ||':'|| prop.property_value target_property  from mgmt_targets tgt,mgmt_target_properties prop,mgmt_target_properties prop2  where tgt.target_guid = mgmt_admin_data.get_em_repos_target_guid   and tgt.target_guid = prop.target_guid   and tgt.target_guid = prop2.target_guid   and prop.property_name = 'OracleHome'   and prop2.property_name = 'DBName'   and exists (select 1 from mgmt_targets  where target_name = :tn and target_type = :tt ) ";
                return string;
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 4;
            }
        }), new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "emrep_RepositoryConfig";
            }

            public String getQuery() {
                String string = " select DECODE(upper(trim(component_mode)), 'CENTRAL','Grid Control', 'SYSAUX','DB CONTROL',component_mode) repos_type, version  from mgmt_versions where component_name='CORE'  and exists (select 1 from mgmt_targets  where target_name = :tn and target_type = :tt ) ";
                return string;
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 2;
            }
        }), new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "EM_PAGE_USAGE";
            }

            public String getQuery() {
                String string = " select pack_label, src_id, count, last_accessed_ts  from (  SELECT NVL(pack_label,'NO_PACK') pack_label, src_id, SUM(count) count, MAX(last_used_timestamp) last_accessed_ts  FROM mgmt_license_usage_history WHERE src_type = 1  GROUP BY pack_label, src_id   ORDER BY count DESC  ) where rownum < 51  and exists (select 1 from mgmt_targets  where target_name = :tn and target_type = :tt ) ";
                return string;
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 4;
            }
        })});
    }

    public Map getTargetProperties(String string, String string2, String string3, String string4, String string5, String string6, Connection connection) throws HarvesterException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.setValuesFromRepository(connection);
        if (this.m_isCrossHost != null) {
            hashMap.put("OCM_CROSS_HOST", this.m_isCrossHost);
        }
        hashMap.put("OLD_ORACLE_HOME", DB_ORACLE_HOME_NOT_AVAIL);
        hashMap.put("OLD_HOST", this.m_hostName_vInstance);
        if (string3 == null || !string3.equals("oracle_emrep")) {
            hashMap.put("OLD_HOST", this.m_omsHostName);
        }
        return hashMap;
    }

    public boolean hasFakeOracleHome(Connection connection) throws HarvesterException {
        return true;
    }

    public String getOracleHome(String string, String string2, Connection connection) throws HarvesterException {
        this.setValuesFromRepository(connection);
        return this.m_oracleHome == null ? DB_ORACLE_HOME_NOT_AVAIL : this.m_oracleHome;
    }

    public boolean hasFakeHost(Connection connection) throws HarvesterException {
        return true;
    }

    public String getHostName(String string, String string2, Connection connection) throws HarvesterException {
        this.setValuesFromRepository(connection);
        if (this.m_hostName == null && this.m_hostName_vInstance == null) {
            throw new IgnoreTargetException("Unable to find Host Name for oracle_emrep target.");
        }
        return this.m_hostName == null ? this.m_hostName_vInstance : this.m_hostName;
    }

    public String getTargetName(String string, String string2, Connection connection) throws HarvesterException {
        this.setValuesFromRepository(connection);
        return this.m_targetName;
    }

    String getEMSystemTargetName(Connection connection) throws HarvesterException {
        this.setValuesFromRepository(connection);
        return this.m_emsystemName;
    }

    private HarvesterSnapshotMD getEMSystemSnapshot() {
        HarvesterSnapshotMD harvesterSnapshotMD = new HarvesterSnapshotMD("oracle_emrep", "orcl_tp_config", "oracle_emsystem", "system_config");
        harvesterSnapshotMD.addEMMetricMD(new HarvesterEMMetricMD("MGMT_ECM_ASSOCIATIONS", 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "ECM_ASSOCIATIONS";
            }

            public String getQuery() {
                String string = " select * from (    SELECT 'contains' assoc_type, target_name , target_type, null target_properties    FROM mgmt_targets WHERE target_type IN ( 'oracle_emd','oracle_beacon')    union    SELECT 'contains' assoc_type, null target_name , t.target_type, t.target_name||'?'||p.property_value target_properties    FROM mgmt_targets t,mgmt_target_properties p WHERE t.target_type ='oracle_oms'     AND t.target_guid = p.target_guid  AND p.property_type = 'INSTANCE' AND p.property_name = 'OracleHome'     union    SELECT 'contains' assoc_type , null target_name, tgt.target_type target_type, tgt.host_name||':'|| (SELECT name FROM v$database) target_property     FROM mgmt_targets tgt,  mgmt_target_properties prop2     WHERE tgt.target_guid = mgmt_admin_data.get_em_repos_target_guid       AND tgt.target_guid = prop2.target_guid AND prop2.property_name = 'DBName'     union    SELECT 'defined_by' assoc_type , (SELECT name FROM v$database)||'_emrep' target_name, 'oracle_emrep' target_type, null target_property     FROM dual  ) where exists ( select 1 from mgmt_targets  where target_name = :tn and target_type = :tt ) ";
                return string;
            }

            public int getParameterLayout() {
                return 2;
            }

            public int getColumnCount() {
                return 4;
            }
        })}));
        return harvesterSnapshotMD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValuesFromRepository(Connection connection) {
        this.m_oracleHome = null;
        this.m_hostName = null;
        String string = " select p.property_name, p.property_value from mgmt_targets t,mgmt_target_properties p  where t.target_guid = p.target_guid    and t.target_guid = mgmt_admin_data.get_em_repos_target_guid    and p.property_name in ( 'OracleHome','MachineName')  UNION  select 'CROSS_HOST',decode( upper(parallel),'YES','TRUE','FALSE')  from v$instance  UNION  select 'TargetName', NAME from v$database  UNION  select 'HostName_in_vInstance', lower(host_name) from v$instance  UNION  select 'oms_hostname', host_name from mgmt_targets where  target_type = 'oracle_emrep'";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                if (string2.equals("CROSS_HOST")) {
                    this.m_isCrossHost = string3;
                    continue;
                }
                if (string2.equals("HostName_in_vInstance")) {
                    this.m_hostName_vInstance = string3;
                    continue;
                }
                if (string2.equals("oms_hostname")) {
                    this.m_omsHostName = string3;
                    continue;
                }
                if (string2.equals("OracleHome")) {
                    this.m_oracleHome = string3;
                    continue;
                }
                if (string2.equals("MachineName")) {
                    this.m_hostName = string3;
                    continue;
                }
                if (!string2.equals("TargetName")) continue;
                this.m_targetName = string3 + "_emrep";
                this.m_emsystemName = string3 + "_EM";
            }
        }
        catch (SQLException sQLException) {
            try {
                String string4 = "Error while getting values for oracle_emrep by query: " + string;
                HarvesterUtil.logErrorMessage(sLog, sQLException, string4);
            }
            catch (Throwable throwable) {
                JDBCUtil.close((Statement)preparedStatement, resultSet);
                throw throwable;
            }
            JDBCUtil.close((Statement)preparedStatement, (ResultSet)resultSet);
        }
        JDBCUtil.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

