/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.ti.weblogic;

import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.ccr.gcharvester.HarvesterEMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.HarvesterOCMMetricMD;
import oracle.sysman.ccr.gcharvester.HarvesterSnapshotMD;
import oracle.sysman.ccr.gcharvester.QueryInfo;
import oracle.sysman.ccr.gcharvester.targettype.convergence.ConvergedTargetTypeInfo;
import oracle.sysman.ccr.gcharvester.ti.weblogic.WLUtil;

public class WLDomainConvergedTargetInfo
extends ConvergedTargetTypeInfo {
    private static final String GET_ECM_ASSOCIATIONS_METRIC_QUERY = "SELECT 'depends_on' as ASSOCIATION_TYPE,\n        -- check isJRFApplicable property for the domain target\n       (CASE WHEN tgtProp2.property_value = 'true'\n            -- case when the isJRFApplicable property value is true\n            THEN ( '/Farm_' || substr(assocTgt.target_name,\n                    instr(assocTgt.target_name,\n                          substr(assocTgt.target_name,\n                                 instr(assocTgt.target_name, '/', 1, 2) + 1 ,\n                                 instr(assocTgt.target_name, '/', 1, 3) - instr(assocTgt.target_name, '/', 1, 2) - 1\n                                )\n                         )\n                   )\n )\n             -- case when the isJRFApplicable property value is false\n             ELSE ( substr(assocTgt.target_name, \n       instr(assocTgt.target_name, '/', 1, 2)\n      )\n )\n            END) TARGET_NAME,\n 'weblogic_j2eeserver' as TARGET_TYPE, assocTgt.host_name || ':' || tgtProp1.property_value as TARGET_PROPERTY\n FROM mgmt_targets domainTgt, mgmt_targets assocTgt, mgmt_target_assocs tgtAssocs, mgmt_target_properties tgtProp, mgmt_target_properties tgtProp1, mgmt_target_properties tgtProp2\n WHERE domainTgt.target_name = :tn\n   AND domainTgt.target_type = :tt\n   AND tgtAssocs.assoc_target_guid = domainTgt.target_guid\n   AND assocTgt.target_type = 'weblogic_j2eeserver'\n   AND assocTgt.target_guid = tgtAssocs.source_target_guid\n   AND tgtProp.target_guid = assocTgt.target_guid\n   AND tgtProp.property_name = 'isAdminServer'\n   AND tgtProp.property_value = 'YES'\n   AND tgtProp1.target_guid = tgtProp.target_guid\n   AND tgtProp1.property_name = 'OracleHome'\n   AND tgtProp2.target_guid = domainTgt.target_guid\n   AND tgtProp2.property_name = 'isJRFApplicable'\n" + " UNION " + " SELECT 'member_of', NULL, P.TARGET_TYPE, P.PROPERTY_VALUE FROM " + " MGMT_TARGETS T, MGMT_FLAT_TARGET_ASSOC A, MGMT$TARGET_PROPERTIES P " + " WHERE T.TARGET_NAME = :tn AND T.TARGET_TYPE = :tt AND " + " A.ASSOC_TARGET_GUID = T.TARGET_GUID AND A.IS_MEMBERSHIP = 1 AND " + " P.TARGET_GUID = A.SOURCE_TARGET_GUID AND " + " P.TARGET_TYPE = 'exa_rack' AND P.PROPERTY_NAME = 'RackId'";

    public WLDomainConvergedTargetInfo(String string) {
        super(string);
    }

    public List getHarvesterSnapshotMDs(Connection connection) throws HarvesterException {
        List list = super.getHarvesterSnapshotMDs(connection);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HarvesterSnapshotMD harvesterSnapshotMD = (HarvesterSnapshotMD)iterator.next();
            if (!harvesterSnapshotMD.getHarvesterSnapshotType().equals("weblogic_domain_config")) continue;
            harvesterSnapshotMD.addEMMetricMD(this.getWLDomainAssocMetric());
        }
        return list;
    }

    private HarvesterEMMetricMD getWLDomainAssocMetric() {
        HarvesterEMMetricMD harvesterEMMetricMD = new HarvesterEMMetricMD("MGMT_ECM_ASSOCIATIONS", 2, 30.0f, new HarvesterOCMMetricMD[]{new HarvesterOCMMetricMD(new QueryInfo(){

            public String getMetricName() {
                return "ECM_ASSOCIATIONS";
            }

            public String getQuery() {
                return GET_ECM_ASSOCIATIONS_METRIC_QUERY;
            }

            public int getParameterLayout() {
                return 6;
            }

            public int getColumnCount() {
                return 4;
            }
        })});
        return harvesterEMMetricMD;
    }

    public String getHostName(String string, String string2, Connection connection) throws HarvesterException {
        return WLUtil.getAdminserverHost(string, "weblogic_domain", connection, string2);
    }

    public boolean hasFakeHost(Connection connection) throws HarvesterException {
        return true;
    }

    public String getTargetName(String string, String string2, Connection connection) throws HarvesterException {
        return WLUtil.getWLServerTargetName(string, "weblogic_domain", connection);
    }
}

