/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.upload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.sysman.ccr.collector.collectionMgr.CollectionResultList;
import oracle.sysman.ccr.collector.collectionMgr.XMLUploadWriter;
import oracle.sysman.ccr.collector.gcontext.GCContext;
import oracle.sysman.ccr.collector.gcontext.GCContextList;
import oracle.sysman.ccr.collector.gcontext.GCContextManager;
import oracle.sysman.ccr.gcharvester.GcCollectionInfo;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.registration.RegistrationDAO;
import oracle.sysman.ccr.gcharvester.upload.GCUploader;
import oracle.sysman.ccr.gcharvester.upload.UploadCallBack;
import oracle.sysman.ccr.gcharvester.util.GCHarvesterEnv;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.ccr.gcharvester.util.NetworkUtil;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.util.FileSpec;
import org.apache.log4j.Category;
import org.xml.sax.SAXException;

public class GCUploaderImpl
implements GCUploader {
    private static final int MAX_THREADS = 5;
    private static final String INSTANCE_HOME = "INSTANCE_HOME";
    private static final String UPLOAD_TMP_DIR = "sysman" + File.separator + "ocm" + File.separator + "harvester" + File.separator + "tmp";
    private static final Category sLog = Category.getInstance((String)GCUploaderImpl.class.getName());
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private AtomicInteger activeThreadCount = new AtomicInteger();

    @Override
    public boolean shouldCollectConfigMetricData(GcCollectionInfo gcCollectionInfo) throws HarvesterException {
        return true;
    }

    @Override
    public void uploadCollectionResults(List list, boolean bl, UploadCallBack uploadCallBack, Connection connection) throws HarvesterException {
        boolean bl2 = false;
        try {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"Inside GCUploaderImpl.uploadCollectionResults");
                sLog.debug((Object)("isComplete: " + bl));
                sLog.debug((Object)("collectionResults.size: " + list.size()));
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            ArrayList<GCContext> arrayList2 = new ArrayList<GCContext>();
            GCContextList gCContextList = GCContextManager.getGCContextList();
            List list2 = gCContextList.gcContextList();
            for (int i = 0; i < list.size(); ++i) {
                CollectionResultList collectionResultList = (CollectionResultList)list.get(i);
                GCContext gCContext = (GCContext)list2.get(i);
                gCContextList.setCurrentGCContext(gCContext);
                File file = this.getXMLFile(collectionResultList.getObjectBaseFilename(), collectionResultList.getObjectBaseSubDir());
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)("Writing XML File: " + file));
                    sLog.debug((Object)("CollectionResultList.target: " + collectionResultList.getTargetInstance()));
                    sLog.debug((Object)("CollectionResultList.getCollectionName(): " + collectionResultList.getCollectionName()));
                    sLog.debug((Object)("CollectionResultList.getCollectionTSwTZ: " + collectionResultList.getCollectionTSwTZ()));
                    sLog.debug((Object)("contxt.getClientKey: " + gCContext.getClientKey()));
                    sLog.debug((Object)("contxt.getOrgId: " + gCContext.getOrgId()));
                    sLog.debug((Object)("contxt.getHostName: " + gCContext.getHostName()));
                    sLog.debug((Object)("contxt.getOracleHome: " + gCContext.getOracleHome()));
                    sLog.debug((Object)("contxt.getOracleConfigHome: " + gCContext.getOracleConfigHome()));
                }
                XMLUploadWriter xMLUploadWriter = new XMLUploadWriter(file.getAbsolutePath(), collectionResultList, !bl, true);
                xMLUploadWriter.write();
                arrayList.add(file);
                arrayList2.add(gCContext);
            }
            GCUploadRunnable gCUploadRunnable = new GCUploadRunnable(arrayList, arrayList2, uploadCallBack, connection);
            executor.execute(gCUploadRunnable);
            int n = this.activeThreadCount.incrementAndGet();
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Harvester Upload Thread added #: " + n));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl2 = true;
            HarvesterUtil.logErrorMessage(sLog, fileNotFoundException, "XML file creation failed");
            throw new HarvesterException("XML file creation failed", fileNotFoundException);
        }
        catch (IOException iOException) {
            bl2 = true;
            HarvesterUtil.logErrorMessage(sLog, iOException, "XML file creation failed");
            throw new HarvesterException("XML file creation failed", iOException);
        }
        catch (SAXException sAXException) {
            bl2 = true;
            HarvesterUtil.logErrorMessage(sLog, sAXException, "XML file creation failed");
            throw new HarvesterException("XML file creation failed", sAXException);
        }
        finally {
            if (bl2) {
                uploadCallBack.callback(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureUploadIsComplete() {
        try {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"Check All threads are completed or not");
            }
            boolean bl = true;
            int n = 0;
            while (bl) {
                ++n;
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)("Checking in while loop: " + n));
                }
                boolean bl2 = false;
                if (this.activeThreadCount.get() <= 0) {
                    bl2 = true;
                }
                if (bl2) {
                    bl = false;
                    if (!sLog.isDebugEnabled()) continue;
                    sLog.debug((Object)"All upload thread have finished the job");
                    continue;
                }
                if (n > 4320) {
                    if (sLog.isDebugEnabled()) {
                        sLog.debug((Object)"Lot of time spend waiting for upload to complete. Now shuting down uploader");
                    }
                    executor.shutdownNow();
                    bl = false;
                    continue;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.activeThreadCount = new AtomicInteger();
        }
    }

    private File getXMLFile(String string, String string2) throws IOException {
        File file;
        String string3 = System.getProperty(INSTANCE_HOME);
        String string4 = string3 + File.separator + UPLOAD_TMP_DIR;
        if (GCHarvesterEnv.canDeleteFiles()) {
            string4 = string4 + File.separator + string2;
        }
        if (!(file = new File(string4)).exists()) {
            file.mkdirs();
        }
        File file2 = File.createTempFile(string, ".xml", file);
        return file2;
    }

    @Override
    public void cleanCollectionData() {
        for (int i = 0; i < 11; ++i) {
            String string = System.getProperty(INSTANCE_HOME) + File.separator + UPLOAD_TMP_DIR + File.separator + i;
            File file = new File(string);
            if (!file.exists()) continue;
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (int j = 0; j < stringArray.length; ++j) {
                    File file2 = new File(FileSpec.catfile(new String[]{string, stringArray[j]}));
                    GCUploaderImpl.deleteFile(file2);
                }
            }
            GCUploaderImpl.deleteFile(file);
        }
    }

    private static void deleteFile(File file) {
        if (file.exists() && !file.delete()) {
            System.gc();
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    class GCUploadRunnable
    implements Runnable {
        private ArrayList<File> files;
        private ArrayList<GCContext> gcContextList;
        private UploadCallBack callBack;
        private Connection connection;
        private static final int MAX_ATTEMPT = 3;

        GCUploadRunnable(ArrayList<File> arrayList, ArrayList<GCContext> arrayList2, UploadCallBack uploadCallBack, Connection connection) {
            this.files = arrayList;
            this.gcContextList = arrayList2;
            this.callBack = uploadCallBack;
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = true;
            try {
                for (int i = 0; i < this.files.size(); ++i) {
                    GCContext gCContext;
                    File file = this.files.get(i);
                    boolean bl2 = this.uploadFile(file, gCContext = this.gcContextList.get(i));
                    if (bl2) continue;
                    bl = false;
                    break;
                }
            }
            catch (Throwable throwable) {
                bl = false;
                HarvesterUtil.logErrorMessage(sLog, throwable, "Unexpected exception in upload");
            }
            finally {
                try {
                    this.deleteFiles();
                    this.callBack.callback(bl);
                }
                catch (Throwable throwable) {
                    HarvesterUtil.logErrorMessage(sLog, throwable, "Unexpected exception in finally of upload");
                }
                int n = GCUploaderImpl.this.activeThreadCount.decrementAndGet();
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)("Harvester Upload thread job completed active count #: " + n));
                }
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"Upload thread job completed");
            }
        }

        private boolean uploadFile(File file, GCContext gCContext) {
            OCMEndPoint oCMEndPoint = null;
            boolean bl = false;
            for (int i = 1; i <= 3; ++i) {
                try {
                    if (oCMEndPoint == null) {
                        oCMEndPoint = NetworkUtil.ocmEndPoint();
                    }
                    if (sLog.isDebugEnabled()) {
                        sLog.debug((Object)("Uploading File: " + file));
                        sLog.debug((Object)("contxt.getClientKey: " + gCContext.getClientKey()));
                        sLog.debug((Object)("contxt.getOrgId: " + gCContext.getOrgId()));
                        sLog.debug((Object)("contxt.getHostName: " + gCContext.getHostName()));
                        sLog.debug((Object)("contxt.getOracleHome: " + gCContext.getOracleHome()));
                        sLog.debug((Object)("contxt.getOracleConfigHome: " + gCContext.getOracleConfigHome()));
                    }
                    oCMEndPoint.sendContent(file, gCContext.getClientKey(), gCContext.getOrgId(), gCContext.getHostName(), gCContext.getOracleHome(), gCContext.getOracleConfigHome(), "GC");
                    bl = true;
                    if (!sLog.isDebugEnabled()) break;
                    sLog.debug((Object)"Upload Successfull");
                    break;
                }
                catch (Exception exception) {
                    if (sLog.isDebugEnabled()) {
                        sLog.debug((Object)("Upload failed in attempt " + i), (Throwable)exception);
                    }
                    if (i != 3) continue;
                    sLog.error((Object)("GC OCM Harvester: 3attempts to upload failed for file: " + file.getAbsolutePath() + " Exception: " + exception));
                    continue;
                }
            }
            return bl;
        }

        private boolean registrationChanged(GCContext gCContext) throws HarvesterException {
            long l = gCContext.getRegistrationId();
            return RegistrationDAO.isPendingRegistration(l, this.connection);
        }

        private void deleteFiles() {
            if (!GCHarvesterEnv.canDeleteFiles()) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)"Returning without deleting the file");
                }
                return;
            }
            for (File file : this.files) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)("Deleting file: " + file));
                }
                GCUploaderImpl.deleteFile(file);
            }
        }
    }
}

