/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.upload;

import java.util.ArrayList;
import oracle.jdbc.OracleConnection;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.targettype.HarvesterTargetPropUtil;
import oracle.sysman.ccr.gcharvester.ti.common.HarvesterTargetProperies;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.eml.ecm.track.TrackUtilities;
import org.apache.log4j.Category;

public class UploadCallBack {
    private String targetName;
    private String targetType;
    private String oracleHome;
    private String snapShotType;
    private boolean hasOCMMetrics = false;
    private OracleConnection connection;
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$upload$UploadCallBack == null ? (class$oracle$sysman$ccr$gcharvester$upload$UploadCallBack = UploadCallBack.class$("oracle.sysman.ccr.gcharvester.upload.UploadCallBack")) : class$oracle$sysman$ccr$gcharvester$upload$UploadCallBack).getName());
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$upload$UploadCallBack;

    public UploadCallBack(String string, String string2, String string3, String string4, boolean bl, OracleConnection oracleConnection) {
        this.targetName = string;
        this.targetType = string2;
        this.oracleHome = string3;
        this.snapShotType = string4;
        this.hasOCMMetrics = bl;
        this.connection = oracleConnection;
    }

    public void callback(boolean bl) throws HarvesterException {
        if (bl && (this.hasOCMMetrics || this.snapShotType.equals("OCheck"))) {
            HarvesterTargetPropUtil.deleteHarvesterTargetProperty(this.connection, this.targetName, this.targetType, "IS_OUT_OF_PLACE_UPGRADE");
            HarvesterTargetPropUtil.deleteHarvesterTargetProperty(this.connection, this.targetName, this.targetType, HarvesterTargetProperies.OLD_OH_PROP);
            HarvesterTargetPropUtil.deleteHarvesterTargetProperty(this.connection, this.targetName, this.targetType, HarvesterTargetProperies.OLD_HOST_PROP);
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1);
            try {
                if ("oracle_home".equals(this.targetType) && GCVersion.pre11_2GC()) {
                    arrayList.add(new Object[]{this.targetName, "host", "host_configuration", this.oracleHome});
                    TrackUtilities.executePreparedStatement((OracleConnection)this.connection, (String)"UPDATE mgmt_ocm_upl_metrics    SET is_changed = 0  WHERE target_name = ?    AND target_type = ?    AND snapshot_type = ?    AND addl_target_info = ?", (int[])new int[]{1, 1, 1, 1}, arrayList, null, null, (boolean)true);
                } else if ("weblogic_domain".equals(this.targetType) || "weblogic_cluster".equals(this.targetType) || "oracle_ias_farm".equals(this.targetType) || "j2ee_application".equals(this.targetType) || "oracle_vm_guest".equals(this.targetType) && GCVersion.pre11_2GC()) {
                    arrayList.add(new Object[]{this.targetName, this.targetType, this.snapShotType, this.oracleHome});
                    TrackUtilities.executePreparedStatement((OracleConnection)this.connection, (String)"UPDATE mgmt_ocm_upl_metrics    SET is_changed = 0  WHERE target_name = ?    AND target_type = ?    AND snapshot_type = ?    AND addl_target_info = ?", (int[])new int[]{1, 1, 1, 1}, arrayList, null, null, (boolean)true);
                } else {
                    arrayList.add(new Object[]{this.targetName, this.targetType, this.snapShotType});
                    TrackUtilities.executePreparedStatement((OracleConnection)this.connection, (String)"UPDATE mgmt_ocm_upl_metrics    SET is_changed = 0  WHERE target_name = ?    AND target_type = ?    AND snapshot_type = ?    AND addl_target_info IS NULL", (int[])new int[]{1, 1, 1}, arrayList, null, null, (boolean)true);
                }
                this.connection.commit();
            }
            catch (Exception exception) {
                String string = "Failed to clear metrics for generated snapshot (for target " + this.targetName + " of type " + this.targetType + " for snapshot type " + this.snapShotType + "): " + exception.getMessage();
                HarvesterUtil.logErrorMessage(sLog, exception, string);
                throw new HarvesterException(string, exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

