/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.ti.database.DatabaseMetricCallback;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class GCHarvesterEnv {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$util$GCHarvesterEnv == null ? (class$oracle$sysman$ccr$gcharvester$util$GCHarvesterEnv = GCHarvesterEnv.class$("oracle.sysman.ccr.gcharvester.util.GCHarvesterEnv")) : class$oracle$sysman$ccr$gcharvester$util$GCHarvesterEnv).getName());
    private static final String OCM_PROPS_QUERY = "select name, str_value from mgmt_ocm_upl_props where str_value is not null";
    private static volatile boolean sInitialize = false;
    private static GCHarvesterEnv instance = null;
    private Map properties = new HashMap();
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$util$GCHarvesterEnv;

    private GCHarvesterEnv() {
    }

    public static void init(Connection connection) throws HarvesterException {
        if (!sInitialize) {
            instance = new GCHarvesterEnv();
            instance.initialize(connection);
            sInitialize = true;
        }
        GCVersion.init(connection);
        DatabaseMetricCallback.setGCHarvInitProperties();
    }

    public static String getProperty(String string) {
        if (instance != null) {
            return (String)GCHarvesterEnv.instance.properties.get(string);
        }
        return null;
    }

    public static boolean disableCSIAssign() {
        return GCHarvesterEnv.checkForTrue("disable_csi_assignment");
    }

    public static boolean isGlobalGCForced() {
        return GCHarvesterEnv.checkForTrue("is_gc_force");
    }

    public static boolean canDeleteFiles() {
        return GCHarvesterEnv.checkForFalse("delete_upload_file");
    }

    public static boolean isTestEnv() {
        return GCHarvesterEnv.checkForTrue("gc_harvester_test_env");
    }

    public static boolean ignoreErrors() {
        return GCHarvesterEnv.checkForFalse("ignore_errors");
    }

    public static boolean overrideTestConverged() {
        return GCHarvesterEnv.checkForTrue("harvester_test_override");
    }

    public static boolean testPeriodicMetric() {
        return GCHarvesterEnv.checkForTrue("harvester_test_periodic_metric");
    }

    private static boolean checkForTrue(String string) {
        String string2 = GCHarvesterEnv.getProperty(string);
        return string2 != null && string2.equalsIgnoreCase("true");
    }

    private static boolean checkForFalse(String string) {
        String string2 = GCHarvesterEnv.getProperty(string);
        return string2 == null || !string2.equalsIgnoreCase("false");
    }

    private void initialize(Connection connection) throws HarvesterException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(OCM_PROPS_QUERY);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                this.properties.put(string, string2);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string = "Error in getting data from mgmt_ocm_upl_props";
                HarvesterUtil.logErrorMessage(sLog, sQLException, string);
                throw new HarvesterException(string, sQLException);
            }
            catch (Throwable throwable) {
                JDBCUtil.close(resultSet);
                JDBCUtil.close((Statement)preparedStatement);
                throw throwable;
            }
        }
        JDBCUtil.close((ResultSet)resultSet);
        JDBCUtil.close((Statement)preparedStatement);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

