/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.util;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.jdbc.OracleConnection;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.ccr.util.Utils;
import oracle.sysman.eml.ecm.track.TrackUtilities;
import org.apache.log4j.Category;

public class GCVersion {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$util$GCVersion == null ? (class$oracle$sysman$ccr$gcharvester$util$GCVersion = GCVersion.class$("oracle.sysman.ccr.gcharvester.util.GCVersion")) : class$oracle$sysman$ccr$gcharvester$util$GCVersion).getName());
    private static final String GET_OMS_VERSION = " SELECT version FROM mgmt_versions WHERE component_name= 'CORE' ";
    private static volatile String sGCVersion = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$util$GCVersion;

    public static void init(Connection connection) throws HarvesterException {
        GCVersion.gcRepositoryVersion(connection);
    }

    public static String gcRepositoryVersion() {
        if (sGCVersion == null) {
            throw new IllegalStateException("GCVersion.init should be called before calling this method");
        }
        return sGCVersion;
    }

    public static boolean pre11_1GC() {
        String string = GCVersion.gcRepositoryVersion();
        return Utils.compareVersions("11.1.0.1.0", string) == 1;
    }

    public static boolean pre11_2GC() {
        String string = GCVersion.gcRepositoryVersion();
        return Utils.compareVersions("11.2", string) == 1;
    }

    public static boolean pre12_102GC() {
        String string = GCVersion.gcRepositoryVersion();
        return Utils.compareVersions("12.1.0.2.0", string) == 1;
    }

    private static String gcRepositoryVersion(Connection connection) throws HarvesterException {
        if (sGCVersion == null) {
            ArrayList arrayList = null;
            try {
                arrayList = TrackUtilities.executePreparedStatement((OracleConnection)((OracleConnection)connection), (String)GET_OMS_VERSION, null, null, (int[])new int[]{1}, (int[])new int[]{64}, (boolean)false);
            }
            catch (Exception exception) {
                String string = "Failed to get OMS version : " + exception.getMessage();
                HarvesterUtil.logErrorMessage(sLog, exception, string);
                throw new HarvesterException(string, exception);
            }
            if (arrayList == null || arrayList.isEmpty()) {
                String string = "Failed to get OMS version";
                throw new HarvesterException(string);
            }
            sGCVersion = (String)((Object[])arrayList.get(0))[0];
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("GC Version: " + sGCVersion));
            }
        }
        return sGCVersion;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

