/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.util;

import HTTPClient.ParseException;
import java.util.Properties;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.network.EndPoint;
import oracle.sysman.ccr.common.network.httplog.HTTPThreadLogger;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.util.GCHarvesterEnv;
import oracle.sysman.ccr.gcharvester.util.GCVersion;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.ccr.netmgr.EndPointAddr;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import org.apache.log4j.Category;

public class NetworkUtil {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$util$NetworkUtil == null ? (class$oracle$sysman$ccr$gcharvester$util$NetworkUtil = NetworkUtil.class$("oracle.sysman.ccr.gcharvester.util.NetworkUtil")) : class$oracle$sysman$ccr$gcharvester$util$NetworkUtil).getName());
    private static volatile OCMEndPoint sLiveLinkServer = null;
    private static volatile EndPoint sEndPoint = null;
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$util$NetworkUtil;

    private static void enableHTTPLog() {
        Config config = UplinkHomeConfig.getInstance();
        String string = config.getProperty("httpclient.log.enable");
        if ("true".equals(string)) {
            HTTPThreadLogger.addThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OCMEndPoint ocmEndPoint() throws HarvesterException {
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)"Inside NetworkUtil.ocmEndPoint");
        }
        NetworkUtil.enableHTTPLog();
        if (GCVersion.pre11_1GC()) {
            return null;
        }
        if (sLiveLinkServer == null) {
            Class clazz = class$oracle$sysman$ccr$gcharvester$util$NetworkUtil == null ? (class$oracle$sysman$ccr$gcharvester$util$NetworkUtil = NetworkUtil.class$("oracle.sysman.ccr.gcharvester.util.NetworkUtil")) : class$oracle$sysman$ccr$gcharvester$util$NetworkUtil;
            synchronized (clazz) {
                if (sLiveLinkServer == null) {
                    EndPoint endPoint = null;
                    OCMEndPoint oCMEndPoint = null;
                    try {
                        OCMEndPoint.init();
                        endPoint = new EndPoint(NetworkUtil.getEndpointAddr(), NetworkUtil.getProxyProps());
                        if (sLog.isDebugEnabled()) {
                            sLog.debug((Object)"Got EndPoint object");
                        }
                        oCMEndPoint = new OCMEndPoint(endPoint);
                        sEndPoint = endPoint;
                        sLiveLinkServer = oCMEndPoint;
                    }
                    catch (HarvesterException harvesterException) {
                        throw harvesterException;
                    }
                    catch (Throwable throwable) {
                        HarvesterUtil.logErrorMessage(sLog, throwable, "Connection to the endpoint refused. Harvester collection and upload failed.");
                        throw new HarvesterException("Unable to connect to Oracle Configuration Manager content receiver", throwable);
                    }
                }
            }
        }
        return sLiveLinkServer;
    }

    public static void releaseConnection() {
        if (GCVersion.pre11_1GC()) {
            return;
        }
        if (sEndPoint != null) {
            sEndPoint.disconnect();
            sEndPoint = null;
        }
        sLiveLinkServer = null;
    }

    private static EndPointAddr getEndpointAddr() throws HarvesterException {
        try {
            EndPointAddr endPointAddr = UplinkSystemConfig.getOCMServiceEndPoint();
            if (endPointAddr == null) {
                sLog.error((Object)"Oracle Configuration Manager endpoint unknown");
                throw new HarvesterException("Oracle Configuration Manager endpoint unknown");
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("EndPointAddr: " + endPointAddr));
            }
            return endPointAddr;
        }
        catch (ParseException parseException) {
            HarvesterUtil.logErrorMessage(sLog, parseException, "Invalid Oracle Configuration Manager endpoint");
            throw new HarvesterException("Invalid Oracle Configuration Manager endpoint.", parseException);
        }
    }

    private static Properties getProxyProps() {
        Properties properties = new Properties();
        Config config = UplinkSystemConfig.getInstance();
        String string = config.getProperty("http.proxyHost");
        String string2 = config.getProperty("http.proxyPort");
        String string3 = GCHarvesterEnv.getProperty("ocm_proxyauth_basic_realm");
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("Proxy Host: " + string));
            sLog.debug((Object)("Proxy Port: " + string2));
        }
        if (string3 != null) {
            properties.setProperty("ocm_proxyauth_basic_realm", string3);
        }
        if (string != null) {
            properties.setProperty("http.proxyHost", string);
            if (string2 != null) {
                properties.setProperty("http.proxyPort", string2);
            }
        }
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

