/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.util;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.install.AnonymousMailRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.ConfigResponse;
import oracle.sysman.ccr.collector.install.ConnectionException;
import oracle.sysman.ccr.collector.install.InvalidEndPointException;
import oracle.sysman.ccr.collector.install.InvalidRepeaterException;
import oracle.sysman.ccr.collector.install.InvalidValueException;
import oracle.sysman.ccr.collector.install.MetaLinkEmailPrincipal;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.AuthenticationKey;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfig;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.gcharvester.GCConfigureCCRException;
import oracle.sysman.ccr.gcharvester.util.Platform;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.ccr.scheduler.Scheduler;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.Process;
import oracle.sysman.ccr.util.crypt.Crypt;
import org.apache.log4j.Category;

public class OCMConfigureUtil {
    private static final Category sLog = Category.getInstance((String)(class$oracle$sysman$ccr$gcharvester$util$OCMConfigureUtil == null ? (class$oracle$sysman$ccr$gcharvester$util$OCMConfigureUtil = OCMConfigureUtil.class$("oracle.sysman.ccr.gcharvester.util.OCMConfigureUtil")) : class$oracle$sysman$ccr$gcharvester$util$OCMConfigureUtil).getName());
    private static final String CCR_HOME = "ccr";
    private static final String BIN_DIR = "bin";
    private static final String CONFIGCCR = "configCCR";
    private static final String WIN_FILETYPE = ".exe";
    private static final String SH_FILETYPE = "";
    private static final String OCM_FILE_PREFIX = "ocm";
    private static final String OCM_FILE_POSTFIX = ".rsp";
    private static final String SETUP_OPTION = "-R";
    private static final int SUCCESS = 0;
    static /* synthetic */ Class class$oracle$sysman$ccr$gcharvester$util$OCMConfigureUtil;

    public static boolean ocmInUnauthMode() {
        if (Collector.isDisconnected()) {
            return false;
        }
        String string = UplinkSystemConfig.getInstance().getProperty("ccr.registration_mode");
        return string != null && string.equals("anon");
    }

    public static String getConfigCCRFile() {
        String string = SH_FILETYPE;
        String string2 = System.getProperty("ORACLE_HOME");
        string = System.getProperty("os.name").startsWith("Windows") ? WIN_FILETYPE : SH_FILETYPE;
        return FileSpec.catfile(new String[]{string2, CCR_HOME, BIN_DIR, CONFIGCCR + string});
    }

    public static OCMRegistrationPrincipal createOCMPrincipalFromCCR(EndPoint endPoint) {
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)"Inside createOCMPrincipalFromCCR");
        }
        Config config = UplinkSystemConfig.getInstance();
        String string = config.getProperty("ccr.metalink_email.address");
        return OCMConfigureUtil.createOCMPrincipal(endPoint, string, null, true);
    }

    public static OCMRegistrationPrincipal createOCMPrincipal(EndPoint endPoint, String string, String string2, boolean bl) {
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("Inside createOCMPrincipal with user: " + string));
        }
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.trim().length() <= 0) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"passwd is null");
            }
            if (bl) {
                return new AnonymousMailRegistrationPrincipal(string);
            }
            return null;
        }
        try {
            OCMEndPoint oCMEndPoint = new OCMEndPoint(endPoint);
            String string3 = oCMEndPoint.authenticateUser(string, string2.getBytes());
            return new MetaLinkEmailPrincipal(string, string2.getBytes(), string3);
        }
        catch (NetworkException networkException) {
            if (bl) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)"authenticate failed, registering using AnonymousMailRegistrationPrincipal.");
                }
                return new AnonymousMailRegistrationPrincipal(string);
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"authenticate failed, skiping registration.");
            }
            return null;
        }
    }

    public static void createResponseFile(NetworkConfiguration networkConfiguration, OCMRegistrationPrincipal oCMRegistrationPrincipal, String string) throws GCConfigureCCRException {
        try {
            ConfigResponse.createResponseFile(string, networkConfiguration, oCMRegistrationPrincipal);
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Response file " + string + " has been created."));
            }
        }
        catch (IOException iOException) {
            throw new GCConfigureCCRException("Failed to create response file, IOException: " + iOException.getMessage(), iOException);
        }
    }

    public static void execConfigCCR(String string, String string2) throws GCConfigureCCRException {
        block13: {
            String[] stringArray;
            String[] stringArray2 = new String[]{string, SETUP_OPTION, string2};
            String[] stringArray3 = stringArray = Platform.getEnvArray();
            String string3 = System.getProperty("ORACLE_CONFIG_HOME");
            if (string3 != null && string3.length() > 0) {
                stringArray3 = new String[stringArray.length + 1];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray3[i] = stringArray[i];
                }
                stringArray3[i] = "ORACLE_CONFIG_HOME=" + string3;
            }
            if (sLog.isDebugEnabled()) {
                String string4 = SH_FILETYPE;
                for (int i = 0; i < stringArray3.length; ++i) {
                    string4 = string4 + stringArray3[i] + ", ";
                }
                sLog.debug((Object)("Env variable passed to configCCR command: " + string4));
            }
            try {
                StringBuffer stringBuffer = new StringBuffer();
                Process process = Process.exec(stringArray2, stringArray3, null);
                int n = process.waitFor(stringBuffer);
                if (n == 0) {
                    if (sLog.isDebugEnabled()) {
                        sLog.debug((Object)("configCCR cmd message: " + stringBuffer));
                    }
                    UplinkSystemConfig.reload();
                    UplinkHomeConfig.reload();
                    Scheduler.reload();
                    Collector.setDisconnected();
                    try {
                        SecurityMgr securityMgr = SecurityMgr.getInstance();
                        AuthenticationKey authenticationKey = AuthenticationKey.instantiate();
                        securityMgr.setAuthenticationKey(authenticationKey);
                    }
                    catch (AuthenticationFailure authenticationFailure) {
                        throw new GCConfigureCCRException("Unable to load the AuthenticationKey: " + authenticationFailure.getMessage(), authenticationFailure);
                    }
                    if (Collector.isDisconnected()) {
                        throw new GCConfigureCCRException("Collector still in disconnected mode, although command configCCR -R <respFile> was successfull.");
                    }
                    if (Scheduler.isStopped()) {
                        throw new GCConfigureCCRException("Scheduler is not running, although command configCCR -R <respFile> was successfull.");
                    }
                    break block13;
                }
                throw new GCConfigureCCRException("configCCR command failed, return code is " + n + " and output is " + stringBuffer);
            }
            catch (IOException iOException) {
                throw new GCConfigureCCRException("IOException in executing the configCCR command: " + iOException.getMessage(), iOException);
            }
            catch (InterruptedException interruptedException) {
                throw new GCConfigureCCRException("InterruptedException in executing the configCCR command: " + interruptedException.getMessage(), interruptedException);
            }
        }
    }

    public static String getResponseFile() throws GCConfigureCCRException {
        String string = System.getProperty("ORACLE_HOME");
        String string2 = FileSpec.catfile(new String[]{string, CCR_HOME, BIN_DIR});
        String string3 = SH_FILETYPE;
        try {
            File file = File.createTempFile(OCM_FILE_PREFIX, OCM_FILE_POSTFIX, new File(string2));
            string3 = file.getName();
        }
        catch (IOException iOException) {
            throw new GCConfigureCCRException("IOException in creating the tmp response file: " + iOException.getMessage(), iOException);
        }
        return FileSpec.catfile(new String[]{string2, string3});
    }

    public static void deleteResponseFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            System.gc();
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public static EndPoint proxyFromCCR(NetworkConfiguration networkConfiguration) {
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)"Inside proxyFromCCR");
        }
        Config config = UplinkSystemConfig.getInstance();
        String string = config.getProperty("http.proxyHost");
        String string2 = config.getProperty("http.proxyPort");
        String string3 = config.getProperty("http.proxyUser");
        String string4 = config.getProperty("http.proxyPassword");
        String string5 = config.getProperty("ccr.proxypswd.seed");
        String string6 = null;
        if (string5 != null && string5.length() > 0 && string4 != null) {
            Crypt crypt = new Crypt();
            string6 = crypt.decrypt(string4, string5);
        }
        return OCMConfigureUtil.testProxyConnection(networkConfiguration, string, string2, string3, string6);
    }

    public static EndPoint testDirectConnection(NetworkConfiguration networkConfiguration) {
        EndPoint endPoint;
        block2: {
            endPoint = null;
            try {
                endPoint = OCMConfigureUtil.testConnectionWrapper(networkConfiguration);
            }
            catch (Exception exception) {
                if (!sLog.isDebugEnabled()) break block2;
                sLog.debug((Object)"Error in direct connection", (Throwable)exception);
            }
        }
        return endPoint;
    }

    public static EndPoint testConnectionWrapper(NetworkConfiguration networkConfiguration) throws GCConfigureCCRException, UnknownHostException, SSLPeerUnverifiedException, IOException {
        EndPoint endPoint = null;
        try {
            endPoint = networkConfiguration.testExtendedConnection();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            endPoint = networkConfiguration.testConnection();
        }
        catch (ConnectionException connectionException) {
            if (connectionException instanceof InvalidEndPointException || connectionException instanceof InvalidRepeaterException) {
                throw new GCConfigureCCRException("Error while connecting to ccr server: " + connectionException.getMessage(), connectionException);
            }
            throw new GCConfigureCCRException("Unknown exception encountered in testExtendedConnection - " + connectionException.getMessage(), connectionException);
        }
        return endPoint;
    }

    public static EndPoint testProxyConnection(NetworkConfiguration networkConfiguration, String string, String string2, String string3, String string4) {
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("Inside testProxyConnection with: host=" + string + ", " + "port=" + string2 + ", " + "user=" + string3));
        }
        if (string == null || string.length() <= 0) {
            return null;
        }
        networkConfiguration.resetProxyInformation();
        try {
            networkConfiguration.setProxyHost(string);
            if (string2 != null && string2.length() > 0) {
                networkConfiguration.setProxyPort(Integer.parseInt(string2));
            }
            if (string3 != null && string4 != null) {
                networkConfiguration.setProxyCreds(string3, string4.getBytes());
            }
            return networkConfiguration.testProxyConnection();
        }
        catch (ConnectionException connectionException) {
            sLog.error((Object)("Connection problem using proxy info from EM Repo: " + connectionException));
        }
        catch (UnknownHostException unknownHostException) {
            sLog.error((Object)("Unexcepted Error while initializing NetworkConfiguration object: " + unknownHostException));
        }
        catch (InvalidValueException invalidValueException) {
            sLog.error((Object)("Unexcepted Error while initializing NetworkConfiguration object: " + invalidValueException));
        }
        catch (NumberFormatException numberFormatException) {
            sLog.error((Object)("Unexcepted Error while initializing NetworkConfiguration object: " + numberFormatException));
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

