/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.gcharvester.util;

import java.sql.Connection;
import oracle.sysman.ccr.gcharvester.HarvesterException;
import oracle.sysman.ccr.gcharvester.util.HarvesterUtil;
import oracle.sysman.ccr.gcharvester.util.ISecurityAdaptor;
import oracle.sysman.emSDK.core.sec.credstore.EMCredential;
import oracle.sysman.emSDK.core.sec.credstore.EMCredentialInfo;
import oracle.sysman.emSDK.core.sec.credstore.EMCredentialObjectFactory;
import oracle.sysman.emSDK.core.sec.credstore.EMCredentialReferenceForCredName;
import oracle.sysman.emSDK.core.sec.credstore.EMCredentialService;
import oracle.sysman.emSDK.core.sec.credstore.types.generic.GenericPassword;
import oracle.sysman.emSDK.sec.authz.EMSecurityContext;
import oracle.sysman.util.jdbc.JDBCUtil;
import org.apache.log4j.Category;

public class SecurityAdaptorEM
implements ISecurityAdaptor {
    private static final Category sLog = Category.getInstance((String)SecurityAdaptorEM.class.getName());
    private static final String STRIPE_NAME = "GCHarvester";
    private static final String STRIPE_USAGE_NAME = "GCHarvesterRegistration";

    @Override
    public String insertSecureInfo(String string, Connection connection) throws HarvesterException {
        String string2 = null;
        try {
            EMCredentialService eMCredentialService = EMSecurityContext.getCredentialService();
            GenericPassword genericPassword = GenericPassword.createGenericPassword((String)string);
            EMCredentialInfo eMCredentialInfo = EMCredentialObjectFactory.createCredentialInfo();
            eMCredentialInfo.setStripeName(STRIPE_NAME);
            eMCredentialInfo.setStripeUsageName(STRIPE_USAGE_NAME);
            string2 = eMCredentialService.createCredential(connection, eMCredentialInfo, (EMCredential)genericPassword);
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("Secure Info guid= " + string2));
            }
            connection.commit();
        }
        catch (Exception exception) {
            String string3 = "Error in storing the secure data using EM Security framework APIs";
            JDBCUtil.forceTransactionRollback((Connection)connection);
            HarvesterUtil.logErrorMessage(sLog, exception, string3);
            new HarvesterException(string3, exception);
        }
        return string2;
    }

    @Override
    public void deleteSecureInfo(String string, Connection connection) throws HarvesterException {
        try {
            EMCredentialService eMCredentialService = EMSecurityContext.getCredentialService();
            eMCredentialService.deleteCredential(connection, string);
            connection.commit();
        }
        catch (Exception exception) {
            String string2 = "Error in deleting the secure data with guid (" + string + ") using EM Security framework APIs";
            JDBCUtil.forceTransactionRollback((Connection)connection);
            HarvesterUtil.logErrorMessage(sLog, exception, string2);
            new HarvesterException(string2, exception);
        }
    }

    @Override
    public String getSecureInfo(String string, Connection connection) throws HarvesterException {
        String string2 = null;
        try {
            EMCredentialService eMCredentialService = EMSecurityContext.getCredentialService();
            EMCredentialReferenceForCredName eMCredentialReferenceForCredName = (EMCredentialReferenceForCredName)eMCredentialService.getCredentialReference(string);
            GenericPassword genericPassword = (GenericPassword)eMCredentialReferenceForCredName.getCredential();
            string2 = genericPassword.getPassword();
        }
        catch (Exception exception) {
            String string3 = "Error in getting the secure data using EM Security framework APIs";
            HarvesterUtil.logErrorMessage(sLog, exception, string3);
            new HarvesterException(string3, exception);
        }
        return string2;
    }
}

